#import <Foundation/Foundation.h>

typedef enum {
    Unknown,
    Default,
    Revision,
    RevisionDecoder,
    RevisionDriver,
    TerminalId,
    Baudrate,
    WordLength,
    ReceiverTimeout,
    RtsCts,
    XonXoff,
    AckNak,
    TtlLevel,
    ImageVga,
    PowerUpBeeper,
    BeepOnBELChar,
    TriggerClick,
    Beep,
    BeepVolume,
    BeepFreq,
    BeepError,
    BeepDuration,
    Led,
    LedPolarity,
    BeepErrNumber,
    BeepNumber,
    BeepPolarity,
    GoodReadDelay,
    TriggerMode,
    ManualTriggerMode,
    IlluminationManual,
    ReadTimeout,
    LowPowerTimeout,
    LedAfterDecode,
    LedTimeout,
    PresentSensitifity,
    PresentaionMode,
    IdleIllumination,
    PresentationCenteringEnable,
    PresentationCenteringTop,
    PresentationCenteringBottom,
    PresentationCenteringLeft,
    PresentationCenteringRight,
    PoorQuality1DCodes,
    PoorQuality1PDFCodes,
    CodeGate,
    HandlHeldScanning,
    PresentationScanning,
    HandsFreeTimeout,
    RereadDelay,
    LedPowerLevel,
    RereadDelay2D,
    CharActMode,
    ActiveChar,
    EndCharAct,
    CharActTimeout,
    CharDeactMode,
    DeactChar,
    IlluminationLights,
    ImagerTimeout,
    AimerDelay,
    AimerMode,
    CenterWindow,
    CenterWindowLeft,
    CenterWindowRight,
    CenterWindowTop,
    CenterWindowBottom,
    CenterWin40,
    CenterWin60,
    DecodeMode,
    EnterSequence,
    DefaultSequence,
    RequireSequence,
    MultipleSymbols,
    NoRead,
    PrintWeight,
    VideoReverse,
    WorkingOrientation,
    AddAllCRSuffix,
    AddPrefix,
    ClearOnePrefix,
    ClearAllPrefix,
    AddSuffix,
    ClearOneSuffix,
    ClearAllSuffix,
    FuncCodeTransmit,
    IntercharacterDelay,
    IntercharacterDelayLength,
    CharacterTriggerDelay,
    InterfunctionDelay,
    IntermessageDealy,
    DefaultDataFormat,
    EnterDataFormat,
    ClearOneDataFormat,
    ClearAllDataFormat,
    DataFormatter,
    AlternateDataFormats1,
    AlternateDataFormats2,
    AlternateDataFormats3,
    DataFormat,
     AllSymbol,
     CodabarDefault,
    Codabar,
    CodabarStartStopChar,
    CodabarCheckChar,
    CodabarConcatenation,
    CodabarLengthMin,
    CodabarLengthMax,
     Code39Default,
    Code39,
    Code39StartStopChar,
    Code39CheckChar,
    Code39LengthMin,
    Code39LengthMax,
    Code39Append,
    Code32Pharmaceutical,
    Code39FullAscii,
    Code39CodePage,
     I2of5Default,
    I2of5,
    I2of5CheckDigit,
    I2of5LengthMin,
    I2of5LengthMax,
     NEC2of5Default,
    NEC2of5,
    NEC2of5CheckDigit,
    NEC2of5LengthMin,
    NEC2of5LengthMax,
     Code93Default,
    Code93,
    Code93LengthMin,
    Code93LengthMax,
    Code93Append,
    Code93CodePage,
     R2of5Default,
    R2of5,
    R2of5LengthMin,
    R2of5LengthMax,
     A2of5Default,
    A2of5,
    A2of5LengthMin,
    A2of5LengthMax,
     X2of5Default,
    X2of5,
    X2of5LengthMin,
    X2of5LengthMax,
     Code11Default,
    Code11,
    Code11CheckDigit,
    Code11LengthMin,
    Code11LengthMax,
     Code128Default,
    Code128,
    IsbtConcatenation,
    Code128LengthMin,
    Code128LengthMax,
    Code128Append,
    Code128CodePage,
     GS1128Default,
    GS1128,
    GS1128LengthMin,
    GS1128LengthMax,
     TelepenDefault,
    Telepen,
    TelepenOutput,
    TelepenLengthMin,
    TelepenLengthMax,
     UPCADefault,
    UPCA,
    UPCACheckDigit,
    UPCANumberSystem,
    UPCA2DigitAdd,
    UPCA5DigitAdd,
    UPCAAddReq,
    UPCAAddSep,
    UPCACouponCode,
    CouponGS1DataBarOutput,
    ConvertUPCAtoEAN13,
    // UPC-E0
    UPCE0Default,
    UPCE0,
    UPCE0Expand,
    UPCE0CheckDigit,
    UPCE0NumberSystem,
    UPCE02DigitAdd,
    UPCE05DigitAdd,
    UPCE0AddReq,
    UPCE0AddSep,
    // UPC-E1
    UPCE1,
    // EAN/JAN-13
    EAN13Default,
    EAN13,
    EAN13CheckDigit,
    EAN132DigitAdd,
    EAN135DigitAdd,
    EAN13AddReq,
    EAN13AddSep,
    IsbnTranslate,
    // ENA/JAN-8
    EAN8Default,
    EAN8,
    EAN8CheckDigit,
    EAN82DigitAdd,
    EAN85DigitAdd,
    EAN8AddReq,
    EAN8AddSep,
    // MSI
    MSIDefault,
    MSI,
    MSICheckChar,
    MSILengthMin,
    MSILengthMax,
    // RSS-14
    RSS14Default,
    RSS14,
    // RSS Limited
    RSSLimitDefault,
    RSSLimit,
    // RSS Expanded
    RSSExpDefault,
    RSSExp,
    RSSExpLengthMin,
    RSSExpLengthMax,
    // Trioptic Code
    TriopticCode,
    // Codablock A
    CodablockADefault,
    CodablockA,
    CodablockALengthMin,
    CodablockALengthMax,
    // Codablock F
    CodablockFDefault,
    CodablockF,
    CodablockFLengthMin,
    CodablockFLengthMax,
    // PDF417
    PDF417Default,
    PDF417,
    PDF417LengthMin,
    PDF417LengthMax,
    // MacroPDF417
    MacroPDF417,
    // MicroPDF417
    MicroPDFDefault,
    MicroPDF,
    MicroPDFLengthMin,
    MicroPDFLengthMax,
    // EAN/UCC Composite Code (GS1 Composite Codes)
    ComCode,
    UPCEANVersion,
    ComCodeLengthMin,
    ComCodeLengthMax,
    ComCodeEmulation,
    GS1Emulation,
    // TCIF Linked Code 39
    TLC39,
    // China Post
    ChinaPostDefault,
    ChinaPost,
    ChinaPostLengthMin,
    ChinaPostLengthMax,
    // Korea Post
    KoreaPostDefault,
    KoreaPost,
    KoreaPostLengthMin,
    KoreaPostLengthMax,
    KoreaPostCheckDigit,
    // CR Code
    QRCodeDefault,
    QRCode,
    QRCodeLengthMin,
    QRCodeLengthMax,
    QRCodeAppend,
    QRCodePage,
    // Data Matrix
    MatrixDefault,
    Matrix,
    MatrixLengthMin,
    MatrixLengthMax,
    MatrixAppend,
    MatrixCodePage,
    // MaxiCode
    MaxiCodeDefault,
    MaxiCode,
    MaxiCodeLengthMin,
    MaxiCodeLengthMax,
    // Aztec Code
    AztecCodeDefault,
    AztecCode,
    AztecCodeLengthMin,
    AztecCodeLengthMax,
    AztecAppend,
    AztecCodePage,
    AztecCodeRunes,
    // Chinese Sensible (Han Xin) Code
    HanXinCodeDefault,
    HanXinCode,
    HanXinCodeLengthMin,
    HanXinCodeLengthMax,
    // Postal Codes
    PostalCodes,
    AustralianPostInterpretation,
    // Imaging Default Commands
    ImageDefault,
    ImageStyle,
    ImageBeep,
    ImageExposure,
    ImageFrameRate,
    ImageGain,
    ImageDelta,
    ImageLed,
    ImageTrigger,
    ImageUpdate,
    ImageWhite,
    ImagePercentage,
    ImageFilter,
    ImageCompensation,
    ImagePixelDepth,
    ImageSharpenEdges,
    ImageFormat,
    ImageHistogram,
    ImageInvertX,
    ImageInvertY,
    ImageFlySpec,
    ImageRotate,
    ImageQuality,
    ImageGamma,
    ImageCropLeft,
    ImageCropBottom,
    ImageCropMargin,
    ImageProtocol,
    ImageShipEvery,
    ImageDocFilter,
    ImageShipHistogram,
    // OCR Selections
    OCRDefault,
    OCR,
    OCRTemplate,
    OCRVarG,
    OCRVarH,
    OCRCheckChar
} ParamName;

@interface AsParamName : NSObject
//+(NSString *)msg:(ParamName)paramName;
+(NSString *)getTag:(ParamName)paramName;
+(NSString *)getName:(ParamName)paramName;
+(ParamName) startWith:(NSString *)tag;
@end
