//
//  AppDelegate.swift
//  AsReaderGUN
//
//  Created by mac on 2020/5/28.
//  Copyright © 2020 Asterisk. All rights reserved.
//

import UIKit

@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate {
    var window: UIWindow?
    private var systemSetting: SystemSetting?
    func application(_ application: UIApplication, didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        systemSetting = SystemSetting.shared()
        if (systemSetting?.getNotFirstUsed() == false) {
            systemSetting?.setNotFirstUsed(true)
            systemSetting?.setTidOn(false)
            systemSetting?.setTidLength(4)
            systemSetting?.setBuzzer(Int(Buzzer_High.rawValue))
            systemSetting?.setVibrator(Int(Vibrator_On.rawValue))
            systemSetting?.setInventoryTime(400)
            systemSetting?.setIdleTime(100)
            systemSetting?.setAutoOffTime(600)
            systemSetting?.setQValue(4)
            systemSetting?.setAlgorithm(Int(DynamicQ.rawValue))
            systemSetting?.setMaxQ(15)
            systemSetting?.setMinQ(0)
            systemSetting?.setSleepTime(300)
            systemSetting?.setMaskTypeValue(Int(MaskType_NO_MASK.rawValue))
            systemSetting?.setLinkProfileValue(3)
            systemSetting?.setDefaultLinkProfileValue(1)
            systemSetting?.setOperationTime(0)
            systemSetting?.setPowerGain(300)
            systemSetting?.setInventorySession(Int(Session_S0.rawValue))
            systemSetting?.setSessionFlag(Int(SessionFlag_AB.rawValue))
            systemSetting?.setContinuousMode(true)
            systemSetting?.setRssiMode(false)
            systemSetting?.setPropBarcodeMode(true)
            systemSetting?.setEpcMaskMatchMode(false)
            systemSetting?.setDisPlayPC(true)
            systemSetting?.setLbtItemData(nil)
            systemSetting?.setEpcMaskData(nil)
            systemSetting?.setUseSelectionMask(Int(SelectFlag_All.rawValue))
            systemSetting?.setSelectionEpcMaskData(nil)
            systemSetting?.setBarcodeParamData(nil)
            systemSetting?.setBuzzerTime(1)
            systemSetting?.setVibratorTime(1)
            systemSetting?.setBarcodeReScanTime(0)
            systemSetting?.setCustomPrefixSuffix(false)
        }
//        ExcelData.redirectNSLogToDocumentFolder();
//        ExcelData.removeLogFile();
        return true
    }
    func applicationWillResignActive(_ application: UIApplication) {
    }
    func applicationDidEnterBackground(_ application: UIApplication) {
    }
    func applicationWillEnterForeground(_ application: UIApplication) {
    }
    func applicationDidBecomeActive(_ application: UIApplication) {
    }
    func applicationWillTerminate(_ application: UIApplication) {
    }
    func getAppVersion() -> String! {
        guard let infoDictionary = Bundle.main.infoDictionary  else {
            return "Version  Build  "
        }
        let majorVersion: String = infoDictionary["CFBundleShortVersionString"] as! String
        let minorVersion: String = infoDictionary["CFBundleVersion"] as! String
        return "Version \(majorVersion) Build \(minorVersion)"
    }
}

