//
//  SystemSetting.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/16.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

final class SystemSetting: NSObject {
    private let BUZZER = "Buzzer"
    private let VIBRATOR = "Vibrator"
    private let BUZZERTIME = "BuzzerTime"
    private let VIBRATORTIME = "VibratorTime"
    private let INVENTORYTIME = "InventoryTime"
    private let IDLETIME = "IdleTime"
    private let AUTOOFFTIME = "AutoOffTime"
    private let QVALUE = "QValue"
    private let ALGORITHM = "Algorithm"
    private let MAXQ = "MaxQ"
    private let MINQ = "MinQ"
    private let SLEEPTIME = "SleepTime"
    private let MASKTYPEVALUE = "MaskTypeValue"
    private let LINKPROFILEVALUE = "LinkProfileValue"
    private let OPERATIONTIME = "OperationTime"
    private let POWERGAIN = "PowerGain"
    private let INVENTORYSESSION = "InventorySession"
    private let SESSIONFLAG = "SessionFlag"
    private let USESELECTIONMASK = "UseSelectionMask"
    private let CONTINUOUSMODE = "ContinuousMode"
    private let RSSIMODE = "RssiMode"
    private let PROPBARCODEMODE = "PropBarcodeMode"
    private let EPCMASKMATCHMODE = "EpcMaskMatchMode"
    private let DISPLAYPC = "Displaypc"
    private let LBTITEMDATA = "LbtItemData"
    private let RFIDDATA = "RfidData"
    private let BARCODEDATA = "BarcodeData"
    private let MAPTAGS = "MapTags"
    private let EPCMASKDATA = "EpcMaskData"
    private let SELECTIONEPCMASKDATA = "SelectionEpcMaskData"
    private let BARCODEPARAMDATA = "barcodeParamData"
    private let barcodeRescanTime = "BarcodeRescanTime"
    private let isNotFirtUsed = "IsNotFirtUsed"
    private let defaultLinkKey = "DefaultLinkProfileValue"
    private let TIDLEN = "TidLength"
    private let TIDON = "TidOn"
    private let BATTERYINTERVAL = "batteryInterval"
    private let THRESHOLD = "thresHold"
    private let CUSTOMPREFIXSUFFIX = "CustomPrefixSuffix"
    private var userDefaults: UserDefaults!
    static private var systemSetting: SystemSetting!
    public final class func shared() -> SystemSetting! {
        if systemSetting == nil {
            systemSetting = SystemSetting()
        }
        return systemSetting
    }
    override init() {
        super.init()
        userDefaults = UserDefaults.standard
    }
    func setNotFirstUsed(_ isFirst: Bool) {
        userDefaults.set(isFirst, forKey: isNotFirtUsed)
        userDefaults.synchronize()
    }
    func getNotFirstUsed() -> Bool {
        return userDefaults.bool(forKey: isNotFirtUsed)
    }
    
    func setCustomPrefixSuffix(_ isPreSuffixOn: Bool) {
        userDefaults.set(isPreSuffixOn, forKey: CUSTOMPREFIXSUFFIX)
        userDefaults.synchronize()
    }
    func getCustomPrefixSuffix() -> Bool {
        return userDefaults.bool(forKey: CUSTOMPREFIXSUFFIX)
    }
    
    func setBuzzer(_ buzzrtType: Int) {
        userDefaults.set(buzzrtType, forKey: BUZZER)
        userDefaults.synchronize()
    }
    func setVibrator(_ vibratorType: Int) {
        userDefaults.set(vibratorType, forKey: VIBRATOR)
        userDefaults.synchronize()
    }
    func setInventoryTime(_ inventoryTime: Int) {
        userDefaults.set(inventoryTime, forKey: INVENTORYTIME)
        userDefaults.synchronize()
    }
    func setIdleTime(_ idleTime: Int) {
        userDefaults.set(idleTime, forKey: IDLETIME)
        userDefaults.synchronize()
    }
    func setAutoOffTime(_ autoOffTime: Int) {
        userDefaults.set(autoOffTime, forKey: AUTOOFFTIME)
        userDefaults.synchronize()
    }
    func setQValue(_ qValue: Int) {
        userDefaults.set(qValue, forKey: QVALUE)
        userDefaults.synchronize()
    }
    func setAlgorithm(_ algorithm: Int) {
        userDefaults.set(algorithm, forKey: ALGORITHM)
        userDefaults.synchronize()
    }
    func setMaxQ(_ maxQValue: Int) {
        userDefaults.set(maxQValue, forKey: MAXQ)
        userDefaults.synchronize()
    }
    func setMinQ(_ minQValue: Int) {
        userDefaults.set(minQValue, forKey: MINQ)
        userDefaults.synchronize()
    }
    func setSleepTime(_ sleepTimeValue: Int) {
        userDefaults.set(sleepTimeValue, forKey: SLEEPTIME)
        userDefaults.synchronize()
    }
    func setMaskTypeValue(_ maskTypeValue: Int) {
        userDefaults.set(maskTypeValue, forKey: MASKTYPEVALUE)
        userDefaults.synchronize()
    }
    func setLinkProfileValue(_ linkProfileValue: Int) {
        userDefaults.set(linkProfileValue, forKey: LINKPROFILEVALUE)
        userDefaults.synchronize()
    }
    func setDefaultLinkProfileValue(_ defaultLinkProfileValue: Int) {
        userDefaults.set(defaultLinkProfileValue, forKey: defaultLinkKey)
        userDefaults.synchronize()
    }
    func setOperationTime(_ operationTime: Int) {
        userDefaults.set(operationTime, forKey: OPERATIONTIME)
        userDefaults.synchronize()
    }
    func setPowerGain(_ powerGain: Int) {
        userDefaults.set(powerGain, forKey: POWERGAIN)
        userDefaults.synchronize()
    }
    func setInventorySession(_ inventorySession: Int) {
        userDefaults.set(inventorySession, forKey: INVENTORYSESSION)
        userDefaults.synchronize()
    }
    func setSessionFlag(_ sessionFlag: Int) {
        userDefaults.set(sessionFlag, forKey: SESSIONFLAG)
        userDefaults.synchronize()
    }
    func setUseSelectionMask(_ useSelectionMask: Int) {
        userDefaults.set(useSelectionMask, forKey: USESELECTIONMASK)
        userDefaults.synchronize()
    }
    func setContinuousMode(_ isContinuousMode: Bool) {
        userDefaults.set(isContinuousMode, forKey: CONTINUOUSMODE)
        userDefaults.synchronize()
    }
    func setRssiMode(_ isRssiMode: Bool) {
        userDefaults.set(isRssiMode, forKey: RSSIMODE)
        userDefaults.synchronize()
    }
    func setPropBarcodeMode(_ isPropBarcodeMode: Bool) {
        userDefaults.set(isPropBarcodeMode, forKey: PROPBARCODEMODE)
        userDefaults.synchronize()
    }
    func setEpcMaskMatchMode(_ isEpcMaskMatchMode: Bool) {
        userDefaults.set(isEpcMaskMatchMode, forKey: EPCMASKMATCHMODE)
        userDefaults.synchronize()
    }
    func setDisPlayPC(_ isDisplaypc: Bool) {
        userDefaults.set(isDisplaypc, forKey: DISPLAYPC)
        userDefaults.synchronize()
    }
    func setTidLength(_ length: Int) {
        userDefaults.set(length, forKey: TIDLEN)
        userDefaults.synchronize()
    }
    func setTidOn(_ isOn: Bool) {
        userDefaults.set(isOn, forKey: TIDON)
        userDefaults.synchronize()
    }
    func setLbtItemData(_ lbtItemData: [Any]?) {
        var lbtData: Data?
        if let aData = lbtItemData {
            do {
                lbtData = try NSKeyedArchiver.archivedData(
                    withRootObject: aData,
                    requiringSecureCoding: false
                )
            } catch {
               
            }
        }
        userDefaults.set(lbtData, forKey: LBTITEMDATA)
    }
    func setRfidData(_ rfidData: [Any]?) {
        var data: Data?
        if let aData = rfidData {
            do {
                data = try NSKeyedArchiver.archivedData(
                    withRootObject: aData,
                    requiringSecureCoding: false
                )
            } catch {
               
            }
        }
        userDefaults.set(data, forKey: RFIDDATA)
    }
    func setBarcodeData(_ barcodeData: [Any]?) {
        var data: Data?
        if let aData = barcodeData {
            do {
                data = try NSKeyedArchiver.archivedData(
                    withRootObject: aData,
                    requiringSecureCoding: false
                )
            } catch {
               
            }
        }
        userDefaults.set(data, forKey: BARCODEDATA)
    }
    func setMapTags(_ mapTags: [AnyHashable: Any]?) {
        var data: Data?
        if let aTags = mapTags {
            do {
                data = try NSKeyedArchiver.archivedData(
                    withRootObject: aTags,
                    requiringSecureCoding: false
                )
            } catch {
               
            }
        }
        userDefaults.set(data, forKey: MAPTAGS)
        data = nil
        userDefaults.synchronize()
    }
    func setEpcMaskData(_ epcMaskData: [Any]?) {
        var epcData: Data?
        if let aData = epcMaskData {
            do {
                epcData = try NSKeyedArchiver.archivedData(
                    withRootObject: aData,
                    requiringSecureCoding: false
                )
            } catch {
               
            }
        }
        userDefaults.set(epcData, forKey: EPCMASKDATA)
        epcData = nil
        userDefaults.synchronize()
    }
    func setSelectionEpcMaskData(_ selectionEpcMaskData: [Any]?) {
        var selectionEpcData: Data?
        if let aData = selectionEpcMaskData {
            do {
                selectionEpcData = try NSKeyedArchiver.archivedData(
                    withRootObject: aData,
                    requiringSecureCoding: false
                )
            } catch {
               
            }
        }
        userDefaults.set(selectionEpcData, forKey: SELECTIONEPCMASKDATA)
        selectionEpcData = nil
        userDefaults.synchronize()
    }
    func setBarcodeParamData(_ barcodeParamData: [Any]?) {
        var barcodeData: Data?
        if let aData = barcodeParamData {
            do {
                barcodeData = try NSKeyedArchiver.archivedData(
                    withRootObject: aData,
                    requiringSecureCoding: false
                )
            } catch {
               
            }
        }
        userDefaults.set(barcodeData, forKey: BARCODEPARAMDATA)
        barcodeData = nil
        userDefaults.synchronize()
    }
    func setThresHold(_ thresHold: Int) {
        userDefaults.set(thresHold, forKey: THRESHOLD)
        userDefaults.synchronize()
    }
    func getBuzzer() -> Int {
        return userDefaults.integer(forKey: BUZZER) 
    }
    func getVibrator() -> Int {
        return userDefaults.integer(forKey: VIBRATOR) 
    }
    func getInventoryTime() -> Int {
        return userDefaults.integer(forKey: INVENTORYTIME) 
    }
    func getIdleTime() -> Int {
        return userDefaults.integer(forKey: IDLETIME) 
    }
    func getAutoOffTime() -> Int {
        return userDefaults.integer(forKey: AUTOOFFTIME)
    }
    func getQValue() -> Int {
        return userDefaults.integer(forKey: QVALUE)
    }
    func getAlgorithm() -> Int {
        return userDefaults.integer(forKey: ALGORITHM)
    }
    func getMaxQ() -> Int {
        return userDefaults.integer(forKey: MAXQ)
    }
    func getMinQ() -> Int {
        return userDefaults.integer(forKey: MINQ)
    }
    func getSleepTime() -> Int {
        return userDefaults.integer(forKey: SLEEPTIME) 
    }
    func getMaskTypeValue() -> Int {
        return userDefaults.integer(forKey: MASKTYPEVALUE) 
    }
    func getLinkProfileValue() -> Int {
        return userDefaults.integer(forKey: LINKPROFILEVALUE) 
    }
    func getDefaultLinkProfileValue() -> Int {
        return userDefaults.integer(forKey: defaultLinkKey) 
    }
    func getOperationTime() -> Int {
        return userDefaults.integer(forKey: OPERATIONTIME) 
    }
    func getPowerGain() -> Int {
        return userDefaults.integer(forKey: POWERGAIN) 
    }
    func getInventorySession() -> Int {
        return userDefaults.integer(forKey: INVENTORYSESSION) 
    }
    func getSessionFlag() -> Int {
        return userDefaults.integer(forKey: SESSIONFLAG) 
    }
    func getUseSelectionMask() -> Int {
        return userDefaults.integer(forKey: USESELECTIONMASK) 
    }
    func getContinuousMode() -> Bool {
        return userDefaults.bool(forKey: CONTINUOUSMODE) 
    }
    func getRssiMode() -> Bool {
        return userDefaults.bool(forKey: RSSIMODE) 
    }
    func getPropBarcodeMode() -> Bool {
        return userDefaults.bool(forKey: PROPBARCODEMODE) 
    }
    func getEpcMaskMatchMode() -> Bool {
        return userDefaults.bool(forKey: EPCMASKMATCHMODE) 
    }
    func getDisPlayPC() -> Bool {
        return userDefaults.bool(forKey: DISPLAYPC) 
    }
    func getTidLength() -> Int {
        return userDefaults.integer(forKey: TIDLEN) 
    }
    func getTidOn() -> Bool {
        return userDefaults.bool(forKey: TIDON) 
    }
    func getThresHold() -> Int? {
        return userDefaults.integer(forKey: THRESHOLD)
    }
    func getLbtItemData() -> [LbtItem]? {
        guard let tokenObject = userDefaults.data(forKey: LBTITEMDATA) else {
            return nil
        }
        do {
            let unarchivedObject = try NSKeyedUnarchiver.unarchivedObject(
                ofClasses: [NSArray.self, LbtItem.self],
                from: tokenObject
            )
            return unarchivedObject as? [LbtItem]
        } catch {
            return nil
        }
    }
    func getBarcodeData() -> [AsBarcodeItem]? {
        guard let data = userDefaults.data(forKey: BARCODEDATA) else {
            return nil
        }
        do {
            let unarchivedObject = try NSKeyedUnarchiver.unarchivedObject(
                ofClasses: [NSArray.self, AsBarcodeItem.self],
                from: data
            )
            return unarchivedObject as? [AsBarcodeItem]
        } catch {
            return nil
        }
    }
    func getEpcMaskData() -> [AsSelectMaskParam]? {
        guard let tokenObject = userDefaults.data(forKey: EPCMASKDATA) else {
            return nil
        }
        do {
            let unarchivedObject = try NSKeyedUnarchiver.unarchivedObject(
                ofClasses: [NSArray.self, AsSelectMaskParam.self],
                from: tokenObject
            )
            return unarchivedObject as? [AsSelectMaskParam]
        } catch {
            return nil
        }
    }
    func getSelectionEpcMaskData() -> [AsSelectMaskEPCParam]? {
        guard let tokenObject = userDefaults.data(forKey: SELECTIONEPCMASKDATA) else {
            return nil
        }
        do {
            let unarchivedObject = try NSKeyedUnarchiver.unarchivedObject(
                ofClasses: [NSArray.self, AsSelectMaskEPCParam.self],
                from: tokenObject
            )
            return unarchivedObject as? [AsSelectMaskEPCParam]
        } catch {
            return nil
        }
    }
    func getBarcodeParamData() -> [AsParamValue]? {
        guard let tokenObject = userDefaults.data(forKey: BARCODEPARAMDATA) else {
            return nil
        }
        do {
            let unarchivedObject = try NSKeyedUnarchiver.unarchivedObject(
                ofClasses: [NSArray.self, AsParamValue.self],
                from: tokenObject
            )
            return unarchivedObject as? [AsParamValue]
        } catch {
            return nil
        }
    }
    func setBuzzerTime(_ buzzerTime: Int) {
        userDefaults.set(buzzerTime, forKey: BUZZERTIME)
        userDefaults.synchronize()
    }
    func getBuzzerTime() -> Int {
        return userDefaults.integer(forKey: BUZZERTIME) 
    }
    func setVibratorTime(_ vibratorTime: Int) {
        userDefaults.set(vibratorTime, forKey: VIBRATORTIME)
        userDefaults.synchronize()
    }
    func getVibratorTime() -> Int {
        return userDefaults.integer(forKey: VIBRATORTIME) 
    }
    func setBarcodeReScanTime(_ barcodeReScanTime: Int) {
        userDefaults.set(barcodeReScanTime, forKey: barcodeRescanTime)
        userDefaults.synchronize()
    }
    func getBarcodeReScanTime() -> Int {
        return userDefaults.integer(forKey: barcodeRescanTime) 
    }
    func setBatteryInterval(_ batteryInterval: String?) {
        userDefaults.set(batteryInterval, forKey: BATTERYINTERVAL)
        userDefaults.synchronize()
    }
    func getBatteryInterval() -> String? {
        guard let batteryInterval = userDefaults.string(forKey: BATTERYINTERVAL) else {
            return "10000"
        }
        guard !batteryInterval.isEmpty else {
            return "10000"
        }
        return batteryInterval
    }
}
