//
//  VersionHandler.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/13.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

protocol VersionHandlerDelegate: AnyObject {
    func updateUrl(_ url: String?, forceType: String?)
}
final class VersionHandler: NSObject {
    static var sharedVersionHandler: VersionHandler?
    weak var versionHandlerDelegate: VersionHandlerDelegate?
    var downloadUrl = ""
    var bundleVersion = ""
    var bundleBuild = ""
    var forceType = ""
    final class func shared() -> VersionHandler? {
        if sharedVersionHandler == nil {
            sharedVersionHandler = VersionHandler()
        }
        return sharedVersionHandler
    }
    override init() {
        super.init()
    }
    func getServeVersion(withUrl url: String?) {
        do {
            guard let nowUrl = url else {
                return
            }
            guard let nowUsedUrl = URL(string: nowUrl) else {
                return
            }
            let data = try Data(contentsOf: nowUsedUrl)
            var dic: [String: Any] = [:]
            var propertyListForamt =  PropertyListSerialization.PropertyListFormat.xml
            dic = (try PropertyListSerialization.propertyList(from: data,
                                                              options: .mutableContainersAndLeaves,
                                                              format: &propertyListForamt) as? [String: Any]) ?? [:]
            let itemsArray = (dic["items"] as? [Any]) ?? []
            for index in 0..<itemsArray.count where itemsArray[index] is [String: Any] {
                let itemsDic = (itemsArray[index] as? [String: Any]) ?? [:]
                if let aItemsArr = itemsDic["assets"] {
                    if  !(aItemsArr is NSNull) {
                        if aItemsArr is [Any] {
                            let assetsArray = (aItemsArr as? [Any]) ?? []
                            for tag in 0..<assetsArray.count  where assetsArray[tag] is [String: Any] {
                                let assetsDic = (assetsArray[tag] as? [String: Any]) ?? [:]
                                if let isJapan = getCurrentLanguage()?.hasPrefix("ja") {
                                    if isJapan {
                                        downloadUrl = (assetsDic["url_jp"] as? String) ?? ""
                                    }
                                }
                                if let isEN = getCurrentLanguage()?.hasPrefix("en") {
                                    if isEN {
                                        downloadUrl = (assetsDic["url_en"] as? String) ?? ""
                                    }
                                }
                                if let isChina = getCurrentLanguage()?.hasPrefix("zh-Hans") {
                                    if isChina {
                                        downloadUrl = (assetsDic["url_cn"] as? String) ?? ""
                                    }
                                }
                            }
                        }
                    }
                    if let aItemsDic = itemsDic["metadata"] {
                        if  !(aItemsDic is NSNull) {
                            if aItemsDic is [String: Any] {
                                let metadataDic = aItemsDic as? [String: Any]
                                if let bundleVer = metadataDic?["bundle-version"] {
                                    if !(bundleVer is NSNull) {
                                        bundleVersion = (bundleVer as? String) ?? ""
                                    }
                                }
                                if let bundleB = metadataDic?["bundle-build"] {
                                    if !(bundleB is NSNull) {
                                        bundleBuild = (bundleB as? String) ?? ""
                                    }
                                }
                                if let iosVerForce = metadataDic?["ios_ver_force"] {
                                    if !(iosVerForce is NSNull) {
                                        forceType = (iosVerForce as? String) ?? ""
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if !downloadUrl.isEmpty && !bundleVersion.isEmpty && !bundleBuild.isEmpty && !forceType.isEmpty {
                if isNeedDownloadApp() {
                    if versionHandlerDelegate != nil {
                        versionHandlerDelegate?.updateUrl(downloadUrl, forceType: forceType)
                    }
                }
            }
        } catch {
            print(error)
        }
    }
    func isNeedDownloadApp() -> Bool {
        let infoDictionary = Bundle.main.infoDictionary
        let appVersion = infoDictionary?["CFBundleShortVersionString"] as? String
        var appVersionArray: [String] = []
        if let aString = appVersion?.components(separatedBy: ".") {
            appVersionArray = aString
        }
        var serverVersionArray: [String] = bundleVersion.components(separatedBy: ".")
        if appVersionArray.count > serverVersionArray.count {
            for _ in serverVersionArray.count..<appVersionArray.count {
                serverVersionArray.append("0")
            }
        } else {
            for _ in appVersionArray.count..<serverVersionArray.count {
                appVersionArray.append("0")
            }
        }
        if appVersion == bundleVersion {
            return false
        } else {
            for index in 0..<appVersionArray.count {
                let serverVersion: Int = Int(serverVersionArray[index]) ?? 0
                let appVersion: Int = Int(appVersionArray[index]) ?? 0
                if serverVersion > appVersion {
                    return true
                } else if serverVersion < appVersion {
                    return false
                }
            }
        }
        return false
    }
    func getCurrentLanguage() -> String? {
        let languages = NSLocale.preferredLanguages
        let currentLanguage = languages[0]
        return currentLanguage
    }
}
