
//
//  RegionSettingViewController.swift
//  AsReaderGUN
//
//  Created by mac on 2020/9/23.
//  Copyright © 2020 Asterisk. All rights reserved.
//

import UIKit

class RegionSettingViewController: UITableViewController {
    @IBOutlet private var regionTableView: UITableView!
    private var asReaderGUNManager: AsReaderGUNManager! = AsReaderGUNManager.sharedAsReaderGUNManager
    private var systemSetting: SystemSetting! = SystemSetting.shared()
    private var regionList: [String] = []
    private var currentRegion: String = ""
    private var regionCheck: NSRange = NSRange.init()
    private var selectedIndex: NSInteger = 0
    override func viewDidLoad() {
        super.viewDidLoad()
        currentRegion = asReaderGUNManager.mReader?.regionName() ?? ""
        self.title = currentRegion
        regionList = ["USA", "Australia", "Japan", "Brazil", "Europe"]
        regionTableView.dataSource = self
        regionTableView.delegate = self
    }
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        asReaderGUNManager.asReaderGUNManagerDelegate = self
    }
    // MARK: - private
    private func updateRegion(regionValue: Int32, name: String) {
        let alertController = UIAlertController(title: "Change Region", message: name, preferredStyle: .alert)
        let okAction = UIAlertAction(title: ok, style: .default) { alert in
            AsReaderGUNManager.showGlobalProgressHUD(withTitle: "Please wait (MAX 40s)")
            if (self.asReaderGUNManager.mReader?.changeRegion(regionValue) == ResultNoError) {
                self.title = self.asReaderGUNManager.mReader?.regionName()
                let alertController2 = UIAlertController(title: "Success", message: "Press the power button once. The reader turns on again.", preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .cancel) { alert in
                }
                alertController2.addAction(okAction)
                self.present(alertController2, animated: true, completion: nil)
            } else if (self.asReaderGUNManager.mReader?.changeRegion(regionValue) == ResultNotSupportFirmware){
                let alertController3 = UIAlertController(title: "Setting fail", message: "NOT SUPPORTED REGION", preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .cancel) { alert in
                }
                alertController3.addAction(okAction)
                self.present(alertController3, animated: true, completion: nil)
            } else {
                let alertController4 = UIAlertController(title: "Setting fail", message: "Please try again", preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .cancel) { alert in
                }
                alertController4.addAction(okAction)
                self.present(alertController4, animated: true, completion: nil)
            }
            AsReaderGUNManager.dismissGlobalHUD()
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel) { alert in
            alertController.dismiss(animated: true, completion: nil)
        }
        alertController.addAction(okAction)
        alertController.addAction(cancelAction)
        present(alertController, animated: true, completion: nil)
    }
    // MARK: - tableViewDelegate
    override func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    override func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return regionList.count
    }
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withIdentifier: "RegionCell", for: indexPath)
        cell.textLabel!.text = regionList[indexPath.row]
        return cell
    }
    override func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        selectedIndex = indexPath.row
        switch selectedIndex {
        case 0:
            updateRegion(regionValue: 2, name: "US")
            break
        case 1:
            updateRegion(regionValue: 14, name: "Australia")
            break
        case 2:
            updateRegion(regionValue: 8, name: "Japan")
            break
        case 3:
            updateRegion(regionValue: 5, name: "Brazil")
            break
        case 4:
            updateRegion(regionValue: 1, name: "Europe")
            break
        default:
            break
        }
    }
}
// MARK: - AsReaderGUNManagerDelegate
extension RegionSettingViewController: AsReaderGUNManagerDelegate {
    func whenAsReaderGUNConnected(_ isConnected: Bool) {
        if isConnected == false {
            DispatchQueue.main.async {
                self.navigationController?.popToRootViewController(animated: true)
            }
        }
    }
}
