//
//  SelectionMaskEditViewController.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/10.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

final class SelectionMaskEditViewController: UIViewController {
    @IBOutlet private weak var targetTextField: UITextField!
    @IBOutlet private weak var actionTextField: UITextField!
    @IBOutlet private weak var bankTextField: UITextField!
    @IBOutlet private weak var offsetTextField: UITextField!
    @IBOutlet private weak var maskTextField: UITextField!
    @IBOutlet private weak var lengthTextField: UITextField!
    @IBOutlet private weak var pickerView: UIPickerView!
    @IBOutlet private weak var targetPickerTopView: UIView!
    @IBOutlet private weak var actionPickerTopView: UIView!
    @IBOutlet private weak var bankPickerTopView: UIView!
    @IBOutlet private weak var offsetPickerTopView: UIView!
    @IBOutlet private weak var lengthPickerTopView: UIView!
    private enum PickerViewTag: Int {
        case pickerViewTarget = 0
        case pickerViewAction = 1
        case pickerViewBank = 2
        case pickerViewOffset = 3
        case pickerViewLength = 4
    }
    private var asReaderGUNManager: AsReaderGUNManager! = AsReaderGUNManager.sharedAsReaderGUNManager
    var selectMaskParam: AsSelectMaskParam?
    private lazy var targetPickerData: [String] = {
        return dataTarget
    }()
    private lazy var actionPickerData: [String] = {
        return dataAction
    }()
    private lazy var bankPickerData: [String] = {
        return dataBank
    }()
    private lazy var offsetPickerData: [String] = {
        var tmpArray: [String] = []
        for offset in bitData {
            tmpArray.append("\(offset) bit")
        }
        return tmpArray
    }()
    private lazy var lengthPickerData: [String] = {
        var tmpArray: [String] = []
        for offset in bitData {
            tmpArray.append("\(offset) bit")
        }
        return tmpArray
    }()
    private lazy var bitData: [String] = {
        return dataBit
    }()
    override func viewDidLoad() {
        super.viewDidLoad()
        if let aSelectMaskParam = selectMaskParam {
            setTarget(Int(aSelectMaskParam.target.rawValue))
            setAction(Int(aSelectMaskParam.action.rawValue))
            setBank(Int(aSelectMaskParam.bank.rawValue))
            setOffset(getBitDataIndex(Int(aSelectMaskParam.offset)))
            setMask(aSelectMaskParam.mask)
            setLength(getBitDataIndex(Int(aSelectMaskParam.length)))
        } else {
            selectMaskParam = AsSelectMaskParam()
            setTarget(Int(MaskTarget_SL.rawValue))
            setAction(Int(MaskAction_AB.rawValue))
            setBank(Int(Bank_EPC.rawValue))
            setOffset(1)
            setLength(1)
        }
    }
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        asReaderGUNManager.asReaderGUNManagerDelegate = self
    }
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
    }
    override func shouldPerformSegue(withIdentifier identifier: String, sender: Any?) -> Bool {
        if identifier == "BackToSource" {
            if let text = lengthTextField.text {
                if let row = lengthPickerData.firstIndex(of: text) {
                    let maskBit = Int(bitData[row]) ?? 0
                    if maskTextField.text?.count != maskBit / 4 {
                        let alertController = UIAlertController(title: "Error",
                                                                message: "Mask length is not valid",
                                                                preferredStyle: .alert)
                        let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                        alertController.addAction(okAction)
                        present(alertController, animated: true, completion: nil)
                        return false
                    }
                }
            }
        }
        return true
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    @IBAction func targetBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewTarget.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        targetPickerTopView.isHidden = false
        if let text = targetTextField.text {
            if !text.isEmpty {
                if let row = targetPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func actionBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewAction.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        actionPickerTopView.isHidden = false
        if let text = actionTextField.text {
            if !text.isEmpty {
                if let row = actionPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func bankBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewBank.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        bankPickerTopView.isHidden = false
        if let text = bankTextField.text {
            if !text.isEmpty {
                if let row = bankPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func offsetBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewOffset.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        offsetPickerTopView.isHidden = false
        if let text = offsetTextField.text {
            if !text.isEmpty {
                if let row = offsetPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func maskBtnTapped(_ sender: UIButton) {
        let alertController = UIAlertController(title: "Mask:", message: "Please enter mask value.", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .numberPad
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: { _ in
            self.setMask("")
        })
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            self.setMask(alertController.textFields?.first?.text)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction func lengthBtnTapped(_ sender: UIButton) {
        pickerView.tag = PickerViewTag.pickerViewLength.rawValue
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        lengthPickerTopView.isHidden = false
        if let text = lengthTextField.text {
            if !text.isEmpty {
                if let row = lengthPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func pickerCloseBtnTapped(_ sender: UIButton) {
        hidePickerView()
    }
    @IBAction func targetPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setTarget(idx)
        hidePickerView()
    }
    @IBAction func actionPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setAction(idx)
        hidePickerView()
    }
    @IBAction func bankPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setBank(idx)
        hidePickerView()
    }
    @IBAction func offsetPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setOffset(idx)
        hidePickerView()
    }
    @IBAction func lengthPickerOkBtnTapped(_ sender: UIButton) {
        let idx: Int = pickerView.selectedRow(inComponent: 0)
        setLength(idx)
        hidePickerView()
    }
}
// MARK: - UIPickerViewDelegate, UIPickerViewDataSource
extension SelectionMaskEditViewController: UIPickerViewDelegate, UIPickerViewDataSource {
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return 1
    }
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewTarget {
                return targetPickerData.count
            } else if pickerViewTag == .pickerViewAction {
                return actionPickerData.count
            } else if pickerViewTag == .pickerViewBank {
                return bankPickerData.count
            } else if pickerViewTag == .pickerViewOffset {
                return bitData.count
            } else if pickerViewTag == .pickerViewLength {
                return lengthPickerData.count
            }
        }
        return 0
    }
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        if let pickerViewTag = PickerViewTag(rawValue: pickerView.tag) {
            if pickerViewTag == .pickerViewTarget {
                return targetPickerData[row]
            } else if pickerViewTag == .pickerViewAction {
                return actionPickerData[row]
            } else if pickerViewTag == .pickerViewBank {
                return bankPickerData[row]
            } else if pickerViewTag == .pickerViewOffset {
                return offsetPickerData[row]
            } else if pickerViewTag == .pickerViewLength {
                return lengthPickerData[row]
            }
        }
        return "None"
    }
}
// MARK: - Setters
extension  SelectionMaskEditViewController {
    func setTarget(_ index: Int) {
        targetTextField.text = targetPickerData[index]
        selectMaskParam?.target = MaskTargetType(rawValue: MaskTargetType.RawValue(index))
    }
    func setAction(_ index: Int) {
        actionTextField.text = actionPickerData[index]
        selectMaskParam?.action = MaskActionType(rawValue: MaskActionType.RawValue(index))
    }
    func setBank(_ index: Int) {
        bankTextField.text = bankPickerData[index]
        selectMaskParam?.bank = MemoryBank(rawValue: MemoryBank.RawValue(index))
    }
    func setOffset(_ index: Int) {
        offsetTextField.text = offsetPickerData[index]
        selectMaskParam?.offset = Int32(bitData[index]) ?? 0
    }
    func setMask(_ mask: String?) {
        maskTextField.text = mask
        selectMaskParam?.mask = mask
    }
    func setLength(_ index: Int) {
        lengthTextField.text = lengthPickerData[index]
        selectMaskParam?.length = Int32(bitData[index]) ?? 0
    }
}
// MARK: - AsReaderGUNManagerDelegate
extension SelectionMaskEditViewController: AsReaderGUNManagerDelegate {
    func whenAsReaderGUNConnected(_ isConnected: Bool) {
        if isConnected == true {
            DispatchQueue.main.async {
                self.viewDidAppear(true)
            }
        } else {
            DispatchQueue.main.async {
                self.navigationController?.popToRootViewController(animated: true)
            }
        }
    }
    func asReaderGUNOn(asReaderTriggerKeyEvent status: Bool) -> Bool {
        return false
    }
}
// MARK: - Custom
extension SelectionMaskEditViewController {
    func hidePickerView() {
        targetPickerTopView.isHidden = true
        actionPickerTopView.isHidden = true
        bankPickerTopView.isHidden = true
        offsetPickerTopView.isHidden = true
        lengthPickerTopView.isHidden = true
        pickerView.isHidden = true
    }
    func getBitDataIndex(_ bit: Int) -> Int {
        return bitData.firstIndex(of: "\(bit)") ?? 0
    }
}
// MARK: - UITextFieldDelegate
extension SelectionMaskEditViewController: UITextFieldDelegate {
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        if string.isEmpty {
            return true
        }
        if "0123456789ABCDEFabcdef" .contains(string) {
            let newString = (textField.text as NSString?)?.replacingCharacters(in: range, with: string)
            textField.text = newString?.uppercased()
        }
        return false
    }
}
