//
//  TagAccessViewController.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/13.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

final class TagAccessViewController: UIViewController {
    @IBOutlet private weak var selectionTagLabel: UILabel!
    @IBOutlet private weak var messageLabel: UILabel!
    @IBOutlet private weak var pickerView: UIPickerView!
    @IBOutlet private weak var killPasswordSwitch: UISwitch!
    @IBOutlet private weak var accessPasswordSwitch: UISwitch!
    @IBOutlet private weak var epcSwitch: UISwitch!
    @IBOutlet private weak var tidSwitch: UISwitch!
    @IBOutlet private weak var userSwitch: UISwitch!
    @IBOutlet private weak var passwordTextField: UITextField!
    @IBOutlet private weak var powerGainTextField: UITextField!
    @IBOutlet private weak var operationTimeTextField: UITextField!
    @IBOutlet private weak var lockBtn: UIButton!
    @IBOutlet private weak var unlockBtn: UIButton!
    @IBOutlet private weak var permalockBtn: UIButton!
    @IBOutlet private weak var killBtn: UIButton!
    @IBOutlet private weak var setAccessPwdBtn: UIButton!
    @IBOutlet private weak var setKillPwdBtn: UIButton!
    @IBOutlet private weak var clearBtn: UIButton!
    @IBOutlet private weak var maskBtn: UIButton!
    @IBOutlet private weak var powerGainPickerTopView: UIView!
    @IBOutlet private var buttonCollection: [UIButton]!
    @IBOutlet private weak var rssiLabel: UILabel!
    @IBOutlet private weak var phaseLabel: UILabel!
    @IBOutlet private weak var reportRssiSwitch: UISwitch!
    @IBOutlet private var reportRssiCollection: [UILabel]!
    private let pickerViewPowerGain = 0
    private var asReaderGUNManager: AsReaderGUNManager! = AsReaderGUNManager.sharedAsReaderGUNManager
    private var currentAlertController: UIAlertController?
    private var isActionResult = false
    private var maskType: MaskType?
    private var systemSetting: SystemSetting! = SystemSetting.shared()
    var maskValue = ""
    private var powerGainPickerData: [String] = []
    override func viewDidLoad() {
        super.viewDidLoad()
    }
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        asReaderGUNManager.asReaderGUNManagerDelegate = self
    }
    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        AsReaderGUNManager.showGlobalProgressHUD(withTitle: loading)
        if asReaderGUNManager.mReader == nil {
            AsReaderGUNManager.dismissGlobalHUD()
            return
        }
        initPowerGainPickerData()
        asReaderGUNManager.mReader?.continuousMode = false
        maskType = (asReaderGUNManager?.mReader?.maskTypeValue).map { MaskType(rawValue: MaskType.RawValue($0)) }
        if  !maskValue.isEmpty {
            asReaderGUNManager.initMask(maskValue, maskType: MaskType_Selection)
        }
        isActionResult = false
        if let powerGain =  asReaderGUNManager.mReader?.powerGain {
            let nPower = powerGain
            setPowerGain((Int(nPower / 10)))
        }
        if let operationTime = asReaderGUNManager.mReader?.operationTime {
            setOperationTime("\(operationTime)")
        }
        if let isReportRSSI = asReaderGUNManager.mReader?.rssiMode {
            setReportRssiModeEnabled(isReportRSSI)
        }
        pickerView.reloadAllComponents()
        if  !maskValue.isEmpty {
            selectionTagLabel.text = maskValue
            maskBtn.isEnabled = false
        }
        AsReaderGUNManager.dismissGlobalHUD()
    }
    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)
        if  !maskValue.isEmpty {
            asReaderGUNManager.exitMask()
        }
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    @IBAction func passwordBtnTapped(_ sender: UIButton) {
        let alertController = UIAlertController(title: "Password:", message: "Please enter password.", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .alphabet
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            let value = alertController.textFields?.first?.text
            self.setPassword(value)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction func powerGainBtnTapped(_ sender: UIButton) {
        pickerView.tag = pickerViewPowerGain
        pickerView.reloadAllComponents()
        pickerView.isHidden = false
        powerGainPickerTopView.isHidden = false
        if let text = powerGainTextField.text {
            if !text.isEmpty {
                if let row = powerGainPickerData.firstIndex(of: text) {
                    pickerView.selectRow(row, inComponent: 0, animated: false)
                    return
                }
            }
        }
        pickerView.selectRow(0, inComponent: 0, animated: false)
    }
    @IBAction func operationTimeBtnTapped(_ sender: UIButton) {
        let alertController = UIAlertController(title: "Operation Time:", message: "Please enter operation time.\n(ex: 30 ms)", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .numberPad
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            var text = alertController.textFields?.first?.text
            guard let value = text else {
                return
            }
            if value.isEmpty {
                text = "0"
            }
            if let aText = text {
                self.setOperationTime(aText)
                self.asReaderGUNManager.mReader?.operationTime = Int32(aText) ?? 0
                self.systemSetting.setOperationTime(Int(aText) ?? 0)
            }
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction func reportRssiSwitchTapped(_ sender: UISwitch) {
        asReaderGUNManager.mReader?.rssiMode = reportRssiSwitch.isOn
        systemSetting.setRssiMode(reportRssiSwitch.isOn)
        setReportRssiModeEnabled(reportRssiSwitch.isOn)
    }
    @IBAction func lockBtnTapped(_ sender: UIButton) {
        isActionResult = false
        asReaderGUNManager.mReader?.accessPassword = passwordTextField.text
        let param = LockParam()
        param.killPassword = killPasswordSwitch.isOn
        param.accessPassword = accessPasswordSwitch.isOn
        param.epc = epcSwitch.isOn
        param.tid = tidSwitch.isOn
        param.user = userSwitch.isOn
        if let operationTimeText = operationTimeTextField.text {
            let time: Int32 = Int32(operationTimeText) ?? 0
            asReaderGUNManager.mReader?.operationTime = time
            systemSetting.setOperationTime(Int(time))
        }
        if asReaderGUNManager.mReader?.lock(param) != ResultNoError {
            print("ERROR. Failed to start lock tag")
        }
    }
    @IBAction func unlockBtnTapped(_ sender: UIButton) {
        isActionResult = false
        asReaderGUNManager.mReader?.accessPassword = passwordTextField.text
        let param = LockParam()
        param.killPassword = killPasswordSwitch.isOn
        param.accessPassword = accessPasswordSwitch.isOn
        param.epc = epcSwitch.isOn
        param.tid = tidSwitch.isOn
        param.user = userSwitch.isOn
        if let operationTimeText = operationTimeTextField.text {
            let time: Int32 = Int32(operationTimeText) ?? 0
            asReaderGUNManager.mReader?.operationTime = time
            systemSetting.setOperationTime(Int(time))
        }
        if asReaderGUNManager.mReader?.unlock(param) != ResultNoError {
        }
    }
    @IBAction func permalockBtnTapped(_ sender: UIButton) {
        isActionResult = false
        asReaderGUNManager.mReader?.accessPassword = passwordTextField.text
        let param = LockParam()
        param.killPassword = killPasswordSwitch.isOn
        param.accessPassword = accessPasswordSwitch.isOn
        param.epc = epcSwitch.isOn
        param.tid = tidSwitch.isOn
        param.user = userSwitch.isOn
        if let operationTimeText = operationTimeTextField.text {
            let time: Int32 = Int32(operationTimeText) ?? 0
            asReaderGUNManager.mReader?.operationTime = time
            systemSetting.setOperationTime(Int(time))
        }
        if asReaderGUNManager.mReader?.permaLock(param) != ResultNoError {
        }
    }
    @IBAction func killBtnTapped(_ sender: UIButton) {
        isActionResult = false
        let alertController = UIAlertController(title: "Kill Password:", message: "Please enter password.", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .alphabet
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            guard let pwd: String = alertController.textFields?.first?.text else {
                self.currentAlertController?.dismiss(animated: true, completion: nil)
                self.currentAlertController = UIAlertController(title: "Error",
                                                                message: "Password length is not valid ",
                                                                preferredStyle: .alert)
                let okAction = UIAlertAction(title: cancel, style: .default, handler: nil)
                self.currentAlertController?.addAction(okAction)
                guard let alert = self.currentAlertController else {
                    return
                }
                self.present(alert, animated: true, completion: nil)
                return
            }
            if (pwd.count != 8) {
                self.currentAlertController?.dismiss(animated: true, completion: nil)
                self.currentAlertController = UIAlertController(title: "Error",
                                                                message: "Password length is not valid ",
                                                                preferredStyle: .alert)
                let okAction = UIAlertAction(title: cancel, style: .default, handler: nil)
                self.currentAlertController?.addAction(okAction)
                guard let alert = self.currentAlertController else {
                    return
                }
                self.present(alert, animated: true, completion: nil)
            } else {
                self.asReaderGUNManager.mReader?.kill(pwd)
            }
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction func setAccessPwdBtnTapped(_ sender: UIButton) {
        isActionResult = false
        let alertController = UIAlertController(title: "Set Access Password:", message: "Please enter password.", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .alphabet
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            let value = alertController.textFields?.first?.text
            self.asReaderGUNManager.mReader?.accessPassword = self.passwordTextField.text
            self.asReaderGUNManager.mReader?.writeMemory(Bank_Reserved, offset: 2, value: value)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction func setKillPwdBtnTapped(_ sender: UIButton) {
        isActionResult = false
        let alertController = UIAlertController(title: "Set Kill Password:", message: "Please enter password.", preferredStyle: .alert)
        alertController.addTextField { (textField) in
            textField.keyboardType = .alphabet
            textField.delegate = self
        }
        let cancelAction = UIAlertAction(title: cancel, style: .cancel, handler: nil)
        let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
            let value = alertController.textFields?.first?.text
            self.asReaderGUNManager.mReader?.accessPassword = self.passwordTextField.text
            self.asReaderGUNManager.mReader?.writeMemory(Bank_Reserved, offset: 0, value: value)
        })
        alertController.addAction(cancelAction)
        alertController.addAction(okAction)
        present(alertController, animated: true, completion: nil)
    }
    @IBAction func clearBtnTapped(_ sender: UIButton) {
        selectionTagLabel.text = "Result"
        messageLabel.text = msgTagWait
        rssiLabel.text = "0.0 dB"
        phaseLabel.text = "0.0˚"
    }
    @IBAction func maskBtnTapped(_ sender: UIButton) {
        if maskType == MaskType_Selection {
            performSegue(withIdentifier: "SelectionMask", sender: self)
        } else {
            currentAlertController?.dismiss(animated: true, completion: nil)
            currentAlertController = UIAlertController(title: "",
                                                       message: "Please choosing the Selection Mask type in the RFID Option menu.",
                                                       preferredStyle: .alert)
            let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
            currentAlertController?.addAction(okAction)
            guard let alert = self.currentAlertController else {
                return
            }
            self.present(alert, animated: true, completion: nil)
            return
        }
    }
    @IBAction func pickerCloseBtnTapped(_ sender: UIButton) {
        hidePickerView()
    }
    @IBAction func powerGainPickerOkBtnTapped(_ sender: UIButton) {
        var idx: Int32 = Int32(pickerView.selectedRow(inComponent: 0))
        if let min = asReaderGUNManager.mReader?.powerGainRange().min {
            idx += (min / 10)
        }
        setPowerGain(Int(idx))
        asReaderGUNManager.mReader?.powerGain = idx * 10
        systemSetting.setPowerGain(Int(idx * 10))
        hidePickerView()
    }
    @IBAction func prepare(forUnwind segue: UIStoryboardSegue) {
    }
}
// MARK: - AsReaderGUNManagerDelegate
extension TagAccessViewController: AsReaderGUNManagerDelegate {
    func whenAsReaderGUNConnected(_ isConnected: Bool) {
        if isConnected == true {
            DispatchQueue.main.async {
                self.viewDidAppear(true)
            }
        } else {
            DispatchQueue.main.async {
                self.navigationController?.popToRootViewController(animated: true)
            }
        }
    }
    func asReaderGUNOn(asReaderTriggerKeyEvent status: Bool) -> Bool {
        if status {
            DispatchQueue.main.async {
                self.currentAlertController?.dismiss(animated: true, completion: nil)
                self.currentAlertController = UIAlertController(title: "Error",
                                                                message: "For this page no Trigger key function.",
                                                                preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                self.currentAlertController?.addAction(okAction)
                let alert = self.currentAlertController
                self.present(alert!, animated: true, completion: nil)
            }
        }
        return false
    }
    func asReaderGUNOn(asReaderLeftModeKeyEvent status: Bool) -> Bool {
          let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
          let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
          if  rfidModule && barcodeModule {
              return true
          } else {
              return false
          }
      }
      func asReaderGUNOn(asReaderRightModeKeyEvent status: Bool) -> Bool {
          let rfidModule: Bool = (asReaderGUNManager.mReader?.isRFIDModule())!
          let barcodeModule: Bool = (asReaderGUNManager.mReader?.isBarcodeModule())!
          if  rfidModule && barcodeModule {
              return true
          } else {
              return false
          }
      }
    func asReaderGUNUpdateDeviceState(_ error: ResultCode) {
        if error != ResultNoError {
            DispatchQueue.main.async {
                self.currentAlertController?.dismiss(animated: true, completion: nil)
                self.currentAlertController = UIAlertController(title: "Error",
                                                                message: "Failed to get response. Try again.",
                                                                preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: { _ in
                    self.navigationController?.popViewController(animated: true)
                })
                self.currentAlertController?.addAction(okAction)
                guard let alert = self.currentAlertController else {
                    return
                }
                self.present(alert, animated: true, completion: nil)
            }
        }
    }
    func asReaderGUNChangedActionState(_ action: CommandType, resultCode: Int) {
        DispatchQueue.main.async {
            if action == CommandStop {
                self.currentAlertController?.dismiss(animated: true, completion: nil)
                if !self.isActionResult {
                    self.messageLabel.text = msgTagWait
                }
            } else {
                self.currentAlertController?.dismiss(animated: true, completion: nil)
                self.currentAlertController = UIAlertController(title: "On progress",
                                                                message: "Waiting Tag Memory",
                                                                preferredStyle: .alert)
                let okAction = UIAlertAction(title: "Stop", style: .default, handler: { _ in
                    self.stopAction()
                })
                self.currentAlertController?.addAction(okAction)
                guard let alert = self.currentAlertController else {
                    return
                }
                self.present(alert, animated: true, completion: nil)
            }
        }
    }
    func asReaderGUNAccessResult(_ error: ResultCode, actionState action: CommandType, epc: String?, data: String?, rssi: Float, phase: Float, frequency: Float) {
        isActionResult = true
        DispatchQueue.main.async {
            self.currentAlertController?.dismiss(animated: true, completion: nil)
            self.selectionTagLabel.text = epc
            if error != ResultNoError {
                self.messageLabel.text = AsResultCode.msg(error)
                self.currentAlertController = UIAlertController(title: "Error",
                                                                message: AsResultCode.msg(error),
                                                                preferredStyle: .alert)
                let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
                self.currentAlertController?.addAction(okAction)
                guard let alert = self.currentAlertController else {
                    return
                }
                self.present(alert, animated: true, completion: nil)
                return
            }
            self.messageLabel.text = "Success"
            if !self.reportRssiSwitch.isOn {
                self.setReportRssiModeDefault()
            } else {
                self.rssiLabel.text = String(format: "%.1f dB", rssi)
                self.phaseLabel.text = String(format: "%.1f˚", phase)
            }
            self.currentAlertController = UIAlertController(title: "Success",
                                                            message: "Write memory successfully",
                                                            preferredStyle: .alert)
            let okAction = UIAlertAction(title: ok, style: .default, handler: nil)
            self.currentAlertController?.addAction(okAction)
            guard let alert = self.currentAlertController else {
                return
            }
            self.present(alert, animated: true, completion: nil)
        }
    }
}
// MARK: - UIPickerViewDataSource, UIPickerViewDelegate
extension TagAccessViewController: UIPickerViewDataSource, UIPickerViewDelegate {
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return 1
    }
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        if pickerView.tag == pickerViewPowerGain {
            return powerGainPickerData.count
        }
        return 0
    }
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        if pickerView.tag == pickerViewPowerGain {
            return powerGainPickerData[row]
        }
        return "None"
    }
}
// MARK: - UITextFieldDelegate
extension TagAccessViewController: UITextFieldDelegate {
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        let text = textField.text ?? ""
        let length = text.count + string.count - range.length
        if length > maxPasswordLength {
            return false
        }
        if string.isEmpty {
            return true
        }
        if "0123456789ABCDEFabcdef" .contains(string) {
            let newString = (textField.text as NSString?)?.replacingCharacters(in: range, with: string)
            textField.text = newString?.uppercased()
        }
        return false
    }
}
// MARK: - Custom
extension TagAccessViewController {
    func initPowerGainPickerData() {
        var tmpArray: [String] = []
        if let min = asReaderGUNManager?.mReader?.powerGainRange().min,
            let max = asReaderGUNManager?.mReader?.powerGainRange().max {
            var index = min
            while index <= max {
                tmpArray.append(String(format: "%i.0 dB", index / 10))
                index += 10
            }
        }
        powerGainPickerData = tmpArray
    }
    func hidePickerView() {
        powerGainPickerTopView.isHidden = true
        pickerView.isHidden = true
    }
}
// MARK: - Setters
extension TagAccessViewController {
    func setPassword(_ password: String?) {
        passwordTextField.text = password
    }
    func setPowerGain(_ power: Int) {
        let value = String(format: "%i.0 dB", power)
        if powerGainPickerData.contains(value) {
            if  let index = powerGainPickerData.firstIndex(of: value) {
                if powerGainPickerData.count > index {
                    powerGainTextField.text = powerGainPickerData[index]
                }
            }
        }
    }
    func setOperationTime(_ operationTime: String?) {
        operationTimeTextField.text = operationTime
    }
    func stopAction() {
        asReaderGUNManager.mReader?.stop()
    }
    func setReportRssiModeEnabled(_ enabled: Bool) {
        for elem in reportRssiCollection {
            elem.isEnabled = enabled
        }
        if !enabled {
            setReportRssiModeDefault()
        }
        reportRssiSwitch.isOn = enabled
    }
    func setReportRssiModeDefault() {
        rssiLabel.text = String(format: "%.1f dB", 0.0)
        phaseLabel.text = String(format: "%.1f˚", 0.0)
    }
}
