//
//  AsBarcodeItem.swift
//  AsReaderGUN
//
//  Created by mac on 2018/7/10.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

final class AsBarcodeItem: NSObject, NSCoding {
    public var barcodeType  = BarcodeType.RawValue()
    public var codeId = ""
    public var barcode = ""
    public var dateTime = ""
    public var count: Int = 0

    func encode(with aCoder: NSCoder) {
        aCoder.encode(barcodeType, forKey: "barcodeType")
        aCoder.encode(codeId, forKey: "codeId")
        aCoder.encode(barcode, forKey: "barcode")
        aCoder.encode(dateTime, forKey: "dateTime")
        aCoder.encode(String.init(format: "%d", count), forKey: "count")
    }
    required init?(coder aDecoder: NSCoder) {
        super.init()
        barcodeType = (aDecoder.decodeObject(forKey: "barcodeType") as? BarcodeType.RawValue) ?? BarcodeTypeNoRead.rawValue
        codeId = (aDecoder.decodeObject(forKey: "codeId" ) as? String) ?? ""
        barcode = (aDecoder.decodeObject(forKey: "barcode" ) as? String) ?? ""
        dateTime = (aDecoder.decodeObject(forKey: "dateTime" ) as? String) ?? ""
        let countString: String = (aDecoder.decodeObject(forKey: "count" ) as? String) ?? ""
        count = Int(countString) ?? 0
    }
    
    init(barcodeType: BarcodeType, codeId: String, barcode: String, dateTime: String, count: Int) {
        self.barcodeType = barcodeType.rawValue
        self.codeId = codeId
        self.barcode = barcode
        self.dateTime = dateTime
        self.count = count
        super.init()
    }
    override init() {
        super.init()
    }
}
