//
//  ExcelData.h
//  AsReaderLR
//
//  Created by mac on 2018/11/27.
//  Copyright © 2018年 asterisk. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

typedef enum ExportType {
    barcodeExportType = 0,
    rfidExportType,
}ExportType;

@interface ExcelData : NSObject

+ (NSString *) filePath:(NSString *)fileName export:(ExportType)type;

+ (void) createExcelWithFileName:(NSString *)fileName export:(ExportType)type;

+ (void) exportRfidExcel:(NSString *)fileName withArray:(NSArray *)array export:(ExportType)type isEpc:(BOOL)isEpc isRssi:(BOOL)isRssiOn isTid:(BOOL)isTidOn;

+ (void) exportBarcodeExcel:(NSString *)fileName withArray:(NSArray *)array export:(ExportType)type;

+ (void)redirectNSLogToDocumentFolder;
+ (void)removeLogFile;
@end
