//
//  MainButton.swift
//  AsReaderGUN
//
//  Created by mac on 2018/6/29.
//  Copyright © 2018年 asterisk. All rights reserved.
//

import UIKit

final class MainButton: UIButton {
    private var didInitTextLabel = false
    private var isDisabled = false
    private lazy var textLabel: UILabel = {
        let buttonSize: CGSize = bounds.size
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineHeightMultiple = 0.80
        let attributes = [kCTParagraphStyleAttributeName: paragraphStyle,
                          kCTFontAttributeName: UIFont.systemFont(ofSize: 24.0)]
        let attributedText = NSAttributedString(string: titleLabel?.text ?? "",
                                                attributes: attributes as [NSAttributedString.Key: Any])
        let label = UILabel(frame: CGRect(x: 0, y: 0, width: buttonSize.width, height: 50))
        label.numberOfLines = 0
        label.attributedText = attributedText
        label.font = UIFont(name: "Helvetica-Bold", size: 24)
        label.textAlignment = .left
        label.center.y = titleLabel?.center.y ?? 0.0
        return label
    }()
    override func awakeFromNib() {
        super.awakeFromNib()
    }
    override func layoutSubviews() {
        super.layoutSubviews()
        initTextLabel()
    }
    func initTextLabel() {
        if !didInitTextLabel {
            setTitle("", for: .normal)
            addSubview(textLabel)
            didInitTextLabel = true
        }
    }
    func disableButton() {
        if !isDisabled {
            isDisabled = true
            isEnabled = false
            textLabel.textColor = UIColor.gray
        }
    }
     func enableButton() {
        if isDisabled {
            isDisabled = false
            isEnabled = true
            textLabel.textColor = UIColor.black

        }
    }
}
