/********* AsReaderGunPlugin.mm Cordova Plugin Implementation *******/

#import <Cordova/CDV.h>
#import <AsReaderGunSDK/AsReaderGunSDK.h>
#import <AsRingAccessorySDK/AsRingDeviceSDK.h>
#import <Foundation/Foundation.h>

@interface AsReaderGunPlugin : CDVPlugin<AsReaderDelegate>

@property (strong, nonatomic,readwrite) AsReaderGUN *mAsReaderGUN;
@property (strong, nonatomic,readwrite) AsReader *mReader;

#pragma mark ---init---
- (void)initAsReaderGUN:(CDVInvokedUrlCommand *)command;
#pragma mark ---Listener---
- (void)setAsReaderGUNDisconnectedListener:(CDVInvokedUrlCommand *)command;
- (void)setAsReaderGUNErrorListener:(CDVInvokedUrlCommand *)command;
- (void)setReaderInitializedListener:(CDVInvokedUrlCommand *)command;
- (void)setUpdateDeviceStateListener:(CDVInvokedUrlCommand *)command;
- (void)setReadTagListener:(CDVInvokedUrlCommand *)command;
- (void)setChangedActionStateListener:(CDVInvokedUrlCommand *)command;
- (void)setDetectBarcodeStringListener:(CDVInvokedUrlCommand *)command;
- (void)setDetectBarcodeDataListener:(CDVInvokedUrlCommand *)command;
- (void)setAccessResultListener:(CDVInvokedUrlCommand *)command;
- (void)setReadTagWithTidListener:(CDVInvokedUrlCommand *)command;
- (void)setCommandCompleteListener:(CDVInvokedUrlCommand *)command;
- (void)setOnModuleOverHeatedListener:(CDVInvokedUrlCommand *)command;
- (void)setOnResetReaderListener:(CDVInvokedUrlCommand *)command;
- (void)setOnAsReaderLeftModeKeyEventListener:(CDVInvokedUrlCommand *)command;
- (void)setOnAsReaderRightModeKeyEventListener:(CDVInvokedUrlCommand *)command;
- (void)setOnAsReaderTriggerKeyEventListener:(CDVInvokedUrlCommand *)command;
#pragma mark ---Property---
- (void)getIsAvailableDefaultLinkProfile:(CDVInvokedUrlCommand *)command;
- (void)setBuzzer:(CDVInvokedUrlCommand *)command;
- (void)getBuzzer:(CDVInvokedUrlCommand *)command;
- (void)setVibrator:(CDVInvokedUrlCommand *)command;
- (void)getVibrator:(CDVInvokedUrlCommand *)command;
- (void)setOperationTime:(CDVInvokedUrlCommand *)command;
- (void)getOperationTime:(CDVInvokedUrlCommand *)command;
- (void)setInventoryTime:(CDVInvokedUrlCommand *)command;
- (void)getInventoryTime:(CDVInvokedUrlCommand *)command;
- (void)setIdleTime:(CDVInvokedUrlCommand *)command;
- (void)getIdleTime:(CDVInvokedUrlCommand *)command;
- (void)setSleepTime:(CDVInvokedUrlCommand *)command;
- (void)getSleepTime:(CDVInvokedUrlCommand *)command;
- (void)setAutoOffTime:(CDVInvokedUrlCommand *)command;
- (void)getAutoOffTime:(CDVInvokedUrlCommand *)command;
- (void)setAccessPassword:(CDVInvokedUrlCommand *)command;
- (void)getAccessPassword:(CDVInvokedUrlCommand *)command;
- (void)setInventorySession:(CDVInvokedUrlCommand *)command;
- (void)getInventorySession:(CDVInvokedUrlCommand *)command;
- (void)setSessionFlag:(CDVInvokedUrlCommand *)command;
- (void)getSessionFlag:(CDVInvokedUrlCommand *)command;
- (void)getSerialNumber:(CDVInvokedUrlCommand *)command;
- (void)setContinuousMode:(CDVInvokedUrlCommand *)command;
- (void)getContinuousMode:(CDVInvokedUrlCommand *)command;
- (void)setPowerGain:(CDVInvokedUrlCommand *)command;
- (void)getPowerGain:(CDVInvokedUrlCommand *)command;
- (void)setUseSelectionMask:(CDVInvokedUrlCommand *)command;
- (void)getUseSelectionMask:(CDVInvokedUrlCommand *)command;
- (void)setReportMode:(CDVInvokedUrlCommand *)command;
- (void)getReportMode:(CDVInvokedUrlCommand *)command;
- (void)setStoredMode:(CDVInvokedUrlCommand *)command;
- (void)getStoredMode:(CDVInvokedUrlCommand *)command;
- (void)setRssiMode:(CDVInvokedUrlCommand *)command;
- (void)getRssiMode:(CDVInvokedUrlCommand *)command;
- (void)setEpcMaskMatchMode:(CDVInvokedUrlCommand *)command;
- (void)getEpcMaskMatchMode:(CDVInvokedUrlCommand *)command;
- (void)setAlgorithm:(CDVInvokedUrlCommand *)command;
- (void)getAlgorithm:(CDVInvokedUrlCommand *)command;
- (void)setMinQ:(CDVInvokedUrlCommand *)command;
- (void)getMinQ:(CDVInvokedUrlCommand *)command;
- (void)setMaxQ:(CDVInvokedUrlCommand *)command;
- (void)getMaxQ:(CDVInvokedUrlCommand *)command;
- (void)setQValue:(CDVInvokedUrlCommand *)command;
- (void)getQValue:(CDVInvokedUrlCommand *)command;
- (void)setLinkProfileValue:(CDVInvokedUrlCommand *)command;
- (void)getLinkProfileValue:(CDVInvokedUrlCommand *)command;
- (void)setDefaultLinkProfileValue:(CDVInvokedUrlCommand *)command;
- (void)getDefaultLinkProfileValue:(CDVInvokedUrlCommand *)command;
- (void)setMaskTypeValue:(CDVInvokedUrlCommand *)command;
- (void)getMaskTypeValue:(CDVInvokedUrlCommand *)command;
- (void)setThresHoldValue:(CDVInvokedUrlCommand *)command;
- (void)getThresHoldValue:(CDVInvokedUrlCommand *)command;
- (void)setModeLeftLedOn:(CDVInvokedUrlCommand *)command;
- (void)getModeLeftLedOn:(CDVInvokedUrlCommand *)command;
- (void)setModeRightLedOn:(CDVInvokedUrlCommand *)command;
- (void)getModeRightLedOn:(CDVInvokedUrlCommand *)command;
#pragma mark ---Method---
- (void)getAsReaderGUNAddress:(CDVInvokedUrlCommand *)command;
- (void)getAsReaderGUNVersion:(CDVInvokedUrlCommand *)command;
- (void)getAction:(CDVInvokedUrlCommand *)command;
- (void)setScanMode:(CDVInvokedUrlCommand *)command;
- (void)getScanMode:(CDVInvokedUrlCommand *)command;
- (void)changeRegion:(CDVInvokedUrlCommand *)command;
- (void)inventory:(CDVInvokedUrlCommand *)command;
- (void)inventoryWithTidOffset:(CDVInvokedUrlCommand *)command;
- (void)readMemory:(CDVInvokedUrlCommand *)command;
- (void)writeMemory:(CDVInvokedUrlCommand *)command;
- (void)lock:(CDVInvokedUrlCommand *)command;
- (void)unlock:(CDVInvokedUrlCommand *)command;
- (void)permaLock:(CDVInvokedUrlCommand *)command;
- (void)kill:(CDVInvokedUrlCommand *)command;
- (void)blockWrite:(CDVInvokedUrlCommand *)command;
- (void)blockErase:(CDVInvokedUrlCommand *)command;
- (void)stop:(CDVInvokedUrlCommand *)command;
- (void)stopSync:(CDVInvokedUrlCommand *)command;
- (void)defaultParameter:(CDVInvokedUrlCommand *)command;
- (void)setDebugMode:(CDVInvokedUrlCommand *)command;
- (void)getRegionName:(CDVInvokedUrlCommand *)command;
- (void)getRFModuleVersion:(CDVInvokedUrlCommand *)command;
- (void)getFirmwareVersion:(CDVInvokedUrlCommand *)command;
- (void)getPowerGainRange:(CDVInvokedUrlCommand *)command;
- (void)getBatteryStatus:(CDVInvokedUrlCommand *)command;
- (void)clearEpcMask:(CDVInvokedUrlCommand *)command;
- (void)getEpcMaskCount:(CDVInvokedUrlCommand *)command;
- (void)addEpcMaskWithAsSelectMaskEPCParam:(CDVInvokedUrlCommand *)command;
- (void)getEpcMask:(CDVInvokedUrlCommand *)command;
- (void)getLBT:(CDVInvokedUrlCommand *)command;
- (void)setLBT:(CDVInvokedUrlCommand *)command;
- (void)startBuzzerWithBuzzerTime:(CDVInvokedUrlCommand *)command;
- (void)startVibratorWithVibratorTime:(CDVInvokedUrlCommand *)command;
- (void)startDecode:(CDVInvokedUrlCommand *)command;
- (void)startDecodeWithEncodingType:(CDVInvokedUrlCommand *)command;
- (void)stopDecode:(CDVInvokedUrlCommand *)command;
- (void)setBarcodeParam:(CDVInvokedUrlCommand *)command;
- (void)getBarcodeParam:(CDVInvokedUrlCommand *)command;
- (void)usedSelectionMask:(CDVInvokedUrlCommand *)command;
- (void)getSelectionMask:(CDVInvokedUrlCommand *)command;
- (void)setSelectionMask:(CDVInvokedUrlCommand *)command;
- (void)clearSelectionMask:(CDVInvokedUrlCommand *)command;
- (void)removeSelectionMask:(CDVInvokedUrlCommand *)command;
- (void)readRegister:(CDVInvokedUrlCommand *)command;
- (void)readOEMCFGADDR_SJC_CFG:(CDVInvokedUrlCommand *)command;
- (void)setMaskUsed:(CDVInvokedUrlCommand *)command;
- (void)setBarcodeModeAndIsKeyAction:(CDVInvokedUrlCommand *)command;
- (void)isBarcodeModule:(CDVInvokedUrlCommand *)command;
- (void)isRFIDModule:(CDVInvokedUrlCommand *)command;
- (void)setPropBarcodeMode:(CDVInvokedUrlCommand *)command;
- (void)startHWTriggerDecode:(CDVInvokedUrlCommand *)command;
- (void)stopHWTriggerDecode:(CDVInvokedUrlCommand *)command;
- (void)doDefaultAsReaderLeftModeKeyTouch:(CDVInvokedUrlCommand *)command;
- (void)doDefaultAsReaderLeftModeKeyUp:(CDVInvokedUrlCommand *)command;
- (void)doDefaultAsReaderRightModeKeyTouch:(CDVInvokedUrlCommand *)command;
- (void)doDefaultAsReaderRightModeKeyUp:(CDVInvokedUrlCommand *)command;
- (void)doDefaultAsReaderTriggerKeyTouch:(CDVInvokedUrlCommand *)command;
- (void)doDefaultAsReaderTriggerKeyUp:(CDVInvokedUrlCommand *)command;
- (void)getAsRingFirmwareRevision:(CDVInvokedUrlCommand *)command;
@end

@implementation AsReaderGunPlugin {
    NSString *asReaderGUNDisconnectedListenerCallbackId;
    NSString *asReaderGUNErrorListenerCallbackId;
    NSString *readerInitializedListenerCallbackId;
    NSString *updateDeviceStateListenerCallbackId;
    NSString *readTagListenerCallbackId;
    NSString *changedActionStateListenerCallbackId;
    NSString *detectBarcodeStringListenerCallbackId;
    NSString *detectBarcodeDataListenerCallbackId;
    NSString *accessResultListenerCallbackId;
    NSString *readTagWithTidListenerCallbackId;
    NSString *commandCompleteListenerCallbackId;
    NSString *onModuleOverHeatedListenerCallbackId;
    NSString *onResetReaderListenerCallbackId;
    NSString *setOnAsReaderLeftModeKeyEventListenerCallbackId;
    NSString *setOnAsReaderRightModeKeyEventListenerCallbackId;
    NSString *setOnAsReaderTriggerKeyEventListenerCallbackId;
    NSStringEncoding encoding;
}
#pragma mark ---init---
- (void)pluginInitialize {
    encoding = NSASCIIStringEncoding;
    NSNotificationCenter *center = [NSNotificationCenter defaultCenter];
    [center addObserver:self selector:@selector(AsReaderGUNConnected:) name:@"AsReaderGUNConnected" object:nil];
    [center addObserver:self selector:@selector(AsReaderGUNDisconnected:) name:@"AsReaderGUNDisconnected" object:nil];
    [center addObserver:self selector:@selector(AsReaderGUNError:) name:@"Alert" object:nil];
}
- (void)initAsReaderGUN:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (!self.mAsReaderGUN) {
            NSArray *arguments = command.arguments;
            NSString *deviceModel = [NSString stringWithFormat:@"%@", [arguments objectAtIndex:0]];
            self.mAsReaderGUN = [[AsReaderGUN alloc] initWithDeviceModel:deviceModel];
            self.mAsReaderGUN.deviceModel = deviceModel;
        }
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)AsReaderGUNConnected:(NSNotification *)notification {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    dispatch_async(dispatch_get_main_queue(),^{
        if (self.mAsReaderGUN) {
            self.mReader = [[AsReader alloc] initWithAsReaderGUN:self.mAsReaderGUN delegate:self];
        }else{
            NSLog(@"self.mAsReaderGUN is nil.");
        }
    });
}
- (void)AsReaderGUNDisconnected:(NSNotification *)notification {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    self.mReader = nil;
    if (asReaderGUNDisconnectedListenerCallbackId) {
        CDVPluginResult *pluginResult = nil;
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:YES];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:asReaderGUNDisconnectedListenerCallbackId];
    }
}
- (void)AsReaderGUNError:(NSNotification *)notification {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (asReaderGUNErrorListenerCallbackId) {
        CDVPluginResult *pluginResult = nil;
        NSString *dataString = [[notification userInfo] objectForKey:@"DATA"];
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:dataString];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:asReaderGUNErrorListenerCallbackId];
    }
}
#pragma mark ---Listener---
- (void)setAsReaderGUNDisconnectedListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    asReaderGUNDisconnectedListenerCallbackId = command.callbackId;
}
- (void)setAsReaderGUNErrorListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    asReaderGUNErrorListenerCallbackId = command.callbackId;
}
- (void)setReaderInitializedListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    readerInitializedListenerCallbackId = command.callbackId;
}
- (void)setUpdateDeviceStateListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    updateDeviceStateListenerCallbackId = command.callbackId;
}
- (void)setReadTagListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    readTagListenerCallbackId = command.callbackId;
}
- (void)setChangedActionStateListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    changedActionStateListenerCallbackId = command.callbackId;
}
- (void)setDetectBarcodeStringListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    detectBarcodeStringListenerCallbackId = command.callbackId;
}
- (void)setDetectBarcodeDataListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    detectBarcodeDataListenerCallbackId = command.callbackId;
}
- (void)setAccessResultListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    accessResultListenerCallbackId = command.callbackId;
}
- (void)setReadTagWithTidListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    readTagWithTidListenerCallbackId = command.callbackId;
}
- (void)setCommandCompleteListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    commandCompleteListenerCallbackId = command.callbackId;
}
- (void)setOnModuleOverHeatedListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    onModuleOverHeatedListenerCallbackId = command.callbackId;
}
- (void)setOnResetReaderListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    onResetReaderListenerCallbackId = command.callbackId;
}
- (void)setOnAsReaderLeftModeKeyEventListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    setOnAsReaderLeftModeKeyEventListenerCallbackId = command.callbackId;
}
- (void)setOnAsReaderRightModeKeyEventListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    setOnAsReaderRightModeKeyEventListenerCallbackId = command.callbackId;
}
- (void)setOnAsReaderTriggerKeyEventListener:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    setOnAsReaderTriggerKeyEventListenerCallbackId = command.callbackId;
}
#pragma mark ---Property---
- (void)getIsAvailableDefaultLinkProfile:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            BOOL isAvailableDefaultLinkProfile = self.mReader.isAvailableDefaultLinkProfile;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:isAvailableDefaultLinkProfile];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setBuzzer:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            switch (idx) {
                case 0:
                case 1:
                case 2: {
                    self.mReader.buzzer = (BuzzerState)idx;
                    pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
                }
                    break;
                default:{
                    pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"parameter is not sufficient"];
                }
                    break;
            }
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getBuzzer:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            BuzzerState buzzer = self.mReader.buzzer;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:(int)buzzer];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setVibrator:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            switch (idx) {
                case 0:
                case 1:
                case 2: {
                    self.mReader.vibrator = (VibratorState)idx;
                    pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
                }
                    break;
                default:{
                    pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"parameter is not sufficient"];
                }
                    break;
            }
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getVibrator:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            VibratorState vibrator = self.mReader.vibrator;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:(int)vibrator];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setOperationTime:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            self.mReader.operationTime = idx;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getOperationTime:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int operationTime = self.mReader.operationTime;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:operationTime];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setInventoryTime:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            self.mReader.inventoryTime = idx;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getInventoryTime:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int inventoryTime = self.mReader.inventoryTime;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:inventoryTime];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setIdleTime:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            self.mReader.idleTime = idx;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getIdleTime:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int idleTime = self.mReader.idleTime;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:idleTime];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setSleepTime:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            self.mReader.sleepTime = idx;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getSleepTime:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int sleepTime = self.mReader.sleepTime;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:sleepTime];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setAutoOffTime:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            self.mReader.autoOffTime = idx;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getAutoOffTime:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int autoOffTime = self.mReader.autoOffTime;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:autoOffTime];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setAccessPassword:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            NSString *accessPassword = [NSString stringWithFormat:@"%@", [arguments objectAtIndex:0]];
            self.mReader.accessPassword = accessPassword;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getAccessPassword:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSString *accessPassword = self.mReader.accessPassword;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:accessPassword];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setInventorySession:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            switch (idx) {
                case 0:
                case 1:
                case 2:
                case 3:{
                    self.mReader.inventorySession = (SessionType)idx;
                    pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
                }
                    break;
                default:{
                    pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"parameter is not sufficient"];
                }
                    break;
            }
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getInventorySession:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            SessionType inventorySession = self.mReader.inventorySession;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:(int)inventorySession];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setSessionFlag:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            switch (idx) {
                case 0:
                case 1:
                case 2: {
                    self.mReader.sessionFlag = (SessionFlag)idx;
                    pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
                }
                    break;
                default:{
                    pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"parameter is not sufficient"];
                }
                    break;
            }
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getSessionFlag:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            SessionFlag sessionFlag = self.mReader.sessionFlag;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:(int)sessionFlag];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getSerialNumber:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSString *serialNumber = self.mReader.serialNumber;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:serialNumber];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setContinuousMode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            BOOL continuousMode = [[arguments objectAtIndex:0] boolValue];
            self.mReader.continuousMode = continuousMode;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getContinuousMode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            BOOL continuousMode = self.mReader.continuousMode;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:continuousMode];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setPowerGain:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int powerGain = [[arguments objectAtIndex:0] intValue];
            self.mReader.powerGain = powerGain;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getPowerGain:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int continuousMode = self.mReader.powerGain;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:continuousMode];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setUseSelectionMask:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            switch (idx) {
                case 0:
                case 1:
                case 2:
                case 3:{
                    self.mReader.useSelectionMask = (SelectFlag)idx;
                    pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
                }
                    break;
                default:{
                    pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"parameter is not sufficient"];
                }
                    break;
            }
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getUseSelectionMask:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            SelectFlag selectFlag = self.mReader.useSelectionMask;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:(int)selectFlag];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setReportMode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            BOOL reportMode = [[arguments objectAtIndex:0] boolValue];
            self.mReader.reportMode = reportMode;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getReportMode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            BOOL reportMode = self.mReader.reportMode;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:reportMode];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setStoredMode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            BOOL storedMode = [[arguments objectAtIndex:0] boolValue];
            self.mReader.storedMode = storedMode;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getStoredMode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            BOOL storedMode = self.mReader.storedMode;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:storedMode];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setRssiMode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            BOOL rssiMode = [[arguments objectAtIndex:0] boolValue];
            self.mReader.rssiMode = rssiMode;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getRssiMode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            BOOL rssiMode = self.mReader.rssiMode;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:rssiMode];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setEpcMaskMatchMode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            BOOL epcMaskMatchMode = [[arguments objectAtIndex:0] boolValue];
            self.mReader.epcMaskMatchMode = epcMaskMatchMode;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getEpcMaskMatchMode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            BOOL epcMaskMatchMode = self.mReader.epcMaskMatchMode;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:epcMaskMatchMode];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setAlgorithm:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            switch (idx) {
                case 0:
                case 1: {
                    self.mReader.algorithm = (AlgorithmType)idx;
                    pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
                }
                    break;
                default:{
                    pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"parameter is not sufficient"];
                }
                    break;
            }
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getAlgorithm:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            AlgorithmType algorithm = self.mReader.algorithm;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:(int)algorithm];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setMinQ:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int minQ = [[arguments objectAtIndex:0] intValue];
            self.mReader.minQ = minQ;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getMinQ:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int minQ = self.mReader.minQ;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:minQ];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setMaxQ:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int maxQ = [[arguments objectAtIndex:0] intValue];
            self.mReader.maxQ = maxQ;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getMaxQ:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int maxQ = self.mReader.maxQ;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:maxQ];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setQValue:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int qValue = [[arguments objectAtIndex:0] intValue];
            self.mReader.qValue = qValue;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getQValue:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int qValue = self.mReader.qValue;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:qValue];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setLinkProfileValue:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int linkProfileValue = [[arguments objectAtIndex:0] intValue];
            self.mReader.linkProfileValue = linkProfileValue;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getLinkProfileValue:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int linkProfileValue = self.mReader.linkProfileValue;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:linkProfileValue];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setDefaultLinkProfileValue:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int defaultLinkProfileValue = [[arguments objectAtIndex:0] intValue];
            self.mReader.defaultLinkProfileValue = defaultLinkProfileValue;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getDefaultLinkProfileValue:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int defaultLinkProfileValue = self.mReader.defaultLinkProfileValue;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:defaultLinkProfileValue];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setMaskTypeValue:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int maskTypeValue = [[arguments objectAtIndex:0] intValue];
            self.mReader.maskTypeValue = maskTypeValue;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getMaskTypeValue:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int maskTypeValue = self.mReader.maskTypeValue;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:maskTypeValue];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setThresHoldValue:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int thresHoldValue = [[arguments objectAtIndex:0] intValue];
            self.mReader.thresHoldValue = thresHoldValue;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getThresHoldValue:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int thresHoldValue = self.mReader.thresHoldValue;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:thresHoldValue];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setModeLeftLedOn:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            BOOL modeLeftLedOn = [[arguments objectAtIndex:0] boolValue];
            self.mReader.modeLeftLedOn = modeLeftLedOn;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getModeLeftLedOn:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            BOOL modeLeftLedOn = self.mReader.modeLeftLedOn;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:modeLeftLedOn];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setModeRightLedOn:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            BOOL modeRightLedOn = [[arguments objectAtIndex:0] boolValue];
            self.mReader.modeRightLedOn = modeRightLedOn;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        }else{
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getModeRightLedOn:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            BOOL modeRightLedOn = self.mReader.modeRightLedOn;
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:modeRightLedOn];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
#pragma mark ---Method---
- (void)getAsReaderGUNAddress:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    NSString *address = @"";
    if (self.mAsReaderGUN) {
        address = [self.mAsReaderGUN address];
    }
    CDVPluginResult *pluginResult = nil;
    pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:address];
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getAsReaderGUNVersion:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    NSString *versionString = @"";
    if (self.mAsReaderGUN) {
        versionString = [self.mAsReaderGUN getAsReaderGUNVersion];
    }
    CDVPluginResult *pluginResult = nil;
    pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:versionString];
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getAction:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            CommandType commandType = [self.mReader getAction];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:(int)commandType];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setScanMode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            [self.mReader setScanMode:(ScanMode)idx];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getScanMode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            ScanMode scanMode = [self.mReader getScanMode];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:(int)scanMode];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)changeRegion:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            ResultCode resultCode = [self.mReader changeRegion:idx];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)inventory:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            ResultCode resultCode = [self.mReader inventory];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)inventoryWithTidOffset:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int offset = [[arguments objectAtIndex:0] intValue];
            int length = [[arguments objectAtIndex:1] intValue];
            int inventorySession = [[arguments objectAtIndex:2] intValue];
            int sessionFlag = [[arguments objectAtIndex:3] intValue];
            ResultCode resultCode = [self.mReader inventoryWithTidOffset:offset length:length inventorySession:(SessionType)inventorySession sessionFlag:(SessionFlag)sessionFlag];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)readMemory:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int maskBank = [[arguments objectAtIndex:0] intValue];
            int offset = [[arguments objectAtIndex:1] intValue];
            int length = [[arguments objectAtIndex:2] intValue];
            MemoryBank bank;
            switch (maskBank) {
                case 0: {
                    bank = Bank_Reserved;
                }
                    break;
                case 1: {
                    bank = Bank_EPC;
                }
                    break;
                case 2: {
                    bank = Bank_TID;
                }
                    break;
                case 3: {
                    bank = Bank_User;
                }
                    break;
                default:
                    break;
            }
            ResultCode resultCode = [self.mReader readMemory:bank offset:offset length:length];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)writeMemory:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int maskBank = [[arguments objectAtIndex:0] intValue];
            int offset = [[arguments objectAtIndex:1] intValue];
            NSString *value = [NSString stringWithFormat:@"%@", [arguments objectAtIndex:2]];
            MemoryBank bank;
            switch (maskBank) {
                case 0: {
                    bank = Bank_Reserved;
                }
                    break;
                case 1: {
                    bank = Bank_EPC;
                }
                    break;
                case 2: {
                    bank = Bank_TID;
                }
                    break;
                case 3: {
                    bank = Bank_User;
                }
                    break;
                default:
                    break;
            }
            ResultCode resultCode = [self.mReader writeMemory:bank offset:offset value:value];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)lock:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            BOOL killPassword = [[arguments objectAtIndex:0] boolValue];
            BOOL accessPassword = [[arguments objectAtIndex:1] boolValue];
            BOOL epc = [[arguments objectAtIndex:2] boolValue];
            BOOL tid = [[arguments objectAtIndex:3] boolValue];
            BOOL user = [[arguments objectAtIndex:4] boolValue];
            LockParam *lockParam = [[LockParam alloc] init];
            lockParam.killPassword = killPassword;
            lockParam.accessPassword = accessPassword;
            lockParam.epc = epc;
            lockParam.tid = tid;
            lockParam.user = user;
            ResultCode resultCode = [self.mReader lock:lockParam];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)unlock:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            BOOL killPassword = [[arguments objectAtIndex:0] boolValue];
            BOOL accessPassword = [[arguments objectAtIndex:1] boolValue];
            BOOL epc = [[arguments objectAtIndex:2] boolValue];
            BOOL tid = [[arguments objectAtIndex:3] boolValue];
            BOOL user = [[arguments objectAtIndex:4] boolValue];
            LockParam *lockParam = [[LockParam alloc] init];
            lockParam.killPassword = killPassword;
            lockParam.accessPassword = accessPassword;
            lockParam.epc = epc;
            lockParam.tid = tid;
            lockParam.user = user;
            ResultCode resultCode = [self.mReader unlock:lockParam];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)permaLock:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            BOOL killPassword = [[arguments objectAtIndex:0] boolValue];
            BOOL accessPassword = [[arguments objectAtIndex:1] boolValue];
            BOOL epc = [[arguments objectAtIndex:2] boolValue];
            BOOL tid = [[arguments objectAtIndex:3] boolValue];
            BOOL user = [[arguments objectAtIndex:4] boolValue];
            LockParam *lockParam = [[LockParam alloc] init];
            lockParam.killPassword = killPassword;
            lockParam.accessPassword = accessPassword;
            lockParam.epc = epc;
            lockParam.tid = tid;
            lockParam.user = user;
            ResultCode resultCode = [self.mReader permaLock:lockParam];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)kill:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            NSString *killPassword = [NSString stringWithFormat:@"%@", [arguments objectAtIndex:0]];
            ResultCode resultCode = [self.mReader kill:killPassword];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)blockWrite:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int maskBank = [[arguments objectAtIndex:0] intValue];
            int offset = [[arguments objectAtIndex:1] intValue];
            NSString *value = [NSString stringWithFormat:@"%@", [arguments objectAtIndex:2]];
            MemoryBank bank;
            switch (maskBank) {
                case 0: {
                    bank = Bank_Reserved;
                }
                    break;
                case 1: {
                    bank = Bank_EPC;
                }
                    break;
                case 2: {
                    bank = Bank_TID;
                }
                    break;
                case 3: {
                    bank = Bank_User;
                }
                    break;
                default:
                    break;
            }
            ResultCode resultCode = [self.mReader blockWrite:bank offset:offset value:value];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)blockErase:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int maskBank = [[arguments objectAtIndex:0] intValue];
            int offset = [[arguments objectAtIndex:1] intValue];
            int length = [[arguments objectAtIndex:2] intValue];
            MemoryBank bank;
            switch (maskBank) {
                case 0: {
                    bank = Bank_Reserved;
                }
                    break;
                case 1: {
                    bank = Bank_EPC;
                }
                    break;
                case 2: {
                    bank = Bank_TID;
                }
                    break;
                case 3: {
                    bank = Bank_User;
                }
                    break;
                default:
                    break;
            }
            ResultCode resultCode = [self.mReader blockErase:bank offset:offset length:length];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)stop:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            ResultCode resultCode = [self.mReader stop];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)stopSync:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            ResultCode resultCode = [self.mReader stopSync];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)defaultParameter:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            ResultCode resultCode = [self.mReader defaultParameter];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setDebugMode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            BOOL mode = [[arguments objectAtIndex:0] boolValue];
            ResultCode resultCode = [self.mReader setDebugMode:mode];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getRegionName:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSString *name = [self.mReader regionName];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:name];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getRFModuleVersion:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSString *version = [self.mReader rFModuleVersion];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:version];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getFirmwareVersion:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSString *version = [self.mReader firmwareVersion];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:version];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getPowerGainRange:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            CMinMaxValue value = [self.mReader powerGainRange];
            NSMutableDictionary *dic = [NSMutableDictionary dictionary];
            [dic setValue:[NSString stringWithFormat:@"%d", value.min] forKey:@"min"];
            [dic setValue:[NSString stringWithFormat:@"%d", value.max] forKey:@"max"];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsDictionary:dic];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getBatteryStatus:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int battery = [self.mReader batteryStatus];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:battery];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)clearEpcMask:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            ResultCode resultCode = [self.mReader clearEpcMask];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getEpcMaskCount:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            int epcMaskCount = [self.mReader epcMaskCount];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:epcMaskCount];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)addEpcMaskWithAsSelectMaskEPCParam:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int offset = [[arguments objectAtIndex:0] intValue];
            int length = [[arguments objectAtIndex:1] intValue];
            NSString *mask = [NSString stringWithFormat:@"%@", [arguments objectAtIndex:2]];
            AsSelectMaskEPCParam *param = [[AsSelectMaskEPCParam alloc] init];
            param.offset = offset;
            param.length = length;
            param.mask = mask;
            ResultCode resultCode = [self.mReader addEpcMask:param];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getEpcMask:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            AsSelectMaskEPCParam *asSelectMaskEPCParam = [self.mReader getEpcMask:idx];
            NSMutableDictionary *dic = [NSMutableDictionary dictionary];
            if (asSelectMaskEPCParam) {
                [dic setValue:[NSString stringWithFormat:@"%d",asSelectMaskEPCParam.offset] forKey:@"offset"];
                [dic setValue:[NSString stringWithFormat:@"%d",asSelectMaskEPCParam.length] forKey:@"length"];
                [dic setValue:asSelectMaskEPCParam.mask forKey:@"mask"];
                [dic setValue:[NSString stringWithFormat:@"%d", idx] forKey:@"index"];
            } else {
                [dic setValue:@"" forKey:@"offset"];
                [dic setValue:@"" forKey:@"length"];
                [dic setValue:@"" forKey:@"mask"];
                [dic setValue:@"" forKey:@"index"];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsDictionary:dic];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getLBT:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSMutableArray *lbtItems = [[NSMutableArray alloc] initWithArray:[self.mReader getLBT]];
            LbtItem *lbtI = [[LbtItem alloc] init];
            for (LbtItem *lbtItem in lbtItems)
            {
                lbtItem.frequency = [self.mReader getLBTFrequency:lbtItem.mSlot];
                if ([lbtItem.frequency isEqualToString:@"0 HZ"]) {
                    lbtI = lbtItem;
                }
            }
            [lbtItems removeObject:lbtI];

            NSMutableArray *array = [NSMutableArray array];
            for (LbtItem *lbtItem in lbtItems) {
                NSMutableDictionary *dic = [NSMutableDictionary dictionary];
                [dic setValue:[NSString stringWithFormat:@"%d", lbtItem.mSlot] forKey:@"mSlot"];
                [dic setValue:[NSString stringWithFormat:@"%d", lbtItem.mIsUsed] forKey:@"mIsUsed"];
                [dic setValue:[NSString stringWithFormat:@"%@", lbtItem.frequency] forKey:@"frequency"];
                [array addObject:dic];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsArray:array];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setLBT:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            NSArray *lbtArray = [arguments objectAtIndex:0];
            NSMutableArray *array = [NSMutableArray array];
            for (NSDictionary *dic in lbtArray) {
                LbtItem *lbtItem = [[LbtItem alloc] initWithSlot:[[dic objectForKey:@"mSlot"] intValue] isUsed:[[dic objectForKey:@"mIsUsed"] boolValue]];
                [array addObject:lbtItem];
            }
            [self.mReader setLBT:array];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)startBuzzerWithBuzzerTime:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int time = [[arguments objectAtIndex:0] intValue];
            ResultCode resultCode = [self.mReader startBuzzerWithBuzzerTime:time];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)startVibratorWithVibratorTime:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int time = [[arguments objectAtIndex:0] intValue];
            ResultCode resultCode = [self.mReader startVibratorWithVibratorTime:time];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)startDecode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            ResultCode resultCode = [self.mReader startDecode];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)startDecodeWithEncodingType:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int encodingName = [[arguments objectAtIndex:0] intValue];
            encoding = (NSStringEncoding)encodingName;
            ResultCode resultCode = [self.mReader startDecode];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)stopDecode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            ResultCode resultCode = [self.mReader stopDecode];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setBarcodeParam:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int paramName = [[arguments objectAtIndex:0] intValue];
            unsigned int value = [[arguments objectAtIndex:1] unsignedIntValue];
            AsParamValue *val = [[AsParamValue alloc] init];
            val.paramName = (ParamName)paramName;
            val.value = value;
            ResultCode resultCode = [self.mReader setBarcodeParam:val];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getBarcodeParam:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            AsParamValue *val = [self.mReader getBarcodeParam:[NSNumber numberWithInt:idx]];
            NSMutableDictionary *dic = [NSMutableDictionary dictionary];
            if (val) {
                [dic setValue:[AsParamName getName:val.paramName] forKey:@"paramName"];
                [dic setValue:[NSString stringWithFormat:@"%d", val.value] forKey:@"value"];
            } else {
                [dic setValue:@"" forKey:@"paramName"];
                [dic setValue:@"" forKey:@"value"];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsDictionary:dic];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)usedSelectionMask:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            NSMutableDictionary *dic = [[NSMutableDictionary alloc] init];
            if (self.mReader) {
                BOOL result  = [self.mReader usedSelectionMask:idx];
                [dic setValue:[NSString stringWithFormat:@"%d",result] forKey:@"result"];
                [dic setValue:[NSString stringWithFormat:@"%d",idx] forKey:@"index"];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsDictionary:dic];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getSelectionMask:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            AsSelectMaskParam *val = [self.mReader getSelectionMask:idx];
            NSMutableDictionary *dic = [NSMutableDictionary dictionary];
            if (val) {
                [dic setValue:[NSString stringWithFormat:@"%d", val.target] forKey:@"target"];
                [dic setValue:[NSString stringWithFormat:@"%d", val.action] forKey:@"action"];
                [dic setValue:[NSString stringWithFormat:@"%d", val.bank] forKey:@"bank"];
                [dic setValue:[NSString stringWithFormat:@"%d", val.offset] forKey:@"offset"];
                if (!val.mask) {
                    val.mask = @"";
                }
                [dic setValue:[NSString stringWithFormat:@"%@", val.mask] forKey:@"mask"];
                [dic setValue:[NSString stringWithFormat:@"%d", val.length] forKey:@"length"];
                [dic setValue:[NSString stringWithFormat:@"%d", val.used] forKey:@"used"];
            } else {
                [dic setValue:@"" forKey:@"target"];
                [dic setValue:@"" forKey:@"action"];
                [dic setValue:@"" forKey:@"bank"];
                [dic setValue:@"" forKey:@"offset"];
                [dic setValue:@"" forKey:@"mask"];
                [dic setValue:@"" forKey:@"length"];
                [dic setValue:@"" forKey:@"used"];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsDictionary:dic];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setSelectionMask:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            int target = [[arguments objectAtIndex:1] intValue];
            int action = [[arguments objectAtIndex:2] intValue];
            int bank = [[arguments objectAtIndex:3] intValue];
            int offset = [[arguments objectAtIndex:4] intValue];
            NSString *mask = [NSString stringWithFormat:@"%@", [arguments objectAtIndex:5]];
            int length = [[arguments objectAtIndex:6] intValue];
            BOOL used = [[arguments objectAtIndex:7] boolValue];
            AsSelectMaskParam *asSelectMaskParam = [[AsSelectMaskParam alloc] init];
            asSelectMaskParam.target = (MaskTargetType)target;
            asSelectMaskParam.action = (MaskActionType)action;
            asSelectMaskParam.bank = (MemoryBank)bank;
            asSelectMaskParam.offset = offset;
            asSelectMaskParam.mask = mask;
            asSelectMaskParam.length = length;
            asSelectMaskParam.used = used;
            [self.mReader setSelectionMask:idx withParam:asSelectMaskParam];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)clearSelectionMask:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            [self.mReader clearSelectionMask];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)removeSelectionMask:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            [self.mReader removeSelectionMask:idx];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)readRegister:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            uint16_t idx = [[arguments objectAtIndex:0] longLongValue];
            [self.mReader readRegister:idx];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)readOEMCFGADDR_SJC_CFG:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            [self.mReader readOEMCFGADDR_SJC_CFG];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setMaskUsed:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            int idx = [[arguments objectAtIndex:0] intValue];
            BOOL used = [[arguments objectAtIndex:1] boolValue];
            [self.mReader setMaskUsed:idx used:used];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setBarcodeModeAndIsKeyAction:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            BOOL mode = [[arguments objectAtIndex:0] boolValue];
            BOOL keyAction = [[arguments objectAtIndex:1] boolValue];
            ResultCode resultCode = [self.mReader setBarcodeMode:mode isKeyAction:keyAction];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)isBarcodeModule:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            BOOL module = [self.mReader isBarcodeModule];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:module];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)isRFIDModule:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            BOOL module = [self.mReader isRFIDModule];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:module];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)setPropBarcodeMode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            NSArray *arguments = command.arguments;
            BOOL mode = [[arguments objectAtIndex:0] boolValue];
            [self.mReader setPropBarcodeMode:mode];
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)startHWTriggerDecode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            ResultCode resultCode = [self.mReader startHWTriggerDecode];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)stopHWTriggerDecode:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            ResultCode resultCode = [self.mReader stopHWTriggerDecode];
            NSString * errorString = @"success";
            if (resultCode != ResultNoError) {
                errorString = [AsResultCode msg:resultCode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)doDefaultAsReaderLeftModeKeyTouch:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            if (self.mReader.isRFIDModule && self.mReader.isBarcodeModule){
                if ([self.mReader getScanMode] == RFIDScanMode) {
                    [self.mReader setScanMode:BarcodeScanMode];
                }else if ([self.mReader getScanMode] == BarcodeScanMode){
                    [self.mReader setScanMode:RFIDScanMode];
                }
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)doDefaultAsReaderLeftModeKeyUp:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)doDefaultAsReaderRightModeKeyTouch:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            if (self.mReader.isRFIDModule && self.mReader.isBarcodeModule){
                if ([self.mReader getScanMode] == RFIDScanMode) {
                    [self.mReader setScanMode:BarcodeScanMode];
                }else if ([self.mReader getScanMode] == BarcodeScanMode){
                    [self.mReader setScanMode:RFIDScanMode];
                }
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)doDefaultAsReaderRightModeKeyUp:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)doDefaultAsReaderTriggerKeyTouch:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            if (self.mReader.isRFIDModule){
                [self.mReader inventory];
            }else if (self.mReader.isBarcodeModule){
                [self.mReader startDecode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)doDefaultAsReaderTriggerKeyUp:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        if (self.mReader) {
            if (self.mReader.isRFIDModule){
                [self.mReader stop];
            }else if (self.mReader.isBarcodeModule){
                [self.mReader stopDecode];
            }
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"success"];
        } else {
            pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"asreader is nil"];
        }
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
- (void)getAsRingFirmwareRevision:(CDVInvokedUrlCommand *)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    CDVPluginResult *pluginResult = nil;
    @try {
        NSString *version = [[AsRingDeviceSDK sharedAsRingDeviceSDK] getAsRingFirmwareRevision];
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:version];
    } @catch (NSException *exception) {
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:@"sdk error"];
    } @finally {
    }
    [self.commandDelegate sendPluginResult:pluginResult callbackId:command.callbackId];
}
#pragma mark ---AsReaderDelegate---
- (void)readerInitialized:(AsReader *)reader {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (readerInitializedListenerCallbackId) {
        CDVPluginResult *pluginResult = nil;
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:YES];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:readerInitializedListenerCallbackId];
    }
}
- (void)updateDeviceState:(ResultCode)error {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (updateDeviceStateListenerCallbackId) {
        CDVPluginResult *pluginResult = nil;
        NSString * errorString = @"success";
        if (error != ResultNoError) {
            errorString = [AsResultCode msg:error];
        }
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsString:errorString];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:updateDeviceStateListenerCallbackId];
    }
}
- (void)readTag:(NSString *)tag rssi:(float)rssi phase:(float)phase frequency:(float)frequency {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (readTagListenerCallbackId) {
        //    dispatch_queue_t queue =  dispatch_queue_create("queue",DISPATCH_QUEUE_SERIAL);
        //    dispatch_async(queue, ^{
        NSMutableDictionary *dic = [NSMutableDictionary dictionary];
        [dic setValue:tag forKey:@"tag"];
        [dic setValue:[NSString stringWithFormat:@"%f",rssi] forKey:@"rssi"];
        [dic setValue:[NSString stringWithFormat:@"%f",phase] forKey:@"phase"];
        [dic setValue:[NSString stringWithFormat:@"%f",frequency] forKey:@"frequency"];
        CDVPluginResult *pluginResult = nil;
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsDictionary:dic];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:readTagListenerCallbackId];
        //    });
    }
}
- (void)changedActionState:(CommandType)action resultCode:(NSInteger)resultCode {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (changedActionStateListenerCallbackId) {
        CDVPluginResult *pluginResult = nil;
        NSMutableDictionary *dic = [NSMutableDictionary dictionary];
        [dic setValue:[NSString stringWithFormat:@"%d",action] forKey:@"action"];
        NSString * errorString = @"success";
        if (resultCode != ResultNoError) {
            errorString = [AsResultCode msg:(ResultCode)resultCode];
        }
        [dic setValue:[NSString stringWithFormat:@"%@",errorString] forKey:@"resultCode"];
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsDictionary:dic];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:changedActionStateListenerCallbackId];
    }
}
- (void)detectBarcode:(BarcodeType)barcodeType codeId:(NSString *)codeId barcode:(NSString *)barcode {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (detectBarcodeStringListenerCallbackId) {
        NSString *barcodeTypeStr = [AsBarcodeType getBarcodeString:barcodeType];
        CDVPluginResult *pluginResult = nil;
        NSMutableDictionary *dic = [NSMutableDictionary dictionary];
        [dic setValue:barcodeTypeStr forKey:@"barcodeType"];
        [dic setValue:barcode forKey:@"barcode"];
        [dic setValue:codeId forKey:@"codeId"];
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsDictionary:dic];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:detectBarcodeStringListenerCallbackId];
    }
}
- (void)detectBarcode:(BarcodeType)barcodeType codeId:(NSString *)codeId barcodeData:(NSData *)barcodeData {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (detectBarcodeDataListenerCallbackId) {
        NSString *barcode = [[NSString alloc] initWithData:barcodeData encoding:encoding];
        if (!barcode) {
            barcode = @"";
        }
        NSString *barcodeTypeStr = [AsBarcodeType getBarcodeString:barcodeType];
        CDVPluginResult *pluginResult = nil;
        NSMutableDictionary *dic = [NSMutableDictionary dictionary];
        [dic setValue:barcodeTypeStr forKey:@"barcodeType"];
        [dic setValue:barcode forKey:@"barcode"];
        [dic setValue:codeId forKey:@"codeId"];
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsDictionary:dic];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:detectBarcodeDataListenerCallbackId];
    }
}
- (void)accessResult:(ResultCode)error actionState:(CommandType)action epc:(NSString *)epc data:(NSString *)data rssi:(float)rssi phase:(float)phase frequency:(float)frequency {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (accessResultListenerCallbackId) {
        NSMutableDictionary *dic = [NSMutableDictionary dictionary];
        NSString * errorString = @"success";
        if (error != ResultNoError) {
            errorString = [AsResultCode msg:error];
        }
        [dic setValue:[NSString stringWithFormat:@"%@", errorString] forKey:@"error"];
        [dic setValue:[NSString stringWithFormat:@"%d", action] forKey:@"action"];
        [dic setValue:[NSString stringWithFormat:@"%@", epc] forKey:@"epc"];
        [dic setValue:[NSString stringWithFormat:@"%@", data] forKey:@"data"];
        [dic setValue:[NSString stringWithFormat:@"%f", rssi] forKey:@"rssi"];
        [dic setValue:[NSString stringWithFormat:@"%f", phase] forKey:@"phase"];
        [dic setValue:[NSString stringWithFormat:@"%f", frequency] forKey:@"frequency"];
        CDVPluginResult *pluginResult = nil;
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsDictionary:dic];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:accessResultListenerCallbackId];
    }
}
- (void)readTagWithTid:(ResultCode)error actionState:(CommandType)action epc:(NSString *)epc tid:(NSString *)data rssi:(float)rssi phase:(float)phase frequency:(float)frequency {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (readTagWithTidListenerCallbackId) {
        NSMutableDictionary *dic = [NSMutableDictionary dictionary];
        NSString * errorString = @"success";
        if (error != ResultNoError) {
            errorString = [AsResultCode msg:error];
        }
        [dic setValue:[NSString stringWithFormat:@"%@", errorString] forKey:@"error"];
        [dic setValue:[NSString stringWithFormat:@"%d", action] forKey:@"action"];
        [dic setValue:[NSString stringWithFormat:@"%@", epc] forKey:@"epc"];
        [dic setValue:[NSString stringWithFormat:@"%@", data] forKey:@"tid"];
        [dic setValue:[NSString stringWithFormat:@"%f", rssi] forKey:@"rssi"];
        [dic setValue:[NSString stringWithFormat:@"%f", phase] forKey:@"phase"];
        [dic setValue:[NSString stringWithFormat:@"%f", frequency] forKey:@"frequency"];
        CDVPluginResult *pluginResult = nil;
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsDictionary:dic];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:readTagWithTidListenerCallbackId];
    }
}
- (void)commandComplete:(CommandType)command {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (commandCompleteListenerCallbackId) {
        CDVPluginResult *pluginResult = nil;
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsInt:command];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:commandCompleteListenerCallbackId];
    }
}
- (void)onModuleOverHeated {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (onModuleOverHeatedListenerCallbackId) {
        CDVPluginResult *pluginResult = nil;
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:commandCompleteListenerCallbackId];
    }
}
- (void)onResetReader {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (onResetReaderListenerCallbackId) {
        CDVPluginResult *pluginResult = nil;
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:commandCompleteListenerCallbackId];
    }
}
- (BOOL)onAsReaderLeftModeKeyEvent:(BOOL)status {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (setOnAsReaderLeftModeKeyEventListenerCallbackId) {
        CDVPluginResult *pluginResult = nil;
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:status];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:setOnAsReaderLeftModeKeyEventListenerCallbackId];
    }
    return NO;
}
- (BOOL)onAsReaderRightModeKeyEvent:(BOOL)status {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (setOnAsReaderRightModeKeyEventListenerCallbackId) {
        CDVPluginResult *pluginResult = nil;
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:status];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:setOnAsReaderRightModeKeyEventListenerCallbackId];
    }
    return NO;
}
- (BOOL)onAsReaderTriggerKeyEvent:(BOOL)status {
    NSLog(@"%s,called",__PRETTY_FUNCTION__);
    if (setOnAsReaderTriggerKeyEventListenerCallbackId) {
        CDVPluginResult *pluginResult = nil;
        pluginResult = [CDVPluginResult resultWithStatus:CDVCommandStatus_OK messageAsBool:status];
        [pluginResult setKeepCallbackAsBool:YES];
        [self.commandDelegate sendPluginResult:pluginResult callbackId:setOnAsReaderTriggerKeyEventListenerCallbackId];
    }
    return NO;
}
@end
