    var exec = require('cordova/exec');

    window.ParamName = {
        Unknown                        : 0,
        Default                        : 1,
        Revision                       : 2,
        RevisionDecoder                : 3,
        RevisionDriver                 : 4,
        TerminalId                     : 5,
        Baudrate                       : 6,
        WordLength                     : 7,
        ReceiverTimeout                : 8,
        RtsCts                         : 9,
        XonXoff                        : 10,
        AckNak                         : 11,
        TtlLeve                        : 12,
        ImageVga                       : 13,
        PowerUpBeeper                  : 14,
        BeepOnBELChar                  : 15,
        TriggerClick                   : 16,
        Beep                           : 17,
        BeepVolume                     : 18,
        BeepFreq                       : 19,
        BeepError                      : 20,
        BeepDuration                   : 21,
        Led                            : 22,
        LedPolarity                    : 23,
        BeepErrNumber                  : 24,
        BeepNumber                     : 25,
        BeepPolarity                   : 26,
        GoodReadDelay                  : 27,
        TriggerMode                    : 28,
        ManualTriggerMode              : 29,
        IlluminationManual             : 30,
        ReadTimeout                    : 31,
        LowPowerTimeout                : 32,
        LedAfterDecode                 : 33,
        LedTimeout                     : 34,
        PresentSensitifity             : 35,
        PresentaionMode                : 36,
        IdleIllumination               : 37,
        PresentationCenteringEnable    : 38,
        PresentationCenteringTop       : 39,
        PresentationCenteringBottom    : 40,
        PresentationCenteringLeft      : 41,
        PresentationCenteringRight     : 42,
        PoorQuality1DCodes             : 43,
        PoorQuality1PDFCodes           : 44,
        CodeGate                       : 45,
        HandlHeldScanning              : 46,
        PresentationScanning           : 47,
        HandsFreeTimeout               : 48,
        RereadDelay                    : 49,
        LedPowerLevel                  : 50,
        RereadDelay2D                  : 51,
        CharActMode                    : 52,
        ActiveChar                     : 53,
        EndCharAct                     : 54,
        CharActTimeout                 : 55,
        CharDeactMode                  : 56,
        DeactChar                      : 57,
        IlluminationLights             : 58,
        ImagerTimeout                  : 59,
        AimerDelay                     : 60,
        AimerMode                      : 61,
        CenterWindow                   : 62,
        CenterWindowLeft               : 63,
        CenterWindowRight              : 64,
        CenterWindowTop                : 65,
        CenterWindowBottom             : 66,
        CenterWin40                    : 67,
        CenterWin60                    : 68,
        DecodeMode                     : 69,
        EnterSequence                  : 70,
        DefaultSequence                : 71,
        RequireSequence                : 72,
        MultipleSymbols                : 73,
        NoRead                         : 74,
        PrintWeight                    : 75,
        VideoReverse                   : 76,
        WorkingOrientation             : 77,
        AddAllCRSuffix                 : 78,
        AddPrefix                      : 79,
        ClearOnePrefix                 : 80,
        ClearAllPrefix                 : 81,
        AddSuffix                      : 82,
        ClearOneSuffix                 : 83,
        ClearAllSuffix                 : 84,
        FuncCodeTransmit               : 85,
        IntercharacterDelay            : 86,
        IntercharacterDelayLength      : 87,
        CharacterTriggerDelay          : 88,
        InterfunctionDelay             : 89,
        IntermessageDealy              : 90,
        DefaultDataFormat              : 91,
        EnterDataFormat                : 92,
        ClearOneDataFormat             : 93,
        ClearAllDataFormat             : 94,
        DataFormatter                  : 95,
        AlternateDataFormats1          : 96,
        AlternateDataFormats2          : 97,
        AlternateDataFormats3          : 98,
        DataFormat                     : 99,
        AllSymbol                      : 100,
        CodabarDefault                 : 101,
        Codabar                        : 102,
        CodabarStartStopChar           : 103,
        CodabarCheckChar               : 104,
        CodabarConcatenation           : 105,
        CodabarLengthMin               : 106,
        CodabarLengthMax               : 107,
        Code39Default                  : 108,
        Code39                         : 109,
        Code39StartStopChar            : 110,
        Code39CheckChar                : 111,
        Code39LengthMin                : 112,
        Code39LengthMax                : 113,
        Code39Append                   : 114,
        Code32Pharmaceutical           : 115,
        Code39FullAscii                : 116,
        Code39CodePage                 : 117,
        I2of5Default                   : 118,
        I2of5                          : 119,
        I2of5CheckDigit                : 120,
        I2of5LengthMin                 : 121,
        I2of5LengthMax                 : 122,
        NEC2of5Default                 : 123,
        NEC2of5                        : 124,
        NEC2of5CheckDigit              : 125,
        NEC2of5LengthMin               : 126,
        NEC2of5LengthMax               : 127,
        Code93Default                  : 128,
        Code93                         : 129,
        Code93LengthMin                : 130,
        Code93LengthMax                : 131,
        Code93Append                   : 132,
        Code93CodePage                 : 133,
        R2of5Default                   : 134,
        R2of5                          : 135,
        R2of5LengthMin                 : 136,
        R2of5LengthMax                 : 137,
        A2of5Default                   : 138,
        A2of5                          : 139,
        A2of5LengthMin                 : 140,
        A2of5LengthMax                 : 141,
        X2of5Default                   : 142,
        X2of5                          : 143,
        X2of5LengthMin                 : 144,
        X2of5LengthMax                 : 145,
        Code11Default                  : 146,
        Code11                         : 147,
        Code11CheckDigit               : 148,
        Code11LengthMin                : 149,
        Code11LengthMax                : 150,
        Code128Default                 : 151,
        Code128                        : 152,
        IsbtConcatenation              : 153,
        Code128LengthMin               : 154,
        Code128LengthMax               : 155,
        Code128Append                  : 156,
        Code128CodePage                : 157,
        GS1128Default                  : 158,
        GS1128                         : 159,
        GS1128LengthMin                : 160,
        GS1128LengthMax                : 161,
        TelepenDefault                 : 162,
        Telepen                        : 163,
        TelepenOutput                  : 164,
        TelepenLengthMin               : 165,
        TelepenLengthMax               : 166,
        UPCADefault                    : 167,
        UPCA                           : 168,
        UPCACheckDigit                 : 169,
        UPCANumberSystem               : 170,
        UPCA2DigitAdd                  : 171,
        UPCA5DigitAdd                  : 172,
        UPCAAddReq                     : 173,
        UPCAAddSep                     : 174,
        UPCACouponCode                 : 175,
        CouponGS1DataBarOutput         : 176,
        ConvertUPCAtoEAN13             : 177,
        UPCE0Default                   : 178,
        UPCE0                          : 179,
        UPCE0Expand                    : 180,
        UPCE0CheckDigit                : 181,
        UPCE0NumberSystem              : 182,
        UPCE02DigitAdd                 : 183,
        UPCE05DigitAdd                 : 184,
        UPCE0AddReq                    : 185,
        UPCE0AddSep                    : 186,
        UPCE1                          : 187,
        EAN13Default                   : 188,
        EAN13                          : 189,
        EAN13CheckDigit                : 190,
        EAN132DigitAdd                 : 191,
        EAN135DigitAdd                 : 192,
        EAN13AddReq                    : 193,
        EAN13AddSep                    : 194,
        IsbnTranslate                  : 195,
        EAN8Default                    : 196,
        EAN8                           : 197,
        EAN8CheckDigit                 : 198,
        EAN82DigitAdd                  : 199,
        EAN85DigitAdd                  : 200,
        EAN8AddReq                     : 201,
        EAN8AddSep                     : 202,
        MSIDefault                     : 203,
        MSI                            : 204,
        MSICheckChar                   : 205,
        MSILengthMin                   : 206,
        MSILengthMax                   : 207,
        RSS14Default                   : 208,
        RSS14                          : 209,
        RSSLimitDefault                : 210,
        RSSLimit                       : 211,
        RSSExpDefault                  : 212,
        RSSExp                         : 213,
        RSSExpLengthMin                : 214,
        RSSExpLengthMax                : 215,
        TriopticCode                   : 216,
        CodablockADefault              : 217,
        CodablockA                     : 218,
        CodablockALengthMin            : 219,
        CodablockALengthMax            : 220,
        CodablockFDefault              : 221,
        CodablockF                     : 222,
        CodablockFLengthMin            : 223,
        CodablockFLengthMax            : 224,
        PDF417Default                  : 225,
        PDF417                         : 226,
        PDF417LengthMin                : 227,
        PDF417LengthMax                : 228,
        MacroPDF417                    : 229,
        MicroPDFDefault                : 230,
        MicroPDF                       : 231,
        MicroPDFLengthMin              : 232,
        MicroPDFLengthMax              : 233,
        ComCode                        : 234,
        UPCEANVersion                  : 235,
        ComCodeLengthMin               : 236,
        ComCodeLengthMax               : 237,
        ComCodeEmulation               : 238,
        GS1Emulation                   : 239,
        TLC39                          : 240,
        ChinaPostDefault               : 241,
        ChinaPost                      : 242,
        ChinaPostLengthMin             : 243,
        ChinaPostLengthMax             : 244,
        KoreaPostDefault               : 245,
        KoreaPost                      : 246,
        KoreaPostLengthMin             : 247,
        KoreaPostLengthMax             : 248,
        KoreaPostCheckDigit            : 249,
        QRCodeDefault                  : 250,
        QRCode                         : 251,
        QRCodeLengthMin                : 252,
        QRCodeLengthMax                : 253,
        QRCodeAppend                   : 254,
        QRCodePage                     : 255,
        MatrixDefault                  : 256,
        Matrix                         : 257,
        MatrixLengthMin                : 258,
        MatrixLengthMax                : 259,
        MatrixAppend                   : 260,
        MatrixCodePage                 : 261,
        MaxiCodeDefault                : 262,
        MaxiCode                       : 263,
        MaxiCodeLengthMin              : 264,
        MaxiCodeLengthMax              : 265,
        AztecCodeDefault               : 266,
        AztecCode                      : 267,
        AztecCodeLengthMin             : 268,
        AztecCodeLengthMax             : 269,
        AztecAppend                    : 270,
        AztecCodePage                  : 271,
        AztecCodeRunes                 : 272,
        HanXinCodeDefault              : 273,
        HanXinCode                     : 274,
        HanXinCodeLengthMin            : 275,
        HanXinCodeLengthMax            : 276,
        PostalCodes                    : 277,
        AustralianPostInterpretation   : 278,
        ImageDefault                   : 279,
        ImageStyle                     : 280,
        ImageBeep                      : 281,
        ImageExposure                  : 282,
        ImageFrameRate                 : 283,
        ImageGain                      : 284,
        ImageDelta                     : 285,
        ImageLed                       : 286,
        ImageTrigger                   : 287,
        ImageUpdate                    : 288,
        ImageWhite                     : 289,
        ImagePercentage                : 290,
        ImageFilter                    : 291,
        ImageCompensation              : 292,
        ImagePixelDepth                : 293,
        ImageSharpenEdges              : 294,
        ImageFormat                    : 295,
        ImageHistogram                 : 296,
        ImageInvertX                   : 297,
        ImageInvertY                   : 298,
        ImageFlySpec                   : 299,
        ImageRotate                    : 300,
        ImageQuality                   : 301,
        ImageGamma                     : 302,
        ImageCropLeft                  : 303,
        ImageCropBottom                : 304,
        ImageCropMargin                : 305,
        ImageProtocol                  : 306,
        ImageShipEvery                 : 307,
        ImageDocFilter                 : 308,
        ImageShipHistogram             : 309,
        OCRDefault                     : 310,
        OCR                            : 311,
        OCRTemplate                    : 312,
        OCRVarG                        : 313,
        OCRVarH                        : 314,
        OCRCheckChar                   : 315
    } ;
    window.CommandType = {
        CommandInventory               : 0x66,
        CommandReadMemory              : 0x72,
        CommandWriteMemory             : 0x77,
        CommandKill                    : 0x6B,
        CommandLock                    : 0x6C,
        CommandUnlock                  : 0x6D,
        CommandPermaLock               : 0x70,
        CommandBlockWrite              : 0x57,
        CommandBlockErase              : 0x45,
        CommandStop                    : 0x73,
        CommandLoadStoredTag           : 0x4C,
        CommandSaveStoredTag           : 0x54,
        CommandRemoveAllStoredTag      : 0x44,
        CommandSoftReset               : 0x62,
        CommandHardReset               : 0x68,
        CommandDefaultParam            : 0x61,
        CommandSaveParam               : 0x53,
        CommandEnterBypass             : 0x42,
        CommandEnterBarcodeBypass      : 0x59,
        CommandLeaveBypass             : 0x43,
        CommandDecodeStart             : 0x64,
        CommandBuzzerStart             : 0x75,
        CommandVibratorStart           : 0x76,
        CommandDecodeStop              : 0x65,
        CommandHWTriggerStart          : 0x77,
        CommandHWTriggerStop           : 0x78,
        CommandInventoryWithTid        : 0x79
    };

    window.MemoryBank = {
        Bank_Reserved                  : 0,
        Bank_EPC                       : 1,
        Bank_TID                       : 2,
        Bank_User                      : 3
    };
    window.BuzzerState = {
        Buzzer_Off                     : 0,
        Buzzer_Low                     : 1,
        Buzzer_High                    : 2
    };
    window.VibratorState = {
        Vibrator_Off                   : 0,
        Vibrator_On                    : 1
    };
    window.SessionType = {
        Session_S0                     : 0,
        Session_S1                     : 1,
        Session_S2                     : 2,
        Session_S3                     : 3
    };

    window.SessionFlag = {
        SessionFlag_A                  : 0,
        SessionFlag_B                  : 1,
        SessionFlag_AB                 : 2
    };

    window.SelectFlag = {
        SelectFlag_NotUsed             : 0,
        SelectFlag_SL                  : 1,
        SelectFlag_NOT_SL              : 2,
        SelectFlag_All                 : 3
    };

    window.MaskTargetType = {
    MaskTarget_S0                      : 0,
    MaskTarget_S1                      : 1,
    MaskTarget_S2                      : 2,
    MaskTarget_S3                      : 3,
    MaskTarget_SL                      : 4
    };

    window.MaskActionType = {
        MaskAction_AB                  : 0,
        MaskAction_AN                  : 1,
        MaskAction_NB                  : 2,
        MaskAction_MN                  : 3,
        MaskAction_BA                  : 4,
        MaskAction_BN                  : 5,
        MaskAction_NA                  : 6,
        MaskAction_NM                  : 7
    };

    window.MaskType = {
        MaskType_NO_MASK               : 0,
        MaskType_Selection             : 1,
        MaskType_EPC                   : 2
    };
    window.ScanMode = {
        RFIDScanMode                   : 0,
        BarcodeScanMode                : 1
    };
    window.AlgorithmType = {
        FixedQ                         : 0,
        DynamicQ                       : 1
    };
    window.EncodingType = {
         NSASCIIStringEncoding         : 1,
         NSNEXTSTEPStringEncoding      : 2,
         NSJapaneseEUCStringEncoding   : 3,
         NSUTF8StringEncoding          : 4,
         NSISOLatin1StringEncoding     : 5,
         NSSymbolStringEncoding        : 6,
         NSNonLossyASCIIStringEncoding : 7,
         NSShiftJISStringEncoding      : 8,
         NSISOLatin2StringEncoding     : 9,
         NSUnicodeStringEncoding       : 10,
         NSWindowsCP1251StringEncoding : 11,
         NSWindowsCP1252StringEncoding : 12,
         NSWindowsCP1253StringEncoding : 13,
         NSWindowsCP1254StringEncoding : 14,
         NSWindowsCP1250StringEncoding : 15,
         NSISO2022JPStringEncoding     : 21,
         NSMacOSRomanStringEncoding    : 30
    };
    exports.coolMethod = function (arg0, success, error) {
        exec(success, error, 'AsReaderGunPlugin', 'coolMethod', [arg0]);
    };

    module.exports = {
    setAsReaderGUNDisconnectedListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setAsReaderGUNDisconnectedListener", []);
    },
    setAsReaderGUNErrorListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setAsReaderGUNErrorListener", []);
    },
    initAsReaderGUN: function (listener, deviceModel) {
        exec(listener, null, "AsReaderGunPlugin", "initAsReaderGUN", [deviceModel]);
    },
    getAsReaderGUNVersion: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getAsReaderGUNVersion", []);
    },
    getAsReaderGUNAddress: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getAsReaderGUNAddress", []);
    },
    getIsAvailableDefaultLinkProfile: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getIsAvailableDefaultLinkProfile", []);
    },
    setBuzzer: function (listener, buzzer) {
        exec(listener, null, "AsReaderGunPlugin", "setBuzzer", [buzzer]);
    },
    getBuzzer: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getBuzzer", []);
    },
    setVibrator: function (listener, vibrator) {
        exec(listener, null, "AsReaderGunPlugin", "setVibrator", [vibrator]);
    },
    getVibrator: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getVibrator", []);
    },
    setOperationTime: function (listener, operationTime) {
        exec(listener, null, "AsReaderGunPlugin", "setOperationTime", [operationTime]);
    },
    getOperationTime: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getOperationTime", []);
    },
    setInventoryTime: function (listener, inventoryTime) {
        exec(listener, null, "AsReaderGunPlugin", "setInventoryTime", [inventoryTime]);
    },
    getInventoryTime: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getInventoryTime", []);
    },
    setIdleTime: function (listener, idleTime) {
        exec(listener, null, "AsReaderGunPlugin", "setIdleTime", [idleTime]);
    },
    getIdleTime: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getIdleTime", []);
    },
    setSleepTime: function (listener, sleepTime) {
        exec(listener, null, "AsReaderGunPlugin", "setSleepTime", [sleepTime]);
    },
    getSleepTime: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getSleepTime", []);
    },
    setAutoOffTime: function (listener, autoOffTime) {
        exec(listener, null, "AsReaderGunPlugin", "setAutoOffTime", [autoOffTime]);
    },
    getAutoOffTime: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getAutoOffTime", []);
    },
    setAccessPassword: function (listener, accessPassword) {
        exec(listener, null, "AsReaderGunPlugin", "setAccessPassword", [accessPassword]);
    },
        //    getAccessPassword: function (listener) {
        //        exec(listener, null, "AsReaderGunPlugin", "getAccessPassword", []);
        //    },
    setInventorySession: function (listener, inventorySession) {
        exec(listener, null, "AsReaderGunPlugin", "setInventorySession", [inventorySession]);
    },
    getInventorySession: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getInventorySession", []);
    },
    setSessionFlag: function (listener, sessionFlag) {
        exec(listener, null, "AsReaderGunPlugin", "setSessionFlag", [sessionFlag]);
    },
    getSessionFlag: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getSessionFlag", []);
    },
    getSerialNumber: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getSerialNumber", []);
    },
    setContinuousMode: function (listener, continuousMode) {
        exec(listener, null, "AsReaderGunPlugin", "setContinuousMode", [continuousMode]);
    },
    getContinuousMode: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getContinuousMode", []);
    },
    setPowerGain: function (listener, powerGain) {
        exec(listener, null, "AsReaderGunPlugin", "setPowerGain", [powerGain]);
    },
    getPowerGain: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getPowerGain", []);
    },
    setUseSelectionMask: function (listener, useSelectionMask) {
        exec(listener, null, "AsReaderGunPlugin", "setUseSelectionMask", [useSelectionMask]);
    },
    getUseSelectionMask: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getUseSelectionMask", []);
    },
    setReportMode: function (listener, reportMode) {
        exec(listener, null, "AsReaderGunPlugin", "setReportMode", [reportMode]);
    },
    getReportMode: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getReportMode", []);
    },
    setStoredMode: function (listener, storedMode) {
        exec(listener, null, "AsReaderGunPlugin", "setStoredMode", [storedMode]);
    },
    getStoredMode: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getStoredMode", []);
    },
    setRssiMode: function (listener, rssiMode) {
        exec(listener, null, "AsReaderGunPlugin", "setRssiMode", [rssiMode]);
    },
    getRssiMode: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getRssiMode", []);
    },
    setEpcMaskMatchMode: function (listener, epcMaskMatchMode) {
        exec(listener, null, "AsReaderGunPlugin", "setEpcMaskMatchMode", [epcMaskMatchMode]);
    },
    getEpcMaskMatchMode: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getEpcMaskMatchMode", []);
    },
    setAlgorithm: function (listener, algorithm) {
        exec(listener, null, "AsReaderGunPlugin", "setAlgorithm", [algorithm]);
    },
    getAlgorithm: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getAlgorithm", []);
    },
    setMinQ: function (listener, minQ) {
        exec(listener, null, "AsReaderGunPlugin", "setMinQ", [minQ]);
    },
    getMinQ: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getMinQ", []);
    },
    setMaxQ: function (listener, maxQ) {
        exec(listener, null, "AsReaderGunPlugin", "setMaxQ", [maxQ]);
    },
    getMaxQ: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getMaxQ", []);
    },
    setQValue: function (listener, qValue) {
        exec(listener, null, "AsReaderGunPlugin", "setQValue", [qValue]);
    },
    getQValue: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getQValue", []);
    },
    setLinkProfileValue: function (listener, linkProfileValue) {
        exec(listener, null, "AsReaderGunPlugin", "setLinkProfileValue", [linkProfileValue]);
    },
    getLinkProfileValue: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getLinkProfileValue", []);
    },
    setDefaultLinkProfileValue: function (listener, defaultLinkProfileValue) {
        exec(listener, null, "AsReaderGunPlugin", "setDefaultLinkProfileValue", [defaultLinkProfileValue]);
    },
    getDefaultLinkProfileValue: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getDefaultLinkProfileValue", []);
    },
    setMaskTypeValue: function (listener, maskTypeValue) {
        exec(listener, null, "AsReaderGunPlugin", "setMaskTypeValue", [maskTypeValue]);
    },
    getMaskTypeValue: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getMaskTypeValue", []);
    },
    setThresHoldValue: function (listener, thresHoldValue) {
        exec(listener, null, "AsReaderGunPlugin", "setThresHoldValue", [thresHoldValue]);
    },
    getThresHoldValue: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getThresHoldValue", []);
    },
    setModeLeftLedOn: function (listener, modeLeftLedOn) {
        exec(listener, null, "AsReaderGunPlugin", "setModeLeftLedOn", [modeLeftLedOn]);
    },
    getModeLeftLedOn: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getModeLeftLedOn", []);
    },
    setModeRightLedOn: function (listener, modeRightLedOn) {
        exec(listener, null, "AsReaderGunPlugin", "setModeRightLedOn", [modeRightLedOn]);
    },
    getModeRightLedOn: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getModeRightLedOn", []);
    },
    getAction: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getAction", []);
    },
    setScanMode: function (listener, scanType) {
        exec(listener, null, "AsReaderGunPlugin", "setScanMode", [scanType]);
    },
    getScanMode: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getScanMode", []);
    },
    changeRegion: function (listener, region) {
        exec(listener, null, "AsReaderGunPlugin", "changeRegion", [region]);
    },
    inventory: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "inventory", []);
    },
    inventoryWithTidOffset: function (listener, offset, length, inventorySession, sessionFlag) {
        exec(listener, null, "AsReaderGunPlugin", "inventoryWithTidOffset", [offset, length, inventorySession, sessionFlag]);
    },
    readMemory: function (listener, bank, offset, length) {
        exec(listener, null, "AsReaderGunPlugin", "readMemory", [bank, offset, length]);
    },
    writeMemory: function (listener, bank, offset, value) {
        exec(listener, null, "AsReaderGunPlugin", "writeMemory", [bank, offset, value]);
    },
    lock: function (listener, killPassword, accessPassword, epc, tid, user) {
        exec(listener, null, "AsReaderGunPlugin", "lock", [killPassword, accessPassword, epc, tid, user]);
    },
    unlock: function (listener, killPassword, accessPassword, epc, tid, user) {
        exec(listener, null, "AsReaderGunPlugin", "unlock", [killPassword, accessPassword, epc, tid, user]);
    },
    permaLock: function (listener, killPassword, accessPassword, epc, tid, user) {
        exec(listener, null, "AsReaderGunPlugin", "permaLock", [killPassword, accessPassword, epc, tid, user]);
    },
    kill: function (listener, killPassword) {
        exec(listener, null, "AsReaderGunPlugin", "kill", [killPassword]);
    },
    blockWrite: function (listener, maskBank, offset, value) {
        exec(listener, null, "AsReaderGunPlugin", "blockWrite", [maskBank, offset, value]);
    },
    blockErase: function (listener, maskBank, offset, length) {
        exec(listener, null, "AsReaderGunPlugin", "blockErase", [maskBank, offset, length]);
    },
    stop: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "stop", []);
    },
    stopSync: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "stopSync", []);
    },
    defaultParameter: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "defaultParameter", []);
    },
    setDebugMode: function (listener, enabled) {
        exec(listener, null, "AsReaderGunPlugin", "setDebugMode", [enabled]);
    },
    getRegionName: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getRegionName", []);
    },
    getRFModuleVersion: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getRFModuleVersion", []);
    },
    getFirmwareVersion: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getFirmwareVersion", []);
    },
    getPowerGainRange: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getPowerGainRange", []);
    },
    getBatteryStatus: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getBatteryStatus", []);
    },
    clearEpcMask: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "clearEpcMask", []);
    },
    getEpcMaskCount: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getEpcMaskCount", []);
    },
    addEpcMaskWithAsSelectMaskEPCParam: function (listener, offset, length, mask) {
        exec(listener, null, "AsReaderGunPlugin", "addEpcMaskWithAsSelectMaskEPCParam", [offset, length, mask]);
    },
    getEpcMask: function (listener, index) {
        exec(listener, null, "AsReaderGunPlugin", "getEpcMask", [index]);
    },
    getLBT: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getLBT", []);
    },
    setLBT: function (listener, lbtArray) {
        exec(listener, null, "AsReaderGunPlugin", "setLBT", [lbtArray]);
    },
    startBuzzerWithBuzzerTime: function (listener, buzzerTime) {
        exec(listener, null, "AsReaderGunPlugin", "startBuzzerWithBuzzerTime", [buzzerTime]);
    },
    startVibratorWithVibratorTime: function (listener, vibratorTime) {
        exec(listener, null, "AsReaderGunPlugin", "startVibratorWithVibratorTime", [vibratorTime]);
    },
    startDecode: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "startDecode", []);
    },
    startDecodeWithEncodingType: function (listener, encodingType) {
        exec(listener, null, "AsReaderGunPlugin", "startDecodeWithEncodingType", [encodingType]);
    },
    stopDecode: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "stopDecode", []);
    },
    setBarcodeParam: function (listener, paramName, paramValue) {
        exec(listener, null, "AsReaderGunPlugin", "setBarcodeParam", [paramName, paramValue]);
    },
    getBarcodeParam: function (listener, paramData) {
        exec(listener, null, "AsReaderGunPlugin", "getBarcodeParam", [paramData]);
    },
    usedSelectionMask: function (listener, idx) {
        exec(listener, null, "AsReaderGunPlugin", "usedSelectionMask", [idx]);
    },
    getSelectionMask: function (listener, idx) {
        exec(listener, null, "AsReaderGunPlugin", "getSelectionMask", [idx]);
    },
    setSelectionMask: function (listener, idx, target, action, bank, offset, mask, length, used) {
        exec(listener, null, "AsReaderGunPlugin", "setSelectionMask", [idx, target, action, bank, offset, mask, length, used]);
    },
    clearSelectionMask: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "clearSelectionMask", []);
    },
    removeSelectionMask: function (listener, idx) {
        exec(listener, null, "AsReaderGunPlugin", "removeSelectionMask", [idx]);
    },
    readRegister:function (listener, addr) {
        exec(listener, null, "AsReaderGunPlugin", "readRegister", [addr]);
    },
    readOEMCFGADDR_SJC_CFG:function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "readOEMCFGADDR_SJC_CFG", []);
    },
    setMaskUsed: function (listener, idx, maskUsed) {
        exec(listener, null, "AsReaderGunPlugin", "setMaskUsed", [idx, maskUsed]);
    },
    setBarcodeModeAndIsKeyAction: function (listener, barcodeMode, keyAction) {
        exec(listener, null, "AsReaderGunPlugin", "setBarcodeModeAndIsKeyAction", [barcodeMode, keyAction]);
    },
    isBarcodeModule: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "isBarcodeModule", []);
    },
    isRFIDModule: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "isRFIDModule", []);
    },
    setPropBarcodeMode: function (listener, propBarcodeMode) {
        exec(listener, null, "AsReaderGunPlugin", "setPropBarcodeMode", [propBarcodeMode]);
    },
    startHWTriggerDecode: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "startHWTriggerDecode", []);
    },
    stopHWTriggerDecode: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "stopHWTriggerDecode", []);
    },
    doDefaultAsReaderLeftModeKeyTouch: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "doDefaultAsReaderLeftModeKeyTouch", []);
    },
    doDefaultAsReaderLeftModeKeyUp: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "doDefaultAsReaderLeftModeKeyUp", []);
    },
    doDefaultAsReaderRightModeKeyTouch: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "doDefaultAsReaderRightModeKeyTouch", []);
    },
    doDefaultAsReaderRightModeKeyUp: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "doDefaultAsReaderRightModeKeyUp", []);
    },
    doDefaultAsReaderTriggerKeyTouch: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "doDefaultAsReaderTriggerKeyTouch", []);
    },
    doDefaultAsReaderTriggerKeyUp: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "doDefaultAsReaderTriggerKeyUp", []);
    },
    getAsRingFirmwareRevision: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "getAsRingFirmwareRevision", []);
    },
    setReaderInitializedListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setReaderInitializedListener", []);
    },
    setUpdateDeviceStateListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setUpdateDeviceStateListener", []);
    },
    setReadTagListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setReadTagListener", []);
    },
    setChangedActionStateListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setChangedActionStateListener", []);
    },
    setDetectBarcodeStringListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setDetectBarcodeStringListener", []);
    },
    setDetectBarcodeDataListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setDetectBarcodeDataListener", []);
    },
    setAccessResultListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setAccessResultListener", []);
    },
    setReadTagWithTidListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setReadTagWithTidListener", []);
    },
    setCommandCompleteListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setCommandCompleteListener", []);
    },
    setOnModuleOverHeatedListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setOnModuleOverHeatedListener", []);
    },
    setOnResetReaderListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setOnResetReaderListener", []);
    },
    setOnAsReaderLeftModeKeyEventListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setOnAsReaderLeftModeKeyEventListener", []);
    },
    setOnAsReaderRightModeKeyEventListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setOnAsReaderRightModeKeyEventListener", []);
    },
    setOnAsReaderTriggerKeyEventListener: function (listener) {
        exec(listener, null, "AsReaderGunPlugin", "setOnAsReaderTriggerKeyEventListener", []);
    },

    };
