package jp.co.asterisk.asreader.a3xd.demoapp.fragment;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;

import java.util.ArrayList;

import jp.co.asterisk.asreader.a3xd.demoapp.MainActivity;
import jp.co.asterisk.asreader.a3xd.demoapp.R;
import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentHomeBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.tagaccess.TagAccessFragment;
import jp.co.asterisk.asreader.a3xd.demoapp.rfid.custom.CustomTagAdapter;
import jp.co.asterisk.asreader.a3xd.demoapp.rfid.custom.TagListItem;
import jp.co.asterisk.asreader.a3xd.demoapp.rfid.home.DeviceState;
import jp.co.asterisk.asreader.a3xd.demoapp.rfid.home.TagData;
import jp.co.asterisk.asreader.a3xd.demoapp.util.Utils;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.common.AsDeviceConst;
import jp.co.asterisk.asreader.a3xd.sdk.manager.DeviceManager;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;
import jp.co.asterisk.asreader.a3xd.sdk.utility.EpcConverter;
import jp.co.asterisk.asreader.a3xd.sdk.utility.LogLevel;
import jp.co.asterisk.asreader.a3xd.sdk.utility.SDKLog;

public class HomeFragment extends BaseFragment
        implements RFIDManagerCallback, AlertDialogFragment.AlertDialogFragmentListener {

    public static final String TAG = "HomeFragment";

    private final int df_NOT_INVALID_RSSI = 10;

    private FragmentHomeBinding binding;

    private ArrayList<TagListItem> tagItemList = new ArrayList<>();
    private ArrayList<TagData> tagDataList = new ArrayList<>();

    private CustomTagAdapter adapter;

    private int encodingType = EpcConverter.HEX_STRING;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        binding = FragmentHomeBinding.inflate(inflater, container, false);

        adapter = new CustomTagAdapter(getContext(), R.layout.cell_tag, tagItemList);
        binding.listView.setAdapter(adapter);
        binding.listView.setOnItemClickListener(onItemClickListener);

        binding.powerToggleButton.setOnClickListener(clickListener);
        binding.readButton.setOnClickListener(clickListener);
        binding.readRfmButton.setOnClickListener(clickListener);
        binding.clearButton.setOnClickListener(clickListener);
        binding.stopButton.setOnClickListener(clickListener);
        binding.batteryButton.setOnClickListener(clickListener);

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        String title = getString(R.string.app_name) + "\n"
                + "APP: "+ Utils.getInstance().getAppVersion(getActivity())
                + " SDK: "+ AsDeviceConst.strLibVersion;
        setToolbar(false, title, getString(R.string.button_name_more));

        binding.batteryTextView.setText("0%");

        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);

        boolean isConnect = AsReaderSDK.getInstance().getDeviceManager().isConnected();
        setDeviceConnectStatus(isConnect);
        setRightButtonEnabled(isConnect);

        changeButtons(getMainActivity().isPowerOn() ?
                DeviceState.DEVICE_POWERON : DeviceState.DEVICE_POWEROFF);

        encodingType = getPreferencesHelper().getEncodingType();
        if (AsReaderSDK.getInstance().getDeviceManager().isM30SDevice()) {

            binding.powerToggleButton.setChecked(false);
            binding.powerToggleButton.setEnabled(false);
        } else {
            binding.powerToggleButton.setEnabled(isConnect);
        }
	}

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    private void setDeviceConnectStatus(boolean isConnected) {
        String message;
        if (isConnected) {
            message = getString(R.string.message_connected);
            ((MainActivity)getActivity()).setVisibilityOtgLogo(View.VISIBLE);
        } else {
            message = getString(R.string.message_disconnected);
            ((MainActivity)getActivity()).setVisibilityOtgLogo(View.INVISIBLE);
        }
        binding.deviceStatusTextView.setText(message);
    }

    private void setPowerOnOff(boolean isPowerOn) {
        boolean beep = getPreferencesHelper().getReaderBeep();
        boolean vib = getPreferencesHelper().getReaderVib();
        boolean led = getPreferencesHelper().getReaderLed();
        boolean aimer = false; // set aimer : only barcode devices
        boolean powerOnBeep = getPreferencesHelper().getReaderPowerOnBeep();

        AsReaderSDK.getInstance().getDeviceManager()
                .setPowerWithOption(isPowerOn, beep, vib, led, aimer, powerOnBeep);
    }

    synchronized public void listRefresh(int[] tagData, float fRSSI) {
        if(getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                tagUpdate(tagData, fRSSI);
            });
        }
    }

    private void tagUpdate(int[] tagData, float fRSSI) {
        Log.d("==","tagData length : " + tagData.length);
        int encodingType = getPreferencesHelper().getEncodingType();
        String strTag = EpcConverter.toString(encodingType, tagData);

        boolean newTagReceived = true;
        boolean newItemReceived = true;
        int dataIndex = 0;

        for (int i = 0; i < tagDataList.size(); i++) {
            if (tagDataList.get(i).strData.equals(strTag)) {
                newTagReceived = false;
                dataIndex = i;
                break;
            }
        }

        if (encodingType == EpcConverter.EAN13) {
            if (newTagReceived) {
                for (int i = 0; i < tagItemList.size(); i++) {
                    if (tagItemList.get(i).getId().equals(strTag)) {
                        newItemReceived = false;
                        dataIndex = i;
                        break;
                    }
                }
            } else {
                newItemReceived = false;
            }
        }

        if (newTagReceived) {
            tagDataList.add(new TagData(tagData, 1, strTag));
        }

        String rssi = fRSSI < df_NOT_INVALID_RSSI ? String.valueOf(fRSSI) : "";
        if ((encodingType != EpcConverter.EAN13 && newTagReceived)
                || (encodingType == EpcConverter.EAN13 && newTagReceived && newItemReceived)) {

            // New Tag
            TagListItem tagItem = new TagListItem(strTag, "", rssi);
            tagItemList.add(tagItem);
            adapter.notifyDataSetChanged();
            binding.tagCountTextView.setText(tagItemList.size() + " tags");

        } else if ((encodingType != EpcConverter.EAN13 && !newTagReceived) ||
                (encodingType == EpcConverter.EAN13 && newTagReceived && !newItemReceived)) {

            // Update Tag
            if (tagItemList.size() > 0) {
                try {
                    TagData cData = tagDataList.get(dataIndex);
                    cData.count += 1;
                    tagDataList.set(dataIndex, cData);
                    tagItemList.get(dataIndex).setId(strTag);
                    tagItemList.get(dataIndex).setRssi(rssi);
                    tagItemList.get(dataIndex).setCount(String.valueOf(cData.count));
                    adapter.notifyDataSetChanged();
                } catch (Exception e){
                    SDKLog.getInstance().Log(TAG, LogLevel.Error, e.toString());
                }
            }
        }
    }

    private void clearTagList() {
        tagItemList.clear();
        tagDataList.clear();
        adapter.notifyDataSetChanged();
        binding.tagCountTextView.setText("0 tags");
    }

    public void onUserLeaveHint() {
        if (!AsReaderSDK.getInstance().getDeviceManager().isM30SDevice()) {
            binding.powerToggleButton.setChecked(false);
        }
        binding.batteryTextView.setText("0%");
        setDeviceConnectStatus(false);
        changeButtons(DeviceState.DEVICE_POWEROFF);
        if (getMainActivity().isPowerOn()) {
            setPowerOnOff(false);
        }
    }

    public void onBackPressed() {
        showAlertDialog(
                "Alert",
                "Do you want to exit the app?",
                "Yes",
                "No",
                this
        );
    }

    private View.OnClickListener clickListener = (View view) -> {
        if (view == binding.powerToggleButton) {
            setPowerOnOff(binding.powerToggleButton.isChecked());

        } else if(view == binding.readButton) {
            changeButtons(DeviceState.START_READ);

            int maxTag = AsReaderSDK.getInstance().getRFIDManager().getMaxTagValue();
            int maxTime = AsReaderSDK.getInstance().getRFIDManager().getMaxTimeValue();
            int repeatCycle = AsReaderSDK.getInstance().getRFIDManager().getRepeatCycleValue();
            boolean displayRSSI = AsReaderSDK.getInstance().getRFIDManager().getRSSIEnable();

            if (displayRSSI) {
                AsReaderSDK.getInstance().getRFIDManager().startInventoryRSSI(maxTag, maxTime, repeatCycle);
            } else {
                AsReaderSDK.getInstance().getRFIDManager().startInventory(maxTag, maxTime, repeatCycle);
            }

        } else if(view == binding.clearButton) {
            clearTagList();

        } else if(view == binding.stopButton) {
            changeButtons(DeviceState.STOP_READ);
            AsReaderSDK.getInstance().getRFIDManager().stopDecode();

        } else if(view == binding.readRfmButton) {
            navigate(this, R.id.action_HomeFragment_to_RfmSensorFragment);

        } else if(view == binding.batteryButton) {
            AsReaderSDK.getInstance().getDeviceManager().getBattery();
        }

    };

    private AdapterView.OnItemClickListener onItemClickListener = new AdapterView.OnItemClickListener() {
        @Override
        public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
            if(parent == binding.listView) {
                AsReaderSDK.getInstance().getRFIDManager().stopDecode();

                if (encodingType == EpcConverter.HEX_STRING) {
                    String strData = EpcConverter.toString(encodingType, tagDataList.get(position).data);
                    Bundle args = new Bundle();
                    args.putString(TagAccessFragment.ARG_SELECTED_TAG, strData);
                    navigate(HomeFragment.this, R.id.action_HomeFragment_to_TagAccessFragment, args);
                } else {
                    showToast("Not possible when encoding type is not HEX.");
                }
            }
        }
    };

    public void changeButtons(DeviceState state) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                if (binding == null){
                    return;
                }
                switch (state) {
                    case STOP_READ:
                        binding.readButton.setEnabled(true);
                        binding.stopButton.setEnabled(false);
                        binding.clearButton.setEnabled(true);
                        if (DeviceManager.getInstance().isM30SDevice()) {
                            binding.readRfmButton.setEnabled(false);
                        } else {
                            binding.readRfmButton.setEnabled(true);
                        }
                        break;

                    case START_READ:
                        binding.readButton.setEnabled(false);
                        binding.readRfmButton.setEnabled(false);
                        binding.stopButton.setEnabled(true);
                        binding.clearButton.setEnabled(true);
                        break;

                    case DEVICE_POWERON:
                        binding.readButton.setEnabled(true);
                        if (DeviceManager.getInstance().isM30SDevice()) {
                            binding.readRfmButton.setEnabled(false);
                        } else {
                            binding.readRfmButton.setEnabled(true);
                        }
                        binding.batteryButton.setEnabled(true);
                        binding.stopButton.setEnabled(true);
                        binding.clearButton.setEnabled(true);
                        if (!AsReaderSDK.getInstance().getDeviceManager().isM30SDevice()) {
                            binding.powerToggleButton.setChecked(true);
                        }
                        setRightButtonEnabled(true);
                        break;

                    case DEVICE_POWEROFF:
                        binding.readButton.setEnabled(false);
                        binding.readRfmButton.setEnabled(false);
                        binding.batteryButton.setEnabled(false);
                        binding.stopButton.setEnabled(false);
                        binding.clearButton.setEnabled(false);
                        if (!AsReaderSDK.getInstance().getDeviceManager().isM30SDevice()) {
                            binding.powerToggleButton.setChecked(false);
                        }
                        setRightButtonEnabled(false);
                        break;
                }
            });
        }
    }


    @Override
    public void onConnect(boolean isConnect) {
        if (isVisible()) {
            setDeviceConnectStatus(isConnect);
            if (!AsReaderSDK.getInstance().getDeviceManager().isM30SDevice()) {
                binding.powerToggleButton.setEnabled(isConnect);
            }
            if (!isConnect) {
               changeButtons(DeviceState.DEVICE_POWEROFF);
            }
        }

        if (isConnect) {
            setPowerOnOff(true);
            if (AsReaderSDK.getInstance().getDeviceManager().isM30SDevice()) {
                boolean continueMode = AsReaderSDK.getInstance().getRFIDManager().getContinueMode();
                AsReaderSDK.getInstance().getRFIDManager().setContinuousMode(continueMode);
            }
        }
    }

    /*
     *  AlertDialogFragmentListener
     */
    @Override
    public void OnClickPositiveButton() {
        changeButtons(DeviceState.DEVICE_POWEROFF);
        setDeviceConnectStatus(false);
        if (getMainActivity().isPowerOn()) {
            AsReaderSDK.getInstance().getRFIDManager().stopDecode();
            setPowerOnOff(false);
        }

        getActivity().moveTaskToBack(true);
        getActivity().finish();

        android.os.Process.killProcess(android.os.Process.myPid());
    }

    @Override
    public void OnClickNegativeButton() {

    }

    /*
     *  RFIDCallbackManager
     */
    @Override
    public void onTagReceived(int[] dest) {
        listRefresh(dest, df_NOT_INVALID_RSSI);
    }

    @Override
    public void onTagWithRssiReceived(int[] pcEpc, int rssi) {
        listRefresh(pcEpc, rssi);
    }

    @Override
    public void onAutoInventoryFinished() {
        changeButtons(DeviceState.STOP_READ);
    }

    public void onBatteryStateReceived(int dest, int charging) {
        binding.batteryTextView.setText(dest + "%");
    }

    public void onCompletedPreparation(boolean isPowerOn) {
        changeButtons(isPowerOn ? DeviceState.DEVICE_POWERON : DeviceState.DEVICE_POWEROFF);
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                showToast(message);
            });
        }
    }
}
