package jp.co.asterisk.asreader.a3xd.demoapp.fragment;

import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioGroup;

import jp.co.asterisk.asreader.a3xd.demoapp.R;
import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentHoppingBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.util.ProgressDialog;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;

public class HoppingFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = HoppingFragment.class.getSimpleName();

    private FragmentHoppingBinding binding;
    private ProgressDialog progressDialog;

    private String information;
    private int readtime;
    private int idletime;
    private int sensetime;
    private int lbtlevel;
    private int fhmode;
    private int lbtmode;
    private int cwmode;
    private int frequencyHopping  = -1;
    private int listenBeforeTalk = -1;
    private boolean bSmartMode = false;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_HoppingFragment_to_HomeFragment);

        binding = FragmentHoppingBinding.inflate(inflater, container, false);

        binding.channelLayout.setVisibility(View.GONE);
        binding.selectHoppingRadioGroup.setOnCheckedChangeListener(onCheckedChangeListener);

        binding.saveButton.setOnClickListener(clickListener);
        binding.refreshInfoButton.setOnClickListener(clickListener);
        binding.setOptimumButton.setOnClickListener(clickListener);
        binding.setSmartOnOffButton.setOnClickListener(clickListener);
        binding.channelButton.setOnClickListener(clickListener);
        binding.setHoppingModeButton.setOnClickListener(clickListener);

        progressDialog = new ProgressDialog(getContext());

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);
        updateInformation();

        setToolbar(true, getString(R.string.toolbar_title_hopping));
    }

    private View.OnClickListener clickListener = (View view) -> {
        if (view == binding.saveButton) {
            AsReaderSDK.getInstance().getRFIDManager().updateRegistry();

        } else if (view == binding.refreshInfoButton) {
            updateInformation();

        } else if (view == binding.setOptimumButton) {
            AsReaderSDK.getInstance().getRFIDManager().setOptimumFrequencyHoppingTable();

        } else if (view == binding.setSmartOnOffButton) {
            AsReaderSDK.getInstance().getRFIDManager().setSmartHopping(binding.smartOnOffToggleButton.isChecked());

        } else if (view == binding.channelButton) {
            AsReaderSDK.getInstance().getRFIDManager().setChannel(Integer.parseInt(binding.channelEditText.getText().toString()), 0);

        } else if (view == binding.setHoppingModeButton) {
            if (listenBeforeTalk == -1) {
                showToast("Please Select FH Mode");
                return;
            }

            AsReaderSDK.getInstance().getRFIDManager().setFhLbtParam(
                    readtime, idletime, sensetime, lbtlevel, frequencyHopping, listenBeforeTalk, 0
            );
            updateInformation();
        }
    };

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
        progressDialog.dismiss();
    }

    private RadioGroup.OnCheckedChangeListener onCheckedChangeListener = (RadioGroup group, int checkedId) -> {
        if (checkedId == R.id.fh_radio_button) {
            frequencyHopping = 2;
            listenBeforeTalk = 1;

        } else if (checkedId == R.id.lbt_radio_button) {
            frequencyHopping = 1;
            listenBeforeTalk = 2;

        } else if (checkedId == R.id.off_radio_button) {
            frequencyHopping = 0;
            listenBeforeTalk = 0;
        }
    };

    private  void updateInformation() {
        progressDialog.show();

        binding.hoppingDataTextView.setText("");
        AsReaderSDK.getInstance().getRFIDManager().getFrequencyHoppingMode();

        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            AsReaderSDK.getInstance().getRFIDManager().getFhLbtParam();
        }, 500);

        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            AsReaderSDK.getInstance().getRFIDManager().getChannel();
        }, 1000);
    }

    @Override
    public void didSetOptiFreqHPTable(int status) {
        if(status == 0) {
            if (getActivity()!=null){
                getActivity().runOnUiThread(() -> {
                    showToast("Wait!! Start Setting Optimum Freq..");
                });
            }

        } else if(status == 1) {
            if (getActivity()!=null){
                getActivity().runOnUiThread(() -> {
                    showToast("Finish OptiMum Freq.");
                });
            }
        }
    }

    @Override
    public void didSetSmartMode(int state) {
        if(state ==0) {
            if (getActivity()!=null){
                getActivity().runOnUiThread(() -> {
                    showToast("Success FH Mode Setting");
                    AsReaderSDK.getInstance().getRFIDManager().getFrequencyHoppingMode();
                });
            }

        } else {
            if (getActivity()!=null){
                getActivity().runOnUiThread(() -> {
                    showToast("Fail FH Mode Setting");
                });
            }
        }
    }

    @Override
    public void onReceiveSmartMode(int state) {
        bSmartMode = state != 0;
        information = "R:"+readtime
                +"\nI:"+idletime
                +"\nS:"+sensetime
                +"\nLbtL:"+lbtlevel
                +"\nFh:"+fhmode
                +"\nlbt:"+lbtmode
                +"\nCw:"+cwmode;
        information += "\nSmartMode : " + (bSmartMode ? "ON" : "OFF");

        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                binding.hoppingDataTextView.setText(information);
                binding.smartOnOffToggleButton.setChecked(bSmartMode);
            });
        }
    }

    @Override
    public void didUpdateRegistry(int state) {
        if(state == 0) {
            if (getActivity()!=null){
                getActivity().runOnUiThread(() -> {
                    showToast("Success Update Registry");
                });
            }
        }
    }

    @Override
    public void onChannelReceived(int channel, int channelOffset) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                binding.channelEditText.setText(Integer.toString(channel));

                progressDialog.dismiss();
            });
        }
    }

    @Override
    public void onFhLbtReceived(int onTime, int offTime, int senseTime,
                                int lbtLevel, int fhEnable, int lbtEnable, int cwEnable) {
        //00 64 01 F4 00 05 FD 1C 01 02 00
        readtime  = onTime;
        idletime  = offTime;
        sensetime = senseTime;
        lbtlevel  = lbtLevel;
        fhmode    = fhEnable;
        lbtmode   = lbtEnable;
        cwmode    = 0;

        information = "R:"+readtime
                +"\nI:"+idletime
                +"\nS:"+sensetime
                +"\nLbtL:"+lbtlevel
                +"\nFh:"+fhmode
                +"\nlbt:"+lbtmode
                +"\nCw:"+cwmode;
        information +=  "\nSmartMode : " + (bSmartMode ? "ON" : "OFF");

        try {
            if (getActivity()!=null){
                getActivity().runOnUiThread(() -> {
                    if(fhmode > lbtmode) {
                        frequencyHopping = 2;
                        listenBeforeTalk = 1;

                        binding.selectHoppingRadioGroup.check(R.id.fh_radio_button);
                        binding.channelLayout.setVisibility(View.GONE);

                    } else if(fhmode < lbtmode) {
                        frequencyHopping = 2;
                        listenBeforeTalk = 1;

                        binding.selectHoppingRadioGroup.check(R.id.lbt_radio_button);
                        binding.channelLayout.setVisibility(View.GONE);

                    } else if(fhmode == lbtmode) {
                        frequencyHopping = 0;
                        listenBeforeTalk = 0;

                        binding.selectHoppingRadioGroup.check(R.id.off_radio_button);
                        binding.channelLayout.setVisibility(View.VISIBLE);
                    }

                    binding.hoppingDataTextView.setText(information);
                });
            }
        }catch (NullPointerException e){
            e.getMessage();
        }
    }

    @Override
    public void onSetChannelSuccess() {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                showToast("Success SetChannel");
            });
        }
    }

    @Override
    public void onSetFhLbtParamSuccess() {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                showToast("Success SetFhLbtParam");
            });
        }
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}
