package jp.co.asterisk.asreader.a3xd.demoapp.fragment;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentInfoBinding;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.common.AsDeviceConst;
import jp.co.asterisk.asreader.a3xd.sdk.event.IOnAsDeviceRfidEvent;
import jp.co.asterisk.asreader.a3xd.demoapp.util.Utils;
import jp.co.asterisk.asreader.a3xd.demoapp.R;


public class InfoFragment extends BaseFragment {

    private FragmentInfoBinding binding;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_InfoFragment_to_HomeFragment);

        binding = FragmentInfoBinding.inflate(inflater, container, false);
        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();

        setAppAndSdkVersionText();
        getReaderInfo();
        setToolbar(true, getString(R.string.toolbar_title_info), getString(R.string.button_name_refresh));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);
        binding.infoTextView.setText("");
        setAppAndSdkVersionText();
        getReaderInfo();
    }

    private void setAppAndSdkVersionText() {
        String text = "APP: "+ Utils.getInstance().getAppVersion(getActivity());
        text += "\nSDK: "+ AsDeviceConst.strLibVersion;
        binding.infoTextView.setText(text);
    }

    private void getReaderInfo() {
        /* Request Reader's info */
        AsReaderSDK.getInstance().getDeviceManager().getReaderInfo(0xb1);
        /* Request RFID info */
        AsReaderSDK.getInstance().getDeviceManager().getReaderInfo(0x01);
    }

    @Override
    public void showToast(String message) {
        super.showToast(message);
    }

    public void onReceivedRFIDModuleVersion(String versionInfo) {
        binding.infoTextView.append("\nRFID : "+ versionInfo);
    }

    public void onReaderAboutInfo(String model, String hwVersion, String fwVersion, byte region) {
        binding.infoTextView.append("\nmodel: "+model+"\nHW: "+hwVersion+"\nFW: "+fwVersion);
    }
}
