package jp.co.asterisk.asreader.a3xd.demoapp.fragment;

import android.os.Bundle;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentReaderSettingOnOffBinding;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.demoapp.R;

import jp.co.asterisk.asreader.a3xd.sdk.manager.DeviceManager;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;

public class ReaderSettingOnOffFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = ReaderSettingOnOffFragment.class.getSimpleName();

    private FragmentReaderSettingOnOffBinding binding;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_ReaderSettingOnOffFragment_to_HomeFragment);

        binding = FragmentReaderSettingOnOffBinding.inflate(inflater, container, false);

        binding.beepToggleButton.setChecked(getPreferencesHelper().getReaderBeep());
        binding.vibrationToggleButton.setChecked(getPreferencesHelper().getReaderVib());
        binding.ledToggleButton.setChecked(getPreferencesHelper().getReaderLed());
        binding.powerOnBeepToggleButton.setChecked(getPreferencesHelper().getReaderPowerOnBeep());

        binding.beepToggleButton.setOnClickListener(clickListener);
        binding.vibrationToggleButton.setOnClickListener(clickListener);
        binding.ledToggleButton.setOnClickListener(clickListener);
        binding.powerOnBeepToggleButton.setOnClickListener(clickListener);
        if (DeviceManager.getInstance().isM30SDevice()){
            binding.vibrationToggleButtonLayout.setVisibility(View.GONE);
            binding.ledToggleButtonLayout.setVisibility(View.GONE);
            binding.powerOnBeepToggleButtonLayout.setVisibility(View.GONE);
        }
        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);

        setToolbar(true, getString(R.string.toolbar_title_reader_setting_on_off));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    private View.OnClickListener clickListener = (View view) -> {
        boolean beep = binding.beepToggleButton.isChecked();
        boolean vib = binding.vibrationToggleButton.isChecked();
        boolean led = binding.ledToggleButton.isChecked();
        boolean powerOnBeep = binding.powerOnBeepToggleButton.isChecked();

        getPreferencesHelper().setReaderBeep(beep);
        getPreferencesHelper().setReaderVib(vib);
        getPreferencesHelper().setReaderLed(led);
        getPreferencesHelper().setReaderPowerOnBeep(powerOnBeep);

        AsReaderSDK.getInstance().getDeviceManager().setReaderSettings(beep, vib, led, false);  // set aimer : only barcode devices
    };

    public void onSetReaderSettingSuccess() {
        showToast(getString(R.string.success), Toast.LENGTH_SHORT);
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}
