package jp.co.asterisk.asreader.a3xd.demoapp.fragment.setting;

import android.os.Bundle;


import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import jp.co.asterisk.asreader.a3xd.demoapp.R;
import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentDutyRatioBaseTimeBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.demoapp.util.EditTextInputFilter;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;



public class DutyRatioBaseTimeFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = DutyRatioBaseTimeFragment.class.getSimpleName();

    private FragmentDutyRatioBaseTimeBinding binding;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_AutoOffTimeFragment_to_HomeFragment);

        binding = FragmentDutyRatioBaseTimeBinding.inflate(inflater, container, false);

        binding.dutyRatioBaseTimeEditText.setFilters(new EditTextInputFilter[]{new EditTextInputFilter("0","65000")});

        binding.dutyRatioBaseTimeEditText.setOnFocusChangeListener(focusChangeListener);

        binding.getRoot().setFocusable(true);

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);
        AsReaderSDK.getInstance().getRFIDManager().getDutyRatioBaseTime();
        setToolbar(true, "Duty Ratio Base Time", getString(R.string.button_name_done));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);
        try {
            binding.getRoot().requestFocus();
            int time = Integer.parseInt(binding.dutyRatioBaseTimeEditText.getText().toString());
            AsReaderSDK.getInstance().getRFIDManager().setDutyRatioBaseTime(time);
        } catch (NumberFormatException e) {
            e.printStackTrace();
            showToast(getString(R.string.error));
        }
    }

    private View.OnFocusChangeListener focusChangeListener = (View view, boolean hasFocus) -> {
        if (!hasFocus) {
            if (view == binding.dutyRatioBaseTimeEditText) {
                if (binding.dutyRatioBaseTimeEditText.getText().toString().equals("")) {
                    binding.dutyRatioBaseTimeEditText.setText("0");
                }
            }
        }
    };

    @Override
    public void didSetDutyRatioBaseTime(int status) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                if (status == 0){
                    showToast(getString(R.string.success), Toast.LENGTH_LONG);
                } else {
                    showToast(getString(R.string.failed), Toast.LENGTH_LONG);
                }
            });
        }
    }

    @Override
    public void onReceiveDutyRatioBaseTime(int time) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                binding.dutyRatioBaseTimeEditText.setText(String.valueOf(time));
            });
        }
    }


    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}