package jp.co.asterisk.asreader.a3xd.demoapp.fragment.setting;

import android.os.Bundle;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.Toast;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentOutputPowerBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.demoapp.R;

import java.util.ArrayList;

import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;

public class OutputPowerFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = OutputPowerFragment.class.getSimpleName();

    public final static String ARGS_MIN_POWER = "minPower";
    public final static String ARGS_MAX_POWER = "maxPower";
    public final static String ARGS_POWER_LEVEL = "powerLevel";

    private FragmentOutputPowerBinding binding;

    private int minPower;
    private int maxPower;
    private int powerLevel;

    private ArrayAdapter<String> adapter;
    private ArrayList<String> powerLevelList;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            minPower = getArguments().getInt(ARGS_MIN_POWER);
            maxPower = getArguments().getInt(ARGS_MAX_POWER);
            powerLevel = getArguments().getInt(ARGS_POWER_LEVEL);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_OutputPowerFragment_to_HomeFragment);

        binding = FragmentOutputPowerBinding.inflate(inflater, container, false);

        powerLevelList = new ArrayList<>();
        for (int i = minPower; i <= maxPower; i++) {
            float power = (float)(i / 10.0);
            powerLevelList.add(String.valueOf(power));
        }
        adapter = new ArrayAdapter<>(getContext(), R.layout.cell_setting_check, powerLevelList);
        binding.listView.setAdapter(adapter);
        binding.listView.setChoiceMode(ListView.CHOICE_MODE_SINGLE);
        binding.listView.setItemChecked((powerLevel - minPower), true);
        binding.listView.setOnItemClickListener((AdapterView<?> parent, View view, int position, long id) -> {
            powerLevel = minPower + position;
        });

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);

        setToolbar(true, getString(R.string.toolbar_title_output_power), getString(R.string.button_name_done));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);
        AsReaderSDK.getInstance().getRFIDManager().setOutputPowerLevel(powerLevel);
    }

    @Override
    public void onSetOutputPowerLevelSuccess() {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                showToast(getString(R.string.success), Toast.LENGTH_LONG);
            });
        }
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}
