package jp.co.asterisk.asreader.a3xd.demoapp.fragment.setting;

import android.os.Bundle;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.Toast;

import java.util.ArrayList;

import jp.co.asterisk.asreader.a3xd.demoapp.R;
import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentQValueBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;

public class QValueFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = QValueFragment.class.getSimpleName();

    private FragmentQValueBinding binding;

    private ArrayAdapter<String> adapter;
    private ArrayList<String> qValueList;

    private int qValue = 0;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_QValueFragment_to_HomeFragment);

        binding = FragmentQValueBinding.inflate(inflater, container, false);

        qValueList = new ArrayList<>();
        for (int i = 0; i < 16; i++) {
            qValueList.add(String.format("%02d", i));
        }
        adapter = new ArrayAdapter<>(getContext(), R.layout.cell_setting_check, qValueList);

        binding.listView.setAdapter(adapter);
        binding.listView.setChoiceMode(ListView.CHOICE_MODE_SINGLE);
        binding.listView.setItemChecked(getPreferencesHelper().getSession(), true);
        binding.listView.setOnItemClickListener((AdapterView<?> parent, View view, int position, long id) -> {
            qValue = position;
            getPreferencesHelper().setQValue(qValue);
        });

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);
        AsReaderSDK.getInstance().getRFIDManager().getQValue();

        setToolbar(true, "Q Value", getString(R.string.button_name_done));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);
        AsReaderSDK.getInstance().getRFIDManager().setQValue(getPreferencesHelper().getQValue());

    }

    @Override
    public void didSetQValue(int status) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                if (status == 0){
                    showToast(getString(R.string.success), Toast.LENGTH_LONG);
                } else {
                    showToast(getString(R.string.failed), Toast.LENGTH_LONG);
                }
            });
        }
    }

    @Override
    public void onReceiveQValue(int value) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                binding.listView.setItemChecked(value, true);
            });
        }
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}
