package jp.co.asterisk.asreader.a3xd.demoapp.fragment.setting;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentRfChannelBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.demoapp.R;

import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;

public class RfChannelFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = RfChannelFragment.class.getSimpleName();

    private FragmentRfChannelBinding binding;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_RfChannelFragment_to_HomeFragment);

        binding = FragmentRfChannelBinding.inflate(inflater, container, false);
        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);
        AsReaderSDK.getInstance().getRFIDManager().getChannel();

        setToolbar(true, getString(R.string.toolbar_title_rf_channel), getString(R.string.button_name_done));

    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);

        try {
            int channel = Integer.parseInt(binding.channelEditText.getText().toString());
            AsReaderSDK.getInstance().getRFIDManager().setChannel(channel, 0);
        } catch (NumberFormatException e) {
            e.printStackTrace();
            showToast(getString(R.string.error));
        }
    }

    @Override
    public void onSetChannelSuccess() {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                showToast("Success SetChannel");
            });
        }
    }

    @Override
    public void onGetFrequencyHoppingTableSuccess(int[] data) {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                // Data for displaying configurable hopping channel values.
                // int[] -> String
                StringBuilder sData = new StringBuilder();
                for(int i = 1; i < data.length; i++) {
                    sData.append(String.format("%02X ", data[i]));
                }
                String[] ss = sData.toString().split(" ");
                // String(Hex) -> Ascii
                String channels = "";
                for (int j = 0; j < ss.length; j++) {
                    channels += Integer.parseInt(ss[j],16)+" ";
                }
                binding.possibleChannelsText.setText("Possible channels:\n"+channels);
            });
        }
    }

    @Override
    public void onChannelReceived(int channel, int channelOffset) {
        binding.channelEditText.setText(String.valueOf(channel));
        AsReaderSDK.getInstance().getRFIDManager().getFrequencyHoppingTable();
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}
