package jp.co.asterisk.asreader.a3xd.demoapp.fragment.setting;

import android.os.Bundle;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentRfidSettingBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.demoapp.rfid.SerializableAsDeviceRfidFhLbtParam;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;
import jp.co.asterisk.asreader.a3xd.sdk.utility.EpcConverter;
import jp.co.asterisk.asreader.a3xd.demoapp.R;


public class RfidSettingFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = RfidSettingFragment.class.getSimpleName();

    private FragmentRfidSettingBinding binding;

    private int minPower;
    private int maxPower;
    private int powerLevel;
    private boolean isFragmentClose = false;

    private SerializableAsDeviceRfidFhLbtParam param;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_RfidSettingFragment_to_HomeFragment);

        binding = FragmentRfidSettingBinding.inflate(inflater, container, false);

        AsReaderSDK.getInstance().getDeviceManager().getReaderInfo(0xB0);
        param = new SerializableAsDeviceRfidFhLbtParam();

        binding.displayTagRssiToggleButton.setChecked(AsReaderSDK.getInstance().getRFIDManager().getRSSIEnable());

        binding.rfChannelLayout.setOnClickListener(clickListener);
        binding.outputPowerLayout.setOnClickListener(clickListener);
        binding.onOffTimeLayout.setOnClickListener(clickListener);
        binding.stopConditionsLayout.setOnClickListener(clickListener);
        binding.modulationModeLayout.setOnClickListener(clickListener);
        binding.encodingTypeLayout.setOnClickListener(clickListener);
        binding.sessionLayout.setOnClickListener(clickListener);
        binding.antiCollisionLayout.setOnClickListener(clickListener);
        binding.continuousModeToggleButton.setOnClickListener(clickListener);
        binding.displayTagRssiToggleButton.setOnClickListener(clickListener);
        binding.autoOffTimeLayout.setOnClickListener(clickListener);
        binding.sessionFlagLayout.setOnClickListener(clickListener);
        binding.qvalueLayout.setOnClickListener(clickListener);
        binding.hidModeToggleButton.setOnClickListener(clickListener);
        binding.dutyRatioLayout.setOnClickListener(clickListener);
        binding.dutyRatioBaseTimeLayout.setOnClickListener(clickListener);
        if (AsReaderSDK.getInstance().getDeviceManager().isM30SDevice()) {
            binding.onOffTimeLayout.setVisibility(View.GONE);
            binding.antiCollisionLayout.setVisibility(View.GONE);
            binding.rfChannelLayout.setVisibility(View.GONE);
        } else {
            binding.m30sLayout.setVisibility(View.GONE);
            binding.continuousModeLayout.setVisibility(View.GONE);
        }
        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        isFragmentClose = false;
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);
        AsReaderSDK.getInstance().getDeviceManager().getReaderInfo(0xB0);
        if (AsReaderSDK.getInstance().getDeviceManager().isM30SDevice()) {
            AsReaderSDK.getInstance().getRFIDManager().getContinuousMode();
            AsReaderSDK.getInstance().getRFIDManager().getHidMode();
            AsReaderSDK.getInstance().getRFIDManager().getSessionFlag();
            AsReaderSDK.getInstance().getRFIDManager().getAutoOffTime();
            AsReaderSDK.getInstance().getRFIDManager().getQValue();
            AsReaderSDK.getInstance().getRFIDManager().getDutyRatioBaseTime();
            AsReaderSDK.getInstance().getRFIDManager().getDutyRatio();
        }
        binding.outputPowerTextView.setText("");
        binding.onOffTimeTextView.setText("");
        binding.antiCollisionTextView.setText("");
        binding.rfChannelTextView.setText("");

        binding.autoOffTimeTextView.setText("");
        binding.sessionFlagTextView.setText("");
        binding.qvalueTextView.setText("");
        binding.dutyRatioTextView.setText("");
        binding.dutyRatioBaseTimeTextView.setText("");
        AsReaderSDK.getInstance().getRFIDManager().getSession();
        int maxTag = AsReaderSDK.getInstance().getRFIDManager().getMaxTagValue();
        int maxTime = AsReaderSDK.getInstance().getRFIDManager().getMaxTimeValue();
        int repeatCycle = AsReaderSDK.getInstance().getRFIDManager().getRepeatCycleValue();

        String stopCondition = maxTag + "/" + maxTime + "/" + repeatCycle;
        binding.stopConditionsTextView.setText(stopCondition);

        int encodingType = getPreferencesHelper().getEncodingType();
        String sEncodingType = EpcConverter.toTypeString(encodingType);
        binding.encodingTypeTextView.setText(sEncodingType);
        if (AsReaderSDK.getInstance().getDeviceManager().isM30SDevice()) {
            setToolbar(true, getString(R.string.toolbar_title_setting), "");
        } else {
            setToolbar(true, getString(R.string.toolbar_title_setting), getString(R.string.button_name_update));
        }
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        isFragmentClose = true;
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);
        AsReaderSDK.getInstance().getRFIDManager().updateRegistry();
    }

    private View.OnClickListener clickListener = (View view) -> {
        if (view == binding.rfChannelLayout) {
            navigate(this, R.id.action_RfidSettingFragment_to_RfChannelFragment);

        } else if (view == binding.outputPowerLayout) {
            Bundle args = new Bundle();
            args.putInt(OutputPowerFragment.ARGS_MIN_POWER, minPower);
            args.putInt(OutputPowerFragment.ARGS_MAX_POWER, maxPower);
            args.putInt(OutputPowerFragment.ARGS_POWER_LEVEL, powerLevel);
            navigate(this, R.id.action_RfidSettingFragment_to_OutputPowerFragment, args);

        } else if (view == binding.onOffTimeLayout) {
            Bundle args = new Bundle();
            args.putString(OnOffTimeFragment.ARGS_ON_OFF_TIME, binding.onOffTimeTextView.getText().toString());
            args.putSerializable(OnOffTimeFragment.ARGS_PARAM, param);
            navigate(this, R.id.action_RfidSettingFragment_to_OnOffTimeFragment, args);

        } else if (view == binding.stopConditionsLayout) {
            navigate(this, R.id.action_RfidSettingFragment_to_StopConditionsFragment);

        } else if (view == binding.modulationModeLayout) {
            navigate(this, R.id.action_RfidSettingFragment_to_ModulationModeFragment);

        } else if (view == binding.encodingTypeLayout) {
            navigate(this, R.id.action_RfidSettingFragment_to_EncodingTypeFragment);

        } else if (view == binding.sessionLayout) {
            navigate(this, R.id.action_RfidSettingFragment_to_SessionFragment);

        } else if (view == binding.antiCollisionLayout) {
            navigate(this, R.id.action_RfidSettingFragment_to_AntiCollisionFragment);

        } else if (view == binding.continuousModeToggleButton) {
            AsReaderSDK.getInstance().getRFIDManager().setContinuousMode(binding.continuousModeToggleButton.isChecked());

        } else if (view == binding.displayTagRssiToggleButton) {
            AsReaderSDK.getInstance().getRFIDManager().setRSSIEnable(binding.displayTagRssiToggleButton.isChecked());

        } else if (view == binding.sessionFlagLayout) {
            navigate(this, R.id.action_RfidSettingFragment_to_SessionFlagFragment);
        } else if (view == binding.hidModeToggleButton) {
            AsReaderSDK.getInstance().getRFIDManager().setHidMode(binding.hidModeToggleButton.isChecked());
        } else if (view == binding.autoOffTimeLayout) {
            navigate(this, R.id.action_RfidSettingFragment_to_AutoOffTimeFragment);
        } else if (view == binding.qvalueLayout) {
            navigate(this, R.id.action_RfidSettingFragment_to_QValueFragment);
        } else if (view == binding.dutyRatioLayout) {
            navigate(this, R.id.action_RfidSettingFragment_to_DutyRatioFragment);
        } else if (view == binding.dutyRatioBaseTimeLayout) {
            navigate(this, R.id.action_RfidSettingFragment_to_DutyRatioBaseTimeFragment);
        }
    };

    public void onReaderInfoReceived(int onTime, int offTime, int senseTime,
                                     int lbtLevel, int fhEnable, int lbtEnable,
                                     int cwEnable, int power, int minPower, int maxPower) {
        param.readtime  = onTime;
        param.idletime  = offTime;
        param.sensetime = senseTime;
        param.lbtlevel  = lbtLevel;
        param.fhmode    = fhEnable;
        param.lbtmode   = lbtEnable;
        param.cwmode    = cwEnable;

        powerLevel  = power;
        this.minPower = minPower;
        this.maxPower = maxPower;

        if (getActivity()!=null && !isFragmentClose){
            getActivity().runOnUiThread(() -> {
                binding.outputPowerTextView.setText(String.valueOf(power / 10.0));
                binding.onOffTimeTextView.setText(onTime + "/" + offTime);
            });
        }
        if(!isFragmentClose)
            AsReaderSDK.getInstance().getRFIDManager().getAntiCollisionMode();
    }

    @Override
    public void onReceiveAntimode(int mode, int qStart, int qMax, int qMin, int counter) {
        if (getActivity()!=null && !isFragmentClose){
            getActivity().runOnUiThread(() -> {
                binding.antiCollisionTextView.setText(String.valueOf(mode));
            });
        }

        AsReaderSDK.getInstance().getRFIDManager().getChannel();
    }

    @Override
    public void didUpdateRegistry(int state) {
        if (getActivity()!=null && !isFragmentClose){
            getActivity().runOnUiThread(() -> {
                if (state == 0) {
                    showToast("Success Data Store into Registry");
                } else {
                    showToast("Fail Store into Registry");
                }
            });
        }
    }

    @Override
    public void onChannelReceived(int channel, int channelOffset) {
        if (getActivity()!=null && !isFragmentClose){
            getActivity().runOnUiThread(() -> {
                binding.rfChannelTextView.setText("ch" + channel + "off:" + channelOffset);
            });
        }
    }

    @Override
    public void onTxPowerLevelReceived(int power, int minPower, int maxPower) {
        powerLevel  = power;
        this.minPower = minPower;
        this.maxPower = maxPower;

        if (getActivity()!=null && !isFragmentClose){
            getActivity().runOnUiThread(() -> {
                float outputPower = (float)(powerLevel / 10.0);
                binding.outputPowerTextView.setText(String.valueOf(outputPower));
            });
        }
    }

    @Override
    public void didSetContinuousMode(int status) {
        if (getActivity()!=null && !isFragmentClose){
            getActivity().runOnUiThread(() -> {
                if (status == 0) {
                    AsReaderSDK.getInstance().getRFIDManager().setContinueMode(binding.continuousModeToggleButton.isChecked());
                    showToast("Success");
                } else {
                    showToast("Fail");
                }
            });
        }
    }

    @Override
    public void onReceiveContinuousMode(boolean status) {
        if (getActivity()!=null && !isFragmentClose){
            getActivity().runOnUiThread(() -> {
                binding.continuousModeToggleButton.setChecked(status);
            });
        }
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }

    @Override
    public void onSessionReceived(int session) {
        if (getActivity()!=null && !isFragmentClose){
            getActivity().runOnUiThread(() -> {
                binding.sessionTextView.setText("S" + session);
            });
        }
    }

    @Override
    public void onReceiveHidMode(boolean value) {
        if (getActivity()!=null && !isFragmentClose){
            getActivity().runOnUiThread(() -> {
                binding.hidModeToggleButton.setChecked(value);
            });
        }
    }

    @Override
    public void onReceiveSessionFlag(int value) {
        if (getActivity()!=null && !isFragmentClose){
            getActivity().runOnUiThread(() -> {
                String string = "A";
                if (value == 0 ){
                    string = "A";
                } else if (value == 1 ){
                    string = "B";
                } else if (value == 2 ){
                    string = "AB";
                }
                binding.sessionFlagTextView.setText(string);
            });
        }
    }

    @Override
    public void onReceiveAutoOffTime(int time) {
        if (getActivity()!=null && !isFragmentClose){
            getActivity().runOnUiThread(() -> {
                binding.autoOffTimeTextView.setText("" + time);
            });
        }
    }

    @Override
    public void onReceiveQValue(int value) {
        if (getActivity()!=null && !isFragmentClose){
            getActivity().runOnUiThread(() -> {
                binding.qvalueTextView.setText(String.format("%02d", value));
            });
        }
    }

    @Override
    public void onReceiveDutyRatioBaseTime(int value) {
        if (getActivity()!=null && !isFragmentClose){
            getActivity().runOnUiThread(() -> {
                binding.dutyRatioBaseTimeTextView.setText("" + value);
            });
        }
    }

    @Override
    public void onReceiveDutyRatio(int value) {
        if (getActivity()!=null && !isFragmentClose){
            getActivity().runOnUiThread(() -> {
                String[] array = {
                        "0:0",
                        "1:5%",
                        "2:10%",
                        "3:15%",
                        "4:20%",
                        "5:25%",
                        "6:30%",
                        "7:35%",
                        "8:40%",
                        "9:45%",
                        "10:50%",
                        "11:55%",
                        "12:60%",
                        "13:70%",
                        "14:80%",
                        "15:90%"
                };
                binding.dutyRatioTextView.setText(array[value/10]);
            });
        }
    }
}
