package jp.co.asterisk.asreader.a3xd.demoapp.fragment.tagaccess;

import android.os.Bundle;

import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentKillBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.common.Convert;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;
import jp.co.asterisk.asreader.a3xd.sdk.sdevice.AsDeviceLib;
import jp.co.asterisk.asreader.a3xd.demoapp.R;

public class KillFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = KillFragment.class.getSimpleName();

    public static final String ARGS_SELECTED_TAG = "selectTag";

    private FragmentKillBinding binding;

    private String nowTag;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            nowTag = getArguments().getString(ARGS_SELECTED_TAG);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_KillFragment_to_HomeFragment);

        binding = FragmentKillBinding.inflate(inflater, container, false);
        binding.killTagEditText.setText(nowTag);
        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);

        setToolbar(true, getString(R.string.toolbar_title_kill), getString(R.string.button_name_done));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);

        if (AsReaderSDK.getInstance().getDeviceManager().isOpen()) {
            try {
                String epc = binding.killTagEditText.getText().toString();
                long password = Long.parseLong(binding.killPasswordEditText.getText().toString(), 16);
                AsReaderSDK.getInstance().getRFIDManager().killTag(password, epc);

            } catch (Exception e) {
                e.printStackTrace();
                showToast(getString(R.string.error));
            }
        }
    }

    @Override
    public void onKillTagMemorySuccess() {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                showToast(getString(R.string.success), Toast.LENGTH_SHORT);
            });
        }
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}
