package jp.co.asterisk.asreader.a3xd.demoapp.fragment.tagaccess;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioGroup;
import android.widget.Toast;

import java.util.function.Function;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentLockBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.common.Convert;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;
import jp.co.asterisk.asreader.a3xd.sdk.sdevice.AsDeviceLib;
import jp.co.asterisk.asreader.a3xd.demoapp.R;

public class LockFragment extends BaseFragment implements RFIDManagerCallback {

    private final String TAG = LockFragment.class.getSimpleName();

    public static final String ARGS_SELECTED_TAG = "selectTag";

    private FragmentLockBinding binding;

    private String nowTag;
    private int seed = 0;
    private int targetMemory = 0;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            nowTag = getArguments().getString(ARGS_SELECTED_TAG);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_LockFragment_to_HomeFragment);

        binding = FragmentLockBinding.inflate(inflater, container, false);

        binding.targetMemoryRadioGroup.setOnCheckedChangeListener(onCheckedChangeListener);
        binding.actionRadioGroup.setOnCheckedChangeListener(onCheckedChangeListener);
        binding.targetTagEditText.setText(nowTag);

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);

        setToolbar(true, getString(R.string.toolbar_title_lock), getString(R.string.button_name_done));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    @Override
    public void onClickRightButton(View view) {
        super.onClickRightButton(view);
        if (AsReaderSDK.getInstance().getDeviceManager().isOpen()) {
            try {
                String epc = binding.targetTagEditText.getText().toString();
                Function<Integer, Integer> getLockData = (val) -> {
                    switch(val) {
                        case 0: return (seed << 8) | (3 << 18);
                        case 1: return (seed << 6) | (3 << 16);
                        case 2: return (seed << 4) | (3 << 14);
                        case 3: return (seed << 2) | (3 << 12);
                        case 4: return (seed << 0) | (3 << 10);
                    }
                    return 0;
                };
                int lock = getLockData.apply(targetMemory);
                long password = Long.parseLong(binding.accessPasswordEditText.getText().toString(), 16);
                AsReaderSDK.getInstance().getRFIDManager().lockTagMemory(password, epc, lock);

            } catch (Exception e) {
                e.printStackTrace();
                showToast(getString(R.string.error));
            }
        } else {
            showToast("lock Tag success");
        }
    }

    private RadioGroup.OnCheckedChangeListener onCheckedChangeListener = new RadioGroup.OnCheckedChangeListener() {
        @Override
        public void onCheckedChanged(RadioGroup group, int checkedId) {
            if (group == binding.targetMemoryRadioGroup) {
                if (checkedId == R.id.kill_radio_button) {
                    targetMemory = 0;
                } else if (checkedId == R.id.acs_radio_button) {
                    targetMemory = 1;
                } else if (checkedId == R.id.epc_radio_button) {
                    targetMemory = 2;
                } else if (checkedId == R.id.tid_radio_button) {
                    targetMemory = 3;
                }  else if (checkedId == R.id.user_radio_button) {
                    targetMemory = 4;
                }

            } else if (group == binding.actionRadioGroup) {
                if (checkedId == R.id.unlock_radio_button) {
                    seed = 0;
                } else if (checkedId == R.id.punlock_radio_button) {
                    seed = 1;
                } else if (checkedId == R.id.lock_radio_button) {
                    seed = 2;
                } else if (checkedId == R.id.plock_radio_button) {
                    seed = 3;
                }

            }
        }
    };

    @Override
    public void onLockTagMemorySuccess() {
        if (getActivity()!=null){
            getActivity().runOnUiThread(() -> {
                showToast(getString(R.string.success), Toast.LENGTH_SHORT);
            });
        }
    }

    @Override
    public void onRFIDManagerError(String message) {
        Log.d(TAG, message);
    }
}
