package jp.co.asterisk.asreader.a3xd.demoapp.fragment.tagaccess;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;

import jp.co.asterisk.asreader.a3xd.demoapp.databinding.FragmentTagAccessBinding;
import jp.co.asterisk.asreader.a3xd.demoapp.fragment.BaseFragment;
import jp.co.asterisk.asreader.a3xd.demoapp.rfid.custom.CustomSimpleMenuAdapter;
import jp.co.asterisk.asreader.a3xd.demoapp.R;

import java.util.ArrayList;

public class TagAccessFragment extends BaseFragment {

    public static final String ARG_SELECTED_TAG = "ARG_SELECTED_TAG";

    private enum MENU_ITEM {
        READ_WRITE("Read/Write"),
        LOCK("Lock"),
        KILL("Kill");

        private final String name;

        MENU_ITEM(String name) {
            this.name = name;
        }

        public String getName() {
            return name;
        }
    }

    private FragmentTagAccessBinding binding;

    public String nowTag;

    private CustomSimpleMenuAdapter adapter;
    private ArrayList<String> menuList;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            nowTag = getArguments().getString(ARG_SELECTED_TAG);
            nowTag = splitEpc(nowTag);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        setBackToHomeActionResId(R.id.action_TagAccessFragment_to_HomeFragment);

        binding = FragmentTagAccessBinding.inflate(inflater, container, false);

        menuList = new ArrayList<>();
        menuList.add(MENU_ITEM.READ_WRITE.getName());
        menuList.add(MENU_ITEM.LOCK.getName());
        menuList.add(MENU_ITEM.KILL.getName());

        adapter = new CustomSimpleMenuAdapter(getContext(), R.layout.simple_menu_list_item, menuList);
        binding.listView.setAdapter(adapter);
        binding.listView.setOnItemClickListener((AdapterView<?> parent, View view, int position, long id) -> {
            Bundle args = new Bundle();
            args.putString("selectTag", nowTag);
            int resId = 0;
            if (position == MENU_ITEM.READ_WRITE.ordinal()) {
                resId = R.id.action_TagAccessFragment_to_ReadWriteFragment;

            } else if (position == MENU_ITEM.LOCK.ordinal()) {
                resId = R.id.action_TagAccessFragment_to_LockFragment;

            } else if (position == MENU_ITEM.KILL.ordinal()) {
                resId = R.id.action_TagAccessFragment_to_KillFragment;
            }

            if (resId != 0) {
                navigate(this, resId, args);
            }
        });

        return binding.getRoot();
    }

    @Override
    public void onResume() {
        super.onResume();
        setToolbar(true, getString(R.string.toolbar_title_tag_access));
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        binding = null;
    }

    private String splitEpc(String pcXpcEpc) {
        // check the XI bit on the PC
//        if((Byte.parseByte(pcXpcEpc.substring(0, 2), 16) & 0x02) == 0x02) {
        if((Integer.parseInt(pcXpcEpc.substring(0, 2),16) & 0x02) == 0x02) {
            // check the XEB bit on the XPC_W1
//            if((Byte.parseByte(pcXpcEpc.substring(4, 6), 16) & 0x80) == 0x80)	{
            if((Integer.parseInt(pcXpcEpc.substring(0, 2),16) & 0x80) == 0x80)	{
                return pcXpcEpc.substring(12);
            } else {
                return pcXpcEpc.substring(8);
            }
        }
        return pcXpcEpc.substring(4);
    }
}
