package jp.co.asterisk.asreader.a3xd.demoapp.rfid;

import jp.co.asterisk.asreader.a3xd.sdk.utility.EpcConverter;

/**
 * Created by sps on 2018. 10. 24..
 */

public class SensorTag {
    public static byte hexTemperature = 0x03;
    public static byte hexMoisture = 0x02;

    private String sensorPcEpc = null;
    private int sensorCop = 0;
    private int sensorCt = 0;
    private double sensorCfq = 0;
    private double sensorTemp = 0;
    private double sensorMoisture = 0;

    public void parseSensorData(int[] pcEpc, int[] data) throws Exception {
        try {
            sensorPcEpc = EpcConverter.toHexString(pcEpc);

            byte[] btSensor = new byte[data.length];
            for (int i = 0; i < data.length; i++) {
                btSensor[i] = (byte) (data[i] & 0xFF);
            }
            getSensorData(btSensor);
        } catch (Exception e) {
            throw  e;
        }
    }

    private boolean getSensorData(byte[] btSensor) {

        if (btSensor.length <8) return false;

        sensorCop = (btSensor[0] << 8) | btSensor[1] & 0xFF;
        int frequency_h = (btSensor[2] << 8) | (btSensor[3] & 0xFF);
        int frequency_l = (btSensor[4] << 8) | (btSensor[5] & 0xFF);

        sensorCfq = frequency_h + (frequency_l / 1000.0);
        sensorCt = btSensor[6];    // 0x02 : Moisture , 0x03 : Temperature

        boolean success = true;
        switch (sensorCt) {
            //Magnus S3 type Sensor TAG
            case 0x03:
                sensorTemp = RFMMagnusS3Temp(btSensor, 11);
                sensorMoisture = (btSensor[7] << 8) | (btSensor[8] & 0xFF);
                break;
            //Magnus S2 type Sensor TAG
            case 0x02:
                sensorMoisture = (btSensor[7] << 8) | (btSensor[8] & 0xFF);
                break;

            default:
                success = false;
                break;
        }
        return success;
    }

    private double RFMMagnusS3Temp(byte[] ba, int typeIdx) {
        double result = 0;
        int offset = 0;
        int temp = 0;

        double tempCode_ = 0;

        double code1_ = 0;
        double code2_ = 0;

        double temp1_ = 0;
        double temp2_ = 0;

        offset = typeIdx;
        tempCode_ = ba[offset + 0] << 8 | ba[offset + 1] & 0xFF;

        temp = ba[offset + 4] & 0xFF;
        temp = (temp << 4) + ((ba[offset + 5] >> 4) & 0x0F);
        code1_ = temp;

        temp = ba[offset + 5] & 0x0F;
        temp = (temp << 7) + ((ba[offset + 6] >> 1) & 0x7F);
        temp1_ = temp;

        temp = ba[offset + 6] & 0x01;
        temp = (temp << 8) + ba[offset + 7];
        temp = (temp << 3) + ((ba[offset + 8] >> 5) & 0x07);
        code2_ = temp;

        temp = ba[offset + 8] & 0x1F;
        temp = (temp << 6) + ((ba[offset + 9] >> 2) & 0x3F);
        temp2_ = temp;

        result = ((temp2_ - temp1_) / (code2_ - code1_) * (tempCode_ - code1_) + temp1_ - 800) / 10;
        return result;
    }

    public String getSensorPcEpc() {
        return sensorPcEpc;
    }

    public double getSensorTemp() {
        return sensorTemp;
    }

    public double getSensorMoisture() {
        return sensorMoisture;
    }
}
