package jp.co.asterisk.asreader.a3xd.demoapp.rfid.custom;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import jp.co.asterisk.asreader.a3xd.demoapp.R;
import jp.co.asterisk.asreader.a3xd.demoapp.databinding.SimpleMenuListItemBinding;

import java.util.List;

public class CustomSimpleMenuAdapter extends ArrayAdapter<String> {
    private int resource;
    private LayoutInflater inflater;

    public CustomSimpleMenuAdapter(@NonNull Context context, int resource, @NonNull List<String> objects) {
        super(context, resource, objects);
        this.resource = resource;
        inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }



    @NonNull
    @Override
    public View getView(int position, @Nullable View convertView, @NonNull ViewGroup parent) {
        if (convertView == null) {
            convertView = inflater.inflate(resource, parent, false);
        }

        String item = getItem(position);
        if (item != null) {
            TextView textView = convertView.findViewById(R.id.text_view);
            textView.setText(item);
        }

        return convertView;
    }
}