package jp.co.asterisk.asreader.a3xd.demoapp.rfid.custom;

import java.util.ArrayList;

import jp.co.asterisk.asreader.a3xd.demoapp.R;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;

import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

public class CustomTagAdapter extends ArrayAdapter<TagListItem> {
    private int mResource;
    private LayoutInflater mInflater;

    public CustomTagAdapter(Context context, int layoutResource, ArrayList<TagListItem> objects) {
		super(context, layoutResource, objects);
		this.mResource = layoutResource;
		this.mInflater =
				(LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
    	TagListItem item = getItem(position);
		if (convertView == null) {
			convertView = mInflater.inflate(mResource, null);
		}

		if (item != null) {
			TextView tTextView = convertView.findViewById(R.id.list_tag);
			TextView cTextView = convertView.findViewById(R.id.list_count);
			TextView rssiTextView = convertView.findViewById(R.id.list_rssi);

			tTextView.setText(item.getId());
			cTextView.setText(item.getCount());
			rssiTextView.setText(item.getRssi());
		}
		return convertView;
    }
}
