/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a3xd.sdk;

import android.content.Context;
import jp.co.asterisk.asreader.a3xd.sdk.SharedPreferencesHelper;
import jp.co.asterisk.asreader.a3xd.sdk.manager.DeviceManager;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManager;
import jp.co.asterisk.asreader.a3xd.sdk.manager.communication.CommunicationManager;
import jp.co.asterisk.asreader.a3xd.sdk.utility.LogLevel;
import jp.co.asterisk.asreader.a3xd.sdk.utility.SDKLog;

public class AsReaderSDK {
    private static AsReaderSDK instance;
    private final String TAG = AsReaderSDK.class.getSimpleName();

    private AsReaderSDK() {
    }

    public static AsReaderSDK getInstance() {
        if (instance == null) {
            instance = new AsReaderSDK();
        }
        return instance;
    }

    public DeviceManager getDeviceManager() {
        return DeviceManager.getInstance();
    }

    public RFIDManager getRFIDManager() {
        return RFIDManager.getInstance();
    }

    public void initialize(Context context) {
        CommunicationManager.getInstance().initialize(context);
        DeviceManager.getInstance().initialize(context);
        RFIDManager.getInstance().initialize();
        SharedPreferencesHelper.getInstance().initialize(context);
        SDKLog.getInstance().initialize(context);
    }

    public void setLogLevel(LogLevel level) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "API:setLogLevel ");
        SDKLog.getInstance().setLogLevel(level);
    }

    public LogLevel getLogLevel() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "API:getLogLevel ");
        return SDKLog.getInstance().getLogLevel();
    }

    public void setLog(boolean enable) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "API:setLog ");
        SDKLog.getInstance().setLogEnable(enable);
    }

    public void removeSDKLog() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "API:removeSDKLog ");
        SDKLog.getInstance().removeAllLog();
    }
}

