/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a3xd.sdk.manager;

import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDCommandType;
import jp.co.asterisk.asreader.a3xd.sdk.utility.PacketModel;

class RFIDCommandFactory {
    private static RFIDCommandFactory instance;

    private RFIDCommandFactory() {
    }

    public static RFIDCommandFactory getInstance() {
        if (instance == null) {
            instance = new RFIDCommandFactory();
        }
        return instance;
    }

    public PacketModel create(RFIDCommandType type) {
        switch (type) {
            case START_DECODE: {
                return this.createStartInventoryAuto();
            }
            case START_DECODE_WITH_RSSI: {
                return this.createStartInventoryAutoWithRSSI();
            }
            case START_DECODE_WITH_TAG_ID: {
                return this.createStartInventoryAutoWithTagID();
            }
            case START_RFM_DECODE: {
                return this.createStartInventoryRFM();
            }
            case STOP_DECODE: {
                return this.createStopDecode();
            }
            case GET_REGION: {
                return this.createGetRegion();
            }
            case SET_REGION: {
                return this.createSetRegion();
            }
            case SET_OPTINUM_FREQUENCY_HOPPING_TABLE: {
                return this.createSetOptimumFrequencyHoppingTable();
            }
            case SET_SMART_HOPPING: {
                return this.createSetSmartHopping();
            }
            case GET_FREQUENCY_HOPPING_MODE: {
                return this.createGetFrequencyHoppingMode();
            }
            case GET_FREQUENCY_HOPPING_TABLE: {
                return this.createGetFrequencyHoppingTable();
            }
            case GET_CHANNEL: {
                return this.createGetChannel();
            }
            case SET_CHANNEL: {
                return this.createSetChannel();
            }
            case GET_SESSION: {
                return this.createGetSession();
            }
            case SET_SESSION: {
                return this.createSetSession();
            }
            case GET_ANTI_COLLISION_MODE: {
                return this.createGetAntiCollisionMode();
            }
            case SET_ANTI_COLLISION_MODE: {
                return this.createSetAntiCollisionMode();
            }
            case GET_FH_LBT_PARAM: {
                return this.createGetFhLbtParam();
            }
            case SET_FH_LBT_PARAM: {
                return this.createSetFhLbtParam();
            }
            case GET_OUTPUT_POWER_LEVEL: {
                return this.createGetOutputPowerLevel();
            }
            case SET_OUTPUT_POWER_LEVEL: {
                return this.createSetOutputPowerLevel();
            }
            case GET_MODULATION: {
                return this.createGetModulation();
            }
            case SET_MODULATION: {
                return this.createSetModulation();
            }
            case SET_TRIGGER_STOP_CONDITION: {
                return this.createSetTriggerStopCondition();
            }
            case READ_TAG_MEMORY: {
                return this.createReadTagMemory();
            }
            case READ_TAG_MEMORY_TIMEOUT: {
                return this.createReadTagMemoryTimeout();
            }
            case READ_TAG_MEMORY_BLOCK: {
                return this.createReadTagMemoryBlock();
            }
            case WRITE_TAG_MEMORY: {
                return this.createWriteToTagMemory();
            }
            case WRITE_TAG_MEMORY_TIMEOUT: {
                return this.createWriteToTagMemoryParam();
            }
            case WRITE_TAG_MEMORY_BLOCK: {
                return this.createBlockWriteToTagMemoryParam();
            }
            case BLOCK_ERASE_TO_TAG_MEMORY_PARAM: {
                return this.createBlockEraseToTagMemoryParam();
            }
            case KILL_TAG_MEMORY: {
                return this.createKillTagMemory();
            }
            case LOCK_TAG_MEMORY: {
                return this.createLockTagMemory();
            }
            case LOCK_TAG_MEMORY_TIMEOUT: {
                return this.createLockTagMemoryParam();
            }
            case UPDATE_REGISTRY: {
                return this.createUpdateRegistry();
            }
        }
        return null;
    }

    private PacketModel createPacketModel(byte type, byte command) {
        PacketModel packetModel = new PacketModel();
        packetModel.setCommand(type, command);
        return packetModel;
    }

    private PacketModel createStartInventoryAuto() {
        return this.createPacketModel((byte)0, (byte)54);
    }

    private PacketModel createStartInventoryAutoWithRSSI() {
        return this.createPacketModel((byte)0, (byte)56);
    }

    private PacketModel createStartInventoryAutoWithTagID() {
        return this.createPacketModel((byte)0, (byte)58);
    }

    private PacketModel createStartInventoryRFM() {
        return this.createPacketModel((byte)0, (byte)59);
    }

    private PacketModel createStopDecode() {
        return this.createPacketModel((byte)0, (byte)55);
    }

    private PacketModel createGetRegion() {
        return this.createPacketModel((byte)0, (byte)6);
    }

    private PacketModel createSetRegion() {
        return this.createPacketModel((byte)0, (byte)7);
    }

    private PacketModel createSetOptimumFrequencyHoppingTable() {
        return this.createPacketModel((byte)0, (byte)-28);
    }

    private PacketModel createGetFrequencyHoppingMode() {
        return this.createPacketModel((byte)0, (byte)-27);
    }

    private PacketModel createGetFrequencyHoppingTable() {
        return this.createPacketModel((byte)0, (byte)48);
    }

    private PacketModel createSetSmartHopping() {
        return this.createPacketModel((byte)0, (byte)-26);
    }

    private PacketModel createGetChannel() {
        return this.createPacketModel((byte)0, (byte)17);
    }

    private PacketModel createSetChannel() {
        return this.createPacketModel((byte)0, (byte)18);
    }

    private PacketModel createGetSession() {
        return this.createPacketModel((byte)0, (byte)46);
    }

    private PacketModel createSetSession() {
        return this.createPacketModel((byte)0, (byte)47);
    }

    private PacketModel createGetAntiCollisionMode() {
        return this.createPacketModel((byte)0, (byte)52);
    }

    private PacketModel createSetAntiCollisionMode() {
        return this.createPacketModel((byte)0, (byte)53);
    }

    private PacketModel createGetFhLbtParam() {
        return this.createPacketModel((byte)0, (byte)19);
    }

    private PacketModel createSetFhLbtParam() {
        return this.createPacketModel((byte)0, (byte)20);
    }

    private PacketModel createGetOutputPowerLevel() {
        return this.createPacketModel((byte)0, (byte)21);
    }

    private PacketModel createSetOutputPowerLevel() {
        return this.createPacketModel((byte)0, (byte)22);
    }

    private PacketModel createGetModulation() {
        return this.createPacketModel((byte)0, (byte)50);
    }

    private PacketModel createSetModulation() {
        return this.createPacketModel((byte)0, (byte)51);
    }

    private PacketModel createSetTriggerStopCondition() {
        return this.createPacketModel((byte)0, (byte)16);
    }

    private PacketModel createReadTagMemory() {
        return this.createPacketModel((byte)0, (byte)41);
    }

    private PacketModel createReadTagMemoryTimeout() {
        return this.createPacketModel((byte)0, (byte)43);
    }

    private PacketModel createReadTagMemoryBlock() {
        return this.createPacketModel((byte)0, (byte)42);
    }

    private PacketModel createWriteToTagMemory() {
        return this.createPacketModel((byte)0, (byte)70);
    }

    private PacketModel createWriteToTagMemoryParam() {
        return this.createPacketModel((byte)0, (byte)73);
    }

    private PacketModel createBlockWriteToTagMemoryParam() {
        return this.createPacketModel((byte)0, (byte)71);
    }

    private PacketModel createBlockEraseToTagMemoryParam() {
        return this.createPacketModel((byte)0, (byte)72);
    }

    private PacketModel createKillTagMemory() {
        return this.createPacketModel((byte)0, (byte)101);
    }

    private PacketModel createLockTagMemory() {
        return this.createPacketModel((byte)0, (byte)-126);
    }

    private PacketModel createLockTagMemoryParam() {
        return this.createPacketModel((byte)0, (byte)-120);
    }

    private PacketModel createUpdateRegistry() {
        return this.createPacketModel((byte)0, (byte)-46);
    }
}

