/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a3xd.sdk.sdevice;

import jp.co.asterisk.asreader.a3xd.sdk.common.Convert;
import jp.co.asterisk.asreader.a3xd.sdk.sdevice.AsDeviceException;
import jp.co.asterisk.asreader.a3xd.sdk.sdevice.AsDeviceLib;

public class AsDevicePacket {
    protected byte[] packet = new byte[this.max_payload_len + 8];
    protected int packet_len;
    protected int payload_len;
    private int max_payload_len = 256;
    public static final int PAYLOAD_INDEX = 5;
    private static final int PACKET_LEN_EXCLUDING_PAYLOAD = 8;
    public static final AsDevicePacket INSTANCE = new AsDevicePacket();

    private AsDevicePacket() {
    }

    public static AsDevicePacket getInstance() {
        return INSTANCE;
    }

    private byte getPreamble() {
        return this.packet[0];
    }

    private byte getType() {
        return this.packet[1];
    }

    private byte getCode() {
        return this.packet[2];
    }

    private byte getEndMask() {
        return this.packet[5 + this.payload_len];
    }

    private int getUCRC16() throws AsDeviceException {
        return Convert.toInt(this.packet, 5 + this.payload_len + 1, 2);
    }

    public void checkPacketSize(int payload_len, boolean crc) {
        if (payload_len > this.max_payload_len) {
            this.max_payload_len = payload_len;
            this.packet = new byte[this.max_payload_len + 8];
        }
        this.payload_len = payload_len;
        this.packet_len = crc ? 5 + payload_len + 3 : 5 + payload_len + 1;
    }

    public void startEncodePacket(byte type, byte code, int payload_len, boolean crc) throws AsDeviceException {
        this.checkPacketSize(payload_len, crc);
        this.packet[0] = -69;
        this.packet[1] = type;
        this.packet[2] = code;
        this.packet[5 + payload_len] = 126;
    }

    public void endEncodePacket() throws AsDeviceException {
    }

    private void checkValidPayloadFormat0(int payload_len) throws AsDeviceException {
        if (this.payload_len != payload_len) {
            AsDeviceException exception = new AsDeviceException("invalid packet format", 3);
            throw exception;
        }
    }

    private void checkValidPayloadFormat1() throws AsDeviceException {
        if (this.payload_len != 1 || this.packet[5] != 0) {
            AsDeviceException exception = new AsDeviceException("invalid packet format", 3);
            throw exception;
        }
    }

    private void checkValidPayloadFormat2() throws AsDeviceException {
        if (Convert.toInt(this.packet[11]) + 7 != this.payload_len || (this.packet[11] & 0x7F) != 0) {
            AsDeviceException exception = new AsDeviceException("invalid packet format", 3);
            throw exception;
        }
    }

    private void checkValidPayloadFormat3() throws AsDeviceException {
        if (this.payload_len != 2 || (this.packet[6] & 7) != 0) {
            AsDeviceException exception = new AsDeviceException("invalid packet format", 3);
            throw exception;
        }
    }

    private void checkValidPayloadFormat4() throws AsDeviceException {
        if (this.payload_len != Convert.toInt(this.packet[5]) + 1) {
            throw new AsDeviceException("invalid packet format", 3);
        }
    }

    private void checkValidPayloadFormat5() throws AsDeviceException {
        if (this.payload_len != 1 || this.packet[5] != 31) {
            throw new AsDeviceException("invalid packet format", 3);
        }
    }

    public void checkValidPacket() throws AsDeviceException {
        if (this.getPreamble() != -69 || this.getType() != 0 && this.getType() != 1 && this.getType() != 2 || this.getEndMask() != 126) {
            AsDeviceException exception = new AsDeviceException("invalid packet format", 3);
            throw exception;
        }
        if (this.getUCRC16() != AsDeviceLib.calculateCRC(this)) {
            AsDeviceException exception = new AsDeviceException("invalid packet: CRC mismatch", 4);
            throw exception;
        }
        if (this.getType() == 0) {
            return;
        }
        if (this.getCode() == 1) {
            this.checkValidPayloadFormat1();
        } else if (this.getCode() != 3) {
            if (this.getCode() == 6) {
                this.checkValidPayloadFormat0(1);
            } else if (this.getCode() == 7) {
                this.checkValidPayloadFormat1();
            } else if (this.getCode() == 8) {
                this.checkValidPayloadFormat1();
            } else if (this.getCode() == 11) {
                this.checkValidPayloadFormat2();
            } else if (this.getCode() == 12) {
                this.checkValidPayloadFormat1();
            } else if (this.getCode() == 13) {
                this.checkValidPayloadFormat3();
            } else if (this.getCode() == 14) {
                this.checkValidPayloadFormat1();
            } else if (this.getCode() == 17) {
                this.checkValidPayloadFormat0(2);
            } else if (this.getCode() == 18) {
                this.checkValidPayloadFormat1();
            } else if (this.getCode() == 19) {
                this.checkValidPayloadFormat0(11);
            } else if (this.getCode() == 20) {
                this.checkValidPayloadFormat1();
            } else if (this.getCode() == 21) {
                this.checkValidPayloadFormat0(2);
            } else if (this.getCode() == 22) {
                this.checkValidPayloadFormat1();
            } else if (this.getCode() == 23) {
                this.checkValidPayloadFormat1();
            } else if (this.getCode() != 34) {
                if (this.getCode() == 37) {
                    if (this.getType() == 1) {
                        this.checkValidPayloadFormat1();
                    } else if (this.getType() == 2) {
                        this.checkValidPayloadFormat5();
                    }
                } else if (this.getCode() != 41) {
                    if (this.getCode() == 48) {
                        this.checkValidPayloadFormat4();
                    } else if (this.getCode() == 49) {
                        this.checkValidPayloadFormat1();
                    } else if (this.getCode() == 50) {
                        this.checkValidPayloadFormat0(4);
                    } else if (this.getCode() == 51) {
                        this.checkValidPayloadFormat1();
                    } else if (this.getCode() == 52) {
                        this.checkValidPayloadFormat0(1);
                    } else if (this.getCode() == 53) {
                        this.checkValidPayloadFormat1();
                    } else if (this.getCode() == 54) {
                        if (this.getType() == 1) {
                            this.checkValidPayloadFormat1();
                        } else if (this.getType() == 2) {
                            this.checkValidPayloadFormat5();
                        }
                    } else if (this.getCode() == 55) {
                        this.checkValidPayloadFormat1();
                    } else if (this.getCode() == 70) {
                        this.checkValidPayloadFormat1();
                    } else if (this.getCode() == 71) {
                        this.checkValidPayloadFormat1();
                    } else if (this.getCode() == 72) {
                        this.checkValidPayloadFormat1();
                    } else if (this.getCode() == 101) {
                        this.checkValidPayloadFormat1();
                    } else if (this.getCode() == -126) {
                        this.checkValidPayloadFormat1();
                    } else if (this.getCode() == -73) {
                        this.checkValidPayloadFormat0(1);
                    } else if (this.getCode() == -59) {
                        this.checkValidPayloadFormat0(2);
                    } else if (this.getCode() == -46) {
                        this.checkValidPayloadFormat1();
                    } else if (this.getCode() == -45) {
                        this.checkValidPayloadFormat1();
                    } else if (this.getCode() != -44 && this.getCode() != -40) {
                        if (this.getCode() == -39) {
                            this.checkValidPayloadFormat1();
                        } else if (this.getCode() == -1) {
                            this.checkValidPayloadFormat0(1);
                        }
                    }
                }
            }
        }
    }

    private boolean isResponseFailure() {
        return this.getCode() == -1 && this.getType() == 1;
    }

    private boolean isNotificationFailure() {
        return this.getCode() == -1 && this.getType() == 2;
    }

    public void checkExpectedResponse(byte code) throws AsDeviceException {
        if (this.isResponseFailure()) {
            AsDeviceException exception;
            switch (this.packet[5]) {
                case 9: {
                    exception = new AsDeviceException("fail to read tag memory", 9);
                    break;
                }
                case 16: {
                    exception = new AsDeviceException("fail to write data", 16);
                    break;
                }
                case 11: {
                    exception = new AsDeviceException("read type C tag ID multiple in operation", 11);
                    break;
                }
                case 13: {
                    exception = new AsDeviceException("not in mode - read type C tag ID multiple", 13);
                    break;
                }
                case 14: {
                    exception = new AsDeviceException("invalid command parameters", 14);
                    break;
                }
                case 18: {
                    exception = new AsDeviceException("fail to kill a tag", 18);
                    break;
                }
                case 19: {
                    exception = new AsDeviceException("fail to lock a tag", 19);
                    break;
                }
                case 21: {
                    exception = new AsDeviceException("fail to read a tag", 21);
                    break;
                }
                case 24: {
                    exception = new AsDeviceException("not supported command", 24);
                    break;
                }
                case -1: {
                    exception = new AsDeviceException("CRC error", -1);
                    break;
                }
                default: {
                    exception = new AsDeviceException("unknown failure", -2);
                }
            }
            throw exception;
        }
        if (this.getType() != 1) {
            AsDeviceException exception = new AsDeviceException("not response", 5);
            throw exception;
        }
        if (this.getCode() != code) {
            AsDeviceException exception = new AsDeviceException("unexpected response", 7);
            throw exception;
        }
    }

    public void checkExpectedNotification(byte code) throws AsDeviceException {
        if (this.isNotificationFailure()) {
            AsDeviceException exception;
            switch (this.packet[5]) {
                case 9: {
                    exception = new AsDeviceException("fail to read tag memory", 9);
                    break;
                }
                case 16: {
                    exception = new AsDeviceException("fail to write data", 16);
                    break;
                }
                case 11: {
                    exception = new AsDeviceException("read type C tag ID multiple in operation", 11);
                    break;
                }
                case 13: {
                    exception = new AsDeviceException("not in mode - read type C tag ID multiple", 13);
                    break;
                }
                case 14: {
                    exception = new AsDeviceException("invalid command parameters", 14);
                    break;
                }
                case 18: {
                    exception = new AsDeviceException("fail to kill a tag", 18);
                    break;
                }
                case 19: {
                    exception = new AsDeviceException("fail to lock a tag", 19);
                    break;
                }
                case 21: {
                    exception = new AsDeviceException("fail to read a tag", 21);
                    break;
                }
                case 24: {
                    exception = new AsDeviceException("not supported command", 24);
                    break;
                }
                case -1: {
                    exception = new AsDeviceException("CRC error", -1);
                    break;
                }
                default: {
                    exception = new AsDeviceException("unknown failure", -2);
                }
            }
            throw exception;
        }
        if (this.getType() != 2) {
            AsDeviceException exception = new AsDeviceException("not notificaiton", 6);
            throw exception;
        }
        if (this.getCode() != 34) {
            if (this.getCode() != code) {
                AsDeviceException exception = new AsDeviceException("unexpected notification", -15);
                throw exception;
            }
            AsDeviceException exception = new AsDeviceException("multiple read complete", -16);
            throw exception;
        }
    }
}

