package com.example.a3xd_plugin;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import io.flutter.plugin.common.MethodChannel;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.common.AsDeviceConst;
import jp.co.asterisk.asreader.a3xd.sdk.common.RFIDConst;
import jp.co.asterisk.asreader.a3xd.sdk.manager.DeviceManagerCallback;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManagerCallback;
import jp.co.asterisk.asreader.a3xd.sdk.utility.LogLevel;

public class A3xdManager implements DeviceManagerCallback, RFIDManagerCallback{
    public static final String ON_CONNECT = "onConnect";
    public static final String ON_BATTERY_STATE_RECEIVED = "onBatteryStateReceived";
    public static final String ON_READER_INFO_RECEIVED = "onReaderInfoReceived";
    public static final String ON_READER_ABOUT_INFO = "onReaderAboutInfo";
    public static final String ON_RECEIVED_RFID_MODULE_VERSION = "onReceivedRFIDModuleVersion";
    public static final String ON_COMPLETED_PREPARATION = "onCompletedPreparation";
    public static final String ON_SET_READER_SETTING_SUCCESS = "onSetReaderSettingSuccess";
    public static final String ON_DEVICE_MANAGER_ERROR = "onDeviceManagerError";
    public static final String DID_UPDATE_REGISTRY = "didUpdateRegistry";
    public static final String ON_MODULATION_RECEIVED = "onModulationReceived";
    public static final String DID_SET_MODULATION = "didSetModulation";
    public static final String ON_TX_POWER_LEVEL_RECEIVED = "onTxPowerLevelReceived";
    public static final String ON_FH_LBT_RECEIVED = "onFhLbtReceived";
    public static final String ON_RECEIVED_ANTIMODE = "onReceiveAntimode";
    public static final String ON_SESSION_RECEIVED = "onSessionReceived";
    public static final String ON_CHANNEL_RECEIVED = "onChannelReceived";
    public static final String ON_REGION_RECEIVED = "onRegionReceived";
    public static final String DID_RECEIVE_REGION = "didReceiveRegion";
    public static final String ON_RECEIVE_SMART_MODE = "onReceiveSmartMode";
    public static final String DID_SET_SMART_MODE = "didSetSmartMode";
    public static final String DID_SET_OPTI_FREQ_HP_TABLE = "didSetOptiFreqHPTable";
    public static final String ON_TAG_RECEIVED = "onTagReceived";
    public static final String ON_TAG_WITH_TID_RECEIVED = "onTagWithTidReceived";
    public static final String ON_TAG_WITH_RSSI_RECEIVED = "onTagWithRssiReceived";
    public static final String ON_TAG_MEMORY_RECEIVED = "onTagMemoryReceived";
    public static final String ON_TAG_MEMORY_LONG_RECEIVED = "onTagMemoryLongReceived";
    public static final String ON_PC_EPC_SENSOR_DATA_RECEIVED = "onPcEpcSensorDataReceived";
    public static final String ON_SET_CHANNEL_SUCCESS = "onSetChannelSuccess";
    public static final String ON_SET_FH_LBT_PARAM_SUCCESS = "onSetFhLbtParamSuccess";
    public static final String ON_LOCK_TAG_MEMORY_SUCCESS = "onLockTagMemorySuccess";
    public static final String ON_WRITE_TO_TAG_MEMORY_SUCCESS = "onWriteToTagMemorySuccess";
    public static final String ON_KILL_TAG_MEMORY_SUCCESS = "onKillTagMemorySuccess";
    public static final String ON_SET_SESSION_SUCCESS = "onSetSessionSuccess";
    public static final String ON_GET_FREQUENCY_HOPPING_TABLE_SUCCESS = "onGetFrequencyHoppingTableSuccess";
    public static final String ON_SET_OUTPUTPOWER_LEVEL_SUCCESS = "onSetOutputPowerLevelSuccess";
    public static final String ON_SET_ANTICOLLISION_MODE_SUCCESS = "onSetAntiCollisionModeSuccess";
    public static final String ON_SET_TRIGGER_STOP_CONDITION_SUCCESS = "onSetTriggerStopConditionSuccess";
    public static final String ON_AUTO_INVENTORY_FINISHED = "onAutoInventoryFinished";
    public static final String ON_RFID_MANAGER_ERROR = "onRFIDManagerError";
    public static final String DID_SET_CONTINUOUS_MODE = "didSetContinuousMode";
    public static final String ON_RECEIVE_CONTINUOUS_MODE = "onReceiveContinuousMode";
    public static final String ON_RECEIVE_Q_VALUE = "onReceiveQValue";
    public static final String DID_SET_Q_VALUE = "didSetQValue";
    public static final String ON_RECEIVE_SESSION_FLAG = "onReceiveSessionFlag";
    public static final String DID_SET_SESSION_FLAG = "didSetSessionFlag";
    public static final String ON_RECEIVE_HID_MODE = "onReceiveHidMode";
    public static final String DID_SET_HID_MODE = "didSetHidMode";
    public static final String ON_RECEIVE_DUTY_RATIO = "onReceiveDutyRatio";
    public static final String DID_SET_DUTY_RATIO = "didSetDutyRatio";
    public static final String ON_RECEIVE_DUTY_RATIO_BASE_TIME = "onReceiveDutyRatioBaseTime";
    public static final String DID_SET_DUTY_RATIO_BASE_TIME = "didSetDutyRatioBaseTime";
    public static final String ON_RECEIVE_AUTO_OFF_TIME = "onReceiveAutoOffTime";
    public static final String DID_SET_AUTO_OFF_TIME = "didSetAutoOffTime";

    public MethodChannel currentChannel;
    public Context currentContext;
    private static A3xdManager mInstance = null;
    private String logTag = "A3xdManager";
    private Handler mainHandler = new Handler(Looper.getMainLooper());

    public static A3xdManager getInstance() {
        if (mInstance == null) mInstance = new A3xdManager();
        return mInstance;
    }

    public void init() {
        Log.d(logTag, "init");
        AsReaderSDK.getInstance().getDeviceManager().setCallback(this);
        AsReaderSDK.getInstance().getRFIDManager().setCallback(this);
        AsReaderSDK.getInstance().initialize(currentContext);
    }

    public String getA3XDFlutterVersion() {
        Log.d(logTag, "getA3XDFlutterVersion");
        return "1.0.0";
    }

    public String getA3XDSDKVersion() {
        Log.d(logTag, "getA3XDSDKVersion");
        return AsDeviceConst.strLibVersion;
    }

    public void setLogLevel(int level) {
        Log.d(logTag, "setLogLevel:" + level);
        LogLevel logLevel = getA3XDLogLevel(level);
        AsReaderSDK.getInstance().setLogLevel(logLevel);
    }

    public int getLogLevel() {
        Log.d(logTag, "getLogLevel");
        LogLevel logLevel = AsReaderSDK.getInstance().getLogLevel();
        int level = getA3XDLogLevel(logLevel);
        return level;
    }

    public void setLog(boolean enable) {
        Log.d(logTag, "setLog:" + enable);
        AsReaderSDK.getInstance().setLog(enable);
    }

    public void removeSDKLog() {
        Log.d(logTag, "removeSDKLog");
        AsReaderSDK.getInstance().removeSDKLog();
    }

    public boolean isConnected() {
        Log.d(logTag, "isConnected");
        return AsReaderSDK.getInstance().getDeviceManager().isConnected();
    }

    public boolean isPowerOn() {
        Log.d(logTag, "isPowerOn");
        return AsReaderSDK.getInstance().getDeviceManager().isPowerOn();
    }

    public boolean isOpen() {
        Log.d(logTag, "isOpen");
        return AsReaderSDK.getInstance().getDeviceManager().isOpen();
    }

    public void setPower(boolean power) {
        Log.d(logTag, "setPower:" + power);
        AsReaderSDK.getInstance().getDeviceManager().setPower(power);
    }

    public void setPowerWithOption(boolean power, boolean beep, boolean vib, boolean led, boolean aimer, boolean powerOnBeep) {
        Log.d(logTag, "setPowerWithOption:" + power + "  beep:" + beep + "  vib:" + vib + "  led:" + led + "  aimer:" + aimer + "  powerOnBeep:" + powerOnBeep);
        AsReaderSDK.getInstance().getDeviceManager().setPowerWithOption(power, beep, vib, led, aimer, powerOnBeep);
    }

    public void setReaderSettings(boolean beep, boolean vib, boolean led , boolean aimer) {
        Log.d(logTag, "setReaderSettings:" + beep + "  vib:" + vib + "  led:" + led + "  aimer:" + aimer);
        AsReaderSDK.getInstance().getDeviceManager().setReaderSettings(beep, vib, led, aimer);
    }

    public void getBattery() {
        Log.d(logTag, "getBattery");
        AsReaderSDK.getInstance().getDeviceManager().getBattery();
    }

    public void getReaderInfo(@IntRange(from = 0, to = 255) int type) {
        Log.d(logTag, "getReaderInfo:" + type);
        AsReaderSDK.getInstance().getDeviceManager().getReaderInfo(type);
    }

    public boolean isM30SDevice() {
        Log.d(logTag, "isM30SDevice");
        return AsReaderSDK.getInstance().getDeviceManager().isM30SDevice();
    }

    public void setMaxTagValue(@IntRange(from = 0, to = 0xFF)int value) {
        Log.d(logTag, "setMaxTagValue:" + value);
        AsReaderSDK.getInstance().getRFIDManager().setMaxTagValue(value);
    }

    public int getMaxTagValue() {
        Log.d(logTag, "getMaxTagValue");
        return AsReaderSDK.getInstance().getRFIDManager().getMaxTagValue();
    }

    public void setMaxTimeValue(@IntRange(from = 0, to = 0xFF)int value) {
        Log.d(logTag, "setMaxTimeValue:" + value);
        AsReaderSDK.getInstance().getRFIDManager().setMaxTimeValue(value);
    }

    public int getMaxTimeValue() {
        Log.d(logTag, "getMaxTimeValue");
        return AsReaderSDK.getInstance().getRFIDManager().getMaxTimeValue();
    }

    public void setRepeatCycleValue(@IntRange(from = 0, to = 0xFFFF)int value) {
        Log.d(logTag, "setRepeatCycleValue:" + value);
        AsReaderSDK.getInstance().getRFIDManager().setRepeatCycleValue(value);
    }

    public int getRepeatCycleValue() {
        Log.d(logTag, "getRepeatCycleValue");
        return AsReaderSDK.getInstance().getRFIDManager().getRepeatCycleValue();
    }

    public void setRSSIEnable(boolean enable) {
        Log.d(logTag, "setRSSIEnable:" + enable);
        AsReaderSDK.getInstance().getRFIDManager().setRSSIEnable(enable);
    }

    public boolean getRSSIEnable() {
        Log.d(logTag, "getRSSIEnable");
        return AsReaderSDK.getInstance().getRFIDManager().getRSSIEnable();
    }

    public void startInventory(@IntRange(from = 0, to = 0xFF) int maxTags,
                               @IntRange(from = 0, to = 0xFF) int maxTime,
                               @IntRange(from = 0, to = 0xFFFF) int repeatCycle) {
        Log.d(logTag, "startInventory:" + maxTags + "  maxTime:" + maxTime + "  repeatCycle:" + repeatCycle);
        AsReaderSDK.getInstance().getRFIDManager().startInventory(maxTags, maxTime, repeatCycle);
    }

    public void startInventoryRSSI(@IntRange(from = 0, to = 0xFF) int maxTags,
                                   @IntRange(from = 0, to = 0xFF) int maxTime,
                                   @IntRange(from = 0, to = 0xFFFF) int repeatCycle) {
        Log.d(logTag, "startInventoryRSSI:" + maxTags + "  maxTime:" + maxTime + "  repeatCycle:" + repeatCycle);
        AsReaderSDK.getInstance().getRFIDManager().startInventoryRSSI(maxTags, maxTime, repeatCycle);
    }

    public void startInventoryTagID(@IntRange(from = 0, to = 0xFF) int maxTags,
                                    @IntRange(from = 0, to = 0xFF) int maxTime,
                                    @IntRange(from = 0, to = 0xFFFF) int repeatCycle) {
        Log.d(logTag, "startInventoryTagID:" + maxTags + "  maxTime:" + maxTime + "  repeatCycle:" + repeatCycle);
        AsReaderSDK.getInstance().getRFIDManager().startInventoryTagID(maxTags, maxTime, repeatCycle);
    }

    public void startRFMDecode(@IntRange(from = 0, to = 0xFF) int codeType,
                               @IntRange(from = 0, to = 0xFF) int maxTags,
                               @IntRange(from = 0, to = 0xFF) int maxTime,
                               @IntRange(from = 0, to = 0xFFFF) int repeatCycle) {
        Log.d(logTag, "startRFMDecode:" + codeType + "  maxTags:" + maxTags + "  maxTime:" + maxTime + "  repeatCycle:" + repeatCycle);
        AsReaderSDK.getInstance().getRFIDManager().startRFMDecode(codeType, maxTags, maxTime, repeatCycle);
    }

    public void stopDecode() {
        Log.d(logTag, "stopDecode");
        AsReaderSDK.getInstance().getRFIDManager().stopDecode();
    }

    public void setRegion(@IntRange(from = 0, to = 0xFF) int region) {
        Log.d(logTag, "setRegion:" + region);
        AsReaderSDK.getInstance().getRFIDManager().setRegion(region);
    }

    public void getRegion() {
        Log.d(logTag, "getRegion");
        AsReaderSDK.getInstance().getRFIDManager().getRegion();
    }

    public void setSmartHopping(boolean isOn) {
        Log.d(logTag, "setSmartHopping:" + isOn);
        AsReaderSDK.getInstance().getRFIDManager().setSmartHopping(isOn);
    }

    public void getFrequencyHoppingMode() {
        Log.d(logTag, "getFrequencyHoppingMode");
        AsReaderSDK.getInstance().getRFIDManager().getFrequencyHoppingMode();
    }

    public void setOptimumFrequencyHoppingTable() {
        Log.d(logTag, "setOptimumFrequencyHoppingTable");
        AsReaderSDK.getInstance().getRFIDManager().setOptimumFrequencyHoppingTable();
    }

    public void getFrequencyHoppingTable() {
        Log.d(logTag, "getFrequencyHoppingTable");
        AsReaderSDK.getInstance().getRFIDManager().getFrequencyHoppingTable();
    }

    public void setChannel(@IntRange(from = 0, to = 0xFF) int num, @IntRange(from = 0, to = 0xFF) int offset) {
        Log.d(logTag, "setChannel:" + num + "  offset:" + offset);
        AsReaderSDK.getInstance().getRFIDManager().setChannel(num, offset);
    }

    public void getChannel() {
        Log.d(logTag, "getChannel");
        AsReaderSDK.getInstance().getRFIDManager().getChannel();
    }

    public void setSession(@IntRange(from = 0, to = 4) int session) {
        Log.d(logTag, "setSession:" + session);
        AsReaderSDK.getInstance().getRFIDManager().setSession(session);
    }

    public void getSession() {
        Log.d(logTag, "getSession");
        AsReaderSDK.getInstance().getRFIDManager().getSession();
    }

    public void setAntiCollisionMode(@IntRange(from = 0, to = 0xFF) int mode,
                                     @IntRange(from = 0, to = 0xFF) int start,
                                     @IntRange(from = 0, to = 0xFF) int max,
                                     @IntRange(from = 0, to = 0xFF) int min,
                                     @IntRange(from = 0, to = 0xFF) int counter) {
        Log.d(logTag, "setAntiCollisionMode:" + mode + "  start:" + start + "  max:" + max + "  min:" + min + "  counter:" + counter);
        AsReaderSDK.getInstance().getRFIDManager().setAntiCollisionMode(mode, start, max, min, counter);
    }

    public void getAntiCollisionMode() {
        Log.d(logTag, "getAntiCollisionMode");
        AsReaderSDK.getInstance().getRFIDManager().getAntiCollisionMode();
    }

    public void setFhLbtParam(@IntRange(from = 0, to = 0xFFFF) int readTime,
                              @IntRange(from = 0, to = 0xFFFF) int idleTime,
                              @IntRange(from = 0, to = 0xFFFF) int senseTime,
                              @IntRange(from = 0, to = 0xFFFF) int rfLevel,
                              @IntRange(from = 0, to = 0xFF) int fhMode,
                              @IntRange(from = 0, to = 0xFF) int lbtMode,
                              @IntRange(from = 0, to = 0xFF) int cwMode) {
        Log.d(logTag, "setFhLbtParam:" + readTime + "  idleTime:" + idleTime + "  senseTime:" + senseTime + "  rfLevel:" + rfLevel + "  fhMode:" + fhMode + "  lbtMode:" + lbtMode + "  cwMode:" + cwMode);
        AsReaderSDK.getInstance().getRFIDManager().setFhLbtParam(readTime, idleTime, senseTime, rfLevel, fhMode, lbtMode, cwMode);
    }

    public void getFhLbtParam() {
        Log.d(logTag, "getFhLbtParam");
        AsReaderSDK.getInstance().getRFIDManager().getFhLbtParam();
    }

    public void setOutputPowerLevel(@IntRange(from = 0, to = 250) int level) {
        Log.d(logTag, "setOutputPowerLevel:" + level);
        AsReaderSDK.getInstance().getRFIDManager().setOutputPowerLevel(level);
    }

    public void getOutputPowerLevel() {
        Log.d(logTag, "getOutputPowerLevel");
        AsReaderSDK.getInstance().getRFIDManager().getOutputPowerLevel();
    }

    public void setModulation(String mode) {
        Log.d(logTag, "setModulation:" + mode);
        AsReaderSDK.getInstance().getRFIDManager().setModulation(mode);
    }

    public void getModulation() {
        Log.d(logTag, "getModulation");
        AsReaderSDK.getInstance().getRFIDManager().getModulation();
    }

    public void setTriggerStopCondition(@IntRange(from = 0, to = 0xFF) int maxTags,
                                        @IntRange(from = 0, to = 0xFF) int maxTime,
                                        @IntRange(from = 0, to = 0xFFFF) int repeatCycle) {
        Log.d(logTag, "setTriggerStopCondition:" + maxTags + "  maxTime:" + maxTime + "  repeatCycle:" + repeatCycle);
        AsReaderSDK.getInstance().getRFIDManager().setTriggerStopCondition(maxTags, maxTime, repeatCycle);
    }

    public void readTagMemory(long password, String targetEPC, int memoryBank, int readType) {
        Log.d(logTag, "readTagMemory:" + password + "  targetEPC:" + targetEPC + "  memoryBank:" + memoryBank + "  readType:" + readType);
        RFIDConst.MemoryBank bank = getA3XDMemoryBank(memoryBank);
        RFIDConst.ReadMemoryType type = getA3XDReadMemoryType(readType);
        AsReaderSDK.getInstance().getRFIDManager().readTagMemory(password, targetEPC, bank, type);
    }

    public void readTagMemoryWithTimeout(long password, String targetEPC, int memoryBank, int readType, int timeout) {
        Log.d(logTag, "readTagMemoryWithTimeout:" + password + "  targetEPC:" + targetEPC + "  memoryBank:" + memoryBank + "  readType:" + readType + "  timeout:" + timeout);
        RFIDConst.MemoryBank bank = getA3XDMemoryBank(memoryBank);
        RFIDConst.ReadMemoryType type = getA3XDReadMemoryType(readType);
        AsReaderSDK.getInstance().getRFIDManager().readTagMemory(password, targetEPC, bank, type, timeout);
    }

    public void readTagMemoryWithData(long password, String targetEPC, int memoryBank, int readType,
                              @IntRange(from = 0, to = 255) int startAddress, @IntRange(from = 0, to = 32767) int dataLength, int timeout) {
        Log.d(logTag, "readTagMemoryWithData:" + password + "  targetEPC:" + targetEPC + "  memoryBank:" + memoryBank + "  readType:" + readType + "  startAddress:" + startAddress + "  dataLength:" + dataLength + "  timeout:" + timeout);
        RFIDConst.MemoryBank bank = getA3XDMemoryBank(memoryBank);
        RFIDConst.ReadMemoryType type = getA3XDReadMemoryType(readType);
        AsReaderSDK.getInstance().getRFIDManager().readTagMemory(password, targetEPC, bank, type, startAddress, dataLength, timeout);
    }

    public void writeTagMemory(long password, String targetEPC, int memoryBank, int writeType, byte[] writeData) {
        Log.d(logTag, "writeTagMemory:" + password + "  targetEPC:" + targetEPC + "  memoryBank:" + memoryBank + "  writeType:" + writeType + "  writeData:" + writeData);
        RFIDConst.MemoryBank bank = getA3XDMemoryBank(memoryBank);
        RFIDConst.WriteMemoryType type = getA3XDWriteMemoryType(writeType);
        AsReaderSDK.getInstance().getRFIDManager().writeTagMemory(password, targetEPC, bank, type, writeData);
    }

    public void writeTagMemoryWithTimeout(long password, String targetEPC, int memoryBank, int writeType, byte[] writeData, @IntRange(from = 0, to = 0xFFFF) int timeout) {
        Log.d(logTag, "writeTagMemoryWithTimeout:" + password + "  targetEPC:" + targetEPC + "  memoryBank:" + memoryBank + "  writeType:" + writeType + "  writeData:" + writeData + "  timeout:" + timeout);
        RFIDConst.MemoryBank bank = getA3XDMemoryBank(memoryBank);
        RFIDConst.WriteMemoryType type = getA3XDWriteMemoryType(writeType);
        AsReaderSDK.getInstance().getRFIDManager().writeTagMemory(password, targetEPC, bank, type, writeData, timeout);
    }

    public void writeTagMemoryWithData(long password, String targetEPC, int memoryBank, int writeType,
                               @IntRange(from = 0, to = 255) int startAddress, byte[] writeData,  int timeout) {
        Log.d(logTag, "writeTagMemoryWithData:" + password + "  targetEPC:" + targetEPC + "  memoryBank:" + memoryBank + "  writeType:" + writeType + "  startAddress:" + startAddress + "  writeData:" + writeData + "  timeout:" + timeout);
        RFIDConst.MemoryBank bank = getA3XDMemoryBank(memoryBank);
        RFIDConst.WriteMemoryType type = getA3XDWriteMemoryType(writeType);
        AsReaderSDK.getInstance().getRFIDManager().writeTagMemory(password, targetEPC, bank, type, startAddress, writeData, timeout);
    }

    public void killTag(long password, String targetEPC) {
        Log.d(logTag, "killTag:" + password + "  targetEPC:" + targetEPC);
        AsReaderSDK.getInstance().getRFIDManager().killTag(password, targetEPC);
    }

    public void lockTagMemory(long password, String targetEPC, @IntRange(from = 0, to = 0x0FFFFF) int lockData ) {
        Log.d(logTag, "lockTagMemory:" + password + "  targetEPC:" + targetEPC + "  lockData:" + lockData);
        AsReaderSDK.getInstance().getRFIDManager().lockTagMemory(password, targetEPC, lockData);
    }

    public void lockTagMemoryWithTimeout(long password, String targetEPC, @IntRange(from = 0, to = 0x0FFFFF) int lockData, @IntRange(from = -1, to = 255) int timeout) {
        Log.d(logTag, "lockTagMemoryWithTimeout:" + password + "  targetEPC:" + targetEPC + "  lockData:" + lockData + "  timeout:" + timeout);
        AsReaderSDK.getInstance().getRFIDManager().lockTagMemory(password, targetEPC, lockData, timeout);
    }

    public void updateRegistry() {
        Log.d(logTag, "updateRegistry");
        AsReaderSDK.getInstance().getRFIDManager().updateRegistry();
    }

    public void getContinuousMode(){
        Log.d(logTag, "getContinuousMode");
        AsReaderSDK.getInstance().getRFIDManager().getContinuousMode();
    }

    public void setContinuousMode(boolean isOn) {
        Log.d(logTag, "setContinuousMode:" + isOn);
        AsReaderSDK.getInstance().getRFIDManager().setContinuousMode(isOn);
    }

    public void getAutoOffTime(){
        Log.d(logTag, "getAutoOffTime");
        AsReaderSDK.getInstance().getRFIDManager().getAutoOffTime();
    }

    public void setAutoOffTime(@IntRange(from = 0, to = 1800)int time){
        Log.d(logTag, "setAutoOffTime:" + time);
        AsReaderSDK.getInstance().getRFIDManager().setAutoOffTime(time);
    }

    public void getSessionFlag(){
        Log.d(logTag, "getSessionFlag");
        AsReaderSDK.getInstance().getRFIDManager().getSessionFlag();
    }

    public void setSessionFlag(@IntRange(from = 0, to = 2)int sessionFlag){
        Log.d(logTag, "setSessionFlag:" + sessionFlag);
        AsReaderSDK.getInstance().getRFIDManager().setSessionFlag(sessionFlag);
    }

    public void getQValue(){
        Log.d(logTag, "getQValue");
        AsReaderSDK.getInstance().getRFIDManager().getQValue();
    }

    public void setQValue(@IntRange(from = 0, to = 15)int value){
        Log.d(logTag, "setQValue:" + value);
        AsReaderSDK.getInstance().getRFIDManager().setQValue(value);
    }

    public void getHidMode(){
        Log.d(logTag, "getHidMode");
        AsReaderSDK.getInstance().getRFIDManager().getHidMode();
    }

    public void setHidMode(boolean hidMode){
        Log.d(logTag, "setHidMode:" + hidMode);
        AsReaderSDK.getInstance().getRFIDManager().setHidMode(hidMode);
    }

    public void getDutyRatio(){
        Log.d(logTag, "getDutyRatio");
        AsReaderSDK.getInstance().getRFIDManager().getDutyRatio();
    }

    public void setDutyRatio(@IntRange(from = 0, to = 150)int dutyRatio){
        Log.d(logTag, "setDutyRatio:" + dutyRatio);
        AsReaderSDK.getInstance().getRFIDManager().setDutyRatio(dutyRatio);
    }

    public void getDutyRatioBaseTime(){
        Log.d(logTag, "getDutyRatioBaseTime");
        AsReaderSDK.getInstance().getRFIDManager().getDutyRatioBaseTime();
    }

    public void setDutyRatioBaseTime(@IntRange(from = 0, to = 65000)int dutyRatioBaseTime){
        Log.d(logTag, "setDutyRatioBaseTime:" + dutyRatioBaseTime);
        AsReaderSDK.getInstance().getRFIDManager().setDutyRatioBaseTime(dutyRatioBaseTime);
    }

    //DeviceManagerCallback
    @Override
    public void onConnect(boolean isConnect) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", isConnect);
                map.put("method", ON_CONNECT);
                currentChannel.invokeMethod(ON_CONNECT, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onConnect result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onConnect errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onConnect notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onBatteryStateReceived(final int dest, final int charging) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("dest", dest);
                map.put("charging", charging);
                map.put("method", ON_BATTERY_STATE_RECEIVED);
                currentChannel.invokeMethod(ON_BATTERY_STATE_RECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onBatteryStateReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onBatteryStateReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onBatteryStateReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReaderInfoReceived(int onTime, int offTime, int senseTime,
                                      int lbtLevel, int fhEnable, int lbtEnable,
                                      int cwEnable, int power, int minPower, int maxPower) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("onTime", onTime);
                map.put("offTime", offTime);
                map.put("senseTime", senseTime);
                map.put("lbtLevel", lbtLevel);
                map.put("fhEnable", fhEnable);
                map.put("lbtEnable", lbtEnable);
                map.put("cwEnable", cwEnable);
                map.put("power", power);
                map.put("minPower", minPower);
                map.put("maxPower", maxPower);
                map.put("method", ON_READER_INFO_RECEIVED);
                currentChannel.invokeMethod(ON_READER_INFO_RECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReaderInfoReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReaderInfoReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReaderInfoReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReaderAboutInfo(String model, String hwVersion, String fwVersion, byte region) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("model", model);
                map.put("hwVersion", hwVersion);
                map.put("fwVersion", fwVersion);
                map.put("region", region);
                map.put("method", ON_READER_ABOUT_INFO);
                currentChannel.invokeMethod(ON_READER_ABOUT_INFO, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReaderAboutInfo result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReaderAboutInfo errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReaderAboutInfo notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReceivedRFIDModuleVersion(final String versionInfo) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", versionInfo);
                map.put("method", ON_RECEIVED_RFID_MODULE_VERSION);
                currentChannel.invokeMethod(ON_RECEIVED_RFID_MODULE_VERSION, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReceivedRFIDModuleVersion result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReceivedRFIDModuleVersion errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReceivedRFIDModuleVersion notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onCompletedPreparation(boolean isPowerOn) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", isPowerOn);
                map.put("method", ON_COMPLETED_PREPARATION);
                currentChannel.invokeMethod(ON_COMPLETED_PREPARATION, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onCompletedPreparation result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onCompletedPreparation errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onCompletedPreparation notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onSetReaderSettingSuccess() {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("method", ON_SET_READER_SETTING_SUCCESS);
                currentChannel.invokeMethod(ON_SET_READER_SETTING_SUCCESS, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onSetReaderSettingSuccess result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onSetReaderSettingSuccess errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onSetReaderSettingSuccess notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onDeviceManagerError(String message) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", message);
                map.put("method", ON_DEVICE_MANAGER_ERROR);
                currentChannel.invokeMethod(ON_DEVICE_MANAGER_ERROR, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onDeviceManagerError result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onDeviceManagerError errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onDeviceManagerError notImplemented");
                    }
                });
            }
        });
    }


    //RFIDManagerCallback
    @Override
    public void didUpdateRegistry(final int state) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", state);
                map.put("method", DID_UPDATE_REGISTRY);
                currentChannel.invokeMethod(DID_UPDATE_REGISTRY, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "didUpdateRegistry result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "didUpdateRegistry errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "didUpdateRegistry notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onModulationReceived(String modulationMode) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", modulationMode);
                map.put("method", ON_MODULATION_RECEIVED);
                currentChannel.invokeMethod(ON_MODULATION_RECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onModulationReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onModulationReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onModulationReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void didSetModulation(final int state) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", state);
                map.put("method", DID_SET_MODULATION);
                currentChannel.invokeMethod(DID_SET_MODULATION, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "didSetModulation result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "didSetModulation errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "didSetModulation notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onTxPowerLevelReceived(int power, int minPower, int maxPower) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("power", power);
                map.put("minPower", minPower);
                map.put("maxPower", maxPower);
                map.put("method", ON_TX_POWER_LEVEL_RECEIVED);
                currentChannel.invokeMethod(ON_TX_POWER_LEVEL_RECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onTxPowerLevelReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onTxPowerLevelReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onTxPowerLevelReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onFhLbtReceived(int onTime, int offTime, int senseTime, int lbtLevel, int fhEnable, int lbtEnable, int cwEnable) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("onTime", onTime);
                map.put("offTime", offTime);
                map.put("senseTime", senseTime);
                map.put("lbtLevel", lbtLevel);
                map.put("fhEnable", fhEnable);
                map.put("lbtEnable", lbtEnable);
                map.put("cwEnable", cwEnable);
                map.put("method", ON_FH_LBT_RECEIVED);
                currentChannel.invokeMethod(ON_FH_LBT_RECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onFhLbtReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onFhLbtReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onFhLbtReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReceiveAntimode(final int mode, final int qStart, int qMax, int qMin, int counter) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("mode", mode);
                map.put("qStart", qStart);
                map.put("qMax", qMax);
                map.put("qMin", qMin);
                map.put("counter", counter);
                map.put("method", ON_RECEIVED_ANTIMODE);
                currentChannel.invokeMethod(ON_RECEIVED_ANTIMODE, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReceiveAntimode result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReceiveAntimode errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReceiveAntimode notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onSessionReceived(final int session) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", session);
                map.put("method", ON_SESSION_RECEIVED);
                currentChannel.invokeMethod(ON_SESSION_RECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onSessionReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onSessionReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onSessionReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onChannelReceived(final int channel, final int channelOffset) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("channel", channel);
                map.put("channelOffset", channelOffset);
                map.put("method", ON_CHANNEL_RECEIVED);
                currentChannel.invokeMethod(ON_CHANNEL_RECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onChannelReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onChannelReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onChannelReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onRegionReceived(final int region) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", region);
                map.put("method", ON_REGION_RECEIVED);
                currentChannel.invokeMethod(ON_REGION_RECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onRegionReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onRegionReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onRegionReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void didReceiveRegion(final int state) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", state);
                map.put("method", DID_RECEIVE_REGION);
                currentChannel.invokeMethod(DID_RECEIVE_REGION, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "didReceiveRegion result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "didReceiveRegion errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "didReceiveRegion notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReceiveSmartMode(final int mode) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", mode);
                map.put("method", ON_RECEIVE_SMART_MODE);
                currentChannel.invokeMethod(ON_RECEIVE_SMART_MODE, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReceiveSmartMode result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReceiveSmartMode errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReceiveSmartMode notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void didSetSmartMode(final int state) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", state);
                map.put("method", DID_SET_SMART_MODE);
                currentChannel.invokeMethod(DID_SET_SMART_MODE, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "didSetSmartMode result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "didSetSmartMode errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "didSetSmartMode notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void didSetOptiFreqHPTable(final int status) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", status);
                map.put("method", DID_SET_OPTI_FREQ_HP_TABLE);
                currentChannel.invokeMethod(DID_SET_OPTI_FREQ_HP_TABLE, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "didSetOptiFreqHPTable result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "didSetOptiFreqHPTable errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "didSetOptiFreqHPTable notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onTagReceived(final int[] dest) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                List<Integer> intList = new ArrayList<>();
                for (int value : dest) {
                    intList.add(value);
                }
                map.put("result", intList);
                map.put("method", ON_TAG_RECEIVED);
                currentChannel.invokeMethod(ON_TAG_RECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onTagReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onTagReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onTagReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onTagWithTidReceived(final int[] pcEpc, final int[] tid) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                List<Integer> intList = new ArrayList<>();
                for (int value : pcEpc) {
                    intList.add(value);
                }
                map.put("pcEpc", intList);
                List<Integer> tidList = new ArrayList<>();
                for (int value : tid) {
                    tidList.add(value);
                }
                map.put("tid", tidList);
                map.put("method", ON_TAG_WITH_TID_RECEIVED);
                currentChannel.invokeMethod(ON_TAG_WITH_TID_RECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onTagWithTidReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onTagWithTidReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onTagWithTidReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onTagWithRssiReceived(final int[] pcEpc, final int rssi) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                List<Integer> intList = new ArrayList<>();
                for (int value : pcEpc) {
                    intList.add(value);
                }
                map.put("pcEpc", intList);
                map.put("rssi", rssi);
                map.put("method", ON_TAG_WITH_RSSI_RECEIVED);
                currentChannel.invokeMethod(ON_TAG_WITH_RSSI_RECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onTagWithRssiReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onTagWithRssiReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onTagWithRssiReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onTagMemoryReceived(final int[] data) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                List<Integer> intList = new ArrayList<>();
                for (int value : data) {
                    intList.add(value);
                }
                map.put("result", intList);
                map.put("method", ON_TAG_MEMORY_RECEIVED);
                currentChannel.invokeMethod(ON_TAG_MEMORY_RECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onTagMemoryReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onTagMemoryReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onTagMemoryReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onTagMemoryLongReceived(final int[] dest) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                List<Integer> intList = new ArrayList<>();
                for (int value : dest) {
                    intList.add(value);
                }
                map.put("result", intList);
                map.put("method", ON_TAG_MEMORY_LONG_RECEIVED);
                currentChannel.invokeMethod(ON_TAG_MEMORY_LONG_RECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onTagMemoryLongReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onTagMemoryLongReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onTagMemoryLongReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onPcEpcSensorDataReceived(int[] pcEpc, int[] sensorData) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                List<Integer> intList = new ArrayList<>();
                for (int value : pcEpc) {
                    intList.add(value);
                }
                map.put("pcEpc", intList);
                List<Integer> dataList = new ArrayList<>();
                for (int value : sensorData) {
                    dataList.add(value);
                }
                map.put("sensorData", dataList);
                map.put("method", ON_PC_EPC_SENSOR_DATA_RECEIVED);
                currentChannel.invokeMethod(ON_PC_EPC_SENSOR_DATA_RECEIVED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onPcEpcSensorDataReceived result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onPcEpcSensorDataReceived errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onPcEpcSensorDataReceived notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onSetChannelSuccess() {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("method", ON_SET_CHANNEL_SUCCESS);
                currentChannel.invokeMethod(ON_SET_CHANNEL_SUCCESS, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onSetChannelSuccess result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onSetChannelSuccess errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onSetChannelSuccess notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onSetFhLbtParamSuccess() {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("method", ON_SET_FH_LBT_PARAM_SUCCESS);
                currentChannel.invokeMethod(ON_SET_FH_LBT_PARAM_SUCCESS, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onSetFhLbtParamSuccess result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onSetFhLbtParamSuccess errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onSetFhLbtParamSuccess notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onLockTagMemorySuccess() {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("method", ON_LOCK_TAG_MEMORY_SUCCESS);
                currentChannel.invokeMethod(ON_LOCK_TAG_MEMORY_SUCCESS, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onLockTagMemorySuccess result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onLockTagMemorySuccess errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onLockTagMemorySuccess notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onWriteToTagMemorySuccess() {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("method", ON_WRITE_TO_TAG_MEMORY_SUCCESS);
                currentChannel.invokeMethod(ON_WRITE_TO_TAG_MEMORY_SUCCESS, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onWriteToTagMemorySuccess result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onWriteToTagMemorySuccess errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onWriteToTagMemorySuccess notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onKillTagMemorySuccess() {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("method", ON_KILL_TAG_MEMORY_SUCCESS);
                currentChannel.invokeMethod(ON_KILL_TAG_MEMORY_SUCCESS, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onKillTagMemorySuccess result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onKillTagMemorySuccess errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onKillTagMemorySuccess notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onSetSessionSuccess() {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("method", ON_SET_SESSION_SUCCESS);
                currentChannel.invokeMethod(ON_SET_SESSION_SUCCESS, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onSetSessionSuccess result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onSetSessionSuccess errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onSetSessionSuccess notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onGetFrequencyHoppingTableSuccess(int[] data) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                List<Integer> intList = new ArrayList<>();
                for (int value : data) {
                    intList.add(value);
                }
                map.put("result", intList);
                map.put("method", ON_GET_FREQUENCY_HOPPING_TABLE_SUCCESS);
                currentChannel.invokeMethod(ON_GET_FREQUENCY_HOPPING_TABLE_SUCCESS, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onGetFrequencyHoppingTableSuccess result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onGetFrequencyHoppingTableSuccess errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onGetFrequencyHoppingTableSuccess notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onSetOutputPowerLevelSuccess() {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("method", ON_SET_OUTPUTPOWER_LEVEL_SUCCESS);
                currentChannel.invokeMethod(ON_SET_OUTPUTPOWER_LEVEL_SUCCESS, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onSetOutputPowerLevelSuccess result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onSetOutputPowerLevelSuccess errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onSetOutputPowerLevelSuccess notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onSetAntiCollisionModeSuccess() {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("method", ON_SET_ANTICOLLISION_MODE_SUCCESS);
                currentChannel.invokeMethod(ON_SET_ANTICOLLISION_MODE_SUCCESS, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onSetAntiCollisionModeSuccess result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onSetAntiCollisionModeSuccess errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onSetAntiCollisionModeSuccess notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onSetTriggerStopConditionSuccess() {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("method", ON_SET_TRIGGER_STOP_CONDITION_SUCCESS);
                currentChannel.invokeMethod(ON_SET_TRIGGER_STOP_CONDITION_SUCCESS, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onSetTriggerStopConditionSuccess result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onSetTriggerStopConditionSuccess errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onSetTriggerStopConditionSuccess notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onAutoInventoryFinished() {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("method", ON_AUTO_INVENTORY_FINISHED);
                currentChannel.invokeMethod(ON_AUTO_INVENTORY_FINISHED, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onAutoInventoryFinished result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onAutoInventoryFinished errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onAutoInventoryFinished notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onRFIDManagerError(String message) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", message);
                map.put("method", ON_RFID_MANAGER_ERROR);
                currentChannel.invokeMethod(ON_RFID_MANAGER_ERROR, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onRFIDManagerError result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onRFIDManagerError errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onRFIDManagerError notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void didSetContinuousMode(int status) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", status);
                map.put("method", DID_SET_CONTINUOUS_MODE);
                currentChannel.invokeMethod(DID_SET_CONTINUOUS_MODE, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "didSetContinuousMode result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "didSetContinuousMode errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "didSetContinuousMode notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReceiveContinuousMode(boolean status) {
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", status);
                map.put("method", ON_RECEIVE_CONTINUOUS_MODE);
                currentChannel.invokeMethod(ON_RECEIVE_CONTINUOUS_MODE, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReceiveContinuousMode result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReceiveContinuousMode errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReceiveContinuousMode notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReceiveQValue(int value){
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", value);
                map.put("method", ON_RECEIVE_Q_VALUE);
                currentChannel.invokeMethod(ON_RECEIVE_Q_VALUE, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReceiveQValue result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReceiveQValue errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReceiveQValue notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void didSetQValue(int status){
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", status);
                map.put("method", DID_SET_Q_VALUE);
                currentChannel.invokeMethod(DID_SET_Q_VALUE, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "didSetQValue result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "didSetQValue errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "didSetQValue notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReceiveSessionFlag(int value){
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", value);
                map.put("method", ON_RECEIVE_SESSION_FLAG);
                currentChannel.invokeMethod(ON_RECEIVE_SESSION_FLAG, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReceiveSessionFlag result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReceiveSessionFlag errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReceiveSessionFlag notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void didSetSessionFlag(int status){
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", status);
                map.put("method", DID_SET_SESSION_FLAG);
                currentChannel.invokeMethod(DID_SET_SESSION_FLAG, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "didSetSessionFlag result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "didSetSessionFlag errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "didSetSessionFlag notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReceiveHidMode(boolean value){
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", value);
                map.put("method", ON_RECEIVE_HID_MODE);
                currentChannel.invokeMethod(ON_RECEIVE_HID_MODE, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReceiveHidMode result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReceiveHidMode errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReceiveHidMode notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void didSetHidMode(int status){
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", status);
                map.put("method", DID_SET_HID_MODE);
                currentChannel.invokeMethod(DID_SET_HID_MODE, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "didSetHidMode result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "didSetHidMode errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "didSetHidMode notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReceiveDutyRatio(int value){
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", value);
                map.put("method", ON_RECEIVE_DUTY_RATIO);
                currentChannel.invokeMethod(ON_RECEIVE_DUTY_RATIO, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReceiveDutyRatio result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReceiveDutyRatio errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReceiveDutyRatio notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void didSetDutyRatio(int status){
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", status);
                map.put("method", DID_SET_DUTY_RATIO);
                currentChannel.invokeMethod(DID_SET_DUTY_RATIO, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "didSetDutyRatio result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "didSetDutyRatio errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "didSetDutyRatio notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReceiveDutyRatioBaseTime(int value){
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", value);
                map.put("method", ON_RECEIVE_DUTY_RATIO_BASE_TIME);
                currentChannel.invokeMethod(ON_RECEIVE_DUTY_RATIO_BASE_TIME, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReceiveDutyRatioBaseTime result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReceiveDutyRatioBaseTime errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReceiveDutyRatioBaseTime notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void didSetDutyRatioBaseTime(int status){
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", status);
                map.put("method", DID_SET_DUTY_RATIO_BASE_TIME);
                currentChannel.invokeMethod(DID_SET_DUTY_RATIO_BASE_TIME, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "didSetDutyRatioBaseTime result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "didSetDutyRatioBaseTime errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "didSetDutyRatioBaseTime notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void onReceiveAutoOffTime(int time){
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", time);
                map.put("method", ON_RECEIVE_AUTO_OFF_TIME);
                currentChannel.invokeMethod(ON_RECEIVE_AUTO_OFF_TIME, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "onReceiveAutoOffTime result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "onReceiveAutoOffTime errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "onReceiveAutoOffTime notImplemented");
                    }
                });
            }
        });
    }

    @Override
    public void didSetAutoOffTime(int status){
        mainHandler.post(new Runnable() {
            @Override
            public void run() {
                Map<String, Object> map = new HashMap<>();
                map.put("result", status);
                map.put("method", DID_SET_AUTO_OFF_TIME);
                currentChannel.invokeMethod(DID_SET_AUTO_OFF_TIME, map, new MethodChannel.Result() {
                    @Override
                    public void success(@Nullable Object result) {
                        Log.d(logTag, "didSetAutoOffTime result:" + result);
                    }

                    @Override
                    public void error(@NonNull String errorCode, @Nullable String errorMessage, @Nullable Object errorDetails) {
                        Log.d(logTag, "didSetAutoOffTime errorCode:" + errorCode + " errorMessage" + errorMessage);
                    }

                    @Override
                    public void notImplemented() {
                        Log.d(logTag, "didSetAutoOffTime notImplemented");
                    }
                });
            }
        });
    }

    private LogLevel getA3XDLogLevel(int logLevel) {
        if (logLevel == 0) {
            return LogLevel.Fatal;
        } else if (logLevel == 1) {
            return LogLevel.Error;
        } else if (logLevel == 2) {
            return LogLevel.Warning;
        } else if (logLevel == 3) {
            return LogLevel.Information;
        } else if (logLevel == 4) {
            return LogLevel.Debug;
        }
        return LogLevel.Fatal;
    }

    private int getA3XDLogLevel(LogLevel logLevel) {
        if (logLevel == LogLevel.Fatal) {
            return 0;
        } else if (logLevel == LogLevel.Error) {
            return 1;
        } else if (logLevel == LogLevel.Warning) {
            return 2;
        } else if (logLevel == LogLevel.Information) {
            return 3;
        } else if (logLevel == LogLevel.Debug) {
            return 4;
        }
        return 0;
    }

    private RFIDConst.MemoryBank getA3XDMemoryBank(int memoryBank) {
        if (memoryBank == 0) {
            return RFIDConst.MemoryBank.RESERVED;
        } else if (memoryBank == 1) {
            return RFIDConst.MemoryBank.EPC;
        } else if (memoryBank == 2) {
            return RFIDConst.MemoryBank.TID;
        } else if (memoryBank == 3) {
            return RFIDConst.MemoryBank.USER;
        } else if (memoryBank == 4) {
            return RFIDConst.MemoryBank.NONE;
        }
        return RFIDConst.MemoryBank.RESERVED;
    }

    private RFIDConst.ReadMemoryType getA3XDReadMemoryType(int readType) {
        if (readType == 0) {
            return RFIDConst.ReadMemoryType.NORMAL;
        } else if (readType == 1) {
            return RFIDConst.ReadMemoryType.LONG_DATA;
        }
        return RFIDConst.ReadMemoryType.NORMAL;
    }

    private RFIDConst.WriteMemoryType getA3XDWriteMemoryType(int writeType) {
        if (writeType == 0) {
            return RFIDConst.WriteMemoryType.NORMAL;
        } else if (writeType == 1) {
            return RFIDConst.WriteMemoryType.BLOCK;
        }
        return RFIDConst.WriteMemoryType.NORMAL;
    }
}

