import 'dart:typed_data';

import 'package:a3xd_plugin/a3xd_define.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:a3xd_plugin/a3xd_plugin.dart';
import 'package:a3xd_plugin/a3xd_plugin_platform_interface.dart';
import 'package:a3xd_plugin/a3xd_plugin_method_channel.dart';
import 'package:plugin_platform_interface/plugin_platform_interface.dart';

class MockA3xdPluginPlatform
    with MockPlatformInterfaceMixin
    implements A3xdPluginPlatform {

  @override
  Future<String?> getPlatformVersion() => Future.value('42');

  @override
  Future<String?> getA3XDFlutterVersion() {
    // TODO: implement getA3XDFlutterVersion
    throw UnimplementedError();
  }

  @override
  Future<String?> getA3XDSDKVersion() {
    // TODO: implement getA3XDSDKVersion
    throw UnimplementedError();
  }

  @override
  Future<void> getAntiCollisionMode() {
    // TODO: implement getAntiCollisionMode
    throw UnimplementedError();
  }

  @override
  Future<void> getAutoOffTime() {
    // TODO: implement getAutoOffTime
    throw UnimplementedError();
  }

  @override
  Future<void> getBattery() {
    // TODO: implement getBattery
    throw UnimplementedError();
  }

  @override
  Future<void> getChannel() {
    // TODO: implement getChannel
    throw UnimplementedError();
  }

  @override
  Future<void> getContinuousMode() {
    // TODO: implement getContinuousMode
    throw UnimplementedError();
  }

  @override
  Future<void> getDutyRatio() {
    // TODO: implement getDutyRatio
    throw UnimplementedError();
  }

  @override
  Future<void> getDutyRatioBaseTime() {
    // TODO: implement getDutyRatioBaseTime
    throw UnimplementedError();
  }

  @override
  Future<void> getFhLbtParam() {
    // TODO: implement getFhLbtParam
    throw UnimplementedError();
  }

  @override
  Future<void> getFrequencyHoppingMode() {
    // TODO: implement getFrequencyHoppingMode
    throw UnimplementedError();
  }

  @override
  Future<void> getFrequencyHoppingTable() {
    // TODO: implement getFrequencyHoppingTable
    throw UnimplementedError();
  }

  @override
  Future<void> getHidMode() {
    // TODO: implement getHidMode
    throw UnimplementedError();
  }

  @override
  Future<A3XDLogLevel?> getLogLevel() {
    // TODO: implement getLogLevel
    throw UnimplementedError();
  }

  @override
  Future<int?> getMaxTagValue() {
    // TODO: implement getMaxTagValue
    throw UnimplementedError();
  }

  @override
  Future<int?> getMaxTimeValue() {
    // TODO: implement getMaxTimeValue
    throw UnimplementedError();
  }

  @override
  Future<void> getModulation() {
    // TODO: implement getModulation
    throw UnimplementedError();
  }

  @override
  Future<void> getOutputPowerLevel() {
    // TODO: implement getOutputPowerLevel
    throw UnimplementedError();
  }

  @override
  Future<void> getQValue() {
    // TODO: implement getQValue
    throw UnimplementedError();
  }

  @override
  Future<bool?> getRSSIEnable() {
    // TODO: implement getRSSIEnable
    throw UnimplementedError();
  }

  @override
  Future<void> getReaderInfo(int type) {
    // TODO: implement getReaderInfo
    throw UnimplementedError();
  }

  @override
  Future<void> getRegion() {
    // TODO: implement getRegion
    throw UnimplementedError();
  }

  @override
  Future<int?> getRepeatCycleValue() {
    // TODO: implement getRepeatCycleValue
    throw UnimplementedError();
  }

  @override
  Future<void> getSession() {
    // TODO: implement getSession
    throw UnimplementedError();
  }

  @override
  Future<void> getSessionFlag() {
    // TODO: implement getSessionFlag
    throw UnimplementedError();
  }

  @override
  Future<bool?> isConnected() {
    // TODO: implement isConnected
    throw UnimplementedError();
  }

  @override
  Future<bool?> isM30SDevice() {
    // TODO: implement isM30SDevice
    throw UnimplementedError();
  }

  @override
  Future<bool?> isOpen() {
    // TODO: implement isOpen
    throw UnimplementedError();
  }

  @override
  Future<bool?> isPowerOn() {
    // TODO: implement isPowerOn
    throw UnimplementedError();
  }

  @override
  Future<void> killTag(int password, String targetEPC) {
    // TODO: implement killTag
    throw UnimplementedError();
  }

  @override
  Future<void> lockTagMemory(int password, String targetEPC, int lockData) {
    // TODO: implement lockTagMemory
    throw UnimplementedError();
  }

  @override
  Future<void> lockTagMemoryWithTimeout(int password, String targetEPC, int lockData, int timeout) {
    // TODO: implement lockTagMemoryWithTimeout
    throw UnimplementedError();
  }

  @override
  Future<void> readTagMemory(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDReadMemoryType readType) {
    // TODO: implement readTagMemory
    throw UnimplementedError();
  }

  @override
  Future<void> readTagMemoryWithData(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDReadMemoryType readType, int startAddress, int dataLength, int timeout) {
    // TODO: implement readTagMemoryWithData
    throw UnimplementedError();
  }

  @override
  Future<void> readTagMemoryWithTimeout(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDReadMemoryType readType, int timeout) {
    // TODO: implement readTagMemoryWithTimeout
    throw UnimplementedError();
  }

  @override
  Future<void> removeSDKLog() {
    // TODO: implement removeSDKLog
    throw UnimplementedError();
  }

  @override
  Future<void> setAntiCollisionMode(int mode, int start, int max, int min, int counter) {
    // TODO: implement setAntiCollisionMode
    throw UnimplementedError();
  }

  @override
  Future<void> setAutoOffTime(int time) {
    // TODO: implement setAutoOffTime
    throw UnimplementedError();
  }

  @override
  Future<void> setChannel(int num, int offset) {
    // TODO: implement setChannel
    throw UnimplementedError();
  }

  @override
  Future<void> setContinuousMode(bool isOn) {
    // TODO: implement setContinuousMode
    throw UnimplementedError();
  }

  @override
  Future<void> setDutyRatio(int dutyRatio) {
    // TODO: implement setDutyRatio
    throw UnimplementedError();
  }

  @override
  Future<void> setDutyRatioBaseTime(int dutyRatioBaseTime) {
    // TODO: implement setDutyRatioBaseTime
    throw UnimplementedError();
  }

  @override
  Future<void> setFhLbtParam(int readTime, int idleTime, int senseTime, int rfLevel, int fhMode, int lbtMode, int cwMode) {
    // TODO: implement setFhLbtParam
    throw UnimplementedError();
  }

  @override
  Future<void> setHidMode(bool hidMode) {
    // TODO: implement setHidMode
    throw UnimplementedError();
  }

  @override
  Future<void> setLog(bool enable) {
    // TODO: implement setLog
    throw UnimplementedError();
  }

  @override
  Future<void> setLogLevel(A3XDLogLevel level) {
    // TODO: implement setLogLevel
    throw UnimplementedError();
  }

  @override
  Future<void> setMaxTagValue(int value) {
    // TODO: implement setMaxTagValue
    throw UnimplementedError();
  }

  @override
  Future<void> setMaxTimeValue(int value) {
    // TODO: implement setMaxTimeValue
    throw UnimplementedError();
  }

  @override
  Future<void> setModulation(String mode) {
    // TODO: implement setModulation
    throw UnimplementedError();
  }

  @override
  Future<void> setOptimumFrequencyHoppingTable() {
    // TODO: implement setOptimumFrequencyHoppingTable
    throw UnimplementedError();
  }

  @override
  Future<void> setOutputPowerLevel(int level) {
    // TODO: implement setOutputPowerLevel
    throw UnimplementedError();
  }

  @override
  Future<void> setPower(bool enable) {
    // TODO: implement setPower
    throw UnimplementedError();
  }

  @override
  Future<void> setPowerWithOption(bool power, bool beep, bool vib, bool led, bool aimer, bool powerOnBeep) {
    // TODO: implement setPowerWithOption
    throw UnimplementedError();
  }

  @override
  Future<void> setQValue(int value) {
    // TODO: implement setQValue
    throw UnimplementedError();
  }

  @override
  Future<void> setRSSIEnable(bool enable) {
    // TODO: implement setRSSIEnable
    throw UnimplementedError();
  }

  @override
  Future<void> setReaderSettings(bool beep, bool vib, bool led, bool aimer) {
    // TODO: implement setReaderSettings
    throw UnimplementedError();
  }

  @override
  Future<void> setRegion(int region) {
    // TODO: implement setRegion
    throw UnimplementedError();
  }

  @override
  Future<void> setRepeatCycleValue(int value) {
    // TODO: implement setRepeatCycleValue
    throw UnimplementedError();
  }

  @override
  Future<void> setSession(int session) {
    // TODO: implement setSession
    throw UnimplementedError();
  }

  @override
  Future<void> setSessionFlag(int sessionFlag) {
    // TODO: implement setSessionFlag
    throw UnimplementedError();
  }

  @override
  Future<void> setSmartHopping(bool isOn) {
    // TODO: implement setSmartHopping
    throw UnimplementedError();
  }

  @override
  Future<void> setTriggerStopCondition(int maxTags, int maxTime, int repeatCycle) {
    // TODO: implement setTriggerStopCondition
    throw UnimplementedError();
  }

  @override
  Future<void> startInventory(int maxTags, int maxTime, int repeatCycle) {
    // TODO: implement startInventory
    throw UnimplementedError();
  }

  @override
  Future<void> startInventoryRSSI(int maxTags, int maxTime, int repeatCycle) {
    // TODO: implement startInventoryRSSI
    throw UnimplementedError();
  }

  @override
  Future<void> startInventoryTagID(int maxTags, int maxTime, int repeatCycle) {
    // TODO: implement startInventoryTagID
    throw UnimplementedError();
  }

  @override
  Future<void> startRFMDecode(int codeType, int maxTags, int maxTime, int repeatCycle) {
    // TODO: implement startRFMDecode
    throw UnimplementedError();
  }

  @override
  Future<void> stopDecode() {
    // TODO: implement stopDecode
    throw UnimplementedError();
  }

  @override
  Future<void> updateRegistry() {
    // TODO: implement updateRegistry
    throw UnimplementedError();
  }

  @override
  Future<void> writeTagMemory(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDWriteMemoryType writeType, Uint8List writeData) {
    // TODO: implement writeTagMemory
    throw UnimplementedError();
  }

  @override
  Future<void> writeTagMemoryWithData(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDWriteMemoryType writeType, int startAddress, Uint8List writeData, int timeout) {
    // TODO: implement writeTagMemoryWithData
    throw UnimplementedError();
  }

  @override
  Future<void> writeTagMemoryWithTimeout(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDWriteMemoryType writeType, Uint8List writeData, int timeout) {
    // TODO: implement writeTagMemoryWithTimeout
    throw UnimplementedError();
  }

}

void main() {
  final A3xdPluginPlatform initialPlatform = A3xdPluginPlatform.instance;

  test('$MethodChannelA3xdPlugin is the default instance', () {
    expect(initialPlatform, isInstanceOf<MethodChannelA3xdPlugin>());
  });

  test('getPlatformVersion', () async {
    A3xdPlugin a3xdPlugin = A3xdPlugin();
    MockA3xdPluginPlatform fakePlatform = MockA3xdPluginPlatform();
    A3xdPluginPlatform.instance = fakePlatform;

    expect(await a3xdPlugin.getPlatformVersion(), '42');
  });
}