/*
 * Decompiled with CFR 0.152.
 */
package jp.co.asterisk.asreader.a3xd.sdk.manager;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import jp.co.asterisk.asreader.a3xd.sdk.AsReaderSDK;
import jp.co.asterisk.asreader.a3xd.sdk.ErrorMessage;
import jp.co.asterisk.asreader.a3xd.sdk.PacketParser;
import jp.co.asterisk.asreader.a3xd.sdk.SharedPreferencesHelper;
import jp.co.asterisk.asreader.a3xd.sdk.common.Convert;
import jp.co.asterisk.asreader.a3xd.sdk.manager.DeviceCommandFactory;
import jp.co.asterisk.asreader.a3xd.sdk.manager.DeviceCommandType;
import jp.co.asterisk.asreader.a3xd.sdk.manager.DeviceManagerCallback;
import jp.co.asterisk.asreader.a3xd.sdk.manager.RFIDManager;
import jp.co.asterisk.asreader.a3xd.sdk.manager.USBManager;
import jp.co.asterisk.asreader.a3xd.sdk.manager.communication.CommunicationManager;
import jp.co.asterisk.asreader.a3xd.sdk.manager.communication.CommunicationManagerDeviceCallback;
import jp.co.asterisk.asreader.a3xd.sdk.utility.LogLevel;
import jp.co.asterisk.asreader.a3xd.sdk.utility.PacketModel;
import jp.co.asterisk.asreader.a3xd.sdk.utility.SDKLog;

public class DeviceManager
implements CommunicationManagerDeviceCallback {
    private static DeviceManager instance = null;
    private final String TAG = DeviceManager.class.getSimpleName();
    private final String ERROR_MSG_FAILED_TO_SEND_PACKET = "Failed to send packet.";
    private final String VID = "10c4";
    public final String VIDM30S = "339c";
    private DeviceManagerCallback callback;
    private Context mContext = null;
    private boolean isConnected;
    private boolean isPowerOn;
    private MyActivityLifecycleCallbacks activityLifecycleCallback;
    BroadcastReceiver usbReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            UsbDevice usbDevice = (UsbDevice)intent.getParcelableExtra("device");
            int parsedVID = Integer.parseInt("10c4", 16);
            int parsedVIDM30S = Integer.parseInt("339c", 16);
            if (usbDevice.getVendorId() != parsedVID && usbDevice.getVendorId() != parsedVIDM30S) {
                return;
            }
            String action = intent.getAction();
            if ("com.asreader.sdevice.action.USB_PERMISSION".equals(action)) {
                if (intent.getBooleanExtra("permission", false)) {
                    USBManager.getInstance().isPermissionRequested(true);
                    DeviceManager.this.openUSBDevice();
                } else {
                    USBManager.getInstance().isPermissionRequested(false);
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                if (DeviceManager.this.getAppProcessStatus(DeviceManager.this.mContext) == ActivityStatus.FOREGROUND) {
                    DeviceManager.this.openUSBDevice();
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && DeviceManager.this.getAppProcessStatus(DeviceManager.this.mContext) == ActivityStatus.FOREGROUND) {
                DeviceManager.this.closeUSBDevice();
            }
        }
    };

    private DeviceManager() {
    }

    public static DeviceManager getInstance() {
        if (instance == null) {
            instance = new DeviceManager();
        }
        return instance;
    }

    public void setCallback(DeviceManagerCallback callback) {
        this.callback = callback;
        PacketParser.getInstance().setDeviceManagerCallback(callback);
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isPowerOn() {
        return this.isPowerOn;
    }

    public boolean isOpen() {
        return CommunicationManager.getInstance().isOpen();
    }

    private ActivityStatus getAppProcessStatus(Context context) {
        if (this.isForeground(context)) {
            return ActivityStatus.FOREGROUND;
        }
        return ActivityStatus.BACKGROUND;
    }

    private boolean isForeground(Context context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List appList = manager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo processInfo : appList) {
            for (String activeProcess : processInfo.pkgList) {
                if (processInfo.importance != 100) continue;
                return true;
            }
        }
        return false;
    }

    private void openUSBDevice() {
        if (!CommunicationManager.getInstance().isOpen()) {
            CommunicationManager.getInstance().open();
            this.isConnected = CommunicationManager.getInstance().isOpen();
            if (this.isConnected && this.callback != null) {
                this.callback.onConnect(true);
            }
        } else {
            this.isConnected = true;
        }
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "DeviceManager openUsbDevice connect = " + this.isConnected);
    }

    private void closeUSBDevice() {
        if (CommunicationManager.getInstance().isOpen()) {
            CommunicationManager.getInstance().close();
            this.isConnected = CommunicationManager.getInstance().isOpen();
            if (!this.isConnected && this.callback != null) {
                this.callback.onConnect(false);
            }
        } else {
            this.isConnected = false;
        }
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "DeviceManager closeUsbDevice connect = " + this.isConnected);
    }

    private void sendPacket(PacketModel packetModel) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "DeviceManager sendPacket");
        boolean result = CommunicationManager.getInstance().sendPacket(packetModel);
        if (!result) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "DeviceManager Failed to send packet.");
            this.callback.onDeviceManagerError("Failed to send packet.");
        }
    }

    private void sendData(byte[] buffer) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Debug, "DeviceManager sendData");
        boolean result = CommunicationManager.getInstance().sendData(buffer);
        if (!result) {
            SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "DeviceManager Failed to send packet.");
            this.callback.onDeviceManagerError("Failed to send packet.");
        }
    }

    public void initialize(Context context) {
        IntentFilter filter = new IntentFilter("com.asreader.sdevice.action.USB_PERMISSION");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        if (Build.VERSION.SDK_INT >= 34) {
            context.registerReceiver(this.usbReceiver, filter, 4);
        } else {
            context.registerReceiver(this.usbReceiver, filter);
        }
        if (context != null) {
            this.mContext = context;
        }
        if (context.getApplicationContext() instanceof Application) {
            this.activityLifecycleCallback = new MyActivityLifecycleCallbacks();
            ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityLifecycleCallback);
        }
        CommunicationManager.getInstance().setDeviceCallBack(this);
    }

    public void setPower(boolean power) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "DeviceManager setPower: power=" + power);
        if (USBManager.getInstance().isM30SDevice()) {
            if (!power) {
                RFIDManager.getInstance().stopDecode();
            }
            new Thread(() -> {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.callback.onCompletedPreparation(power);
            }).start();
            return;
        }
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceCommandType.POWER);
        packetModel.addPayloadData(power ? (byte)-1 : 0);
        this.sendPacket(packetModel);
    }

    public void setPowerWithOption(boolean power, boolean beep, boolean vib, boolean led, boolean aimer, boolean PowerOnBeep) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "DeviceManager setPowerWithOption: power=" + power + " beep=" + beep + " vib=" + vib + "led=" + led + " aimer=" + aimer + " PowerOnBeep=" + PowerOnBeep);
        if (USBManager.getInstance().isM30SDevice()) {
            if (!power) {
                RFIDManager.getInstance().stopDecode();
            }
            new Thread(() -> {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.callback.onCompletedPreparation(power);
            }).start();
            return;
        }
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceCommandType.POWER);
        packetModel.addPayloadData(power ? (byte)-1 : 0);
        packetModel.addPayloadData(beep ? (byte)-1 : 0);
        packetModel.addPayloadData(vib ? (byte)-1 : 0);
        packetModel.addPayloadData(led ? (byte)-1 : 0);
        packetModel.addPayloadData(aimer ? (byte)-1 : 0);
        packetModel.addPayloadData(PowerOnBeep ? (byte)-1 : 0);
        packetModel.addPayloadData((byte)0);
        this.sendPacket(packetModel);
    }

    public void setReaderSettings(boolean beep, boolean vib, boolean led, boolean aimer) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "DeviceManager setReaderSettings: beep=" + beep + " vib=" + vib + "led=" + led + " aimer=" + aimer);
        if (USBManager.getInstance().isM30SDevice()) {
            byte[] byArray;
            DeviceCommandFactory deviceCommandFactory = DeviceCommandFactory.getInstance();
            if (beep) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 50;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 48;
            }
            byte[] sendData = deviceCommandFactory.sendPacket((byte)119, (byte)98, byArray);
            boolean result = USBManager.getInstance().sendData(sendData);
            if (!result) {
                SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                this.callback.onDeviceManagerError("Failed to send packet.");
            }
            return;
        }
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceCommandType.READER_SETTING);
        packetModel.addPayloadData(beep ? (byte)-1 : 0);
        packetModel.addPayloadData(vib ? (byte)-1 : 0);
        packetModel.addPayloadData(led ? (byte)-1 : 0);
        packetModel.addPayloadData(aimer ? (byte)-1 : 0);
        this.sendPacket(packetModel);
    }

    public void getBattery() {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "DeviceManager getBattery");
        if (USBManager.getInstance().isM30SDevice()) {
            this.callback.onBatteryStateReceived(200, 1);
            return;
        }
        PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceCommandType.BATTERY);
        packetModel.addPayloadData((byte)-35);
        this.sendPacket(packetModel);
    }

    public void getReaderInfo(@IntRange(from=0L, to=255L) int type) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "DeviceManager getReaderInfo");
        if (type < 0 || type > 255) {
            return;
        }
        if (USBManager.getInstance().isM30SDevice()) {
            if (type == 177 || type == 178) {
                byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)118, null);
                boolean result = USBManager.getInstance().sendData(sendData);
                if (!result) {
                    SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                    this.callback.onDeviceManagerError("Failed to send packet.");
                }
                sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)72, null);
                boolean resultt = USBManager.getInstance().sendData(sendData);
                if (!resultt) {
                    SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                    this.callback.onDeviceManagerError("Failed to send packet.");
                }
                sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)103, null);
                boolean resulttt = USBManager.getInstance().sendData(sendData);
                if (!resulttt) {
                    SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                    this.callback.onDeviceManagerError("Failed to send packet.");
                }
            } else if (type == 1) {
                byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)86, null);
                boolean result = USBManager.getInstance().sendData(sendData);
                if (!result) {
                    SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                    this.callback.onDeviceManagerError("Failed to send packet.");
                }
            } else if (type == 176) {
                byte[] sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)97, null);
                boolean result = USBManager.getInstance().sendData(sendData);
                if (!result) {
                    SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                    this.callback.onDeviceManagerError("Failed to send packet.");
                }
                sendData = DeviceCommandFactory.getInstance().sendPacket((byte)114, (byte)112, null);
                boolean resultt = USBManager.getInstance().sendData(sendData);
                if (!resultt) {
                    SDKLog.getInstance().Log(this.TAG, LogLevel.Error, "RFIDManager Failed to send packet.");
                    this.callback.onDeviceManagerError("Failed to send packet.");
                }
            }
        } else {
            PacketModel packetModel = DeviceCommandFactory.getInstance().create(DeviceCommandType.READER_INFO);
            packetModel.addPayloadData((byte)type);
            this.sendPacket(packetModel);
        }
    }

    @Override
    public void onReceivedData(PacketModel packetModel) {
        SDKLog.getInstance().Log(this.TAG, LogLevel.Information, "onReceivedData");
        ArrayList<Byte> payload = packetModel.getPayload();
        int[] data = new int[payload.size()];
        for (int i = 0; i < payload.size(); ++i) {
            data[i] = payload.get(i) & 0xFF;
        }
        switch (packetModel.getCommand()) {
            case -35: {
                int battery;
                if (this.callback == null) break;
                int adc = data[0];
                int adcMin = data[1];
                int adcMax = data[2];
                int charging = 16;
                if (data.length > 2) {
                    charging = data[3] & 0xFF;
                }
                if (adcMin == adcMax) {
                    ++adcMax;
                }
                if ((battery = (adc - adcMin) * 100 / (adcMax - adcMin)) > 100) {
                    battery = 100;
                } else if (battery < 0) {
                    battery = 0;
                }
                this.callback.onBatteryStateReceived(battery, charging);
                break;
            }
            case 3: {
                char[] tempChar = new char[data.length];
                for (int i = 0; i < data.length; ++i) {
                    tempChar[i] = (char)(data[i] & 0xFF);
                }
                String strVersion = new String(tempChar, 0, tempChar.length);
                if (data.length > 14 && (data[0] & 0xFF) == 176) {
                    String temp = Convert.toStringHEX(data);
                    int on_time = data[3] * 256 + data[4];
                    int off_time = data[5] * 256 + data[6];
                    int sense_time = Integer.parseInt(temp.substring(14, 18), 16);
                    int lbt_level = Integer.parseInt(temp.substring(18, 22), 16);
                    int fh_enable = Integer.parseInt(temp.substring(22, 24), 16);
                    int lbt_enable = Integer.parseInt(temp.substring(24, 26), 16);
                    int cw_enable = Integer.parseInt(temp.substring(26, 28), 16);
                    int powerLevel = data[14] * 256 + data[15];
                    int tx_minpower = data[16] * 256 + data[17];
                    int tx_maxpower = data[18] * 256 + data[19];
                    this.callback.onReaderInfoReceived(on_time, off_time, sense_time, lbt_level, fh_enable, lbt_enable, cw_enable, powerLevel, tx_minpower, tx_maxpower);
                    break;
                }
                if (data.length > 30 && (data[0] & 0xFF) == 177) {
                    StringBuilder sbModel = new StringBuilder();
                    for (int i = 3; i < 13; ++i) {
                        sbModel.append((char)data[i]);
                    }
                    StringBuilder sbHW = new StringBuilder();
                    for (int i = 13; i < 23; ++i) {
                        sbHW.append((char)data[i]);
                    }
                    StringBuilder sbFW = new StringBuilder();
                    for (int i = 23; i < 33; ++i) {
                        sbFW.append((char)data[i]);
                    }
                    this.callback.onReaderAboutInfo(sbModel.toString(), sbHW.toString(), sbFW.toString(), (byte)data[1]);
                    break;
                }
                if (data.length > 30 && (data[0] & 0xFF) == 178) {
                    StringBuilder info = new StringBuilder();
                    for (int i = 0; i < data.length; ++i) {
                        info.append((char)data[i]);
                    }
                    String[] splitData = info.toString().split(",");
                    Log.d((String)this.TAG, (String)("B2 \uc694\uccad\uc5d0 \ub300\ud55c \ub370\uc774\ud130 : model > " + splitData[0].substring(1) + " h/w > " + splitData[1] + " f/w > " + splitData[2]));
                    this.callback.onReaderAboutInfo(splitData[0].substring(1), splitData[1], splitData[2], (byte)data[1]);
                    break;
                }
                this.callback.onReceivedRFIDModuleVersion(strVersion);
                break;
            }
            case 1: {
                if (data[0] == 255) {
                    this.isPowerOn = true;
                    Log.i((String)"Power On/OFF", (String)"Power on");
                } else if (data[0] == 0) {
                    this.isPowerOn = false;
                    Log.i((String)"Power On/OFF", (String)"Power off");
                }
                this.callback.onCompletedPreparation(this.isPowerOn);
                break;
            }
            case -30: {
                if (this.isPowerOn) {
                    int maxTag = SharedPreferencesHelper.getInstance().getMaxTag();
                    int maxTime = SharedPreferencesHelper.getInstance().getMaxTime();
                    int repeatCycle = SharedPreferencesHelper.getInstance().getRepeatCycle();
                    boolean rssi = SharedPreferencesHelper.getInstance().getRssi();
                    if (data[0] == 255) {
                        if (rssi) {
                            AsReaderSDK.getInstance().getRFIDManager().startInventoryRSSI(maxTag, maxTime, repeatCycle);
                            break;
                        }
                        AsReaderSDK.getInstance().getRFIDManager().startInventory(maxTag, maxTime, repeatCycle);
                        break;
                    }
                    if (data[0] != 0) break;
                    AsReaderSDK.getInstance().getRFIDManager().stopDecode();
                    break;
                }
                Log.i((String)"Power On/OFF", (String)("Power OFF Trigger event RETURN, isPowerOn:" + this.isPowerOn));
                return;
            }
            case -85: {
                this.callback.onSetReaderSettingSuccess();
                break;
            }
            case -1: {
                String message = ErrorMessage.errorMsgType(data[2]);
                this.callback.onDeviceManagerError(message);
            }
        }
    }

    public boolean isM30SDevice() {
        return USBManager.getInstance().isM30SDevice();
    }

    private static enum ActivityStatus {
        FOREGROUND,
        BACKGROUND,
        GONE;

    }

    private class MyActivityLifecycleCallbacks
    implements Application.ActivityLifecycleCallbacks {
        private MyActivityLifecycleCallbacks() {
        }

        public void onActivityStarted(@NonNull Activity activity) {
            DeviceManager.this.openUSBDevice();
            SDKLog.getInstance().open();
        }

        public void onActivityStopped(@NonNull Activity activity) {
            SDKLog.getInstance().Log(DeviceManager.this.TAG, LogLevel.Information, "ActivityStatus = " + (Object)((Object)DeviceManager.this.getAppProcessStatus(DeviceManager.this.mContext)));
            if (DeviceManager.this.getAppProcessStatus(DeviceManager.this.mContext) == ActivityStatus.BACKGROUND) {
                if (CommunicationManager.getInstance().isOpen()) {
                    DeviceManager.this.setPowerWithOption(false, false, false, false, false, false);
                    DeviceManager.this.closeUSBDevice();
                }
                SDKLog.getInstance().close();
            }
        }

        public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        }

        public void onActivityResumed(@NonNull Activity activity) {
        }

        public void onActivityPaused(@NonNull Activity activity) {
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
        }
    }
}

