
import 'a3xd_plugin_platform_interface.dart';
import 'package:a3xd_plugin/a3xd_define.dart';
import 'package:flutter/foundation.dart';

class A3xdPlugin {
  String ON_CONNECT = "onConnect";
  String ON_BATTERY_STATE_RECEIVED = "onBatteryStateReceived";
  String ON_READER_INFO_RECEIVED = "onReaderInfoReceived";
  String ON_READER_ABOUT_INFO = "onReaderAboutInfo";
  String ON_RECEIVED_RFID_MODULE_VERSION = "onReceivedRFIDModuleVersion";
  String ON_COMPLETED_PREPARATION = "onCompletedPreparation";
  String ON_SET_READER_SETTING_SUCCESS = "onSetReaderSettingSuccess";
  String ON_DEVICE_MANAGER_ERROR = "onDeviceManagerError";
  String DID_UPDATE_REGISTRY = "didUpdateRegistry";
  String ON_MODULATION_RECEIVED = "onModulationReceived";
  String DID_SET_MODULATION = "didSetModulation";
  String ON_TX_POWER_LEVEL_RECEIVED = "onTxPowerLevelReceived";
  String ON_FH_LBT_RECEIVED = "onFhLbtReceived";
  String ON_RECEIVED_ANTIMODE = "onReceiveAntimode";
  String ON_SESSION_RECEIVED = "onSessionReceived";
  String ON_CHANNEL_RECEIVED = "onChannelReceived";
  String ON_REGION_RECEIVED = "onRegionReceived";
  String DID_RECEIVE_REGION = "didReceiveRegion";
  String ON_RECEIVE_SMART_MODE = "onReceiveSmartMode";
  String DID_SET_SMART_MODE = "didSetSmartMode";
  String DID_SET_OPTI_FREQ_HP_TABLE = "didSetOptiFreqHPTable";
  String ON_TAG_RECEIVED = "onTagReceived";
  String ON_TAG_WITH_TID_RECEIVED = "onTagWithTidReceived";
  String ON_TAG_WITH_RSSI_RECEIVED = "onTagWithRssiReceived";
  String ON_TAG_MEMORY_RECEIVED = "onTagMemoryReceived";
  String ON_TAG_MEMORY_LONG_RECEIVED = "onTagMemoryLongReceived";
  String ON_PC_EPC_SENSOR_DATA_RECEIVED = "onPcEpcSensorDataReceived";
  String ON_SET_CHANNEL_SUCCESS = "onSetChannelSuccess";
  String ON_SET_FH_LBT_PARAM_SUCCESS = "onSetFhLbtParamSuccess";
  String ON_LOCK_TAG_MEMORY_SUCCESS = "onLockTagMemorySuccess";
  String ON_WRITE_TO_TAG_MEMORY_SUCCESS = "onWriteToTagMemorySuccess";
  String ON_KILL_TAG_MEMORY_SUCCESS = "onKillTagMemorySuccess";
  String ON_SET_SESSION_SUCCESS = "onSetSessionSuccess";
  String ON_GET_FREQUENCY_HOPPING_TABLE_SUCCESS = "onGetFrequencyHoppingTableSuccess";
  String ON_SET_OUTPUTPOWER_LEVEL_SUCCESS = "onSetOutputPowerLevelSuccess";
  String ON_SET_ANTICOLLISION_MODE_SUCCESS = "onSetAntiCollisionModeSuccess";
  String ON_SET_TRIGGER_STOP_CONDITION_SUCCESS = "onSetTriggerStopConditionSuccess";
  String ON_AUTO_INVENTORY_FINISHED = "onAutoInventoryFinished";
  String ON_RFID_MANAGER_ERROR = "onRFIDManagerError";
  String DID_SET_CONTINUOUS_MODE = "didSetContinuousMode";
  String ON_RECEIVE_CONTINUOUS_MODE = "onReceiveContinuousMode";
  String ON_RECEIVE_Q_VALUE = "onReceiveQValue";
  String DID_SET_Q_VALUE = "didSetQValue";
  String ON_RECEIVE_SESSION_FLAG = "onReceiveSessionFlag";
  String DID_SET_SESSION_FLAG = "didSetSessionFlag";
  String ON_RECEIVE_HID_MODE = "onReceiveHidMode";
  String DID_SET_HID_MODE = "didSetHidMode";
  String ON_RECEIVE_DUTY_RATIO = "onReceiveDutyRatio";
  String DID_SET_DUTY_RATIO = "didSetDutyRatio";
  String ON_RECEIVE_DUTY_RATIO_BASE_TIME = "onReceiveDutyRatioBaseTime";
  String DID_SET_DUTY_RATIO_BASE_TIME = "didSetDutyRatioBaseTime";
  String ON_RECEIVE_AUTO_OFF_TIME = "onReceiveAutoOffTime";
  String DID_SET_AUTO_OFF_TIME = "didSetAutoOffTime";

  Future<String?> getPlatformVersion() {
    return A3xdPluginPlatform.instance.getPlatformVersion();
  }

  Future<String?> getA3XDFlutterVersion() {
    return A3xdPluginPlatform.instance.getA3XDFlutterVersion();
  }

  Future<String?> getA3XDSDKVersion() {
    return A3xdPluginPlatform.instance.getA3XDSDKVersion();
  }

  Future<void> setLogLevel(A3XDLogLevel level) {
    return A3xdPluginPlatform.instance.setLogLevel(level);
  }

  Future<A3XDLogLevel?> getLogLevel() {
    return A3xdPluginPlatform.instance.getLogLevel();
  }

  Future<void> setLog(bool enable) {
    return A3xdPluginPlatform.instance.setLog(enable);
  }

  Future<void> removeSDKLog() {
    return A3xdPluginPlatform.instance.removeSDKLog();
  }

  Future<bool?> isConnected() {
    return A3xdPluginPlatform.instance.isConnected();
  }

  Future<bool?> isPowerOn() {
    return A3xdPluginPlatform.instance.isPowerOn();
  }

  Future<bool?> isOpen() {
    return A3xdPluginPlatform.instance.isOpen();
  }

  Future<void> setPower(bool enable) {
    return A3xdPluginPlatform.instance.setPower(enable);
  }

  Future<void> setPowerWithOption(bool power, bool beep, bool vib, bool led, bool aimer, bool powerOnBeep) {
    return A3xdPluginPlatform.instance.setPowerWithOption(power, beep, vib, led, aimer, powerOnBeep);
  }

  Future<void> setReaderSettings(bool beep, bool vib, bool led, bool aimer) {
    return A3xdPluginPlatform.instance.setReaderSettings(beep, vib, led, aimer);
  }

  Future<void> getBattery() {
    return A3xdPluginPlatform.instance.getBattery();
  }

  Future<void> getReaderInfo(int type) {
    return A3xdPluginPlatform.instance.getReaderInfo(type);
  }

  Future<bool?> isM30SDevice() {
    return A3xdPluginPlatform.instance.isM30SDevice();
  }

  Future<void> setMaxTagValue(int value) {
    return A3xdPluginPlatform.instance.setMaxTagValue(value);
  }

  Future<int?> getMaxTagValue() {
    return A3xdPluginPlatform.instance.getMaxTagValue();
  }

  Future<void> setMaxTimeValue(int value) {
    return A3xdPluginPlatform.instance.setMaxTimeValue(value);
  }

  Future<int?> getMaxTimeValue() {
    return A3xdPluginPlatform.instance.getMaxTimeValue();
  }

  Future<void> setRepeatCycleValue(int value) {
    return A3xdPluginPlatform.instance.setRepeatCycleValue(value);
  }

  Future<int?> getRepeatCycleValue() {
    return A3xdPluginPlatform.instance.getRepeatCycleValue();
  }

  Future<void> setRSSIEnable(bool enable) {
    return A3xdPluginPlatform.instance.setRSSIEnable(enable);
  }

  Future<bool?> getRSSIEnable() {
    return A3xdPluginPlatform.instance.getRSSIEnable();
  }

  Future<void> startInventory(int maxTags, int maxTime, int repeatCycle) {
    return A3xdPluginPlatform.instance.startInventory(maxTags, maxTime, repeatCycle);
  }

  Future<void> startInventoryRSSI(int maxTags, int maxTime, int repeatCycle) {
    return A3xdPluginPlatform.instance.startInventoryRSSI(maxTags, maxTime, repeatCycle);
  }

  Future<void> startInventoryTagID(int maxTags, int maxTime, int repeatCycle)  {
    return A3xdPluginPlatform.instance.startInventoryTagID(maxTags, maxTime, repeatCycle);
  }

  Future<void> startRFMDecode(int codeType, int maxTags, int maxTime, int repeatCycle) {
    return A3xdPluginPlatform.instance.startRFMDecode(codeType, maxTags, maxTime, repeatCycle);
  }

  Future<void> stopDecode() {
    return A3xdPluginPlatform.instance.stopDecode();
  }

  Future<void> setRegion(int region) {
    return A3xdPluginPlatform.instance.setRegion(region);
  }

  Future<void> getRegion() {
    return A3xdPluginPlatform.instance.getRegion();
  }

  Future<void> setSmartHopping(bool isOn) {
    return A3xdPluginPlatform.instance.setSmartHopping(isOn);
  }

  Future<void> getFrequencyHoppingMode() {
    return A3xdPluginPlatform.instance.getFrequencyHoppingMode();
  }

  Future<void> setOptimumFrequencyHoppingTable() {
    return A3xdPluginPlatform.instance.setOptimumFrequencyHoppingTable();
  }

  Future<void> getFrequencyHoppingTable() {
    return A3xdPluginPlatform.instance.getFrequencyHoppingTable();
  }

  Future<void> setChannel(int num, int offset) {
    return A3xdPluginPlatform.instance.setChannel(num, offset);
  }

  Future<void> getChannel() {
    return A3xdPluginPlatform.instance.getChannel();
  }

  Future<void> setSession(int session) {
    return A3xdPluginPlatform.instance.setSession(session);
  }

  Future<void> getSession() {
    return A3xdPluginPlatform.instance.getSession();
  }

  Future<void> setAntiCollisionMode(int mode, int start, int max, int min, int counter) {
    return A3xdPluginPlatform.instance.setAntiCollisionMode(mode, start, max, min, counter);
  }

  Future<void> getAntiCollisionMode() {
    return A3xdPluginPlatform.instance.getAntiCollisionMode();
  }

  Future<void> setFhLbtParam(int readTime, int idleTime, int senseTime, int rfLevel, int fhMode, int lbtMode, int cwMode) {
    return A3xdPluginPlatform.instance.setFhLbtParam(readTime, idleTime, senseTime, rfLevel, fhMode, lbtMode, cwMode);
  }

  Future<void> getFhLbtParam() {
    return A3xdPluginPlatform.instance.getFhLbtParam();
  }

  Future<void> setOutputPowerLevel(int level) {
    return A3xdPluginPlatform.instance.setOutputPowerLevel(level);
  }

  Future<void> getOutputPowerLevel() {
    return A3xdPluginPlatform.instance.getOutputPowerLevel();
  }

  Future<void> setModulation(String mode)  {
    return A3xdPluginPlatform.instance.setModulation(mode);
  }

  Future<void> getModulation() {
    return A3xdPluginPlatform.instance.getModulation();
  }

  Future<void> setTriggerStopCondition(int maxTags, int maxTime, int repeatCycle) {
    return A3xdPluginPlatform.instance.setTriggerStopCondition(maxTags, maxTime, repeatCycle);
  }

  Future<void> readTagMemory(int password, String targetEPC,
        A3XDMemoryBank memoryBank, A3XDReadMemoryType readType) {
    return A3xdPluginPlatform.instance.readTagMemory(password, targetEPC, memoryBank, readType);
  }

  Future<void> readTagMemoryWithTimeout(int password, String targetEPC,
        A3XDMemoryBank memoryBank, A3XDReadMemoryType readType,
        int timeout) {
    return A3xdPluginPlatform.instance.readTagMemoryWithTimeout(password, targetEPC, memoryBank, readType, timeout);
  }

  Future<void> readTagMemoryWithData(int password, String targetEPC,
        A3XDMemoryBank memoryBank, A3XDReadMemoryType readType, int startAddress,
        int dataLength, int timeout) {
    return A3xdPluginPlatform.instance.readTagMemoryWithData(password, targetEPC, memoryBank, readType, startAddress, dataLength, timeout);
  }

  Future<void> writeTagMemory(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDWriteMemoryType writeType, Uint8List writeData) {
    return A3xdPluginPlatform.instance.writeTagMemory(password, targetEPC, memoryBank, writeType, writeData);
  }

  Future<void> writeTagMemoryWithTimeout(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDWriteMemoryType writeType, Uint8List writeData, int timeout) {
    return A3xdPluginPlatform.instance.writeTagMemoryWithTimeout(password, targetEPC, memoryBank, writeType, writeData, timeout);
  }

  Future<void> writeTagMemoryWithData(int password, String targetEPC, A3XDMemoryBank memoryBank, A3XDWriteMemoryType writeType, int startAddress, Uint8List writeData, int timeout) {
    return A3xdPluginPlatform.instance.writeTagMemoryWithData(password, targetEPC, memoryBank, writeType, startAddress, writeData, timeout);
  }

  Future<void> killTag(int password, String targetEPC) {
    return A3xdPluginPlatform.instance.killTag(password, targetEPC);
  }

  Future<void> lockTagMemory(int password, String targetEPC, int lockData) {
    return A3xdPluginPlatform.instance.lockTagMemory(password, targetEPC, lockData);
  }

  Future<void> lockTagMemoryWithTimeout(int password, String targetEPC, int lockData, int timeout) {
    return A3xdPluginPlatform.instance.lockTagMemoryWithTimeout(password, targetEPC, lockData, timeout);
  }

  Future<void> updateRegistry() {
    return A3xdPluginPlatform.instance.updateRegistry();
  }

  Future<void> getContinuousMode() {
    return A3xdPluginPlatform.instance.getContinuousMode();
  }

  Future<void> setContinuousMode(bool isOn) {
    return A3xdPluginPlatform.instance.setContinuousMode(isOn);
  }

  Future<void> getAutoOffTime() {
    return A3xdPluginPlatform.instance.getAutoOffTime();
  }

  Future<void> setAutoOffTime(int time) {
    return A3xdPluginPlatform.instance.setAutoOffTime(time);
  }

  Future<void> getSessionFlag() {
    return A3xdPluginPlatform.instance.getSessionFlag();
  }

  Future<void> setSessionFlag(int sessionFlag) {
    return A3xdPluginPlatform.instance.setSessionFlag(sessionFlag);
  }

  Future<void> getQValue() {
    return A3xdPluginPlatform.instance.getQValue();
  }

  Future<void> setQValue(int value) {
    return A3xdPluginPlatform.instance.setQValue(value);
  }

  Future<void> getHidMode() {
    return A3xdPluginPlatform.instance.getHidMode();
  }

  Future<void> setHidMode(bool hidMode) {
    return A3xdPluginPlatform.instance.setHidMode(hidMode);
  }

  Future<void> getDutyRatio() {
    return A3xdPluginPlatform.instance.getDutyRatio();
  }

  Future<void> setDutyRatio(int dutyRatio) {
    return A3xdPluginPlatform.instance.setDutyRatio(dutyRatio);
  }

  Future<void> getDutyRatioBaseTime() {
    return A3xdPluginPlatform.instance.getDutyRatioBaseTime();
  }

  Future<void> setDutyRatioBaseTime(int dutyRatioBaseTime) {
    return A3xdPluginPlatform.instance.setDutyRatioBaseTime(dutyRatioBaseTime);
  }
}
