import 'dart:async';
import 'package:a3xd_plugin_example/setting.dart';
import 'package:a3xd_plugin_example/information.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:a3xd_plugin/a3xd_plugin.dart';
import 'event_bus_instance.dart';

class MoreWidget extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => MoreState();
}

class MoreState extends State<MoreWidget> {
  final _a3xdPlugin = A3xdPlugin();
  static const iosCallPlatform = MethodChannel('a3xd_plugin');

  @override
  void initState() {
    super.initState();
    initPlatformState();
  }
  Future<void> initPlatformState() async {
    Future<dynamic> _handler(MethodCall methodCall) {
      print('more methodCall.method:${methodCall.method}, methodCall.arguments:${methodCall.arguments}');
      if (_a3xdPlugin.ON_CONNECT == methodCall.method) {
        bool isConnected = methodCall.arguments['result'];
        print('onConnect:$isConnected');
        connected(isConnected);
      }
      return Future.value('success');
    }
    iosCallPlatform.setMethodCallHandler(_handler);
  }
  @override
  Widget build(BuildContext context) {
    var upContainer = Container(
      margin: const EdgeInsets.fromLTRB(0, 20, 0, 0),
      alignment: Alignment.center,
      child: ElevatedButton(
          style: ButtonStyle(
            backgroundColor: MaterialStateProperty.all(const Color(0xFFFFFFFF)),
          ),
          onPressed: () async {
            await Navigator.push(
                context, MaterialPageRoute(builder: (context) => SettingWidget()));
            initPlatformState();
          },
          child: const Text('            Setting            ')),
    );
    var upContainer1 = Container(
      margin: const EdgeInsets.fromLTRB(0, 20, 0, 0),
      alignment: Alignment.center,
      child: ElevatedButton(
          style: ButtonStyle(
            backgroundColor: MaterialStateProperty.all(const Color(0xFFFFFFFF)),
          ),
          onPressed: () async {
            await Navigator.push(
                context, MaterialPageRoute(builder: (context) => InformationWidget()));
            initPlatformState();
          },
          child: const Text('         Information         ')),
    );
    return Scaffold(
      appBar: AppBar(
        title: const Text('More'),
        backgroundColor: Colors.white,
        leading: IconButton(
          icon: Image.asset(
            'images/back.png',
            width: 25,
            height: 25,
            fit: BoxFit.cover,
          ),
          onPressed: () {
            Navigator.pop(context);
          },
        ),
      ),
      body: Container(
        color: Colors.white,
        child: Column(
          children: <Widget>[
            upContainer,
            upContainer1,
          ],
        ),
      ),
    );
  }
  void connected(bool isConnected) {
    setState(() {
      if (!isConnected) {
        eventBus.fire(DisconnectEvent());
        Navigator.pop(context);
      }
    });
  }
}
