﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Resources;
using System.Reflection;
using System.Net;
using System.Threading;
using System.Diagnostics;
using UHF;
using System.IO;
using System.Net.Sockets;
using System.IO.Ports;
namespace AsReaderDemo
{
    public partial class Form1 : Form
    {
        private Dictionary<string, int> dicResult = new Dictionary<string, int>();
        private int selectedDeviceNo = 0;
        private bool device1_conned = false;
        private bool device2_conned = false;
        private byte fComAdr = 0xff; //当前操作的ComAdr
        private int ferrorcode;
        private byte fBaud;
        private double fdminfre;
        private double fdmaxfre;
        private int fCmdRet = 30; //所有执行指令的返回值
        private bool fIsInventoryScan;
        private bool fisinventoryscan_6B;
        private byte[] fOperEPC = new byte[100];
        private byte[] fPassWord = new byte[4];
        private byte[] fOperID_6B = new byte[10];
        ArrayList list = new ArrayList();
        private int CardNum1 = 0;
        private string fInventory_EPC_List; //存贮询查列表（如果读取的数据没有变化，则不进行刷新）
        private int frmcomportindex;
        private bool SeriaATflag = false;
        private byte Target = 0;
        private byte InAnt = 0;
        private byte Scantime = 0;
        private byte FastFlag = 0;
        private byte Qvalue = 0;
        private byte Session = 0;
        private int total_turns = 0;//轮数
        private int total_tagnum = 0;//标签数量
        private int total_time = 0;//总时间
        private int targettimes = 0;
        private int CommunicationTime = 0;
        private byte TIDFlag = 0;
        public static byte antinfo = 0;
        private int AA_times = 0;
        private string conn_type = "";
        IntPtr[] DeviceHandle = new IntPtr[30];
        int DeviceNum = -1;
        ArrayList fres_ch = new ArrayList();
        ArrayList fres_us = new ArrayList();
        ArrayList fres_korea = new ArrayList();
        ArrayList fres_eu = new ArrayList();
        ArrayList fres_jp = new ArrayList();
        bool isSelectedTag = false;
        public Form1()
        {
            InitializeComponent();
            //initForms();
        }
        private void ClearFresList() {
            fres_ch.Clear();
            fres_us.Clear();
            fres_korea.Clear();
            fres_eu.Clear();
            fres_jp.Clear();
        }

        //private void initForms()
        //{
        //string[] vcpPort = SerialPort.GetPortNames();
        //int i = 0;
        ////this.ComboBox_COM.Items.Clear();
        ////有限判断是否开通端口模式
        //if (vcpPort.Length > 0)
        //{
        //    for (i = 0; i < vcpPort.Length; i++)
        //    {
        //        this.ComboBox_COM.Items.Add(vcpPort[i]);
        //    }
        //    if (i > 0)
        //        this.ComboBox_COM.SelectedIndex = 0;
        //}
        //}

        private delegate void WriteLogUnSafe(CustomControl.LogRichTextBox logRichTxt, string strLog, int nType);
        private void WriteLog(CustomControl.LogRichTextBox logRichTxt, string strLog, int nType)
        {
            if (this.InvokeRequired)
            {
                WriteLogUnSafe InvokeWriteLog = new WriteLogUnSafe(WriteLog);
                this.Invoke(InvokeWriteLog, new object[] { logRichTxt, strLog, nType });
            }
            else
            {
                if (nType == 0)
                {
                    logRichTxt.AppendTextEx(strLog, Color.Indigo);
                }
                else
                {
                    logRichTxt.AppendTextEx(strLog, Color.Red);
                }

                logRichTxt.Select(logRichTxt.TextLength, 0);
                logRichTxt.ScrollToCaret();
            }
        }
        /// <summary>
        /// 16进制数组字符串转换
        /// </summary>
        /// <param name="s"></param>
        /// <returns></returns>
        #region 
        private byte[] HexStringToByteArray(string s)
        {
            s = s.Replace(" ", "");
            byte[] buffer = new byte[s.Length / 2];
            for (int i = 0; i < s.Length; i += 2)
                buffer[i / 2] = (byte)Convert.ToByte(s.Substring(i, 2), 16);
            return buffer;
        }

        private string ByteArrayToHexString(byte[] data)
        {
            StringBuilder sb = new StringBuilder(data.Length * 3);
            foreach (byte b in data)
                sb.Append(Convert.ToString(b, 16).PadLeft(2, '0'));
            return sb.ToString().ToUpper();

        }
        #endregion
        /// <summary>
        /// 错误代码
        /// </summary>
        /// <param name="cmdRet"></param>
        /// <returns></returns>
        #region 
        private string GetReturnCodeDesc(int cmdRet)
        {
            switch (cmdRet)
            {
                case 0x00:
                    return "successfully";
                case 0x01:
                    return "Return before Inventory finished";
                case 0x02:
                    return "the Inventory-scan-time overflow";
                case 0x03:
                    return "More Data";
                case 0x04:
                    return "Reader module MCU is Full";
                case 0x05:
                    return "Access Password Error";
                case 0x09:
                    return "Destroy Password Error";
                case 0x0a:
                    return "Destroy Password Error Cannot be Zero";
                case 0x0b:
                    return "Tag Not Support the command";
                case 0x0c:
                    return "Use the commmand,Access Password Cannot be Zero";
                case 0x0d:
                    return "Tag is protected,cannot set it again";
                case 0x0e:
                    return "Tag is unprotected,no need to reset it";
                case 0x10:
                    return "There is some locked bytes,write fail";
                case 0x11:
                    return "can not lock it";
                case 0x12:
                    return "is locked,cannot lock it again";
                case 0x13:
                    return "Parameter Save Fail,Can Use Before Power";
                case 0x14:
                    return "Cannot adjust";
                case 0x15:
                    return "Return before Inventory finished";
                case 0x16:
                    return "Inventory-Scan-Time overflow";
                case 0x17:
                    return "More Data";
                case 0x18:
                    return "Reader module MCU is full";
                case 0x19:
                    return "Not Support Command Or AccessPassword Cannot be Zero";
                case 0x1A:
                    return "Perform error tag custom function";
                case 0xF8:
                    return "Antenna connection detect errors";
                case 0xF9:
                    return "Command execution error";
                case 0xFA:
                    return "Get Tag,Poor Communication,Inoperable";
                case 0xFB:
                    return "No Tag Operable";
                case 0xFC:
                    return "Tag Return ErrorCode";
                case 0xFD:
                    return "Command length wrong";
                case 0xFE:
                    return "Illegal command";
                case 0xFF:
                    return "Parameter Error";
                case 0x30:
                    return "Communication error";
                case 0x31:
                    return "CRC checksummat error";
                case 0x32:
                    return "Return data length error";
                case 0x33:
                    return "Communication busy";
                case 0x34:
                    return "Busy,command is being executed";
                case 0x35:
                    return "ComPort Opened";
                case 0x36:
                    return "ComPort Closed";
                case 0x37:
                    return "Invalid Handle";
                case 0x38:
                    return "Invalid Port";
                case 0xEE:
                    return "Return Command Error";
                default:
                    return "";
            }
        }
        private string GetErrorCodeDesc(int cmdRet)
        {
            switch (cmdRet)
            {
                case 0x00:
                    return "Other error";
                case 0x03:
                    return "Memory out or pc not support";
                case 0x04:
                    return "Memory Locked and unwritable";
                case 0x0b:
                    return "No Power,memory write operation cannot be executed";
                case 0x0f:
                    return "Not Special Error,tag not support special errorcode";
                default:
                    return "";
            }
        }
        #endregion
        private void DisabledForm()
        {
            ////应答模式下

            if (device2_conned == false) {

                lxLedControl1.Text = "0";
                lxLedControl2.Text = "0";
                lxLedControl3.Text = "0";
                lxLedControl4.Text = "0";
                lxLedControl5.Text = "0";
                dataGridView1.Rows.Clear();
                dataGridView2.Rows.Clear();
                comboBox_EPC.Items.Clear();
                btIventoryG2.Text = "Start";
                timer_answer.Enabled = false;
                panel1.Enabled = false;
                panel3.Enabled = false;
                panel4.Enabled = false;
                panel5.Enabled = false;
            }
            text_RDVersion.Text = "";
            text_Serial.Text = "";
            gpb_address.Enabled = false;
            gpb_baud.Enabled = false;
            gpb_GPIO.Enabled = false;
            gpb_beep.Enabled = false;
            gpb_RDVersion.Enabled = false;
            gpb_DBM.Enabled = false;
            gpb_Serial.Enabled = false;
            gpb_Freq.Enabled = false;
            btDefault.Enabled = false;
            btGetInformation.Enabled = false;
            gbp_buff.Enabled = false;
            button1.Enabled = false;
            button2.Enabled = false;
            button3.Enabled = false;
        }
        private void DisabledForm2()
        {
            ////应答模式下
            if (device1_conned == false) {

                lxLedControl1.Text = "0";
                lxLedControl2.Text = "0";
                lxLedControl3.Text = "0";
                lxLedControl4.Text = "0";
                lxLedControl5.Text = "0";
                dataGridView1.Rows.Clear();
                dataGridView2.Rows.Clear();
                comboBox_EPC.Items.Clear();
                btIventoryG2.Text = "Start";
                timer_answer.Enabled = false;
                panel1.Enabled = false;
                panel3.Enabled = false;
                panel4.Enabled = false;
                panel5.Enabled = false;

            }
            text_RDVersion_2.Text = "";
            text_Serial_2.Text = "";
            gpb_address_2.Enabled = false;
            gpb_baud_2.Enabled = false;
            gpb_GPIO_2.Enabled = false;
            gpb_beep_2.Enabled = false;
            gpb_RDVersion_2.Enabled = false;
            gpb_DBM_2.Enabled = false;
            gpb_Serial_2.Enabled = false;
            gpb_Freq_2.Enabled = false;
            btDefault_2.Enabled = false;
            btGetInformation_2.Enabled = false;
            gbp_buff_2.Enabled = false;
            btnSetWkParam_2.Enabled = false;
            btnGetWkParam_2.Enabled = false;
            btnSetBeep.Enabled = false;
        }
        private void EnabledForm()
        {
            panel1.Enabled = true;
            panel3.Enabled = true;
            panel4.Enabled = true;
            panel5.Enabled = true;
            gpb_address.Enabled = true;
            gpb_baud.Enabled = true;
            gpb_GPIO.Enabled = true;
            gpb_beep.Enabled = true;
            gpb_RDVersion.Enabled = true;
            gpb_DBM.Enabled = true;
            gpb_Serial.Enabled = true;
            gpb_Freq.Enabled = true;
            btDefault.Enabled = true;
            btGetInformation.Enabled = true;
            gbp_buff.Enabled = true;
            button1.Enabled = true;
            button2.Enabled = true;
            button3.Enabled = true;
        }
        private void EnabledForm2()
        {
            panel1.Enabled = true;
            panel3.Enabled = true;
            panel4.Enabled = true;
            panel5.Enabled = true;
            gpb_address_2.Enabled = true;
            gpb_baud_2.Enabled = true;
            gpb_GPIO_2.Enabled = true;
            gpb_beep_2.Enabled = true;
            gpb_RDVersion_2.Enabled = true;
            gpb_DBM_2.Enabled = true;
            gpb_Serial_2.Enabled = true;
            gpb_Freq_2.Enabled = true;
            btDefault_2.Enabled = true;
            btGetInformation_2.Enabled = true;
            gbp_buff_2.Enabled = true;

            btnSetWkParam_2.Enabled = true;
            btnGetWkParam_2.Enabled = true;
            btnSetBeep.Enabled = true;
        }

        private void SetButtonBold(Button btnBold)
        {
            Font oldFont = btnBold.Font;
            Font newFont = new Font(oldFont, oldFont.Style ^ FontStyle.Bold);
            btnBold.Font = newFont;
        }

        private void SetRadioButtonBold(CheckBox ckBold)
        {
            Font oldFont = ckBold.Font;
            Font newFont = new Font(oldFont, oldFont.Style ^ FontStyle.Bold);
            ckBold.Font = newFont;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            com_Q.SelectedIndex = 4;
            com_Target.SelectedIndex = 0;
            int i = 0;
            for (i = 0x03; i <= 0xff; i++)
                com_scantime.Items.Add(Convert.ToString(i) + "*100ms");
            com_scantime.SelectedIndex = 7;
            com_S.SelectedIndex = 0;

            for (i = 0; i < 100; i++)
            {
                comboBox1.Items.Add(i.ToString() + "*1s");
                cmbFilterTime_2.Items.Add(i.ToString() + "*1s");
            }
            comboBox1.SelectedIndex = 0;
            cmbFilterTime_2.SelectedIndex = 0;

            DisabledForm();
            DisabledForm2();

            radioButton_band1.Checked = true;
            ComboBox_baud.SelectedIndex = 3;
            ComboBox_PowerDbm.SelectedIndex = 24;
            btConnect232.ForeColor = Color.Indigo;
            btDisConnect232.ForeColor = Color.Black;
            SetButtonBold(btConnect232);
            // SetButtonBold(btDisConnect232);
            Maintab.TabPages.Remove(Main_Page3);

            ComboBox_COM.SelectedIndex = 0;
            ComboBox_baud2.SelectedIndex = 3;


            radioButton_band1_2.Checked = true;
            ComboBox_baud_2.SelectedIndex = 3;
            ComboBox_PowerDbm_2.SelectedIndex = 24;
            btConnect232_2.ForeColor = Color.Indigo;
            btDisConnect232_2.ForeColor = Color.Black;
            SetButtonBold(btConnect232_2);

            ComboBox_COM_2.SelectedIndex = 0;
            ComboBox_baud2_2.SelectedIndex = 3;

            byte[] ver = new byte[3];
            int ret = RWDev.GetSDKVersion(ver);
            txtSDKVer.Text = Convert.ToString(ver[0], 10) + "." + Convert.ToString(ver[1], 10) + "." + Convert.ToString(ver[2], 10);
            txtSDKVer2.Text = txtSDKVer.Text;
        }

        /// <summary>
        /// USB CONN
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btConnect232_Click(object sender, EventArgs e)
        {
            conn_type = "USB";
            if (device1_conned == false)
            {
                fCmdRet = RWDev.GetDeviceList(DeviceHandle, ref DeviceNum);
                if (fCmdRet != 0)
                {
                    string strLog = "Device 1 Connect failed: " + GetReturnCodeDesc(fCmdRet);
                    WriteLog(lrtxtLog, strLog, 1);
                    return;
                }

            }
            if (DeviceNum >= 2 || (device2_conned == false && DeviceNum < 2))
            {
                string strLog = "Device 1 Connected ";
                WriteLog(lrtxtLog, strLog, 0);

                //处理界面元素是否有效
                EnabledForm();
                gbRS232.Enabled = false;
                btConnect232.Enabled = false;
                btDisConnect232.Enabled = true;
                //设置按钮字体颜色
                btConnect232.ForeColor = Color.Black;
                btDisConnect232.ForeColor = Color.Indigo;
                SetButtonBold(btConnect232);
                SetButtonBold(btDisConnect232);
                fComAdr = 0xff;
                RWDev.SetBeepNotification(ref fComAdr, 0, DeviceHandle[0]);
                btGetInformation_Click(null, null);//获取读写器信息
                device1_conned = true;
            }
            else {
                string strLog = "Device 1 not found. ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        /// <summary>
        /// USB DIS CONN
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btDisConnect232_Click(object sender, EventArgs e)
        {
            if (device1_conned)
                fCmdRet = RWDev.CloseUSBPort(DeviceHandle[0]);
            if (fCmdRet == 0) device1_conned = false;
            DisabledForm();
            btConnect232.Enabled = true;
            gbRS232.Enabled = true;
            btDisConnect232.Enabled = false;

            btConnect232.ForeColor = Color.Indigo;
            btDisConnect232.ForeColor = Color.Black;
            SetButtonBold(btConnect232);
            SetButtonBold(btDisConnect232);
            if (!btDisConnect232_2.Enabled) {
                ClearFresList();
            }
        }

        private void btFlashCl_Click(object sender, EventArgs e)
        {
            ////应答模式下刷屏
            if (tabControl2.SelectedTab == tabPage3)
            {
                lxLedControl1.Text = "0";
                lxLedControl2.Text = "0";
                lxLedControl3.Text = "0";
                lxLedControl4.Text = "0";
                lxLedControl5.Text = "0";
                dataGridView1.Rows.Clear();
            }
            ////主动模式下刷屏
            if (tabControl2.SelectedTab == tabPage4)
            {
                lxLed_Num.Text = "0";
                lxLed_cmdsud.Text = "0";
                lxLed_toltag.Text = "0";
                lxLed_toltime.Text = "0";
                lxLed_cmdTime.Text = "0";
                dataGridView2.Rows.Clear();
            }
            ////6B标签刷屏
            if (Maintab.SelectedTab == Main_Page3)
            {
                text_R6B.Text = "";
                text_6BUID.Text = "";
                text_Statu6B.Text = "";
            }

            total_tagnum = 0;
            total_time = System.Environment.TickCount;
            comboBox_EPC.Items.Clear();
            lrtxtLog.Clear();

        }

        private void btIventoryG2_Click(object sender, EventArgs e)
        {
            timer_answer.Enabled = !timer_answer.Enabled;
            if (timer_answer.Enabled)
            {
                lxLedControl1.Text = "0";
                lxLedControl2.Text = "0";
                lxLedControl3.Text = "0";
                lxLedControl4.Text = "0";
                lxLedControl5.Text = "0";
                dataGridView1.Rows.Clear();
                comboBox_EPC.Items.Clear();
                AA_times = 0;
                Scantime = Convert.ToByte(com_scantime.SelectedIndex + 3);
                Qvalue = Convert.ToByte(com_Q.SelectedIndex);
                Session = Convert.ToByte(com_S.SelectedIndex);
                //if (rb_epc.Checked)
                TIDFlag = 0;
                //else
                //   TIDFlag = 1;
                total_turns = 0;
                total_tagnum = 0;
                targettimes = Convert.ToInt32(text_target.Text);
                total_time = System.Environment.TickCount;
                fIsInventoryScan = false;
                Target = 0;
                btIventoryG2.BackColor = Color.Red;
                btIventoryG2.Text = "Stop";
                dicResult.Clear();
            }
            else
            {
                btIventoryG2.BackColor = Color.Transparent;
                btIventoryG2.Text = "Start";
            }
        }
        private void inventory()
        {
            DataGridViewRow rows = new DataGridViewRow();
            int ntime = 0;
            int devCnt = 0;
            if (DeviceNum == 2 && device1_conned && device2_conned) {
                devCnt = 2;

            } else if (device1_conned || device2_conned) {
                devCnt = 1;
            }

            for (int index = 0; index < devCnt; index++)
            {
                int cbtime = System.Environment.TickCount;
                fComAdr = 0xff;
                byte Ant = 0;
                int CardNum = 0;
                int Totallen = 0;
                int EPClen, m;
                byte[] EPC = new byte[50000];
                int CardIndex;
                string temps, temp;
                temp = "";
                string sEPC;
                byte MaskMem = 0;
                byte[] MaskAdr = new byte[2];
                byte MaskLen = 0;
                byte[] MaskData = new byte[100];
                byte MaskFlag = 0;
                byte AdrTID = 0;
                byte LenTID = 0;
                AdrTID = 0;
                LenTID = 6;
                MaskFlag = 0;
                string devNo = "";
                int tmp = 0;
                if (device1_conned && index == 0)
                {
                    fCmdRet = conn_type == "USB" ?
                        RWDev.Inventory_G2(ref fComAdr, Qvalue, Session, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, AdrTID, LenTID, TIDFlag, Target, InAnt, Scantime, FastFlag, EPC, ref Ant, ref Totallen, ref CardNum, DeviceHandle[index])
                        : RWDevGPIO.Inventory_G2(ref fComAdr, Qvalue, Session, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, AdrTID, LenTID, TIDFlag, Target, InAnt, Scantime, FastFlag, EPC, ref Ant, ref Totallen, ref CardNum, frmcomportindex);
                    devNo = "1";
                }
                else if (device2_conned)
                {
                    tmp = DeviceNum == 1 ? 0 : 1;

                    fCmdRet = conn_type == "USB" ?
                        RWDev.Inventory_G2(ref fComAdr, Qvalue, Session, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, AdrTID, LenTID, TIDFlag, Target, InAnt, Scantime, FastFlag, EPC, ref Ant, ref Totallen, ref CardNum, DeviceHandle[tmp])
                        : RWDevGPIO.Inventory_G2(ref fComAdr, Qvalue, Session, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, AdrTID, LenTID, TIDFlag, Target, InAnt, Scantime, FastFlag, EPC, ref Ant, ref Totallen, ref CardNum, frmcomportindex);
                    devNo = "2";
                }

                total_turns = total_turns + 1;
                int x_time = System.Environment.TickCount - cbtime;//命令时间

                string strLog = "Device " + devNo + ": " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 0);

                if ((fCmdRet == 1) | (fCmdRet == 2) | (fCmdRet == 3) | (fCmdRet == 4))//代表已查找结束，
                {
                    byte[] daw = new byte[Totallen];
                    Array.Copy(EPC, daw, Totallen);
                    temps = ByteArrayToHexString(daw);
                    m = 0;
                    if (CardNum == 0)
                    {
                        if (Session > 1)
                            AA_times = AA_times + 1;
                        continue;
                    }
                    AA_times = 0;
                    //antstr = Convert.ToString(Ant, 2).PadLeft(4, '0');
                    for (CardIndex = 0; CardIndex < CardNum; CardIndex++)
                    {
                        EPClen = daw[m] + 1;
                        temp = temps.Substring(m * 2 + 2, EPClen * 2);
                        sEPC = temp.Substring(0, temp.Length - 2);
                        //string RSSI = Convert.ToInt32(temp.Substring(temp.Length - 2, 2), 16).ToString();
                        m = m + EPClen + 1;
                        if (sEPC.Length != (EPClen - 1) * 2)
                        {
                            return;
                        }
                        bool isonlistview = false;
                        for (int i = 0; i < dataGridView1.RowCount; i++)
                        {
                            if ((dataGridView1.Rows[i].Cells[1].Value != null) && (sEPC == dataGridView1.Rows[i].Cells[1].Value.ToString()))
                            {
                                rows = dataGridView1.Rows[i];
                                ntime = Convert.ToInt32(rows.Cells[2].Value.ToString());
                                ntime = ntime + 1;
                                if (ntime == 99999) ntime = 1;
                                rows.Cells[2].Value = ntime;
                                //rows.Cells[3].Value = RSSI;
                                rows.Cells[4].Value = devNo;
                                isonlistview = true;
                                break;
                            }
                        }
                        if (!isonlistview)
                        {
                            string[] arr = new string[5];
                            arr[0] = (dataGridView1.RowCount + 1).ToString();
                            arr[1] = sEPC;
                            arr[2] = "1";
                            //arr[3] = RSSI;
                            arr[4] = devNo;
                            dataGridView1.Rows.Insert(dataGridView1.RowCount, arr);
                            //if (rb_epc.Checked)
                            comboBox_EPC.Items.Add(sEPC);
                            if (!dicResult.ContainsKey(sEPC)) {

                                dicResult.Add(sEPC, index);
                            }
                            else {

                                dicResult[sEPC] = index;
                            }
                        }
                    }
                }
                lxLedControl3.Text = x_time.ToString();
                if (x_time > CommunicationTime)
                    x_time = x_time - CommunicationTime;//减去通讯时间等于标签的实际时间
                int sulv = 0;
                if (x_time != 0) sulv = (CardNum * 1000) / x_time;//速度等于张数/时间
                //lxLedControl2.Text = sulv.ToString();
                total_tagnum = total_tagnum + CardNum;
                lxLedControl4.Text = total_tagnum.ToString();
                x_time = System.Environment.TickCount - total_time;//总时间
                lxLedControl2.Text = (total_tagnum * 1000 / x_time).ToString();
                lxLedControl5.Text = x_time.ToString();
                lxLedControl1.Text = dataGridView1.RowCount.ToString();
            }

        }
        private void timer_answer_Tick(object sender, EventArgs e)
        {
            if (fIsInventoryScan)
                return;
            fIsInventoryScan = true;
            FastFlag = 1;
            InAnt = 0x80;
            if (Session == 0 || Session == 1)
            {
                Target = (byte)com_Target.SelectedIndex;
            }
            else
            {
                if ((check_num.Checked) && (AA_times + 1 > targettimes))
                {
                    Target = Convert.ToByte(1 - Target);  //如果连续2次未读到卡片，A/B状态切换。
                }
                else if (!check_num.Checked)
                {
                    Target = (byte)com_Target.SelectedIndex;
                }
            }
            inventory();
            fIsInventoryScan = false;
        }

        private void radioButton_band1_CheckedChanged(object sender, EventArgs e)
        {
            if (fres_ch.Count == 0)
            {
                int region = 1;
                fres_ch = GetFrequencyByRegion(region);
            }
            ComboBox_dminfre.Items.Clear();
            ComboBox_dmaxfre.Items.Clear();
            foreach (string item in fres_ch)
            {
                ComboBox_dminfre.Items.Add(item);
                ComboBox_dmaxfre.Items.Add(item);
            }
            ComboBox_dmaxfre.SelectedIndex = fres_ch.Count - 1;
            ComboBox_dminfre.SelectedIndex = 0;
        }

        private void radioButton_band2_CheckedChanged(object sender, EventArgs e)
        {
            if (fres_us.Count == 0)
            {
                int region = 2;
                fres_us = GetFrequencyByRegion(region);
            }
            ComboBox_dmaxfre.Items.Clear();
            ComboBox_dminfre.Items.Clear();
            foreach (string item in fres_us)
            {
                ComboBox_dminfre.Items.Add(item);
                ComboBox_dmaxfre.Items.Add(item);
            }
            ComboBox_dmaxfre.SelectedIndex = fres_us.Count - 1;
            ComboBox_dminfre.SelectedIndex = 0;
        }

        private void radioButton_band3_CheckedChanged(object sender, EventArgs e)
        {
            if (fres_korea.Count == 0)
            {
                int region = 3;
                fres_korea = GetFrequencyByRegion(region);
            }
            ComboBox_dmaxfre.Items.Clear();
            ComboBox_dminfre.Items.Clear();
            foreach (string item in fres_korea)
            {
                ComboBox_dminfre.Items.Add(item);
                ComboBox_dmaxfre.Items.Add(item);
            }
            ComboBox_dmaxfre.SelectedIndex = fres_korea.Count - 1;
            ComboBox_dminfre.SelectedIndex = 0;
        }

        private void radioButton_band4_CheckedChanged(object sender, EventArgs e)
        {
            if (fres_eu.Count == 0)
            {
                int region = 4;
                fres_eu = GetFrequencyByRegion(region);
            }
            ComboBox_dmaxfre.Items.Clear();
            ComboBox_dminfre.Items.Clear();
            foreach (string item in fres_eu)
            {
                ComboBox_dminfre.Items.Add(item);
                ComboBox_dmaxfre.Items.Add(item);
            }
            ComboBox_dmaxfre.SelectedIndex = fres_eu.Count - 1;
            ComboBox_dminfre.SelectedIndex = 0;
        }

        private void CheckBox_SameFre_CheckedChanged(object sender, EventArgs e)
        {
            if (CheckBox_SameFre.Checked)
                ComboBox_dmaxfre.SelectedIndex = ComboBox_dminfre.SelectedIndex;
        }

        private bool CheckCRC(string s)
        {
            int i, j;
            int current_crc_value;
            byte crcL, crcH;
            byte[] data = HexStringToByteArray(s);
            current_crc_value = 0xFFFF;
            for (i = 0; i <= (data.Length - 1); i++)
            {
                current_crc_value = current_crc_value ^ (data[i]);
                for (j = 0; j < 8; j++)
                {
                    if ((current_crc_value & 0x01) != 0)
                        current_crc_value = (current_crc_value >> 1) ^ 0x8408;
                    else
                        current_crc_value = (current_crc_value >> 1);
                }
            }
            crcL = Convert.ToByte(current_crc_value & 0xFF);
            crcH = Convert.ToByte((current_crc_value >> 8) & 0xFF);
            if (crcH == 0 && crcL == 0)
            {
                return true;
            }
            else
            {
                return false;
            }

        }

        private void GetData()
        {
            int TagNum = 0;
            int BufferCount = 0;
            byte MaskMem = 0;
            byte[] MaskAdr = new byte[2];
            byte MaskLen = 0;
            byte[] MaskData = new byte[100];
            byte MaskFlag = 0;
            byte AdrTID = 0;
            byte LenTID = 0;
            AdrTID = 0;
            LenTID = 6;
            MaskFlag = 0;
            int cbtime = System.Environment.TickCount;
            DataGridViewRow rows = new DataGridViewRow();
            TagNum = 0;
            BufferCount = 0;
            Target = 0;
            Scantime = 0x03;
            Qvalue = 4;
            Session = 1;
            FastFlag = 1;

            int devCnt = 0;
            if (DeviceNum == 2 && device1_conned && device2_conned)
            {
                devCnt = 2;

            }
            else if (device1_conned || device2_conned)
            {
                devCnt = 1;
            }
            string devNo = "";
            int BufferCount1 = 0;
            int BufferCount2 = 0;
            for (int index = 0; index < devCnt; index++)
            {
                fComAdr = 0xff;

                if (device1_conned && index == 0)
                {
                    fCmdRet = conn_type == "USB" ?
                       RWDev.InventoryBuffer_G2(ref fComAdr, Qvalue, Session, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, AdrTID, LenTID, TIDFlag, Target, InAnt, Scantime, FastFlag, ref BufferCount, ref TagNum, DeviceHandle[index])
                       : RWDevGPIO.InventoryBuffer_G2(ref fComAdr, Qvalue, Session, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, AdrTID, LenTID, TIDFlag, Target, InAnt, Scantime, FastFlag, ref BufferCount, ref TagNum, frmcomportindex);
                    devNo = "1";
                    BufferCount1 = BufferCount;
                }
                else if (device2_conned) {
                    int tmp = DeviceNum == 1 ? 0 : 1;
                    fCmdRet = conn_type == "USB" ?
                       RWDev.InventoryBuffer_G2(ref fComAdr, Qvalue, Session, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, AdrTID, LenTID, TIDFlag, Target, InAnt, Scantime, FastFlag, ref BufferCount, ref TagNum, DeviceHandle[tmp])
                       : RWDevGPIO.InventoryBuffer_G2(ref fComAdr, Qvalue, Session, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, AdrTID, LenTID, TIDFlag, Target, InAnt, Scantime, FastFlag, ref BufferCount, ref TagNum, frmcomportindex);
                    devNo = "2";
                    BufferCount2 = BufferCount;
                }

                total_turns = total_turns + 1;
                int x_time = System.Environment.TickCount - cbtime;//命令时间
                string strLog = "Device " + devNo + " Inventory buffer: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 0);
                ///////////设置网络断线重连
                if (fCmdRet == 0)//代表已查找结束，
                {
                    lxLed_cmdTime.Text = x_time.ToString();
                    total_tagnum = total_tagnum + TagNum;
                    int sulv = 0;
                    if (x_time != 0) sulv = (TagNum * 1000) / x_time;//速度等于张数/时间
                    //lxLed_cmdsud.Text = sulv.ToString();
                    lxLed_toltag.Text = total_tagnum.ToString();
                    x_time = System.Environment.TickCount - total_time;//总时间
                    lxLed_cmdsud.Text = (total_tagnum * 1000 / x_time).ToString();
                    lxLed_toltime.Text = x_time.ToString();
                    lxLed_Num.Text = (BufferCount1 + BufferCount2).ToString();
                }
            }

        }

        private void timer_runmode_Tick(object sender, EventArgs e)
        {
            if (fIsInventoryScan)
                return;
            fIsInventoryScan = true;
            GetData();
            fIsInventoryScan = false;
        }


        private void Maintab_SelectedIndexChanged(object sender, EventArgs e)
        {
            timer_runmode.Enabled = false;
            timer_answer.Enabled = false;
            timer_EAS.Enabled = false;
            Timer_Test_6B.Enabled = false;
            btIventoryG2.Text = "Start";
            btStartBuff.Text = "Start";
            btCheckEASAlarm.Text = "Detect";
            pictureBox2.Visible = false;
            btIventoryG2.BackColor = Color.Transparent;
            btStartBuff.BackColor = Color.Transparent;
            btInventory6B.Text = "Start";
            btInventory6B.BackColor = Color.Transparent;
            if (comboBox_EPC.Text == "" && comboBox_EPC.Items.Count > 0)
            {
                comboBox_EPC.SelectedIndex = 0;
            }
        }



        private void txtbox_decimal_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = !Char.IsNumber(e.KeyChar) && e.KeyChar != (char)8;
        }

        private void txtbox_hex_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = ("0123456789ABCDEF".IndexOf(Char.ToUpper(e.KeyChar)) < 0) && e.KeyChar != (char)8;
        }

        private void btGetInformation_Click(object sender, EventArgs e)
        {
            byte TrType = 0;
            byte[] VersionInfo = new byte[2];
            byte ReaderType = 0;
            byte ScanTime = 0;
            byte dmaxfre = 0;
            byte dminfre = 0;
            byte powerdBm = 0;
            byte FreBand = 0;
            byte Ant = 0;
            byte BeepEn = 0;
            byte OutputRep = 0;
            byte CheckAnt = 0;
            text_RDVersion.Text = "";
            int ctime = System.Environment.TickCount;
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.GetReaderInformation(ref fComAdr, VersionInfo, ref ReaderType, ref TrType, ref dmaxfre, ref dminfre, ref powerdBm, ref ScanTime, ref Ant, ref BeepEn, ref OutputRep, ref CheckAnt, DeviceHandle[0])
                : RWDevGPIO.GetReaderInformation(ref fComAdr, VersionInfo, ref ReaderType, ref TrType, ref dmaxfre, ref dminfre, ref powerdBm, ref ScanTime, ref Ant, ref BeepEn, ref OutputRep, ref CheckAnt, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Get Reader Information failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                CommunicationTime = System.Environment.TickCount - ctime;
                text_RDVersion.Text = Convert.ToString(VersionInfo[0], 10).PadLeft(2, '0') + "." + Convert.ToString(VersionInfo[1], 10).PadLeft(2, '0');
                if (powerdBm > 24)
                {
                    powerdBm = 24;
                    fCmdRet = conn_type == "USB" ?
                        RWDev.SetRfPower(ref fComAdr, 24, DeviceHandle[0])
                        : RWDevGPIO.SetRfPower(ref fComAdr, 24, frmcomportindex);
                }
                ComboBox_PowerDbm.SelectedIndex = Convert.ToInt32(powerdBm);
                text_address.Text = Convert.ToString(fComAdr, 16).PadLeft(2, '0');
                FreBand = Convert.ToByte(((dmaxfre & 0xc0) >> 4) | (dminfre >> 6));
                switch (FreBand)
                {
                    case 1:
                        {
                            radioButton_band1.Checked = true;
                            ComboBox_dminfre.SelectedIndex = dminfre & 0x3F;
                            ComboBox_dmaxfre.SelectedIndex = dmaxfre & 0x3F;
                        }
                        break;
                    case 2:
                        {
                            if (((dminfre & 0x03F) >= 26) && ((dmaxfre & 0x03F) <= 44))
                            {
                                radioButton_band5.Checked = true;
                                ComboBox_dminfre.SelectedIndex = ((dminfre & 0x3F) - 26);
                                ComboBox_dmaxfre.SelectedIndex = ((dmaxfre & 0x3F) - 26);
                            }
                            else
                            {
                                radioButton_band2.Checked = true;
                                ComboBox_dminfre.SelectedIndex = dminfre & 0x3F;
                                ComboBox_dmaxfre.SelectedIndex = dmaxfre & 0x3F;
                            }

                        }
                        break;
                    case 3:
                        {
                            radioButton_band3.Checked = true;
                            ComboBox_dminfre.SelectedIndex = dminfre & 0x3F;
                            ComboBox_dmaxfre.SelectedIndex = dmaxfre & 0x3F;
                        }
                        break;
                    case 4:
                        {
                            radioButton_band4.Checked = true;
                            ComboBox_dminfre.SelectedIndex = dminfre & 0x3F;
                            ComboBox_dmaxfre.SelectedIndex = dmaxfre & 0x3F;
                        }
                        break;
                }
                if (fdmaxfre != fdminfre)
                    CheckBox_SameFre.Checked = false;

                switch (BeepEn)
                {
                    case 1:
                        Radio_beepEn.Checked = true;
                        break;
                    case 0:
                        Radio_beepDis.Checked = true;
                        break;
                }

                string strLog = "Get Reader Information success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btDefault_Click(object sender, EventArgs e)
        {
            byte aNewComAdr, powerDbm, dminfre, dmaxfre, scantime;
            dminfre = 64;
            dmaxfre = 19;
            aNewComAdr = 0x00;
            powerDbm = 24;
            fBaud = 5;
            scantime = 10;
            ComboBox_baud.SelectedIndex = 3;
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.SetAddress(ref fComAdr, aNewComAdr, DeviceHandle[0])
                : RWDevGPIO.SetAddress(ref fComAdr, aNewComAdr, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set address failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set address access ";
                WriteLog(lrtxtLog, strLog, 0);
            }

            fCmdRet = conn_type == "USB" ?
               RWDev.SetRfPower(ref fComAdr, powerDbm, DeviceHandle[0])
               : RWDevGPIO.SetRfPower(ref fComAdr, powerDbm, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set power failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set power success ";
                WriteLog(lrtxtLog, strLog, 0);
            }

            fCmdRet = conn_type == "USB" ?
               RWDev.SetRegion(ref fComAdr, dmaxfre, dminfre, DeviceHandle[0])
               : RWDevGPIO.SetRegion(ref fComAdr, dmaxfre, dminfre, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set Region failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set Region success ";
                WriteLog(lrtxtLog, strLog, 0);
            }

            fCmdRet = conn_type == "USB" ?
               RWDev.SetBaudRate(ref fComAdr, fBaud, DeviceHandle[0])
               : RWDevGPIO.SetBaudRate(ref fComAdr, fBaud, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set baud rate failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set baud rate success ";
                WriteLog(lrtxtLog, strLog, 0);
            }

            fCmdRet = conn_type == "USB" ?
               RWDev.SetInventoryScanTime(ref fComAdr, scantime, DeviceHandle[0])
               : RWDevGPIO.SetInventoryScanTime(ref fComAdr, scantime, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set max inventory time failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set max inventory time success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
            btGetInformation_Click(null, null);
        }

        private void btaddress_Click(object sender, EventArgs e)
        {
            byte aNewComAdr = Convert.ToByte(text_address.Text, 16);
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.SetAddress(ref fComAdr, aNewComAdr, DeviceHandle[0])
                : RWDevGPIO.SetAddress(ref fComAdr, aNewComAdr, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set address failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set address access ";
                WriteLog(lrtxtLog, strLog, 0);
            }
            fComAdr = 0xff;
            btGetInformation_Click(null, null);
        }

        private void btFreq_Click(object sender, EventArgs e)
        {
            int band = 0;
            if (radioButton_band1.Checked)
                band = 1;
            if (radioButton_band2.Checked)
                band = 2;
            if (radioButton_band3.Checked)
                band = 3;
            if (radioButton_band4.Checked)
                band = 4;
            if (radioButton_band5.Checked)
                band = 5;
            fComAdr = 0xff;
            if (conn_type == "USB")
            {
                fCmdRet = RWDev.SetRegionAndChannel(ref fComAdr, band, ComboBox_dminfre.SelectedIndex, ComboBox_dmaxfre.SelectedIndex, DeviceHandle[0]);
            }
            else
            {
                fCmdRet = RWDevGPIO.SetRegionAndChannel(ref fComAdr, band, ComboBox_dminfre.SelectedIndex, ComboBox_dmaxfre.SelectedIndex, frmcomportindex);
            }
            if (fCmdRet != 0)
            {
                string strLog = "Set Region failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set Region success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void BT_DBM_Click(object sender, EventArgs e)
        {
            byte powerDbm = (byte)ComboBox_PowerDbm.SelectedIndex;
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.SetRfPower(ref fComAdr, powerDbm, DeviceHandle[0])
                : RWDevGPIO.SetRfPower(ref fComAdr, powerDbm, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set power failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set power success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btBaudRate_Click(object sender, EventArgs e)
        {
            byte fBaud = (byte)ComboBox_baud.SelectedIndex;
            if (fBaud > 2)
                fBaud = (byte)(fBaud + 2);

            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.SetBaudRate(ref fComAdr, fBaud, DeviceHandle[0])
                : RWDevGPIO.SetBaudRate(ref fComAdr, fBaud, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set baud rate failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set baud rate success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btSerial_Click(object sender, EventArgs e)
        {
            byte[] SeriaNo = new byte[4];
            text_Serial.Text = "";
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.GetSeriaNo(ref fComAdr, SeriaNo, DeviceHandle[0])
                : RWDevGPIO.GetSeriaNo(ref fComAdr, SeriaNo, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Reader serial number failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                text_Serial.Text = ByteArrayToHexString(SeriaNo);
                string strLog = "Reader serial number success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }


        private void Button_Beep_Click(object sender, EventArgs e)
        {
            byte BeepEn = 0;
            if (Radio_beepEn.Checked)
                BeepEn = 1;
            else
                BeepEn = 0;
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.SetBeepNotification(ref fComAdr, BeepEn, DeviceHandle[0])
                : RWDevGPIO.SetBeepNotification(ref fComAdr, BeepEn, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set beep failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set beep success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }


        private void Button_SetGPIO_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            byte OutputPin = 0;
            if (check_out1.Checked)
                OutputPin = Convert.ToByte(OutputPin | 0x01);
            if (check_out2.Checked)
                OutputPin = Convert.ToByte(OutputPin | 0x02);
            fCmdRet = conn_type == "USB" ?
                RWDev.SetGPIO(ref fComAdr, OutputPin, DeviceHandle[0])
                : RWDevGPIO.SetGPIO(ref fComAdr, OutputPin, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set GPIO failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set GPIO success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void Button_GetGPIO_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            byte OutputPin = 0;
            fCmdRet = conn_type == "USB" ?
                RWDev.GetGPIOStatus(ref fComAdr, ref OutputPin, DeviceHandle[0])
                : RWDevGPIO.GetGPIOStatus(ref fComAdr, ref OutputPin, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Get GPIO status failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                if ((OutputPin & 0x10) == 0x10)
                    check_out1.Checked = true;
                else
                    check_out1.Checked = false;

                if ((OutputPin & 0x20) == 0x20)
                    check_out2.Checked = true;
                else
                    check_out2.Checked = false;

                if ((OutputPin & 0x01) == 1)
                    check_int1.Checked = true;
                else
                    check_int1.Checked = false;

                if ((OutputPin & 0x02) == 2)
                    check_int2.Checked = true;
                else
                    check_int2.Checked = false;

                string strLog = "Get GPIO status success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }


        private void btSelectTag_Click(object sender, EventArgs e)
        {
            text_epc.Text = comboBox_EPC.Text;

            if (dicResult.ContainsKey(comboBox_EPC.Text))
            {
                selectedDeviceNo = dicResult[comboBox_EPC.Text];
            }

        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox1.Checked)
            {
                maskadr_textbox.Enabled = true;
                maskLen_textBox.Enabled = true;
                maskData_textBox.Enabled = true;
                R_EPC.Enabled = true;
                R_TID.Enabled = true;
                R_User.Enabled = true;
                check_selecttag.Checked = false;
                isSelectedTag = false;
            }
            else
            {
                maskadr_textbox.Enabled = false;
                maskLen_textBox.Enabled = false;
                maskData_textBox.Enabled = false;
                R_EPC.Enabled = false;
                R_TID.Enabled = false;
                R_User.Enabled = false;
            }
        }

        private void btRead_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            byte WordPtr, ENum;
            byte Num = 0;
            byte Mem = 0;
            string str = ""; ;
            byte[] CardData = new byte[320];
            byte MaskMem = 0;
            byte[] MaskAdr = new byte[2];
            byte MaskLen = 0;
            byte[] MaskData = new byte[100];
            text_WriteData.Text = "";
            if (checkBox1.Checked)
            {
                if ((maskadr_textbox.Text == "") || (maskLen_textBox.Text == "") || (maskData_textBox.Text == ""))
                {
                    return;
                }
                ENum = 255;
                if (R_EPC.Checked) MaskMem = 1;
                if (R_TID.Checked) MaskMem = 2;
                if (R_User.Checked) MaskMem = 3;
                //MaskAdr = HexStringToByteArray(maskadr_textbox.Text);
                //MaskLen = Convert.ToByte(maskLen_textBox.Text, 16);
                MaskAdr = HexStringToByteArray((Convert.ToInt32(maskadr_textbox.Text) * 16).ToString("X4"));//dec word
                MaskLen = Convert.ToByte(Convert.ToInt32(maskLen_textBox.Text) * 16);//dec word
                MaskData = HexStringToByteArray(maskData_textBox.Text);
            }
            else
            {
                if (check_selecttag.Checked)
                    str = text_epc.Text;
                else
                    str = "";
                ENum = Convert.ToByte(str.Length / 4);
            }
            byte[] EPC = new byte[ENum * 2];
            EPC = HexStringToByteArray(str);
            if (C_Reserve.Checked)
                Mem = 0;
            if (C_EPC.Checked)
                Mem = 1;
            if (C_TID.Checked)
                Mem = 2;
            if (C_User.Checked)
                Mem = 3;
            if (text_WordPtr.Text == "" || text_RWlen.Text == "" || text_AccessCode2.Text.Length != 8)
            {
                return;
            }
            //WordPtr = Convert.ToByte(text_WordPtr.Text, 16);
            WordPtr = Convert.ToByte(Convert.ToInt32(text_WordPtr.Text).ToString("X4"), 16);//DEC WORD
            Num = Convert.ToByte(text_RWlen.Text);
            fPassWord = HexStringToByteArray(text_AccessCode2.Text);
            int currentDevieIndex = 0;
            for (int p = 0; p < 10; p++)
            {
                if (isSelectedTag)
                {
                    currentDevieIndex = selectedDeviceNo;
                }
                else if (DeviceNum == 1 || (DeviceNum > 1 && device1_conned && p < 5))
                {
                    currentDevieIndex = 0;
                }
                else if (DeviceNum > 1 && device2_conned && p >= 5)
                {
                    currentDevieIndex = 1;
                }
                fCmdRet = conn_type == "USB" ?
                  RWDev.ReadData_G2(ref fComAdr, EPC, ENum, Mem, WordPtr, Num, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, CardData, ref ferrorcode, DeviceHandle[currentDevieIndex])
                  : RWDevGPIO.ReadData_G2(ref fComAdr, EPC, ENum, Mem, WordPtr, Num, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, CardData, ref ferrorcode, frmcomportindex);
                if (fCmdRet == 0) break;
            }
            if (fCmdRet != 0)
            {
                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Read data failed: " + "tag return error =0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Read data failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                byte[] daw = new byte[Num * 2];
                Array.Copy(CardData, daw, Num * 2);
                text_WriteData.Text = ByteArrayToHexString(daw);
                string strLog = "Read data success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btWrite_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            byte WordPtr, ENum;
            byte WNum = 0;
            byte Mem = 0;
            string str = ""; ;
            byte[] CardData = new byte[320];
            byte MaskMem = 0;
            byte[] MaskAdr = new byte[2];
            byte MaskLen = 0;
            byte[] MaskData = new byte[100];
            if (checkBox1.Checked)
            {
                if ((maskadr_textbox.Text == "") || (maskLen_textBox.Text == "") || (maskData_textBox.Text == ""))
                {
                    return;
                }
                ENum = 255;
                if (R_EPC.Checked) MaskMem = 1;
                if (R_TID.Checked) MaskMem = 2;
                if (R_User.Checked) MaskMem = 3;
                //MaskAdr = HexStringToByteArray(maskadr_textbox.Text);
                //MaskLen = Convert.ToByte(maskLen_textBox.Text, 16);
                MaskAdr = HexStringToByteArray((Convert.ToInt32(maskadr_textbox.Text) * 16).ToString("X4"));//dec word
                MaskLen = Convert.ToByte(Convert.ToInt32(maskLen_textBox.Text) * 16);//dec word
                MaskData = HexStringToByteArray(maskData_textBox.Text);
            }
            else
            {
                if (check_selecttag.Checked)
                    str = text_epc.Text;
                else
                    str = "";
                ENum = Convert.ToByte(str.Length / 4);
            }
            byte[] EPC = new byte[ENum * 2];
            EPC = HexStringToByteArray(str);
            if (C_Reserve.Checked)
                Mem = 0;
            if (C_EPC.Checked)
                Mem = 1;
            if (C_TID.Checked)
                Mem = 2;
            if (C_User.Checked)
                Mem = 3;
            if (text_WordPtr.Text == "" || text_AccessCode2.Text.Length != 8)
            {
                return;
            }
            string epcstr = text_WriteData.Text;
            if (epcstr.Length % 4 != 0 || epcstr.Length == 0)
            {
                MessageBox.Show("Input data by word.", "Information");
                return;
            }
            if (epcstr.Length > 16)
            {
                MessageBox.Show("The data input is too long,It must be shorter than 4 words.", "Information");
                return;
            }
            WNum = Convert.ToByte(epcstr.Length / 4);
            byte[] Writedata = new byte[WNum * 2 + 1];
            Writedata = HexStringToByteArray(epcstr);
            //WordPtr = Convert.ToByte(text_WordPtr.Text, 16);
            WordPtr = Convert.ToByte(Convert.ToInt32(text_WordPtr.Text).ToString("X4"), 16);//DEC WORD
            fPassWord = HexStringToByteArray(text_AccessCode2.Text);
            if ((checkBox_pc.Checked) && (C_EPC.Checked))
            {
                WordPtr = 1;
                WNum = Convert.ToByte(epcstr.Length / 4 + 1);
                Writedata = HexStringToByteArray(textBox_pc.Text + epcstr);
            }
            int currentDevieIndex = 0;
            for (int p = 0; p < 10; p++)
            {
                if (isSelectedTag)
                {
                    currentDevieIndex = selectedDeviceNo;
                }
                else if (DeviceNum == 1 || (DeviceNum > 1 && device1_conned && p < 5))
                {
                    currentDevieIndex = 0;
                }
                else if (DeviceNum > 1 && device2_conned && p >= 5)
                {
                    currentDevieIndex = 1;
                }
                fCmdRet = conn_type == "USB" ?
                    RWDev.WriteData_G2(ref fComAdr, EPC, WNum, ENum, Mem, WordPtr, Writedata, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, DeviceHandle[currentDevieIndex])
                    : RWDevGPIO.WriteData_G2(ref fComAdr, EPC, WNum, ENum, Mem, WordPtr, Writedata, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, frmcomportindex);
                if (fCmdRet == 0) break;
            }
            if (fCmdRet != 0)
            {
                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Write data failed: " + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Write data failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Write data success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void checkBox_pc_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox_pc.Checked && C_EPC.Checked)
            {
                text_WordPtr.Text = "2";
                text_WordPtr.ReadOnly = true;
                int m, n;
                n = text_WriteData.Text.Length;
                if (n % 4 == 0)
                {
                    m = n / 4;
                    m = (m & 0x3F) << 3;
                    textBox_pc.Text = Convert.ToString(m, 16).PadLeft(2, '0') + "00";
                }
            }
            else
            {
                text_WordPtr.ReadOnly = false;
            }
        }

        private void text_WriteData_TextChanged(object sender, EventArgs e)
        {
            int m, n;
            n = text_WriteData.Text.Length;
            if ((checkBox_pc.Checked) && (n % 4 == 0) && (C_EPC.Checked))
            {
                m = n / 4;
                m = (m & 0x3F) << 3;
                textBox_pc.Text = Convert.ToString(m, 16).PadLeft(2, '0') + "00";
            }
        }

        private void C_EPC_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox_pc.Checked && C_EPC.Checked)
            {
                text_WordPtr.Text = "2";
                text_WordPtr.ReadOnly = true;
            }
            else
            {
                text_WordPtr.ReadOnly = false;
            }
        }

        private void btBlockWrite_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            byte WordPtr, ENum;
            byte WNum = 0;
            byte Mem = 0;
            string str = ""; ;
            byte[] CardData = new byte[320];
            byte MaskMem = 0;
            byte[] MaskAdr = new byte[2];
            byte MaskLen = 0;
            byte[] MaskData = new byte[100];
            if (checkBox1.Checked)
            {
                if ((maskadr_textbox.Text == "") || (maskLen_textBox.Text == "") || (maskData_textBox.Text == ""))
                {
                    return;
                }
                ENum = 255;
                if (R_EPC.Checked) MaskMem = 1;
                if (R_TID.Checked) MaskMem = 2;
                if (R_User.Checked) MaskMem = 3;
                //MaskAdr = HexStringToByteArray(maskadr_textbox.Text);
                //MaskLen = Convert.ToByte(maskLen_textBox.Text, 16);
                MaskAdr = HexStringToByteArray((Convert.ToInt32(maskadr_textbox.Text) * 16).ToString("X4"));//dec word
                MaskLen = Convert.ToByte(Convert.ToInt32(maskLen_textBox.Text) * 16);//dec word
                MaskData = HexStringToByteArray(maskData_textBox.Text);
            }
            else
            {
                if (check_selecttag.Checked)
                    str = text_epc.Text;
                else
                    str = "";
                ENum = Convert.ToByte(str.Length / 4);
            }
            byte[] EPC = new byte[ENum * 2];
            EPC = HexStringToByteArray(str);
            if (C_Reserve.Checked)
                Mem = 0;
            if (C_EPC.Checked)
                Mem = 1;
            if (C_TID.Checked)
                Mem = 2;
            if (C_User.Checked)
                Mem = 3;
            if (text_WordPtr.Text == "" || text_AccessCode2.Text.Length != 8)
            {
                return;
            }
            string epcstr = text_WriteData.Text;
            if (epcstr.Length % 4 != 0 || epcstr.Length == 0)
            {
                MessageBox.Show("Input data by word.", "Information");
                return;
            }
            WNum = Convert.ToByte(epcstr.Length / 4);
            byte[] Writedata = new byte[WNum * 2 + 1];
            Writedata = HexStringToByteArray(epcstr);
            //WordPtr = Convert.ToByte(text_WordPtr.Text, 16);
            WordPtr = Convert.ToByte(Convert.ToInt32(text_WordPtr.Text).ToString("X4"), 16);//DEC WORD
            fPassWord = HexStringToByteArray(text_AccessCode2.Text);
            if ((checkBox_pc.Checked) && (C_EPC.Checked))
            {
                WordPtr = 1;
                WNum = Convert.ToByte(epcstr.Length / 4 + 1);
                Writedata = HexStringToByteArray(textBox_pc.Text + epcstr);
            }
            int currentDevieIndex = 0;
            for (int p = 0; p < 10; p++)
            {
                if (isSelectedTag)
                {
                    currentDevieIndex = selectedDeviceNo;
                }
                else if (DeviceNum == 1 || (DeviceNum > 1 && device1_conned && p < 5))
                {
                    currentDevieIndex = 0;
                }
                else if (DeviceNum > 1 && device2_conned && p >= 5)
                {
                    currentDevieIndex = 1;
                }
                fCmdRet = conn_type == "USB" ?
                    RWDev.BlockWrite_G2(ref fComAdr, EPC, WNum, ENum, Mem, WordPtr, Writedata, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, DeviceHandle[currentDevieIndex])
                    : RWDevGPIO.BlockWrite_G2(ref fComAdr, EPC, WNum, ENum, Mem, WordPtr, Writedata, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, frmcomportindex);
                if (fCmdRet == 0) break;
            }
            if (fCmdRet != 0)
            {
                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Block write failed: " + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Block write failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Block write success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btBlockErase_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            byte WordPtr, ENum;
            byte Num = 0;
            byte Mem = 0;
            string str = ""; ;
            byte MaskMem = 0;
            byte[] MaskAdr = new byte[2];
            byte MaskLen = 0;
            byte[] MaskData = new byte[100];
            text_WriteData.Text = "";
            if (checkBox1.Checked)
            {
                if ((maskadr_textbox.Text == "") || (maskLen_textBox.Text == "") || (maskData_textBox.Text == ""))
                {
                    return;
                }
                ENum = 255;
                if (R_EPC.Checked) MaskMem = 1;
                if (R_TID.Checked) MaskMem = 2;
                if (R_User.Checked) MaskMem = 3;
                //MaskAdr = HexStringToByteArray(maskadr_textbox.Text);
                //MaskLen = Convert.ToByte(maskLen_textBox.Text, 16);
                MaskAdr = HexStringToByteArray((Convert.ToInt32(maskadr_textbox.Text) * 16).ToString("X4"));//dec word
                MaskLen = Convert.ToByte(Convert.ToInt32(maskLen_textBox.Text) * 16);//dec word
                MaskData = HexStringToByteArray(maskData_textBox.Text);
            }
            else
            {
                if (check_selecttag.Checked)
                    str = text_epc.Text;
                else
                    str = "";
                ENum = Convert.ToByte(str.Length / 4);
            }
            byte[] EPC = new byte[ENum * 2];
            EPC = HexStringToByteArray(str);
            if (C_Reserve.Checked)
                Mem = 0;
            if (C_EPC.Checked)
                Mem = 1;
            if (C_TID.Checked)
                Mem = 2;
            if (C_User.Checked)
                Mem = 3;
            if (text_WordPtr.Text == "" || text_RWlen.Text == "" || text_AccessCode2.Text.Length != 8)
            {
                return;
            }
            //WordPtr = Convert.ToByte(text_WordPtr.Text, 16);
            WordPtr = Convert.ToByte(Convert.ToInt32(text_WordPtr.Text).ToString("X4"), 16);//DEC WORD
            Num = Convert.ToByte(text_RWlen.Text);
            fPassWord = HexStringToByteArray(text_AccessCode2.Text);
            int curIndex = isSelectedTag ? selectedDeviceNo : 0;
            fCmdRet = conn_type == "USB" ?
                   RWDev.BlockErase_G2(ref fComAdr, EPC, ENum, Mem, WordPtr, Num, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, DeviceHandle[curIndex])
                   : RWDevGPIO.BlockErase_G2(ref fComAdr, EPC, ENum, Mem, WordPtr, Num, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, frmcomportindex);
            if (fCmdRet != 0 && this.DeviceNum > 1 && device2_conned)
            {
                fCmdRet = conn_type == "USB" ?
                   RWDev.BlockErase_G2(ref fComAdr, EPC, ENum, Mem, WordPtr, Num, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, DeviceHandle[1])
                   : RWDevGPIO.BlockErase_G2(ref fComAdr, EPC, ENum, Mem, WordPtr, Num, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, frmcomportindex);
            }
            if (fCmdRet != 0)
            {
                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Block erase failed: " + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Block erase failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Block erase success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btSetProtectState_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            byte select = 0;
            byte setprotect = 0;
            string str = "";
            byte ENum;
            byte[] CardData = new byte[320];
            byte MaskMem = 0;
            byte[] MaskAdr = new byte[2];
            byte MaskLen = 0;
            byte[] MaskData = new byte[100];

            if (checkBox1.Checked)
            {
                if ((maskadr_textbox.Text == "") || (maskLen_textBox.Text == "") || (maskData_textBox.Text == ""))
                {
                    return;
                }
                ENum = 255;
                if (R_EPC.Checked) MaskMem = 1;
                if (R_TID.Checked) MaskMem = 2;
                if (R_User.Checked) MaskMem = 3;
                //MaskAdr = HexStringToByteArray(maskadr_textbox.Text);
                //MaskLen = Convert.ToByte(maskLen_textBox.Text, 16);
                MaskAdr = HexStringToByteArray((Convert.ToInt32(maskadr_textbox.Text) * 16).ToString("X4"));//dec word
                MaskLen = Convert.ToByte(Convert.ToInt32(maskLen_textBox.Text) * 16);//dec word
                MaskData = HexStringToByteArray(maskData_textBox.Text);
            }
            else
            {
                if (check_selecttag.Checked)
                    str = text_epc.Text;
                else
                    str = "";
                ENum = Convert.ToByte(str.Length / 4);
            }
            byte[] EPC = new byte[ENum * 2];
            EPC = HexStringToByteArray(str);
            if (Edit_AccessCode6.Text.Length != 8)
            {
                return;
            }
            fPassWord = HexStringToByteArray(Edit_AccessCode6.Text);
            if (P_kill.Checked)
                select = 0x00;
            else if (p_pass.Checked)
                select = 0x01;
            else if (P_EPC.Checked)
                select = 0x02;
            else if (P_TID.Checked)
                select = 0x03;
            else if (P_User.Checked)
                select = 0x04;

            if (NoProect2.Checked)
                setprotect = 0x00;
            else if (Proect2.Checked)
                setprotect = 0x02;
            else if (Always2.Checked)
            {
                setprotect = 0x01;
                if (MessageBox.Show(this, "Unlock forever?", "information", MessageBoxButtons.OKCancel) == DialogResult.Cancel)
                    return;
            }
            else if (AlwaysNot2.Checked)
            {
                setprotect = 0x03;
                if (MessageBox.Show(this, "Lock forever?", "information", MessageBoxButtons.OKCancel) == DialogResult.Cancel)
                    return;
            }
            int curIndex = isSelectedTag ? selectedDeviceNo : 0;
            fCmdRet = conn_type == "USB" ?
              RWDev.Lock_G2(ref fComAdr, EPC, ENum, select, setprotect, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, DeviceHandle[curIndex])
              : RWDevGPIO.Lock_G2(ref fComAdr, EPC, ENum, select, setprotect, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, frmcomportindex);
            if (fCmdRet != 0 && this.DeviceNum > 1 && device2_conned)
            {
                fCmdRet = conn_type == "USB" ?
                  RWDev.Lock_G2(ref fComAdr, EPC, ENum, select, setprotect, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, DeviceHandle[1])
                  : RWDevGPIO.Lock_G2(ref fComAdr, EPC, ENum, select, setprotect, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, frmcomportindex);
            }
            if (fCmdRet != 0)
            {

                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Lock failed: " + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Lock failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Lock success ";
                WriteLog(lrtxtLog, strLog, 0);
            }

        }

        private void btDestroyCard_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            string str = "";
            byte ENum;
            byte[] CardData = new byte[320];
            byte MaskMem = 0;
            byte[] MaskAdr = new byte[2];
            byte MaskLen = 0;
            byte[] MaskData = new byte[100];
            if (checkBox1.Checked)
            {
                if ((maskadr_textbox.Text.Length != 4) || (maskLen_textBox.Text.Length != 2) || (maskData_textBox.Text.Length % 2 != 0) && (maskData_textBox.Text.Length == 0))
                {
                    return;
                }
                ENum = 255;
                if (R_EPC.Checked) MaskMem = 1;
                if (R_TID.Checked) MaskMem = 2;
                if (R_User.Checked) MaskMem = 3;
                //MaskAdr = HexStringToByteArray(maskadr_textbox.Text);
                //MaskLen = Convert.ToByte(maskLen_textBox.Text, 16);
                MaskAdr = HexStringToByteArray((Convert.ToInt32(maskadr_textbox.Text) * 16).ToString("X4"));//dec word
                MaskLen = Convert.ToByte(Convert.ToInt32(maskLen_textBox.Text) * 16);//dec word
                MaskData = HexStringToByteArray(maskData_textBox.Text);
            }
            else
            {
                if (check_selecttag.Checked)
                    str = text_epc.Text;
                else
                    str = "";
                ENum = Convert.ToByte(str.Length / 4);
            }
            byte[] EPC = new byte[ENum * 2];
            EPC = HexStringToByteArray(str);
            if (text_DestroyCode.Text.Length != 8)
            {
                return;
            }
            fPassWord = HexStringToByteArray(text_DestroyCode.Text);
            int curIndex = isSelectedTag ? selectedDeviceNo : 0;
            fCmdRet = conn_type == "USB" ?
                RWDev.KillTag_G2(ref fComAdr, EPC, ENum, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, DeviceHandle[curIndex])
                : RWDevGPIO.KillTag_G2(ref fComAdr, EPC, ENum, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, frmcomportindex);
            if (fCmdRet != 0 && this.DeviceNum > 1 && device2_conned)
            {
                fCmdRet = conn_type == "USB" ?
                    RWDev.KillTag_G2(ref fComAdr, EPC, ENum, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, DeviceHandle[1])
                    : RWDevGPIO.KillTag_G2(ref fComAdr, EPC, ENum, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, frmcomportindex);
            }
            if (fCmdRet != 0)
            {

                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Kill tag failed: " + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Kill tag failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Kill tag success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btWriteEPC_G2_Click(object sender, EventArgs e)
        {
            byte[] WriteEPC = new byte[200];
            byte WriteEPClen;
            byte ENum;
            if (text_AccessCode3.Text.Length < 8)
            {
                return;
            }
            if ((text_WriteEPC.Text.Length % 4) != 0 || text_WriteEPC.Text.Length == 0)
            {
                MessageBox.Show("Please input Data in words in hexadecimal form!'+#13+#10+'For example: 1234、12345678", "information");
                return;
            }
            WriteEPClen = Convert.ToByte(text_WriteEPC.Text.Length / 2);
            ENum = Convert.ToByte(text_WriteEPC.Text.Length / 4);
            byte[] EPC = new byte[ENum];
            EPC = HexStringToByteArray(text_WriteEPC.Text);
            fPassWord = HexStringToByteArray(text_AccessCode3.Text);
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.WriteEPC_G2(ref fComAdr, fPassWord, EPC, ENum, ref ferrorcode, DeviceHandle[selectedDeviceNo])
                : RWDevGPIO.WriteEPC_G2(ref fComAdr, fPassWord, EPC, ENum, ref ferrorcode, frmcomportindex);
            if (fCmdRet != 0)
            {

                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Write EPC failed: " + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Write EPC failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                if (comboBox_EPC.Items.IndexOf(text_WriteEPC.Text) == -1)
                    comboBox_EPC.Items.Add(text_WriteEPC.Text);
                string strLog = "Write EPC success ";
                WriteLog(lrtxtLog, strLog, 0);
            }

        }

        private void btSetReadProtect_G2_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            string str = "";
            byte ENum;
            byte MaskMem = 0;
            byte[] MaskAdr = new byte[2];
            byte MaskLen = 0;
            byte[] MaskData = new byte[100];
            if (checkBox1.Checked)
            {
                if (checkBox1.Checked)
                {
                    if ((maskadr_textbox.Text.Length != 4) || (maskLen_textBox.Text.Length != 2) || (maskData_textBox.Text.Length % 2 != 0) && (maskData_textBox.Text.Length == 0))
                    {
                        return;
                    }
                }
                ENum = 255;
                if (R_EPC.Checked) MaskMem = 1;
                if (R_TID.Checked) MaskMem = 2;
                if (R_User.Checked) MaskMem = 3;
                //MaskAdr = HexStringToByteArray(maskadr_textbox.Text);
                //MaskLen = Convert.ToByte(maskLen_textBox.Text, 16);
                MaskAdr = HexStringToByteArray((Convert.ToInt32(maskadr_textbox.Text) * 16).ToString("X4"));//dec word
                MaskLen = Convert.ToByte(Convert.ToInt32(maskLen_textBox.Text) * 16);//dec word
                MaskData = HexStringToByteArray(maskData_textBox.Text);
            }
            else
            {
                if (check_selecttag.Checked)
                    str = text_epc.Text;
                else
                    str = "";
                ENum = Convert.ToByte(str.Length / 4);
            }
            byte[] EPC = new byte[ENum * 2];
            EPC = HexStringToByteArray(str);
            if (text_AccessCode4.Text.Length != 8)
            {
                return;
            }
            fPassWord = HexStringToByteArray(text_AccessCode4.Text);
            int curIndex = isSelectedTag ? selectedDeviceNo : 0;
            fCmdRet = conn_type == "USB" ?
                RWDev.SetPrivacyByEPC_G2(ref fComAdr, EPC, ENum, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, DeviceHandle[curIndex])
                : RWDevGPIO.SetPrivacyByEPC_G2(ref fComAdr, EPC, ENum, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, frmcomportindex);
            if (fCmdRet != 0 && this.DeviceNum > 1 && device2_conned)
            {
                fCmdRet = conn_type == "USB" ?
                    RWDev.SetPrivacyByEPC_G2(ref fComAdr, EPC, ENum, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, DeviceHandle[1])
                    : RWDevGPIO.SetPrivacyByEPC_G2(ref fComAdr, EPC, ENum, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, frmcomportindex);
            }
            if (fCmdRet != 0)
            {

                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Set Privacy by EPC failed:" + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Set Privacy by EPC failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set Privacy by EPC success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btSetMultiReadProtect_G2_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            if (text_AccessCode4.Text.Length != 8)
            {
                return;
            }
            fPassWord = HexStringToByteArray(text_AccessCode4.Text);
            fCmdRet = conn_type == "USB" ?
                RWDev.SetPrivacyWithoutEPC_G2(ref fComAdr, fPassWord, ref ferrorcode, DeviceHandle[selectedDeviceNo])
                : RWDevGPIO.SetPrivacyWithoutEPC_G2(ref fComAdr, fPassWord, ref ferrorcode, frmcomportindex);
            if (fCmdRet != 0)
            {

                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Set privacy without EPC failed: " + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Set privacy without EPC failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set privacy without EPC success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btRemoveReadProtect_G2_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            if (text_AccessCode4.Text.Length != 8)
            {
                return;
            }
            fPassWord = HexStringToByteArray(text_AccessCode4.Text);
            fCmdRet = conn_type == "USB" ?
                RWDev.ResetPrivacy_G2(ref fComAdr, fPassWord, ref ferrorcode, DeviceHandle[selectedDeviceNo])
                : RWDevGPIO.ResetPrivacy_G2(ref fComAdr, fPassWord, ref ferrorcode, frmcomportindex);
            if (fCmdRet != 0)
            {

                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Reset privacy failed: " + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Reset privacy failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Reset privacy success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btCheckReadProtected_G2_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            byte readpro = 2;
            fCmdRet = conn_type == "USB" ?
                RWDev.CheckPrivacy_G2(ref fComAdr, ref readpro, ref ferrorcode, DeviceHandle[selectedDeviceNo])
                : RWDevGPIO.CheckPrivacy_G2(ref fComAdr, ref readpro, ref ferrorcode, frmcomportindex);
            if (fCmdRet != 0)
            {

                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Check privacy failed: " + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Check privacy failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "";
                if (readpro == 0)
                    strLog = " 'Check privacy success'command return=0x00" + "(Single Tag is unprotected)";
                if (readpro == 1)
                    strLog = " 'Check privacy success'command return=0x01" + "(Single Tag is protected)";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btSetEASAlarm_G2_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            byte EAS = 0;
            byte ENum;
            string str = "";
            byte MaskMem = 0;
            byte[] MaskAdr = new byte[2];
            byte MaskLen = 0;
            byte[] MaskData = new byte[100];
            text_WriteData.Text = "";
            if (checkBox1.Checked)
            {
                if ((maskadr_textbox.Text == "") || (maskLen_textBox.Text == "") || (maskData_textBox.Text == ""))
                {
                    return;
                }
                ENum = 255;
                if (R_EPC.Checked) MaskMem = 1;
                if (R_TID.Checked) MaskMem = 2;
                if (R_User.Checked) MaskMem = 3;
                //MaskAdr = HexStringToByteArray(maskadr_textbox.Text);
                //MaskLen = Convert.ToByte(maskLen_textBox.Text, 16);
                MaskAdr = HexStringToByteArray((Convert.ToInt32(maskadr_textbox.Text) * 16).ToString("X4"));//dec word
                MaskLen = Convert.ToByte(Convert.ToInt32(maskLen_textBox.Text) * 16);//dec word
                MaskData = HexStringToByteArray(maskData_textBox.Text);
            }
            else
            {
                if (check_selecttag.Checked)
                    str = text_epc.Text;
                else
                    str = "";
                ENum = Convert.ToByte(str.Length / 4);
            }
            byte[] EPC = new byte[ENum * 2];
            EPC = HexStringToByteArray(str);
            if (text_AccessCode5.Text.Length != 8)
            {
                return;
            }
            fPassWord = HexStringToByteArray(text_AccessCode5.Text);
            if (Alarm_G2.Checked)
                EAS = 1;
            else
                EAS = 0;

            int curIndex = isSelectedTag ? selectedDeviceNo : 0;
            fCmdRet = conn_type == "USB" ?
                RWDev.EASConfigure_G2(ref fComAdr, EPC, ENum, fPassWord, EAS, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, DeviceHandle[curIndex])
                : RWDevGPIO.EASConfigure_G2(ref fComAdr, EPC, ENum, fPassWord, EAS, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, frmcomportindex);
            if (fCmdRet != 0 && this.DeviceNum > 1 && device2_conned)
            {
                fCmdRet = conn_type == "USB" ?
                RWDev.EASConfigure_G2(ref fComAdr, EPC, ENum, fPassWord, EAS, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, DeviceHandle[1])
                : RWDevGPIO.EASConfigure_G2(ref fComAdr, EPC, ENum, fPassWord, EAS, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, frmcomportindex);
            }
            if (fCmdRet != 0)
            {
                string strLog = "EAS Configure failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "";
                if (Alarm_G2.Checked)
                    strLog = " 'EAS Configure' command return=0x00" + "(Set EAS Alarm successfully)";
                else
                    strLog = " 'EAS Configure' command return=0x00" + "(Clear EAS Alarm successfully)";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btCheckEASAlarm_Click(object sender, EventArgs e)
        {
            timer_EAS.Enabled = !timer_EAS.Enabled;
            if (!timer_EAS.Enabled)
            {
                pictureBox2.Visible = false;
                btCheckEASAlarm.Text = "Detect";
                btCheckEASAlarm.BackColor = Color.Transparent;
            }
            else
            {
                fIsInventoryScan = false;
                btCheckEASAlarm.Text = "Stop";
                btCheckEASAlarm.BackColor = Color.Indigo;
            }
        }

        private void timer_EAS_Tick(object sender, EventArgs e)
        {
            if (fIsInventoryScan)
                return;
            fIsInventoryScan = true;
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.EASAlarm_G2(ref fComAdr, ref ferrorcode, DeviceHandle[selectedDeviceNo])
                : RWDevGPIO.EASAlarm_G2(ref fComAdr, ref ferrorcode, frmcomportindex);

            if (fCmdRet != 0)
            {
                string strLog = "Device " + (device1_conned ? "1" : "2") + " No EAS Alarm";
                WriteLog(lrtxtLog, strLog, 1);
                pictureBox2.Visible = false;
            }
            else
            {
                pictureBox2.Visible = true;
                string strLog = "Device " + (device1_conned ? "1" : "2") + " EAS Alarm";
                WriteLog(lrtxtLog, strLog, 0);
            }

            fIsInventoryScan = false;
        }

        private void btInventory6B_Click(object sender, EventArgs e)
        {
            Timer_Test_6B.Enabled = !Timer_Test_6B.Enabled;
            if (!Timer_Test_6B.Enabled)
            {
                btInventory6B.Text = "Start";
                btInventory6B.BackColor = Color.Transparent;
            }
            else
            {
                fisinventoryscan_6B = false;
                ListView_ID_6B.Items.Clear();
                btInventory6B.BackColor = Color.Red;
                btInventory6B.Text = "Stop";
            }
        }
        //public void ChangeSubItem1(ListViewItem ListItem, int subItemIndex, string ItemText, string ant, string RSSI)
        public void ChangeSubItem1(ListViewItem ListItem, int subItemIndex, string ItemText, string ant)
        {
            if (subItemIndex == 1)
            {
                if (ListItem.SubItems[subItemIndex].Text != ItemText)
                {
                    ListItem.SubItems[subItemIndex].Text = ItemText;
                    ListItem.SubItems[subItemIndex + 2].Text = "1";
                    ListItem.SubItems[subItemIndex + 1].Text = ant;
                }
                else
                {
                    ListItem.SubItems[subItemIndex + 2].Text = Convert.ToString(Convert.ToUInt32(ListItem.SubItems[subItemIndex + 2].Text) + 1);
                    if ((Convert.ToUInt32(ListItem.SubItems[subItemIndex + 2].Text) > 9999))
                        ListItem.SubItems[subItemIndex + 2].Text = "1";
                    ListItem.SubItems[subItemIndex + 1].Text = Convert.ToString(Convert.ToInt32(ListItem.SubItems[subItemIndex + 1].Text, 2) | Convert.ToInt32(ant, 2), 2).PadLeft(4, '0');

                }
                //ListItem.SubItems[subItemIndex + 3].Text = RSSI;
            }
        }
        private void Inventory_6B()
        {
            int CardNum = 0;
            byte[] ID_6B = new byte[2000];
            byte[] ID2_6B = new byte[5000];
            bool isonlistview;
            string temps;
            string s, ss, sID;
            ListViewItem aListItem = new ListViewItem();
            int i, j;
            byte Condition = 0;
            byte StartAddress;
            byte mask = 0;
            byte[] ConditionContent = new byte[300];
            byte ant = 0;
            for (int index = 0; index < DeviceNum; index++)
            {
                fComAdr = 0xff;
                if (rb_single.Checked)
                {
                    fCmdRet = conn_type == "USB" ?
                        RWDev.InventorySingle_6B(ref fComAdr, ref ant, ID_6B, DeviceHandle[index])
                        : RWDevGPIO.InventorySingle_6B(ref fComAdr, ref ant, ID_6B, frmcomportindex);
                    if (fCmdRet == 0)
                    {
                        byte[] daw = new byte[10];
                        Array.Copy(ID_6B, daw, 10);
                        temps = ByteArrayToHexString(daw);
                        //string RSSI = daw[9].ToString();
                        temps = temps.Substring(2, 16);

                        if (!list.Contains(temps))
                        {
                            CardNum1 = CardNum1 + 1;
                            list.Add(temps);
                        }
                        string sant = Convert.ToString(ant, 2).PadLeft(4, '0');
                        isonlistview = false;
                        for (i = 0; i < ListView_ID_6B.Items.Count; i++)     //判断是否在ListView列表内
                        {
                            if (temps == ListView_ID_6B.Items[i].SubItems[1].Text)
                            {
                                aListItem = ListView_ID_6B.Items[i];
                                //ChangeSubItem1(aListItem, 1, temps, sant, RSSI);
                                ChangeSubItem1(aListItem, 1, temps, sant);
                                isonlistview = true;
                                break;
                            }
                        }
                        if (!isonlistview)
                        {
                            aListItem = ListView_ID_6B.Items.Add((ListView_ID_6B.Items.Count + 1).ToString());
                            aListItem.SubItems.Add("");
                            aListItem.SubItems.Add("");
                            aListItem.SubItems.Add("");
                            aListItem.SubItems.Add("");
                            aListItem.SubItems.Add("");
                            s = temps;
                            //ChangeSubItem1(aListItem, 1, s, sant, RSSI);
                            ChangeSubItem1(aListItem, 1, s, sant);
                        }
                    }
                }
                if (rb_mutiple.Checked)
                {
                    Condition = 1;
                    ss = "0000000000000000";//4种条件这里选择的是非全0的标签
                    byte[] daw = HexStringToByteArray(ss);
                    mask = 0xFF;
                    StartAddress = 0;
                    CardNum = 0;
                    fCmdRet = conn_type == "USB" ?
                        RWDev.InventoryMultiple_6B(ref fComAdr, Condition, StartAddress, mask, daw, ref ant, ID2_6B, ref CardNum, DeviceHandle[index])
                        : RWDevGPIO.InventoryMultiple_6B(ref fComAdr, Condition, StartAddress, mask, daw, ref ant, ID2_6B, ref CardNum, frmcomportindex);
                    if ((fCmdRet == 0x15) | (fCmdRet == 0x16) | (fCmdRet == 0x17) | (fCmdRet == 0x18) | (fCmdRet == 0xFB))
                    {
                        byte[] daw1 = new byte[CardNum * 10];
                        Array.Copy(ID2_6B, daw1, CardNum * 10);
                        temps = ByteArrayToHexString(daw1);
                        string sant = Convert.ToString(ant, 2).PadLeft(4, '0');
                        for (i = 0; i < CardNum; i++)
                        {
                            sID = temps.Substring(20 * i + 2, 16);
                            //string RSSI = temps.Substring(20 * i + 18, 2);
                            //RSSI = Convert.ToByte(RSSI, 16).ToString();
                            if ((sID.Length) != 16)
                                return;
                            if (CardNum == 0)
                                return;
                            isonlistview = false;
                            for (j = 0; j < ListView_ID_6B.Items.Count; j++)     //判断是否在Listview列表内
                            {
                                if (sID == ListView_ID_6B.Items[j].SubItems[1].Text)
                                {
                                    aListItem = ListView_ID_6B.Items[j];
                                    //ChangeSubItem1(aListItem, 1, sID, sant, RSSI);
                                    ChangeSubItem1(aListItem, 1, sID, sant);
                                    isonlistview = true;
                                    break;
                                }
                            }
                            if (!isonlistview)
                            {
                                aListItem = ListView_ID_6B.Items.Add((ListView_ID_6B.Items.Count + 1).ToString());
                                aListItem.SubItems.Add("");
                                aListItem.SubItems.Add("");
                                aListItem.SubItems.Add("");
                                aListItem.SubItems.Add("");
                                aListItem.SubItems.Add("");
                                s = sID;
                                //ChangeSubItem1(aListItem, 1, s, sant, RSSI);
                                ChangeSubItem1(aListItem, 1, s, sant);
                            }
                        }
                    }
                }

            }
            
            WriteLog(lrtxtLog, "18000-6B Query", 0);
        }
        private void Timer_Test_6B_Tick(object sender, EventArgs e)
        {
            if (fisinventoryscan_6B)
                return;
            fisinventoryscan_6B = true;
            Inventory_6B();
            fisinventoryscan_6B = false;
        }

        private void ListView_ID_6B_DoubleClick(object sender, EventArgs e)
        {
            if (this.ListView_ID_6B.SelectedIndices.Count > 0 && this.ListView_ID_6B.SelectedIndices[0] != -1)
            {
                text_6BUID.Text = ListView_ID_6B.SelectedItems[0].SubItems[1].Text;
            }
        }
        //E004000085D94502
        private void btRead6B_Click(object sender, EventArgs e)
        {
            string temp, temps;
            byte[] CardData = new byte[320];
            byte[] ID_6B = new byte[8];
            byte Num, StartAddress;
            if (text_6BUID.Text == "")
            {
                MessageBox.Show("Select one tag in the list");
                return;
            }
            temp = text_6BUID.Text;
            ID_6B = HexStringToByteArray(temp);
            if (text_R6BAddr.Text == "")
                return;
            StartAddress = Convert.ToByte(text_R6BAddr.Text, 16);
            if (text_R6BLen.Text == "")
                return;
            Num = Convert.ToByte(text_R6BLen.Text, 16);
            for (int i = 0; i < DeviceNum; i++)
            {
                fComAdr = 0xff;
                fCmdRet = conn_type == "USB" ?
                    RWDev.ReadData_6B(ref fComAdr, ID_6B, StartAddress, Num, CardData, ref ferrorcode, DeviceHandle[i])
                    : RWDevGPIO.ReadData_6B(ref fComAdr, ID_6B, StartAddress, Num, CardData, ref ferrorcode, frmcomportindex);
            }

            if (fCmdRet != 0)
            {
                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Read data failed: " + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Read data failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                byte[] data = new byte[Num];
                Array.Copy(CardData, data, Num);
                temps = ByteArrayToHexString(data);
                text_R6B.Text = temps;
                string strLog = "Read data success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btWrite6B_Click(object sender, EventArgs e)
        {
            string temp;
            byte[] CardData = new byte[320];
            byte[] ID_6B = new byte[8];
            byte StartAddress;
            byte Writedatalen;
            int writtenbyte = 0;
            if (text_6BUID.Text == "")
            {
                MessageBox.Show("Select one tag in the list");
                return;
            }
            temp = text_6BUID.Text;
            ID_6B = HexStringToByteArray(temp);
            if (text_W6BAddr.Text == "")
                return;
            StartAddress = Convert.ToByte(text_W6BAddr.Text, 16);
            if (text_W6BLen.Text == "")
                return;
            Writedatalen = Convert.ToByte(text_W6BLen.Text, 16);

            if ((text_W6B.Text == "") | ((text_W6B.Text.Length / 2) != Writedatalen) | ((text_W6B.Text.Length % 2) != 0))
                return;
            byte[] Writedata = new byte[Writedatalen];
            Writedata = HexStringToByteArray(text_W6B.Text);
            for (int i = 0; i < DeviceNum; i++)
            {
                fComAdr = 0xff;
                fCmdRet = conn_type == "USB" ?
                    RWDev.WriteData_6B(ref fComAdr, ID_6B, StartAddress, Writedata, Writedatalen, ref writtenbyte, ref ferrorcode, DeviceHandle[i])
                    : RWDevGPIO.WriteData_6B(ref fComAdr, ID_6B, StartAddress, Writedata, Writedatalen, ref writtenbyte, ref ferrorcode, frmcomportindex);
            }
            if (fCmdRet != 0)
            {
                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Write data failed: " + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Write data failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Write data success ";
                WriteLog(lrtxtLog, strLog, 0);
            }

        }

        private void text_W6BLen_TextChanged(object sender, EventArgs e)
        {
            text_W6B.MaxLength = Convert.ToInt32(text_W6BLen.Text, 16) * 2;
        }

        private void btLock6B_Click(object sender, EventArgs e)
        {
            byte Address;
            string temps;
            byte[] ID_6B = new byte[8];
            if (text_6BUID.Text == "")
            {
                MessageBox.Show("Select one tag in the list");
                return;
            }
            temps = text_6BUID.Text;
            ID_6B = HexStringToByteArray(temps);
            if (text_lock6b.Text == "")
                return;
            Address = Convert.ToByte(text_lock6b.Text, 16);
            if (MessageBox.Show(this, "Lock forever?", "information", MessageBoxButtons.OKCancel) == DialogResult.Cancel)
                return;

            for (int i = 0; i < DeviceNum; i++)
            {
                fComAdr = 0xff;
                fCmdRet = conn_type == "USB" ?
                    RWDev.Lock_6B(ref fComAdr, ID_6B, Address, ref ferrorcode, DeviceHandle[i])
                    : RWDevGPIO.Lock_6B(ref fComAdr, ID_6B, Address, ref ferrorcode, frmcomportindex);
            }
            if (fCmdRet != 0)
            {
                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Lock failed: " + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Lock failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Lock success ";
                WriteLog(lrtxtLog, strLog, 0);
            }

        }

        private void btCheckLock6B_Click(object sender, EventArgs e)
        {
            byte Address, ReLockState = 2;
            string temps;
            byte[] ID_6B = new byte[8];
            if (text_6BUID.Text == "")
            {
                MessageBox.Show("Select one tag in the list");
                return;
            }
            temps = text_6BUID.Text;
            ID_6B = HexStringToByteArray(temps);
            if (text_checkaddr.Text == "")
                return;
            Address = Convert.ToByte(text_checkaddr.Text, 16);

            for (int i = 0; i < DeviceNum; i++)
            {
                fComAdr = 0xff;
                fCmdRet = conn_type == "USB" ?
               RWDev.CheckLock_6B(ref fComAdr, ID_6B, Address, ref ReLockState, ref ferrorcode, DeviceHandle[i])
               : RWDevGPIO.CheckLock_6B(ref fComAdr, ID_6B, Address, ref ReLockState, ref ferrorcode, frmcomportindex);
            }
           
            if (fCmdRet != 0)
            {
                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Detect lock failed: " + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Detect lock failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "";
                if (ReLockState == 0)
                    text_Statu6B.Text = "Unlocked";
                if (ReLockState == 1)
                    text_Statu6B.Text = "Locked";
                strLog = "Detect lock success ";
                WriteLog(lrtxtLog, strLog, 0);
            }

        }



        private void btFlashROM_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            if (MessageBox.Show(this , "Changed to Update Rom mode,if want to restore,need turn off and turn on power,are you sure do that?", "information", MessageBoxButtons.OKCancel) == DialogResult.Cancel)
                return;
            fCmdRet = conn_type == "USB" ?
                RWDev.SetFlashRom(ref fComAdr, DeviceHandle[0])
                : RWDevGPIO.SetFlashRom(ref fComAdr, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Change mode failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Change mode success ";
                WriteLog(lrtxtLog, strLog, 0);
                if (frmcomportindex > 0 && frmcomportindex < 256)
                {
                    btDisConnect232_Click(null, null);
                }
            }
        }

        public static string ByteArrayToHexString2(byte[] data)
        {
            StringBuilder sb = new StringBuilder(data.Length * 3);
            foreach (byte b in data)
                sb.Append(Convert.ToString(b, 16).PadLeft(2, '0').PadLeft(3, ' '));
            return sb.ToString().ToUpper();

        }


        private void com_S_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (com_S.SelectedIndex > 1)
            {
                check_num.Enabled = true;
                text_target.Enabled = true;
            }
            else
            {
                check_num.Enabled = false;
                text_target.Enabled = false;
            }
        }

        private void btExtRead_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            byte ENum;
            byte Num = 0;
            byte Mem = 0;
            byte[] WordPtr = new byte[2];
            string str = ""; ;
            byte[] CardData = new byte[320];
            byte MaskMem = 0;
            byte[] MaskAdr = new byte[2];
            byte MaskLen = 0;
            byte[] MaskData = new byte[100];
            text_WriteData.Text = "";
            if (checkBox1.Checked)
            {
                if ((maskadr_textbox.Text == "") || (maskLen_textBox.Text == "") || (maskData_textBox.Text == ""))
                {
                    return;
                }
                ENum = 255;
                if (R_EPC.Checked) MaskMem = 1;
                if (R_TID.Checked) MaskMem = 2;
                if (R_User.Checked) MaskMem = 3;
                //MaskAdr = HexStringToByteArray(maskadr_textbox.Text);
                //MaskLen = Convert.ToByte(maskLen_textBox.Text, 16);
                MaskAdr = HexStringToByteArray((Convert.ToInt32(maskadr_textbox.Text) * 16).ToString("X4"));//dec word
                MaskLen = Convert.ToByte(Convert.ToInt32(maskLen_textBox.Text) * 16);//dec word
                MaskData = HexStringToByteArray(maskData_textBox.Text);
            }
            else
            {
                if (check_selecttag.Checked)
                    str = text_epc.Text;
                else
                    str = "";
                ENum = Convert.ToByte(str.Length / 4);
            }
            byte[] EPC = new byte[ENum * 2];
            EPC = HexStringToByteArray(str);
            if (C_Reserve.Checked)
                Mem = 0;
            if (C_EPC.Checked)
                Mem = 1;
            if (C_TID.Checked)
                Mem = 2;
            if (C_User.Checked)
                Mem = 3;
            if (text_WordPtr.Text == "" || text_RWlen.Text == "" || text_AccessCode2.Text.Length != 8)
            {
                return;
            }
            //WordPtr = HexStringToByteArray(text_WordPtr.Text);
            WordPtr = HexStringToByteArray(Convert.ToInt32(text_WordPtr.Text).ToString("X4"));//DEC WORD
            Num = Convert.ToByte(text_RWlen.Text);
            fPassWord = HexStringToByteArray(text_AccessCode2.Text);
            for (int p = 0; p < 10; p++)
            {
                fCmdRet = conn_type == "USB" ?
                    RWDev.ExtReadData_G2(ref fComAdr, EPC, ENum, Mem, WordPtr, Num, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, CardData, ref ferrorcode, DeviceHandle[selectedDeviceNo])
                    : RWDevGPIO.ExtReadData_G2(ref fComAdr, EPC, ENum, Mem, WordPtr, Num, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, CardData, ref ferrorcode, frmcomportindex);
                if (fCmdRet == 0) break;
            }
            if (fCmdRet != 0)
            {
                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Extension Read data failed: " + "tag return error =0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Extension Read data failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                byte[] daw = new byte[Num * 2];
                Array.Copy(CardData, daw, Num * 2);
                text_WriteData.Text = ByteArrayToHexString(daw);
                string strLog = "Extension Read data success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btExtWrite_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            byte ENum;
            byte WNum = 0;
            byte Mem = 0;
            byte[] WordPtr = new byte[2];
            string str = "";
            byte[] CardData = new byte[320];
            byte MaskMem = 0;
            byte[] MaskAdr = new byte[2];
            byte MaskLen = 0;
            byte[] MaskData = new byte[100];
            if (checkBox1.Checked)
            {
                if ((maskadr_textbox.Text == "") || (maskLen_textBox.Text == "") || (maskData_textBox.Text == ""))
                {
                    return;
                }
                ENum = 255;
                if (R_EPC.Checked) MaskMem = 1;
                if (R_TID.Checked) MaskMem = 2;
                if (R_User.Checked) MaskMem = 3;
                //MaskAdr = HexStringToByteArray(maskadr_textbox.Text);
                //MaskLen = Convert.ToByte(maskLen_textBox.Text, 16);
                MaskAdr = HexStringToByteArray((Convert.ToInt32(maskadr_textbox.Text) * 16).ToString("X4"));//dec word
                MaskLen = Convert.ToByte(Convert.ToInt32(maskLen_textBox.Text) * 16);//dec word
                MaskData = HexStringToByteArray(maskData_textBox.Text);
            }
            else
            {
                if (check_selecttag.Checked)
                    str = text_epc.Text;
                else
                    str = "";
                ENum = Convert.ToByte(str.Length / 4);
            }
            byte[] EPC = new byte[ENum * 2];
            EPC = HexStringToByteArray(str);
            if (C_Reserve.Checked)
                Mem = 0;
            if (C_EPC.Checked)
                Mem = 1;
            if (C_TID.Checked)
                Mem = 2;
            if (C_User.Checked)
                Mem = 3;
            if (text_WordPtr.Text == "" || text_AccessCode2.Text.Length != 8)
            {
                return;
            }
            string epcstr = text_WriteData.Text;
            if (epcstr.Length % 4 != 0 || epcstr.Length == 0)
            {
                MessageBox.Show("Input data by word.", "Information");
                return;
            }
            WNum = Convert.ToByte(epcstr.Length / 4);
            byte[] Writedata = new byte[WNum * 2 + 1];
            Writedata = HexStringToByteArray(epcstr);
            //WordPtr = HexStringToByteArray(text_WordPtr.Text); 
            WordPtr = HexStringToByteArray(Convert.ToInt32(text_WordPtr.Text).ToString("X4"));//DEC WORD
            fPassWord = HexStringToByteArray(text_AccessCode2.Text);
            if ((checkBox_pc.Checked) && (C_EPC.Checked))
            {
                WordPtr = HexStringToByteArray("0001");
                WNum = Convert.ToByte(epcstr.Length / 4 + 1);
                Writedata = HexStringToByteArray(textBox_pc.Text + epcstr);
            }
            int currentDevieIndex = 0;
            for (int p = 0; p < 10; p++)
            {
                if (isSelectedTag)
                {
                    currentDevieIndex = selectedDeviceNo;
                }
                else if (DeviceNum == 1 || (DeviceNum > 1 && device1_conned && p < 5))
                {
                    currentDevieIndex = 0;
                }
                else if (DeviceNum > 1 && device2_conned && p >= 5)
                {
                    currentDevieIndex = 1;
                }
                fCmdRet = conn_type == "USB" ?
                    RWDev.ExtWriteData_G2(ref fComAdr, EPC, WNum, ENum, Mem, WordPtr, Writedata, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, DeviceHandle[currentDevieIndex])
                    : RWDevGPIO.ExtWriteData_G2(ref fComAdr, EPC, WNum, ENum, Mem, WordPtr, Writedata, fPassWord, MaskMem, MaskAdr, MaskLen, MaskData, ref ferrorcode, frmcomportindex);
                if (fCmdRet == 0) break;
            }
            if (fCmdRet != 0)
            {
                string strLog = "";
                if (fCmdRet == 0xFC)
                    strLog = "Extension Write data failed: " + "tag return error=0x" + Convert.ToString(ferrorcode, 16) + "(" + GetErrorCodeDesc(ferrorcode) + ")";
                else
                    strLog = "Extension Write data failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Extension Write data success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btSetEPCandTIDLen_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            byte SaveLen = 0;
            if (rb128.Checked)
            {
                SaveLen = 0;
            }
            else
            {
                SaveLen = 1;
            }
            fCmdRet = conn_type == "USB" ?
                RWDev.SetSaveLen(ref fComAdr, SaveLen, DeviceHandle[0])
                : RWDevGPIO.SetSaveLen(ref fComAdr, SaveLen, frmcomportindex);
            if (fCmdRet == 0)
            {
                string strLog = "Set buffer EPC/TID length success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
            else
            {
                string strLog = "Set buffer EPC/TID length failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btGetEPCandTIDLen_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            byte SaveLen = 0;
            fCmdRet = conn_type == "USB" ?
                RWDev.GetSaveLen(ref fComAdr, ref SaveLen, DeviceHandle[0])
                : RWDevGPIO.GetSaveLen(ref fComAdr, ref SaveLen, frmcomportindex);
            if (fCmdRet == 0)
            {
                if (SaveLen == 0)
                    rb128.Checked = true;
                else
                    rb496.Checked = true;
                string strLog = "Get buffer EPC/TID length success";
                WriteLog(lrtxtLog, strLog, 0);
            }
            else
            {
                string strLog = "Get buffer EPC/TID length failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btStartBuff_Click(object sender, EventArgs e)
        {
            timer_runmode.Enabled = !timer_runmode.Enabled;
            if (!timer_runmode.Enabled)
            {
                btStartBuff.Text = "Start";
                btStartBuff.BackColor = Color.Transparent;
            }
            else
            {
                fInventory_EPC_List = "";
                TIDFlag = 0;
                total_time = System.Environment.TickCount;
                total_tagnum = 0;
                dataGridView2.Rows.Clear();
                btStartBuff.BackColor = Color.Red;
                fIsInventoryScan = false;
                btStartBuff.Text = "Stop";
            }
        }

        private void btReadBuff_Click(object sender, EventArgs e)
        {
            dataGridView2.Rows.Clear();
            lxLed_Num.Text = "0";
            lxLed_cmdsud.Text = "0";
            lxLed_toltag.Text = "0";
            lxLed_toltime.Text = "0";
            lxLed_cmdTime.Text = "0";
            int devCnt = 0;
            string devNo = "";
            if (DeviceNum == 2 && device1_conned && device2_conned)
            {
                devCnt = 2;

            }
            else if (device1_conned || device2_conned)
            {
                devCnt = 1;
            }

            for (int index = 0; index < devCnt; index++)
            {
                fComAdr = 0xff;
                int Totallen = 0;
                int CardNum = 0;
                byte[] pEPCList = new byte[30000];

                if (device1_conned && index == 0)
                {
                    fCmdRet = conn_type == "USB" ?
                    RWDev.ReadBuffer_G2(ref fComAdr, ref Totallen, ref CardNum, pEPCList, DeviceHandle[index])
                    : RWDevGPIO.ReadBuffer_G2(ref fComAdr, ref Totallen, ref CardNum, pEPCList, frmcomportindex);

                    devNo = "1";

                }
                else if (device2_conned) {
                    int tmp = DeviceNum == 1 ? 0 : 1;
                    fCmdRet = conn_type == "USB" ?
                    RWDev.ReadBuffer_G2(ref fComAdr, ref Totallen, ref CardNum, pEPCList, DeviceHandle[tmp])
                    : RWDevGPIO.ReadBuffer_G2(ref fComAdr, ref Totallen, ref CardNum, pEPCList, frmcomportindex);

                    devNo = "2";
                }

                if (fCmdRet == 1)
                {
                    int m = 0;
                    byte[] daw = new byte[Totallen];
                    Array.Copy(pEPCList, daw, Totallen);
                    for (int i = 0; i < CardNum; i++)
                    {
                        string ant = Convert.ToString(daw[m], 2).PadLeft(4, '0');
                        int len = daw[m + 1];
                        byte[] EPC = new byte[len];
                        Array.Copy(daw, m + 2, EPC, 0, len);
                        string sEPC = ByteArrayToHexString(EPC);
                        //string RSSI = daw[m + 2 + len].ToString();
                        string sCount = daw[m + 3 + len].ToString();
                        m = m + 4 + len;
                        string[] arr = new string[7];
                        arr[0] = (dataGridView2.RowCount + 1).ToString();
                        arr[1] = sEPC;
                        arr[2] = len.ToString();
                        arr[3] = ant;
                        //arr[4] = RSSI;
                        arr[5] = sCount;
                        arr[6] = devNo;
                        dataGridView2.Rows.Insert(dataGridView2.RowCount, arr);
                    }
                    lxLed_Num.Text = dataGridView2.RowCount.ToString();
                    string strLog = "Device " + (index + 1).ToString() + " Read buffer over ";
                    WriteLog(lrtxtLog, strLog, 0);
                }
                else
                {
                    lxLed_Num.Text = dataGridView2.RowCount.ToString();
                    string strLog = "Device " + (index + 1).ToString() + " Read buffer failed";
                    WriteLog(lrtxtLog, strLog, 0);
                }
            }
        }

        private void btClearBuff_Click(object sender, EventArgs e)
        {
            int devCnt = 0;
            if (DeviceNum == 2 && device1_conned && device2_conned)
            {
                devCnt = 2;

            }
            else if (device1_conned || device2_conned)
            {
                devCnt = 1;
            }
            string devNO = "";
            for (int i = 0; i < devCnt; i++)
            {
                fComAdr = 0xff;
                if (device1_conned && i == 0)
                {
                    fCmdRet = conn_type == "USB" ?
                   RWDev.ClearBuffer_G2(ref fComAdr, DeviceHandle[i])
                   : RWDevGPIO.ClearBuffer_G2(ref fComAdr, frmcomportindex);
                    devNO = "1";
                }
                else if (device2_conned)
                {
                    int tmp = DeviceNum == 1 ? 0 : 1;
                    fCmdRet = conn_type == "USB" ?
                   RWDev.ClearBuffer_G2(ref fComAdr, DeviceHandle[tmp])
                   : RWDevGPIO.ClearBuffer_G2(ref fComAdr, frmcomportindex);
                    devNO = "2";
                }
                    
                if (fCmdRet == 0)
                {
                    string strLog = "Device " + devNO + " Clear buffer success ";
                    WriteLog(lrtxtLog, strLog, 0);
                }
                else
                {
                    string strLog = "Device " + devNO + " Clear buffer failed";
                    WriteLog(lrtxtLog, strLog, 0);
                }
            }
        }

        private void btRandCbuff_Click(object sender, EventArgs e)
        {
            btReadBuff_Click(null, null);
            btClearBuff_Click(null, null);
        }

        private void btQueryBuffNum_Click(object sender, EventArgs e)
        {
            int Count = 0;
            lxLed_cmdsud.Text = "0";
            lxLed_cmdTime.Text = "0";
            lxLed_Num.Text = "0";
            lxLed_toltag.Text = "0";
            lxLed_toltime.Text = "0";
            int devCnt = 0;
            if (DeviceNum == 2 && device1_conned && device2_conned)
            {
                devCnt = 2;

            }
            else if (device1_conned || device2_conned)
            {
                devCnt = 1;
            }
            string devNO = "";
            for (int i = 0; i < devCnt; i++)
            {
                fComAdr = 0xff;
                if (device1_conned && i == 0)
                {
                    fCmdRet = conn_type == "USB" ?
                        RWDev.GetBufferCnt_G2(ref fComAdr, ref Count, DeviceHandle[i])
                        : RWDevGPIO.GetBufferCnt_G2(ref fComAdr, ref Count, frmcomportindex);
                    devNO = "1";
                }
                else if (device2_conned) {
                    int tmp = DeviceNum == 1 ? 0 : 1;
                    fCmdRet = conn_type == "USB" ?
                        RWDev.GetBufferCnt_G2(ref fComAdr, ref Count, DeviceHandle[tmp])
                        : RWDevGPIO.GetBufferCnt_G2(ref fComAdr, ref Count, frmcomportindex);
                    devNO = "2";
                }
                    
                if (fCmdRet == 0)
                {
                    lxLed_Num.Text = (int.Parse(lxLed_Num.Text) + Count).ToString();
                    string strLog = "Device " + devNO + " Get buffer tag number success ";
                    WriteLog(lrtxtLog, strLog, 0);
                }
                else
                {
                    string strLog = "Device " + devNO + " Get buffer tag number failed: " + GetReturnCodeDesc(fCmdRet);
                    WriteLog(lrtxtLog, strLog, 0);
                }
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            int Count = 0;
            lxLed_cmdsud.Text = "0";
            lxLed_cmdTime.Text = "0";
            lxLed_Num.Text = "0";
            lxLed_toltag.Text = "0";
            lxLed_toltime.Text = "0";
            //GPIO WU
            for (int index = 0; index < DeviceNum; index++)
            {
                fComAdr = 0xff;
                fCmdRet = RWDev.ChangeToHID(ref fComAdr, DeviceHandle[index]);
                if (fCmdRet == 0)
                {
                    lxLed_Num.Text = Count.ToString();
                    string strLog = "Deveice " + index.ToString() + " Change mode success ";
                    WriteLog(lrtxtLog, strLog, 0);
                }
                else
                {
                    string strLog = "Deveice " + index.ToString() + " Change mode failed";
                    WriteLog(lrtxtLog, strLog, 0);
                }
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            byte Mem = 0;
            byte Adr = 0;
            byte Len = 0;
            byte Enter = 0;
            byte Rpt = 0;
            byte filter = 0;
            if ((textBox1.Text.Trim() == "") || (textBox2.Text.Trim() == ""))
            {
                return;
            }
            if (radioButton1.Checked)
            {
                Mem = 1;
            }
            else if (radioButton2.Checked)
            {
                Mem = 2;
            }
            else
            {
                Mem = 3;
            }
            Adr = Convert.ToByte(textBox1.Text.Trim(), 10);
            Len = Convert.ToByte(textBox2.Text.Trim(), 10);
            if (checkBox2.Checked)
                Enter = 1;
            else
                Enter = 0;

            if (checkBox3.Checked)
                Rpt = 1;
            else
                Rpt = 0;
            filter = (byte)comboBox1.SelectedIndex;
            fComAdr = 0xff;
            fCmdRet = RWDev.SetHidWorkPara(ref fComAdr, Mem, Adr, Len, Enter, Rpt, filter, DeviceHandle[0]);
            if (fCmdRet == 0)
            {
                string strLog = "Set success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
            else
            {
                string strLog = "Set failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            byte Mem = 0;
            byte Adr = 0;
            byte Len = 0;
            byte Enter = 0;
            byte Rpt = 0;
            byte filter = 0;
            fComAdr = 0xff;
            fCmdRet = RWDev.GetHidWorkPara(ref fComAdr, ref Mem, ref Adr, ref Len, ref Enter, ref Rpt, ref filter, DeviceHandle[0]);

            if (fCmdRet == 0)
            {
                if (Mem == 1)
                    radioButton1.Checked = true;
                else if (Mem == 2)
                    radioButton2.Checked = true;
                else
                    radioButton3.Checked = true;
                textBox1.Text = Adr.ToString();
                textBox2.Text = Len.ToString();
                if (Enter == 1)
                    checkBox2.Checked = true;
                else
                    checkBox2.Checked = false;

                if (Rpt == 1)
                    checkBox3.Checked = true;
                else
                    checkBox3.Checked = false;

                comboBox1.SelectedIndex = filter;
                string strLog = "Get success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
            else
            {
                string strLog = "Get failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void radioButton_band5_CheckedChanged(object sender, EventArgs e)
        {
            if (fres_jp.Count == 0)
            {
                int region = 5;
                fres_jp = GetFrequencyByRegion(region);
            }
            ComboBox_dmaxfre.Items.Clear();
            ComboBox_dminfre.Items.Clear();
            foreach (string item in fres_jp)
            {
                ComboBox_dminfre.Items.Add(item);
                ComboBox_dmaxfre.Items.Add(item);
            }
            ComboBox_dmaxfre.SelectedIndex = fres_jp.Count - 1;
            ComboBox_dminfre.SelectedIndex = 0;
        }

        private void button3_Click_1(object sender, EventArgs e)
        {
            byte BeepEn = 0;
            if (radioButton5.Checked)
                BeepEn = 1;
            else
                BeepEn = 0;
            fComAdr = 0xff;
            fCmdRet = RWDev.SetHidBeepEn(ref fComAdr, BeepEn, DeviceHandle[0]);
            if (fCmdRet != 0)
            {
                string strLog = "Set Hid Beep Failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set Hid Beep Success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void maskData_textBox_TextChanged(object sender, EventArgs e)
        {

        }

        /// <summary>
        /// RS232 conn
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnRS323_Click(object sender, EventArgs e)
        {
            conn_type = "RS232";
            int portNum = ComboBox_COM.SelectedIndex + 1;
            int FrmPortIndex = 0;
            string strException = string.Empty;
            fBaud = Convert.ToByte(ComboBox_baud2.SelectedIndex);
            if (fBaud > 2)
                fBaud = Convert.ToByte(fBaud + 2);
            fComAdr = 255;//广播地址打开设备
            fCmdRet = RWDevGPIO.OpenComPort(portNum, ref fComAdr, fBaud, ref FrmPortIndex);
            if (fCmdRet != 0)
            {
                string strLog = "Connect failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
                return;
            }
            else
            {
                frmcomportindex = FrmPortIndex;
                string strLog = "Connected " + ComboBox_COM.Text + "@" + ComboBox_baud2.Text;
                WriteLog(lrtxtLog, strLog, 0);
            }

            //处理界面元素是否有效
            gpb_rs232.Enabled = false;
            EnabledForm();
            btnRS232.Enabled = false;
            btnDisRS232.Enabled = true;

            //设置按钮字体颜色
            btnRS232.ForeColor = Color.Black;
            btnDisRS232.ForeColor = Color.Indigo;
            SetButtonBold(btnRS232);
            SetButtonBold(btnDisRS232);
            RWDevGPIO.SetBeepNotification(ref fComAdr, 0, FrmPortIndex);
            btGetInformation_Click(null, null);//获取读写器信息

        }

        /// <summary>
        /// RS232 disconn
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnDisRS232_Click(object sender, EventArgs e)
        {
            if (frmcomportindex > 0)
                fCmdRet = RWDevGPIO.CloseSpecComPort(frmcomportindex);
            if (fCmdRet == 0) frmcomportindex = -1;
            DisabledForm();

            btnRS232.Enabled = true;
            btnDisRS232.Enabled = false;
            gpb_rs232.Enabled = true;

            btnRS232.ForeColor = Color.Indigo;
            btnDisRS232.ForeColor = Color.Black;
            SetButtonBold(btnRS232);
            SetButtonBold(btnDisRS232);
            ClearFresList();
        }

        private void btConnect232_2_Click(object sender, EventArgs e)
        {
            conn_type = "USB";
            if (device2_conned == false)
            {
                fCmdRet = RWDev.GetDeviceList(DeviceHandle, ref DeviceNum);
                if (fCmdRet != 0)
                {
                    string strLog = "Connect failed: " + GetReturnCodeDesc(fCmdRet);
                    WriteLog(lrtxtLog, strLog, 1);
                    return;
                }
                else if(DeviceNum < 2) {
                    string strLog = "Device 2 not found. ";
                    WriteLog(lrtxtLog, strLog, 0);
                }
                
            }
            if (DeviceNum >= 2 || (DeviceNum >= 1 && device1_conned == false))
            {
                string strLog = "Device 2 Connected ";
                WriteLog(lrtxtLog, strLog, 0);

                //处理界面元素是否有效
                EnabledForm2();
                gbRS232_2.Enabled = false;
                btConnect232_2.Enabled = false;
                btDisConnect232_2.Enabled = true;
                //设置按钮字体颜色
                btConnect232_2.ForeColor = Color.Black;
                btDisConnect232_2.ForeColor = Color.Indigo;
                SetButtonBold(btConnect232_2);
                SetButtonBold(btDisConnect232_2);
                fComAdr = 0xff;
                int ret = RWDev.SetBeepNotification(ref fComAdr, 0, DeviceHandle[DeviceNum < 2 ? 0 : 1]);
                btGetInformation_2_Click(null, null);//获取读写器信息
                device2_conned = true;
            }
        }
    

        private void btDisConnect232_2_Click(object sender, EventArgs e)
        {
            if (device2_conned) {

                if (DeviceHandle.Length > 1)
                {
                    fCmdRet = RWDev.CloseUSBPort(DeviceHandle[DeviceNum < 2 ? 0 : 1]);
                }
                else {
                    fCmdRet = RWDev.CloseUSBPort(DeviceHandle[0]);
                }

            }
                
            if (fCmdRet == 0) device2_conned = false;
            DisabledForm2();
            btConnect232_2.Enabled = true;
            gbRS232_2.Enabled = true;
            btDisConnect232_2.Enabled = false;

            btConnect232_2.ForeColor = Color.Indigo;
            btDisConnect232_2.ForeColor = Color.Black;
            SetButtonBold(btConnect232_2);
            SetButtonBold(btDisConnect232_2);
            if (!btDisConnect232.Enabled)
            {
                ClearFresList();
            }
        }

        private void btnRS232_2_Click(object sender, EventArgs e)
        {

        }

        private void btnDisRS232_2_Click(object sender, EventArgs e)
        {

        }

        private void btaddress_2_Click(object sender, EventArgs e)
        {
            fComAdr = 0xff;
            byte aNewComAdr = Convert.ToByte(text_address_2.Text, 16);
            fCmdRet = conn_type == "USB" ?
                RWDev.SetAddress(ref fComAdr, aNewComAdr, DeviceHandle[DeviceNum < 2 ? 0 : 1])
                : RWDevGPIO.SetAddress(ref fComAdr, aNewComAdr, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set address failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set address access ";
                WriteLog(lrtxtLog, strLog, 0);
            }
            fComAdr = 0xff;
            btGetInformation_2_Click(null, null);
        }

        private void btSerial_2_Click(object sender, EventArgs e)
        {
            byte[] SeriaNo = new byte[4];
            text_Serial_2.Text = "";
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.GetSeriaNo(ref fComAdr, SeriaNo, DeviceHandle[DeviceNum < 2 ? 0 : 1])
                : RWDevGPIO.GetSeriaNo(ref fComAdr, SeriaNo, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Reader serial number failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                text_Serial_2.Text = ByteArrayToHexString(SeriaNo);
                string strLog = "Reader serial number success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void Button_Beep_2_Click(object sender, EventArgs e)
        {
            byte BeepEn = 0;
            if (Radio_beepEn_2.Checked)
                BeepEn = 1;
            else
                BeepEn = 0;

            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.SetBeepNotification(ref fComAdr, BeepEn, DeviceHandle[DeviceNum < 2 ? 0 : 1])
                : RWDevGPIO.SetBeepNotification(ref fComAdr, BeepEn, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set beep failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set beep success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void Button_SetGPIO_2_Click(object sender, EventArgs e)
        {

            byte OutputPin = 0;
            if (check_out1_2.Checked)
                OutputPin = Convert.ToByte(OutputPin | 0x01);
            if (check_out2_2.Checked)
                OutputPin = Convert.ToByte(OutputPin | 0x02);

            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.SetGPIO(ref fComAdr, OutputPin, DeviceHandle[DeviceNum < 2 ? 0 : 1])
                : RWDevGPIO.SetGPIO(ref fComAdr, OutputPin, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set GPIO failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set GPIO success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void Button_GetGPIO_2_Click(object sender, EventArgs e)
        {
            byte OutputPin = 0;
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.GetGPIOStatus(ref fComAdr, ref OutputPin, DeviceHandle[DeviceNum < 2 ? 0 : 1])
                : RWDevGPIO.GetGPIOStatus(ref fComAdr, ref OutputPin, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Get GPIO status failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                if ((OutputPin & 0x10) == 0x10)
                    check_out1_2.Checked = true;
                else
                    check_out1_2.Checked = false;

                if ((OutputPin & 0x20) == 0x20)
                    check_out2_2.Checked = true;
                else
                    check_out2_2.Checked = false;

                if ((OutputPin & 0x01) == 1)
                    check_int1_2.Checked = true;
                else
                    check_int1_2.Checked = false;

                if ((OutputPin & 0x02) == 2)
                    check_int2_2.Checked = true;
                else
                    check_int2_2.Checked = false;

                string strLog = "Get GPIO status success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void BT_DBM_2_Click(object sender, EventArgs e)
        {
            byte powerDbm = (byte)ComboBox_PowerDbm_2.SelectedIndex;
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.SetRfPower(ref fComAdr, powerDbm, DeviceHandle[DeviceNum < 2 ? 0 : 1])
                : RWDevGPIO.SetRfPower(ref fComAdr, powerDbm, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set power failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set power success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btFreq_2_Click(object sender, EventArgs e)
        {
            int band = 0;
            if (radioButton_band1_2.Checked)
                band = 1;
            if (radioButton_band2_2.Checked)
                band = 2;
            if (radioButton_band3_2.Checked)
                band = 3;
            if (radioButton_band4_2.Checked)
                band = 4;
            if (radioButton_band5_2.Checked)
                band = 5;
            fComAdr = 0xff;
            if (conn_type == "USB")
            {
                fCmdRet = RWDev.SetRegionAndChannel(ref fComAdr, band, ComboBox_dminfre_2.SelectedIndex, ComboBox_dmaxfre_2.SelectedIndex, DeviceHandle[DeviceNum < 2 ? 0 : 1]);
            }
            else
            {
                fCmdRet = RWDevGPIO.SetRegionAndChannel(ref fComAdr, band, ComboBox_dminfre_2.SelectedIndex, ComboBox_dmaxfre_2.SelectedIndex, frmcomportindex);
            }
            if (fCmdRet != 0)
            {
                string strLog = "Set Region failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set Region success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btBaudRate_2_Click(object sender, EventArgs e)
        {
            byte fBaud = (byte)ComboBox_baud_2.SelectedIndex;
            if (fBaud > 2)
                fBaud = (byte)(fBaud + 2);
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.SetBaudRate(ref fComAdr, fBaud, DeviceHandle[DeviceNum < 2 ? 0 : 1])
                : RWDevGPIO.SetBaudRate(ref fComAdr, fBaud, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set baud rate failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set baud rate success ";
                WriteLog(lrtxtLog, strLog, 0);
            }

        }

        private void btDefault_2_Click(object sender, EventArgs e)
        {
            byte aNewComAdr, powerDbm, dminfre, dmaxfre, scantime;
            dminfre = 64;
            dmaxfre = 19;
            aNewComAdr = 0x00;
            powerDbm = 24;
            fBaud = 5;
            scantime = 10;
            ComboBox_baud_2.SelectedIndex = 3;
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.SetAddress(ref fComAdr, aNewComAdr, DeviceHandle[DeviceNum < 2 ? 0 : 1])
                : RWDevGPIO.SetAddress(ref fComAdr, aNewComAdr, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set address failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set address access ";
                WriteLog(lrtxtLog, strLog, 0);
            }

            fCmdRet = conn_type == "USB" ?
               RWDev.SetRfPower(ref fComAdr, powerDbm, DeviceHandle[DeviceNum < 2 ? 0 : 1])
               : RWDevGPIO.SetRfPower(ref fComAdr, powerDbm, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set power failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set power success ";
                WriteLog(lrtxtLog, strLog, 0);
            }

            fCmdRet = conn_type == "USB" ?
               RWDev.SetRegion(ref fComAdr, dmaxfre, dminfre, DeviceHandle[DeviceNum < 2 ? 0 : 1])
               : RWDevGPIO.SetRegion(ref fComAdr, dmaxfre, dminfre, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set Region failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set Region success ";
                WriteLog(lrtxtLog, strLog, 0);
            }

            fCmdRet = conn_type == "USB" ?
               RWDev.SetBaudRate(ref fComAdr, fBaud, DeviceHandle[DeviceNum < 2 ? 0 : 1])
               : RWDevGPIO.SetBaudRate(ref fComAdr, fBaud, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set baud rate failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set baud rate success ";
                WriteLog(lrtxtLog, strLog, 0);
            }

            fCmdRet = conn_type == "USB" ?
               RWDev.SetInventoryScanTime(ref fComAdr, scantime, DeviceHandle[DeviceNum < 2 ? 0 : 1])
               : RWDevGPIO.SetInventoryScanTime(ref fComAdr, scantime, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Set max inventory time failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set max inventory time success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
            btGetInformation_2_Click(null, null);
        }

        private void btGetInformation_2_Click(object sender, EventArgs e)
        {

            byte TrType = 0;
            byte[] VersionInfo = new byte[2];
            byte ReaderType = 0;
            byte ScanTime = 0;
            byte dmaxfre = 0;
            byte dminfre = 0;
            byte powerdBm = 0;
            byte FreBand = 0;
            byte Ant = 0;
            byte BeepEn = 0;
            byte OutputRep = 0;
            byte CheckAnt = 0;
            text_RDVersion_2.Text = "";
            int ctime = System.Environment.TickCount;
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.GetReaderInformation(ref fComAdr, VersionInfo, ref ReaderType, ref TrType, ref dmaxfre, ref dminfre, ref powerdBm, ref ScanTime, ref Ant, ref BeepEn, ref OutputRep, ref CheckAnt, DeviceHandle[DeviceNum < 2 ? 0 : 1])
                : RWDevGPIO.GetReaderInformation(ref fComAdr, VersionInfo, ref ReaderType, ref TrType, ref dmaxfre, ref dminfre, ref powerdBm, ref ScanTime, ref Ant, ref BeepEn, ref OutputRep, ref CheckAnt, frmcomportindex);
            if (fCmdRet != 0)
            {
                string strLog = "Get Reader Information failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                CommunicationTime = System.Environment.TickCount - ctime;
                text_RDVersion_2.Text = Convert.ToString(VersionInfo[0], 10).PadLeft(2, '0') + "." + Convert.ToString(VersionInfo[1], 10).PadLeft(2, '0');
                if (powerdBm > 24)
                {
                    powerdBm = 24;
                    fCmdRet = conn_type == "USB" ?
                        RWDev.SetRfPower(ref fComAdr, 24, DeviceHandle[DeviceNum < 2 ? 0 : 1])
                        : RWDevGPIO.SetRfPower(ref fComAdr, 24, frmcomportindex);
                }
                ComboBox_PowerDbm_2.SelectedIndex = Convert.ToInt32(powerdBm);
                text_address_2.Text = Convert.ToString(fComAdr, 16).PadLeft(2, '0');
                FreBand = Convert.ToByte(((dmaxfre & 0xc0) >> 4) | (dminfre >> 6));
                switch (FreBand)
                {
                    case 1:
                        {
                            radioButton_band1_2.Checked = true;
                            ComboBox_dminfre_2.SelectedIndex = dminfre & 0x3F;
                            ComboBox_dmaxfre_2.SelectedIndex = dmaxfre & 0x3F;
                        }
                        break;
                    case 2:
                        {
                            if (((dminfre & 0x03F) >= 26) && ((dmaxfre & 0x03F) <= 44))
                            {
                                radioButton_band5_2.Checked = true;
                                ComboBox_dminfre_2.SelectedIndex = ((dminfre & 0x3F) - 26);
                                ComboBox_dmaxfre_2.SelectedIndex = ((dmaxfre & 0x3F) - 26);
                            }
                            else
                            {
                                radioButton_band2_2.Checked = true;
                                ComboBox_dminfre_2.SelectedIndex = dminfre & 0x3F;
                                ComboBox_dmaxfre_2.SelectedIndex = dmaxfre & 0x3F;
                            }

                        }
                        break;
                    case 3:
                        {
                            radioButton_band3_2.Checked = true;
                            ComboBox_dminfre_2.SelectedIndex = dminfre & 0x3F;
                            ComboBox_dmaxfre_2.SelectedIndex = dmaxfre & 0x3F;
                        }
                        break;
                    case 4:
                        {
                            radioButton_band4_2.Checked = true;
                            ComboBox_dminfre_2.SelectedIndex = dminfre & 0x3F;
                            ComboBox_dmaxfre_2.SelectedIndex = dmaxfre & 0x3F;
                        }
                        break;
                }
                if (fdmaxfre != fdminfre)
                    CheckBox_SameFre_2.Checked = false;

                switch (BeepEn)
                {
                    case 1:
                        Radio_beepEn_2.Checked = true;
                        break;
                    case 0:
                        Radio_beepDis_2.Checked = true;
                        break;
                }

                string strLog = "Get Reader Information success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btSetEPCandTIDLen_2_Click(object sender, EventArgs e)
        {

            byte SaveLen = 0;
            if (rb128_2.Checked)
            {
                SaveLen = 0;
            }
            else
            {
                SaveLen = 1;
            }

            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.SetSaveLen(ref fComAdr, SaveLen, DeviceHandle[DeviceNum < 2 ? 0 : 1])
                : RWDevGPIO.SetSaveLen(ref fComAdr, SaveLen, frmcomportindex);
            if (fCmdRet == 0)
            {
                string strLog = "Set buffer EPC/TID length success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
            else
            {
                string strLog = "Set buffer EPC/TID length failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btGetEPCandTIDLen_2_Click(object sender, EventArgs e)
        {
            byte SaveLen = 0;
            fComAdr = 0xff;
            fCmdRet = conn_type == "USB" ?
                RWDev.GetSaveLen(ref fComAdr, ref SaveLen, DeviceHandle[DeviceNum < 2 ? 0 : 1])
                : RWDevGPIO.GetSaveLen(ref fComAdr, ref SaveLen, frmcomportindex);
            if (fCmdRet == 0)
            {
                if (SaveLen == 0)
                    rb128_2.Checked = true;
                else
                    rb496_2.Checked = true;
                string strLog = "Get buffer EPC/TID length success";
                WriteLog(lrtxtLog, strLog, 0);
            }
            else
            {
                string strLog = "Get buffer EPC/TID length failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btnSetWkParam_2_Click(object sender, EventArgs e)
        {
            byte Mem = 0;
            byte Adr = 0;
            byte Len = 0;
            byte Enter = 0;
            byte Rpt = 0;
            byte filter = 0;
            if ((txtStartAddr_2.Text.Trim() == "") || (txtEndAddr_2.Text.Trim() == ""))
            {
                return;
            }
            if (rbEPC_2.Checked)
            {
                Mem = 1;
            }
            else if (rbTID_2.Checked)
            {
                Mem = 2;
            }
            else
            {
                Mem = 3;
            }
            Adr = Convert.ToByte(txtStartAddr_2.Text.Trim(), 10);
            Len = Convert.ToByte(txtEndAddr_2.Text.Trim(), 10);
            if (cbParam1_2.Checked)
                Enter = 1;
            else
                Enter = 0;

            if (cbParam2_2.Checked)
                Rpt = 1;
            else
                Rpt = 0;
            filter = (byte)cmbFilterTime_2.SelectedIndex;
            fComAdr = 0xff;
            fCmdRet = RWDev.SetHidWorkPara(ref fComAdr, Mem, Adr, Len, Enter, Rpt, filter, DeviceHandle[DeviceNum < 2 ? 0 : 1]);
            if (fCmdRet == 0)
            {
                string strLog = "Set success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
            else
            {
                string strLog = "Set failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btnGetWkParam_2_Click(object sender, EventArgs e)
        {
            byte Mem = 0;
            byte Adr = 0;
            byte Len = 0;
            byte Enter = 0;
            byte Rpt = 0;
            byte filter = 0;
            fComAdr = 0xff;
            fCmdRet = RWDev.GetHidWorkPara(ref fComAdr, ref Mem, ref Adr, ref Len, ref Enter, ref Rpt, ref filter, DeviceHandle[DeviceNum < 2 ? 0 : 1]);

            if (fCmdRet == 0)
            {
                if (Mem == 1)
                    rbEPC_2.Checked = true;
                else if (Mem == 2)
                    rbTID_2.Checked = true;
                else
                    rbUser_2.Checked = true;
                txtStartAddr_2.Text = Adr.ToString();
                txtEndAddr_2.Text = Len.ToString();
                if (Enter == 1)
                    rbTID_2.Checked = true;
                else
                    rbTID_2.Checked = false;

                if (Rpt == 1)
                    rbUser_2.Checked = true;
                else
                    rbUser_2.Checked = false;

                cmbFilterTime_2.SelectedIndex = filter;
                string strLog = "Get success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
            else
            {
                string strLog = "Get failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btnSetBeep_Click(object sender, EventArgs e)
        {
            byte BeepEn = 0;
            if (rbBeepOpen_2.Checked)
                BeepEn = 1;
            else
                BeepEn = 0;

            fComAdr = 0xff;
            fCmdRet = RWDev.SetHidBeepEn(ref fComAdr, BeepEn, DeviceHandle[DeviceNum < 2 ? 0 : 1]);
            if (fCmdRet != 0)
            {
                string strLog = "Set Hid Beep Failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                string strLog = "Set Hid Beep Success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void radioButton_band1_2_CheckedChanged(object sender, EventArgs e)
        {
            if (fres_ch.Count == 0)
            {
                int region = 1;
                fres_ch = GetFrequencyByRegion(region);
            }
            ComboBox_dminfre_2.Items.Clear();
            ComboBox_dmaxfre_2.Items.Clear();
            foreach (string item in fres_ch)
            {
                ComboBox_dminfre_2.Items.Add(item);
                ComboBox_dmaxfre_2.Items.Add(item);
            }
            ComboBox_dmaxfre_2.SelectedIndex = fres_ch.Count - 1;
            ComboBox_dminfre_2.SelectedIndex = 0;
        }

        private void radioButton_band2_2_CheckedChanged(object sender, EventArgs e)
        {
            if (fres_us.Count == 0)
            {
                int region = 2;
                fres_us = GetFrequencyByRegion(region);
            }
            ComboBox_dmaxfre_2.Items.Clear();
            ComboBox_dminfre_2.Items.Clear();
            foreach (string item in fres_us)
            {
                ComboBox_dminfre_2.Items.Add(item);
                ComboBox_dmaxfre_2.Items.Add(item);
            }
            ComboBox_dmaxfre_2.SelectedIndex = fres_us.Count - 1;
            ComboBox_dminfre_2.SelectedIndex = 0;
        }

        private void radioButton_band3_2_CheckedChanged(object sender, EventArgs e)
        {
            if (fres_korea.Count == 0)
            {
                int region = 3;
                fres_korea = GetFrequencyByRegion(region);
            }
            ComboBox_dmaxfre_2.Items.Clear();
            ComboBox_dminfre_2.Items.Clear();
            foreach (string item in fres_korea)
            {
                ComboBox_dminfre_2.Items.Add(item);
                ComboBox_dmaxfre_2.Items.Add(item);
            }
            ComboBox_dmaxfre_2.SelectedIndex = fres_korea.Count - 1;
            ComboBox_dminfre_2.SelectedIndex = 0;
        }

        private void radioButton_band4_2_CheckedChanged(object sender, EventArgs e)
        {
            if (fres_eu.Count == 0)
            {
                int region = 4;
                fres_eu = GetFrequencyByRegion(region);
            }
            ComboBox_dmaxfre_2.Items.Clear();
            ComboBox_dminfre_2.Items.Clear();
            foreach (string item in fres_eu)
            {
                ComboBox_dminfre_2.Items.Add(item);
                ComboBox_dmaxfre_2.Items.Add(item);
            }
            ComboBox_dmaxfre_2.SelectedIndex = fres_eu.Count - 1;
            ComboBox_dminfre_2.SelectedIndex = 0;
        }

        private void radioButton_band5_2_CheckedChanged(object sender, EventArgs e)
        {
            if (fres_jp.Count == 0)
            {
                int region = 5;
                fres_jp = GetFrequencyByRegion(region);
            }
            ComboBox_dmaxfre_2.Items.Clear();
            ComboBox_dminfre_2.Items.Clear();
            foreach (string item in fres_jp)
            {
                ComboBox_dminfre_2.Items.Add(item);
                ComboBox_dmaxfre_2.Items.Add(item);
            }
            ComboBox_dmaxfre_2.SelectedIndex = fres_jp.Count - 1;
            ComboBox_dminfre_2.SelectedIndex = 0;
        }

        private ArrayList GetFrequencyByRegion(int region)
        {
            IntPtr[] fres = new IntPtr[100];
            ArrayList fre_list = new ArrayList();
            var ret = RWDev.GetChannelList(region, fres);
            foreach (var item in fres)
            {
                if (item.ToString() != "" && item.ToString() != "0")
                {
                    fre_list.Add(System.Runtime.InteropServices.Marshal.PtrToStringAnsi(item));
                }
                else
                {
                    break;
                }
            }
            return fre_list;
        }

        private void btnSetRegionDefault_Click(object sender, EventArgs e)
        {
            int band = 0;
            if (radioButton_band1.Checked)
                band = 1;
            if (radioButton_band2.Checked)
                band = 2;
            if (radioButton_band3.Checked)
                band = 3;
            if (radioButton_band4.Checked)
                band = 4;
            if (radioButton_band5.Checked)
                band = 5;
            fComAdr = 0xff;
            if (conn_type == "USB")
            {
                fCmdRet = RWDev.SetRegionWithDefaultChannel(ref fComAdr, band, DeviceHandle[0]);
            }
            else
            {
                fCmdRet = RWDevGPIO.SetRegionWithDefaultChannel(ref fComAdr, band, frmcomportindex);
            }
            if (fCmdRet != 0)
            {
                string strLog = "Set Region failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                ComboBox_dminfre.SelectedIndex = 0;
                ComboBox_dmaxfre.SelectedIndex = ComboBox_dmaxfre.Items.Count - 1;
                CheckBox_SameFre.Checked = false;
                string strLog = "Set Region success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void btnSetRehionDefault_2_Click(object sender, EventArgs e)
        {
            int band = 0;
            if (radioButton_band1_2.Checked)
                band = 1;
            if (radioButton_band2_2.Checked)
                band = 2;
            if (radioButton_band3_2.Checked)
                band = 3;
            if (radioButton_band4_2.Checked)
                band = 4;
            if (radioButton_band5_2.Checked)
                band = 5;
            fComAdr = 0xff;
            if (conn_type == "USB")
            {
                fCmdRet = RWDev.SetRegionWithDefaultChannel(ref fComAdr, band, DeviceHandle[DeviceNum < 2 ? 0 : 1]);
            }
            else
            {
                fCmdRet = RWDevGPIO.SetRegionWithDefaultChannel(ref fComAdr, band, frmcomportindex);
            }
            if (fCmdRet != 0)
            {
                string strLog = "Set Region failed: " + GetReturnCodeDesc(fCmdRet);
                WriteLog(lrtxtLog, strLog, 1);
            }
            else
            {
                ComboBox_dminfre_2.SelectedIndex = 0;
                ComboBox_dmaxfre_2.SelectedIndex = ComboBox_dmaxfre_2.Items.Count - 1;
                CheckBox_SameFre_2.Checked = false;
                string strLog = "Set Region success ";
                WriteLog(lrtxtLog, strLog, 0);
            }
        }

        private void CheckBox_SameFre_2_Click(object sender, EventArgs e)
        {
            if (CheckBox_SameFre_2.Checked)
                ComboBox_dmaxfre_2.SelectedIndex = ComboBox_dminfre_2.SelectedIndex;
        }

        private void check_selecttag_CheckedChanged(object sender, EventArgs e)
        {
            if (check_selecttag.Checked)
            {
                checkBox1.Checked = false;
                isSelectedTag = true;
            }

        }
    }
}
