﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace AsReaderP3xU_Demo
{
    public partial class PasswordPopup : Form
    {
        public event EventHandler<bool> ClosePasswordWindow;
        public PasswordPopup()
        {
            InitializeComponent();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
            ClosePasswordWindow?.Invoke(this, false);
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (txtPwd.Text.Trim() == "")
            {
                MessageBox.Show("Please input the password.", "Warning", MessageBoxButtons.OK);
                return;
            }
            if (txtPwd.Text.Trim() != Properties.Settings.Default.DebugPwd)
            {
                MessageBox.Show("The password is incorrect,please try again.", "Warning", MessageBoxButtons.OK);
                return;
            }
            ClosePasswordWindow?.Invoke(this, true);
            this.Close();
        }
    }
}
