﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO.Ports;
using System.Collections;
using AsReaderP3xU;
using System.Data;
using System.ComponentModel;
using System.IO;
using System.Net;
using System.Configuration;

namespace AsReaderP3xU_Demo
{
    struct Auto_Inventory
    {
        public int Enable;
        public int Mon;
        public int Tues;
        public int Wed;
        public int Thurs;
        public int Fri;
        public int Sat;
        public int Sun;
        public string StartTime;
        public string EndTime;
    }
    class Device
    {
        private AsReader asreader = new AsReader();
        public delegate void CallBackResultTagData(AsReader.InventoryResult data);
        public delegate void CallBackResultError(uint error);
        public delegate void CallBackResultSuccess(uint error);
        public delegate void CallBackResultReadComplete(bool completeStatus);
        public delegate void CallBackResultTriggerHandler(int triggerHandler);
        public CallBackResultTagData callBackResultTagData = null;
        public CallBackResultError callBackResultError = null;
        public CallBackResultSuccess callBackResultSuccess = null;
        public CallBackResultReadComplete callBackResultReadComplete = null;
        public CallBackResultTriggerHandler callBackTriggerHandler = null;

        public string fwURL = "https://camera.asreaderapps.com/mrxapp/MRX-D3Fw/fw/";
        public string fwXmlName = "P35U.xml";
        public string rfidFwURL = "https://apps.asreaderapps.com/mrxapp/MRX-D3Fw/RFIDfw/";
        public string rfidFwXmlName = "P3xURFIDModule.xml";
        public string firmwareFolderNmae = "FirmwareFile";
        public string hwVer = null;
        byte[] FileData;
        private readonly ArrayList resultDataList = new ArrayList();


        static Dictionary<Types.ActionType, string> dicAction = new Dictionary<Types.ActionType, string>{
            { Types.ActionType.ACTION_ASLINVA_DSLINVB, "ASLINVA_DSLINVB" },
            { Types.ActionType.ACTION_ASLINVA_NOTHING,"ASLINVA_NOTHING" },
            { Types.ActionType.ACTION_DSLINVB_ASLINVA,"DSLINVB_ASLINVA" },
            { Types.ActionType.ACTION_DSLINVB_NOTHING,"DSLINVB_NOTHING" },
            { Types.ActionType.ACTION_NOTHING_ASLINVA,"NOTHING_ASLINVA" },
            { Types.ActionType.ACTION_NOTHING_DSLINVB,"NOTHING_DSLINVB" },
            { Types.ActionType.ACTION_NOTHING_NSLINVS,"NOTHING_NSLINVS" },
            { Types.ActionType.ACTION_NSLINVS_NOTHING,"NSLINVS_NOTHING" },
        };

        static Dictionary<Types.ChinaChannelType, string> dicChinaChannel = new Dictionary<Types.ChinaChannelType, string>{
            { Types.ChinaChannelType.CHANNEL_1,"CHANNEL_1" },
            { Types.ChinaChannelType.CHANNEL_2,"CHANNEL_2" },
            { Types.ChinaChannelType.CHANNEL_3,"CHANNEL_3" },
            { Types.ChinaChannelType.CHANNEL_4,"CHANNEL_4" },
            { Types.ChinaChannelType.CHANNEL_5,"CHANNEL_5" },
            { Types.ChinaChannelType.CHANNEL_6,"CHANNEL_6" },
            { Types.ChinaChannelType.CHANNEL_7,"CHANNEL_7" },
            { Types.ChinaChannelType.CHANNEL_8,"CHANNEL_8" },
            { Types.ChinaChannelType.CHANNEL_9,"CHANNEL_9" },
            { Types.ChinaChannelType.CHANNEL_10,"CHANNEL_10" },
            { Types.ChinaChannelType.CHANNEL_11,"CHANNEL_11" },
            { Types.ChinaChannelType.CHANNEL_12,"CHANNEL_12" },
            { Types.ChinaChannelType.CHANNEL_13,"CHANNEL_13" },
            { Types.ChinaChannelType.CHANNEL_14,"CHANNEL_14" },
            { Types.ChinaChannelType.CHANNEL_15,"CHANNEL_15" },
            { Types.ChinaChannelType.CHANNEL_16,"CHANNEL_16" },
            { Types.ChinaChannelType.CHANNEL_17,"CHANNEL_17" },
            { Types.ChinaChannelType.CHANNEL_18,"CHANNEL_18" },
            { Types.ChinaChannelType.CHANNEL_19,"CHANNEL_19" },
            { Types.ChinaChannelType.CHANNEL_20,"CHANNEL_20" },
        };

        static Dictionary<Types.EuropeChannelType, string> diEuropeChannel = new Dictionary<Types.EuropeChannelType, string>{
            { Types.EuropeChannelType.CHANNEL_4,"CHANNEL_4" },
            { Types.EuropeChannelType.CHANNEL_7,"CHANNEL_7" },
            { Types.EuropeChannelType.CHANNEL_10,"CHANNEL_10" },
            { Types.EuropeChannelType.CHANNEL_13,"CHANNEL_13" },
        };

        static Dictionary<Types.JPChannelType, string> diJPChannel = new Dictionary<Types.JPChannelType, string>{
            { Types.JPChannelType.CHANNEL_24,"CHANNEL_24 920.6Mhz" },
            { Types.JPChannelType.CHANNEL_25,"CHANNEL_25 920.8Mhz" },
            { Types.JPChannelType.CHANNEL_26,"CHANNEL_26 921Mhz" },
            { Types.JPChannelType.CHANNEL_27,"CHANNEL_27 921.2Mhz" },
            { Types.JPChannelType.CHANNEL_28,"CHANNEL_28 921.4Mhz" },
            { Types.JPChannelType.CHANNEL_29,"CHANNEL_29 921.6Mhz" },
            { Types.JPChannelType.CHANNEL_30,"CHANNEL_30 921.8Mhz" },
            { Types.JPChannelType.CHANNEL_31,"CHANNEL_31 922Mhz" },
            { Types.JPChannelType.CHANNEL_32,"CHANNEL_32 922.2Mhz" },
            { Types.JPChannelType.CHANNEL_33,"CHANNEL_33 922.4Mhz" },
            { Types.JPChannelType.CHANNEL_34,"CHANNEL_34 922.6Mhz" },
            { Types.JPChannelType.CHANNEL_35,"CHANNEL_35 922.8Mhz" },
            { Types.JPChannelType.CHANNEL_36,"CHANNEL_36 923Mhz" },
        };

        static Dictionary<Types.BrazilChannelType, string> dicBrazilChannel = new Dictionary<Types.BrazilChannelType, string>{
            { Types.BrazilChannelType.CHANNEL_1,"CHANNEL_1" },
            { Types.BrazilChannelType.CHANNEL_2,"CHANNEL_2" },
            { Types.BrazilChannelType.CHANNEL_3,"CHANNEL_3" },
            { Types.BrazilChannelType.CHANNEL_4,"CHANNEL_4" },
            { Types.BrazilChannelType.CHANNEL_5,"CHANNEL_5" },
            { Types.BrazilChannelType.CHANNEL_6,"CHANNEL_6" },
            { Types.BrazilChannelType.CHANNEL_7,"CHANNEL_7" },
            { Types.BrazilChannelType.CHANNEL_8,"CHANNEL_8" },
            { Types.BrazilChannelType.CHANNEL_9,"CHANNEL_9" },
            { Types.BrazilChannelType.CHANNEL_10,"CHANNEL_10" },
            { Types.BrazilChannelType.CHANNEL_11,"CHANNEL_11" },
            { Types.BrazilChannelType.CHANNEL_12,"CHANNEL_12" },
            { Types.BrazilChannelType.CHANNEL_13,"CHANNEL_13" },
            { Types.BrazilChannelType.CHANNEL_14,"CHANNEL_14" },
            { Types.BrazilChannelType.CHANNEL_15,"CHANNEL_15" },
            { Types.BrazilChannelType.CHANNEL_16,"CHANNEL_16" },
            { Types.BrazilChannelType.CHANNEL_17,"CHANNEL_17" },
            { Types.BrazilChannelType.CHANNEL_18,"CHANNEL_18" },
            { Types.BrazilChannelType.CHANNEL_19,"CHANNEL_19" },
            { Types.BrazilChannelType.CHANNEL_20,"CHANNEL_20" },
            { Types.BrazilChannelType.CHANNEL_21,"CHANNEL_21" },
            { Types.BrazilChannelType.CHANNEL_22,"CHANNEL_22" },
            { Types.BrazilChannelType.CHANNEL_23,"CHANNEL_23" },
            { Types.BrazilChannelType.CHANNEL_24,"CHANNEL_24" },
            { Types.BrazilChannelType.CHANNEL_25,"CHANNEL_25" },
            { Types.BrazilChannelType.CHANNEL_26,"CHANNEL_26" },
        };

        static Dictionary<Types.USChannelType, string> dicUSChannel = new Dictionary<Types.USChannelType, string>{
            { Types.USChannelType.CHANNEL_1,"CHANNEL_1" },
            { Types.USChannelType.CHANNEL_2,"CHANNEL_2" },
            { Types.USChannelType.CHANNEL_3,"CHANNEL_3" },
            { Types.USChannelType.CHANNEL_4,"CHANNEL_4" },
            { Types.USChannelType.CHANNEL_5,"CHANNEL_5" },
            { Types.USChannelType.CHANNEL_6,"CHANNEL_6" },
            { Types.USChannelType.CHANNEL_7,"CHANNEL_7" },
            { Types.USChannelType.CHANNEL_8,"CHANNEL_8" },
            { Types.USChannelType.CHANNEL_9,"CHANNEL_9" },
            { Types.USChannelType.CHANNEL_10,"CHANNEL_10" },
            { Types.USChannelType.CHANNEL_11,"CHANNEL_11" },
            { Types.USChannelType.CHANNEL_12,"CHANNEL_12" },
            { Types.USChannelType.CHANNEL_13,"CHANNEL_13" },
            { Types.USChannelType.CHANNEL_14,"CHANNEL_14" },
            { Types.USChannelType.CHANNEL_15,"CHANNEL_15" },
            { Types.USChannelType.CHANNEL_16,"CHANNEL_16" },
            { Types.USChannelType.CHANNEL_17,"CHANNEL_17" },
            { Types.USChannelType.CHANNEL_18,"CHANNEL_18" },
            { Types.USChannelType.CHANNEL_19,"CHANNEL_19" },
            { Types.USChannelType.CHANNEL_20,"CHANNEL_20" },
            { Types.USChannelType.CHANNEL_21,"CHANNEL_21" },
            { Types.USChannelType.CHANNEL_22,"CHANNEL_22" },
            { Types.USChannelType.CHANNEL_23,"CHANNEL_23" },
            { Types.USChannelType.CHANNEL_24,"CHANNEL_24" },
            { Types.USChannelType.CHANNEL_25,"CHANNEL_25" },
            { Types.USChannelType.CHANNEL_26,"CHANNEL_26" },
            { Types.USChannelType.CHANNEL_27,"CHANNEL_27" },
            { Types.USChannelType.CHANNEL_28,"CHANNEL_28" },
            { Types.USChannelType.CHANNEL_29,"CHANNEL_29" },
            { Types.USChannelType.CHANNEL_30,"CHANNEL_30" },
            { Types.USChannelType.CHANNEL_31,"CHANNEL_31" },
            { Types.USChannelType.CHANNEL_32,"CHANNEL_32" },
            { Types.USChannelType.CHANNEL_33,"CHANNEL_33" },
            { Types.USChannelType.CHANNEL_34,"CHANNEL_34" },
            { Types.USChannelType.CHANNEL_35,"CHANNEL_35" },
            { Types.USChannelType.CHANNEL_36,"CHANNEL_36" },
            { Types.USChannelType.CHANNEL_37,"CHANNEL_37" },
            { Types.USChannelType.CHANNEL_38,"CHANNEL_38" },
            { Types.USChannelType.CHANNEL_39,"CHANNEL_39" },
            { Types.USChannelType.CHANNEL_40,"CHANNEL_40" },
            { Types.USChannelType.CHANNEL_41,"CHANNEL_41" },
            { Types.USChannelType.CHANNEL_42,"CHANNEL_42" },
            { Types.USChannelType.CHANNEL_43,"CHANNEL_43" },
            { Types.USChannelType.CHANNEL_44,"CHANNEL_44" },
            { Types.USChannelType.CHANNEL_45,"CHANNEL_45" },
            { Types.USChannelType.CHANNEL_46,"CHANNEL_46" },
            { Types.USChannelType.CHANNEL_47,"CHANNEL_47" },
            { Types.USChannelType.CHANNEL_48,"CHANNEL_48" },
            { Types.USChannelType.CHANNEL_49,"CHANNEL_49" },
            { Types.USChannelType.CHANNEL_50,"CHANNEL_50" },
        };


        static Dictionary<Types.AntiCollisionMode, string> dicCollision = new Dictionary<Types.AntiCollisionMode, string>{
            { Types.AntiCollisionMode.DynamicQ, "DynamicQ" },
            { Types.AntiCollisionMode.FixedQ,"FixedQ" }
        };

        static Dictionary<Types.DRType, string> dicDr = new Dictionary<Types.DRType, string>{
            { Types.DRType.DR_64_3, "DR_64_3" },
            { Types.DRType.DR_8,"DR_8" }
        };

        static Dictionary<Types.MType, string> dicM = new Dictionary<Types.MType, string>{
            { Types.MType.M1, "M1" },
            { Types.MType.M2,"M2" },
            { Types.MType.M4,"M4" },
            { Types.MType.M8,"M8" },
        };

        static Dictionary<Types.TRextType, string> dicTrext = new Dictionary<Types.TRextType, string>{
            { Types.TRextType.NO_Pilot_Tone, "NO_Pilot_Tone" },
            { Types.TRextType.Use_Pilot_Tone,"Use_Pilot_Tone" },
        };

        static Dictionary<Types.SelType, string> dicSel = new Dictionary<Types.SelType, string>{
            { Types.SelType.SEL_ALL, "SEL_ALL" },
            { Types.SelType.SEL_SL,"SEL_SL" },
            { Types.SelType.SEL_SL_N,"SEL_SL_N" },
        };

        static Dictionary<Types.SessionType, string> dicQrySession = new Dictionary<Types.SessionType, string>{
            { Types.SessionType.SESSION_S0, "SESSION_S0" },
            { Types.SessionType.SESSION_S1,"SESSION_S1" },
            { Types.SessionType.SESSION_S2,"SESSION_S2" },
            { Types.SessionType.SESSION_S3,"SESSION_S3" },
        };

        static Dictionary<Types.TargetABType, string> dicQryTarget = new Dictionary<Types.TargetABType, string>{
            { Types.TargetABType.TARGET_A,"A" },
            { Types.TargetABType.TARGET_B,"B" },
            { Types.TargetABType.TOGGLE_INVENTORY_ROUBD,"A/B"},
        };

        static Dictionary<Types.QType, string> dicQ = new Dictionary<Types.QType, string>{
            { Types.QType.Q0, "0" },
            { Types.QType.Q1,"1" },
            { Types.QType.Q2,"2" },
            { Types.QType.Q3,"3" },
            { Types.QType.Q4,"4" },
            { Types.QType.Q5,"5" },
            { Types.QType.Q6,"6" },
            { Types.QType.Q7,"7" },
            { Types.QType.Q8,"8" }
        };

        static Dictionary<Types.GainType, string> dicGain = new Dictionary<Types.GainType, string>{
            { Types.GainType.HIGH_GAIN, "HIGH_GAIN" },
            { Types.GainType.LOW_GAIN,"LOW_GAIN" },
        };

        static Dictionary<Types.RegionType, string> dicRegion = new Dictionary<Types.RegionType, string>{
            { Types.RegionType.REGION_BRAZIL, "REGION_BRAZIL" },
            { Types.RegionType.REGION_CHINA2,"REGION_CHINA2" },
            { Types.RegionType.REGION_EUROPE,"REGION_EUROPE" },
            { Types.RegionType.REGION_JAPAN,"REGION_JAPAN" },
            { Types.RegionType.REGION_US,"REGION_US" },
            { Types.RegionType.REGION_US_NARROW,"REGION_US_NARROW" },
        };

        static Dictionary<Types.SessionType, string> dicSession = new Dictionary<Types.SessionType, string>{
            { Types.SessionType.SESSION_S0,"0" },
            { Types.SessionType.SESSION_S1,"1" },
            { Types.SessionType.SESSION_S2,"2" },
            { Types.SessionType.SESSION_S3,"3" },
        };

        static Dictionary<Types.TargetType, string> dicTarget = new Dictionary<Types.TargetType, string>{
            { Types.TargetType.SESSION_S0, "SESSION_S0" },
            { Types.TargetType.SESSION_S1,"SESSION_S1" },
            { Types.TargetType.SESSION_S2,"SESSION_S2" },
            { Types.TargetType.SESSION_S3,"SESSION_S3" },
            { Types.TargetType.SL_FLAG,"SL_FLAG" },
        };

        public Device()
        {
            SetDelegate();
        }

        /// <summary>
        /// device connect
        /// </summary>
        /// <param name="comPort"></param>
        /// <returns></returns>
        public UInt32 ConnectWithVcp(string comPort)
        {
            UInt32 ret = asreader.ConnectWithVCP(comPort);
            return ret;
        }

        /// <summary>
        /// Device Disconnect
        /// </summary>
        public UInt32 DisConnect()
        {
            return asreader.DisConnect();
        }

        public UInt32 StartInventory(bool rssiEn, byte mtnu, byte mtime, ushort rc, bool ant1)
        {
            return asreader.StartInventory(rssiEn, mtnu, mtime, rc, ant1);
        }

        public UInt32 WriteMemory(Types.MemBankType membank, UInt32 offset, UInt32 password, byte[] epc, byte[] ren)
        {
            return asreader.WriteMemory(membank, offset, password, epc, ren);
        }

        public UInt32 ReadMemory(Types.MemBankType membank, UInt32 offset, UInt32 length, UInt32 password, byte[] epc)
        {
            return asreader.ReadMemory(membank, offset, length, password, epc);
        }

        public UInt32 SetSelectMask(Types.MemBankType membank, Types.TargetType target, Types.ActionType action, UInt32 startAddressWord, byte[] epc)
        {
            return asreader.SetSelectMask(membank, target, action, startAddressWord, epc);
        }

        public UInt32 GetSelectMask(ref Types.MemBankType membank, ref Types.TargetType target, ref Types.ActionType action, ref UInt32 startAddressWord, ref string epc_string)
        {
            return asreader.GetSelectMask(ref membank, ref target, ref action, ref startAddressWord, ref epc_string);
        }

        public UInt32 SetSelectionEnable(Types.SelectionEnable selection_enable)
        {
            return asreader.SetSelectionEnable(selection_enable);
        }

        public UInt32 GetSelectionEnable(ref Types.SelectionEnable selection_enable)
        {
            return asreader.GetSelectionEnable(ref selection_enable);
        }

        public UInt32 LockMemory(AsReader.TagMask tagMask, AsReader.TagAction tagAction, UInt32 accessPwd, byte[] epc)
        {
            return asreader.LockMemory(tagMask, tagAction, accessPwd, epc);
        }

        public UInt32 Kill(UInt32 killPwd, byte[] epc)
        {
            return asreader.Kill(killPwd, epc);
        }

        public UInt32 SetSession(Types.SessionType session)
        {
            return asreader.SetSession(session);
        }

        public UInt32 GetSession(ref Types.SessionType sessionType)
        {
            return asreader.GetSession(ref sessionType);
        }

        public UInt32 SetBasicTarget(Types.TargetABType target)
        {
            return asreader.SetBasicTarget(target);
        }

        public UInt32 GetBasicTarget(ref Types.TargetABType target)
        {
            return asreader.GetBasicTarget(ref target);
        }

        public UInt32 StopInventory()
        {
            return asreader.StopInventory();
        }

        public UInt32 SetTxPower(UInt32 power)
        {
            return asreader.SetTxPower(power);
        }
        public UInt32 GetTxPower(ref UInt32 power, ref UInt32 minPower, ref UInt32 maxPower)
        {
            return asreader.GetTxPower(ref power, ref minPower, ref maxPower);
        }

        public UInt32 SetFH_LBT(uint readTime, uint idelTime, uint cst, uint rfl, Types.FHType fh, Types.LBTType lbt, Types.CWType cw)
        {
            return asreader.SetFH_LBT(readTime, idelTime, cst, rfl, fh, lbt, cw);
        }
        public UInt32 GetFH_LBT(ref uint readTime, ref uint idelTime, ref uint cst, ref uint rfl, ref Types.FHType fh, ref Types.LBTType lbt, ref Types.CWType cw)
        {
            return asreader.GetFH_LBT(ref readTime, ref idelTime, ref cst, ref rfl, ref fh, ref lbt, ref cw);
        }
        public UInt32 SetFrequencyAutomatic(bool status)
        {
            return asreader.SetFrequencyAutomatic(status);
        }

        public UInt32 GetFrequencyAutomatic(ref bool status)
        {
            return asreader.GetFrequencyAutomatic(ref status);
        }
        public UInt32 SetReadTime(uint time_ant1)
        {
            return asreader.SetReadTime(time_ant1);
        }

        public UInt32 GetReadTime(ref uint time_ant1)
        {
            return asreader.GetReadTime(ref time_ant1);
        }

        public UInt32 SetAntiCollisionMode(Types.AntiCollisionMode anticollisionmode, Types.QType startq, Types.QType minq, Types.QType maxq)
        {
            return asreader.SetAntiCollisionMode(anticollisionmode, startq, minq, maxq);
        }

        public UInt32 GetAntiCollisionMode(ref Types.AntiCollisionMode antiCollision, ref Types.QType startq, ref Types.QType minq, ref Types.QType maxq)
        {
            return asreader.GetAntiCollisionMode(ref antiCollision, ref startq, ref minq, ref maxq);
        }

        public UInt32 SetChannel(uint channel)
        {
            return asreader.SetChannel(channel);
        }

        public UInt32 GetChannel(ref uint channel)
        {
            return asreader.GetChannel(ref channel);
        }

        public UInt32 SetQuery(Types.DRType dr, Types.MType m, Types.TRextType trext, Types.SelType sel, Types.SessionType session, Types.TargetABType target, Types.QType q)
        {
            return asreader.SetQuery(dr, m, trext, sel, session, target, q);
        }

        public bool DefaultSetting()
        {
            return asreader.DefaultSetting();
        }

        public UInt32 GetQuery(ref Types.DRType dr, ref Types.MType m, ref Types.TRextType trext, ref Types.SelType sel, ref Types.SessionType session, ref Types.TargetABType target, ref Types.QType q)
        {
            return asreader.GetQuery(ref dr, ref m, ref trext, ref sel, ref session, ref target, ref q);
        }

        public UInt32 SetRegion(Types.RegionType region)
        {
            return asreader.SetRegion(region);
        }

        public UInt32 GetRegion(ref Types.RegionType regionType)
        {
            return asreader.GetRegion(ref regionType);
        }

        public void GetSdkVersion(ref string SdkVersion)
        {
            asreader.GetSdkVersion(ref SdkVersion);
        }

        public uint SetIdelTime(uint idelTime)
        {
            return asreader.SetIdelTime(idelTime);
        }
        public uint GetIdelTime(ref uint idelTime)
        {
            return asreader.GetIdelTime(ref idelTime);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="delCallBackReadTagData"></param>
        /// <param name="delCallBackErrorString"></param>
        private void SetDelegate()
        {
            AsReader.CallBackReadTagData delCallBackReadTagData = CallBackReadTagData;
            AsReader.CallBackErrorCode delCallBackErrorCode = CallBackErrorCode;
            AsReader.CallBackSuccessCode delCallBackSuccessCode = CallBackSuccessCode;
            AsReader.CallBackCommandData delCallBackCommandData = CallBackCommandData;
            AsReader.CallBackReadComplete delCallBackReadComplete = CallBackReadComplete;
            AsReader.CallBackTriggerHandler delcallBackTriggerHandler = CallBackTriggerHandler;
            asreader.SetDelegate(delCallBackReadTagData, delCallBackErrorCode, delCallBackSuccessCode, delCallBackCommandData, delCallBackReadComplete, delcallBackTriggerHandler);
        }

        public void CallBackReadTagData(AsReader.InventoryResult tagcallbackdata)
        {
            Console.WriteLine(DateTime.Now.ToString("G") + " CallBackReadTagData");
            if (callBackResultTagData != null)
            {
                callBackResultTagData(tagcallbackdata);
            }
        }

        public void CallBackErrorCode(uint error)
        {
            if (callBackResultError != null)
            {
                callBackResultError(error);

            }
        }

        public void CallBackSuccessCode(uint error)
        {
            Console.WriteLine(DateTime.Now.ToString("G") + " CallBackSuccessCode");
            if (callBackResultSuccess != null)
            {
                callBackResultSuccess(error);

            }
        }

        public void CallBackReadComplete(bool completeStatus)
        {
            if (callBackResultReadComplete != null)
            {
                callBackResultReadComplete(completeStatus);
            }
        }

        public void CallBackTriggerHandler(int triggerHandler)
        {
            if (callBackTriggerHandler != null)
            {
                callBackTriggerHandler(triggerHandler);
            }
        }

        /// <summary>
        /// Q combox list
        /// </summary>
        public DataTable getQList()
        {
            Array arrs = System.Enum.GetValues(typeof(Types.QType));    // 获取枚举的所有值
            DataTable dt = new DataTable();
            dt.Columns.Add("value", typeof(int));
            dt.Columns.Add("name", Type.GetType("System.String"));
            foreach (var arr in arrs)
            {
                string strText = Enum.Parse(typeof(Types.QType), arr.ToString()).ToString();
                DataRow aRow = dt.NewRow();
                aRow[0] = (int)arr;
                aRow[1] = strText;
                dt.Rows.Add(aRow);
            }
            return dt;
        }

        /// <summary>
        /// combox list
        /// </summary>
        public DataTable getComboxList(Type type)
        {
            Array arrs = System.Enum.GetValues(type);    // 获取枚举的所有值
            DataTable dt = new DataTable();
            dt.Columns.Add("value", typeof(int));
            dt.Columns.Add("name", Type.GetType("System.String"));
            foreach (var arr in arrs)
            {
                string strText = Enum.Parse(type, arr.ToString()).ToString();
                DataRow aRow = dt.NewRow();
                aRow[0] = (int)arr;
                aRow[1] = strText;
                dt.Rows.Add(aRow);
            }
            return dt;
        }

        public DataTable getComboxListByName(Type type, string name)
        {
            Array arrs = System.Enum.GetValues(type);    // 获取枚举的所有值
            DataTable dt = new DataTable();
            dt.Columns.Add("value", typeof(int));
            dt.Columns.Add("name", Type.GetType("System.String"));

            foreach (var arr in arrs)
            {
                string strChannelText = "";
                if (name == "dicQryTarget")
                {
                    Types.TargetABType TargetABTypeKey = (Types.TargetABType)Enum.Parse(type, arr.ToString());
                    strChannelText = dicQryTarget[TargetABTypeKey].ToString();
                }
                if (name == "diJPChannel")
                {
                    Types.JPChannelType JPChannelKey = (Types.JPChannelType)Enum.Parse(type, arr.ToString());
                    strChannelText = diJPChannel[JPChannelKey].ToString();
                }
                if (name == "dicQ")
                {
                    Types.QType QTypeKey = (Types.QType)Enum.Parse(type, arr.ToString());
                    strChannelText = dicQ[QTypeKey].ToString();
                }

                DataRow aRow = dt.NewRow();
                aRow[0] = (int)arr;
                aRow[1] = strChannelText;
                dt.Rows.Add(aRow);
            }
            return dt;
        }

        public uint SetHIDWorkParams(int hid_adr, int hid_len, int hid_inventory, int hid_filter_time, byte repeat_epc_tid, byte epc_tid_user, byte output_suffix, byte output_without)
        {
            return asreader.SetHIDWorkParams(hid_adr, hid_len, hid_inventory, hid_filter_time, repeat_epc_tid, epc_tid_user, output_suffix, output_without);
        }
        public uint GetHIDWorkParams(ref int hid_adr, ref int hid_len, ref int hid_inventory, ref Types.HidRepeatEpcTid repeat_epc_tid, ref int hid_filter_time, ref Types.HidEpcTidUser epc_tid_user, ref Types.HidOutputSuffix output_suffix, ref Types.HidOutputWithout output_without)
        {
            return asreader.GetHIDWorkParams(ref hid_adr, ref hid_len, ref hid_inventory, ref repeat_epc_tid, ref hid_filter_time, ref epc_tid_user, ref output_suffix, ref output_without);
        }
        public uint SetBuzzer(Types.Buzzer buzzer)
        {
            return asreader.SetBuzzer(buzzer);
        }
        public uint GetBuzzer(ref Types.Buzzer buzzer)
        {
            return asreader.GetBuzzer(ref buzzer);
        }

        public uint GetFwVersion(ref string fwVersion)
        {
            return asreader.GetFwVersion(ref fwVersion);
        }

        public uint GetHwVersion(ref string hwVersion)
        {
            uint error = 0;
            error = asreader.GetHwVersion(ref hwVersion);
            hwVer = hwVersion;
            return error;
        }

        public uint GetProductSN(ref string productSN)
        {
            return asreader.GetProductSN(ref productSN);
        }

        public uint GetRFIDFwVersion(ref string rfidFwVersion)
        {
            return asreader.GetRFIDFwVersion(ref rfidFwVersion);
        }

        public uint SetExportPath(string path)
        {
            uint rtn = 0;

            string firmwareFolder = System.AppDomain.CurrentDomain.BaseDirectory + firmwareFolderNmae;
            Directory.CreateDirectory(firmwareFolder);

            FilesINI ConfigINI = new FilesINI();
            ConfigINI.INIWrite("Export Path", "Path", path, firmwareFolderNmae + "/config.ini");

            return rtn;
        }
        public uint GetExportPath(ref string path)
        {
            uint rtn = 0;

            FilesINI ConfigINI = new FilesINI();

            string firmwareFolder = System.AppDomain.CurrentDomain.BaseDirectory + firmwareFolderNmae;
            Directory.CreateDirectory(firmwareFolder);

            string filepath = firmwareFolder + "/config.ini";
            if (!File.Exists(filepath))
            {
                Auto_Inventory config = new Auto_Inventory();
                config.StartTime = "12:00";
                config.EndTime = "12:01";
                SetAutoInventory(config);
                SetExportPath("");
            }

            path = ConfigINI.INIRead("Export Path", "Path", firmwareFolderNmae + "/config.ini");

            return rtn;
        }

        public uint SetAutoInventory(Auto_Inventory config)
        {
            uint rtn = 0;

            string firmwareFolder = System.AppDomain.CurrentDomain.BaseDirectory + firmwareFolderNmae;
            Directory.CreateDirectory(firmwareFolder);

            string filepath = firmwareFolder + "/config.ini";


            FilesINI ConfigINI = new FilesINI();

            ConfigINI.INIWrite("Auto Inventory", "Enable", config.Enable.ToString(), filepath);
            ConfigINI.INIWrite("Auto Inventory", "Mon", config.Mon.ToString(), filepath);
            ConfigINI.INIWrite("Auto Inventory", "Tues", config.Tues.ToString(), filepath);
            ConfigINI.INIWrite("Auto Inventory", "Wed", config.Wed.ToString(), filepath);
            ConfigINI.INIWrite("Auto Inventory", "Thurs", config.Thurs.ToString(), filepath);
            ConfigINI.INIWrite("Auto Inventory", "Fri", config.Fri.ToString(), filepath);
            ConfigINI.INIWrite("Auto Inventory", "Sat", config.Sat.ToString(), filepath);
            ConfigINI.INIWrite("Auto Inventory", "Sun", config.Sun.ToString(), filepath);
            ConfigINI.INIWrite("Auto Inventory", "StartTime ", config.StartTime, filepath);
            ConfigINI.INIWrite("Auto Inventory", "EndTime ", config.EndTime, filepath);

            return rtn;
        }

        public uint GetAutoInventory(ref Auto_Inventory config)
        {
            uint rtn = 0;

            FilesINI ConfigINI = new FilesINI();

            string firmwareFolder = System.AppDomain.CurrentDomain.BaseDirectory + firmwareFolderNmae;
            Directory.CreateDirectory(firmwareFolder);

            string filepath = firmwareFolder + "/config.ini";
            if (!File.Exists(filepath))
            {
                config.StartTime = "12:00";
                config.EndTime = "12:01";
                SetAutoInventory(config);
                SetExportPath("");
            }

            config.Enable = Convert.ToInt32(ConfigINI.INIRead("Auto Inventory", "Enable", filepath));
            config.Mon = Convert.ToInt32(ConfigINI.INIRead("Auto Inventory", "Mon", filepath));
            config.Tues = Convert.ToInt32(ConfigINI.INIRead("Auto Inventory", "Tues", filepath));
            config.Wed = Convert.ToInt32(ConfigINI.INIRead("Auto Inventory", "Wed", filepath));
            config.Thurs = Convert.ToInt32(ConfigINI.INIRead("Auto Inventory", "Thurs", filepath));
            config.Fri = Convert.ToInt32(ConfigINI.INIRead("Auto Inventory", "Fri", filepath));
            config.Sat = Convert.ToInt32(ConfigINI.INIRead("Auto Inventory", "Sat", filepath));
            config.Sun = Convert.ToInt32(ConfigINI.INIRead("Auto Inventory", "Sun", filepath));
            config.StartTime = ConfigINI.INIRead("Auto Inventory", "StartTime", filepath);
            config.EndTime = ConfigINI.INIRead("Auto Inventory", "EndTime", filepath);

            return rtn;
        }

        public uint SetRSSIThreshold(int rssi_threshold)
        {
            return asreader.SetRSSIThreshold(rssi_threshold);
        }
        public uint GetRSSIThreshold(ref int rssi_threshold)
        {
            return asreader.GetRSSIThreshold(ref rssi_threshold);
        }

        public UInt32 SetHIDInventoryMode(Types.HIDInventoryMode mode)
        {
            return asreader.SetHIDInventoryMode(mode);
        }

        public UInt32 GetHIDInventoryMode(ref Types.HIDInventoryMode mode)
        {
            return asreader.GetHIDInventoryMode(ref mode);
        }



        public bool SendCommand(byte[] command)
        {
            return asreader.SendCommand(command);
        }


        public delegate void WhenShowReceiveMsg(string strLog);
        public delegate void WhenReceivedFirmwareUpdateProgress();
        public delegate void WhenReceivedRebootDevice(byte[] packetRx, string strPacket);

        public WhenShowReceiveMsg whenShowReceiveMsg = null;
        public WhenReceivedFirmwareUpdateProgress whenReceivedFirmwareUpdateProgress = null;
        public WhenReceivedRebootDevice whenReceivedRebootDevice = null;

        public delegate void WhenReceivedDownloadFirmwareProgress();
        public WhenReceivedDownloadFirmwareProgress whenReceivedDownloadFirmwareProgress = null;

        public void CallBackCommandData(byte[] packetRx)
        {
            string strPacket = string.Empty;
            for (int i = 0; i < packetRx.Length; i++)
            {
                strPacket += packetRx[i].ToString("x2").ToUpper() + " ";
            }
            receiveFirmwareData(packetRx, strPacket);

        }
        public ResultData FindResultDataList(AsPacket.AsReaderP3xURcpType type)
        {
            try
            {
                foreach (ResultData resultData in resultDataList)
                {
                    if (resultData.asReaderP3xURcpType == type)
                    {
                        return resultData;
                    }
                }
                return null;
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error: FindResultDataList(" + type + ") - " + ex.ToString());
                return null;
            }
        }
        public void receiveFirmwareData(byte[] readByte, string strPacket)
        {
            try
            {
                switch (readByte[1])
                {
                    case (byte)AsPacket.AsReaderP3xUPropertyType.AsReaderP3xUPropertyTypeRec:
                        {
                            switch (readByte[2])
                            {
                                case (byte)AsPacket.AsReaderP3xURcpType.AsReaderP3xUFirmwareTypeAddress: //0x58, Update Address
                                    {
                                        ResultData resultData = FindResultDataList(AsPacket.AsReaderP3xURcpType.AsReaderP3xUFirmwareTypeAddress);
                                        if (resultData == null)
                                        {
                                            return;
                                        }
                                        resultData.waitBytes = readByte;
                                        resultData.waitString = strPacket;
                                        resultData.EndWait();

                                    }
                                    break;
                                case (byte)AsPacket.AsReaderP3xURcpType.AsReaderP3xUFirmwareTypeTransferFile: //0x59,Transfer File
                                    {
                                        ResultData resultData = FindResultDataList(AsPacket.AsReaderP3xURcpType.AsReaderP3xUFirmwareTypeTransferFile);
                                        if (resultData == null)
                                        {
                                            return;
                                        }

                                        resultData.waitBytes = readByte;
                                        resultData.waitString = strPacket;
                                        resultData.EndWait();

                                    }
                                    break;
                                case (byte)AsPacket.AsReaderP3xURcpType.AsReaderP3xUFirmwareTypeTransferComplete: //0x5A, Transfer Complete
                                    {
                                        ResultData resultData = FindResultDataList(AsPacket.AsReaderP3xURcpType.AsReaderP3xUFirmwareTypeTransferComplete);
                                        if (resultData == null)
                                        {
                                            return;
                                        }

                                        resultData.waitBytes = readByte;
                                        resultData.waitString = strPacket;
                                        resultData.EndWait();
                                    }
                                    break;
                                case (byte)AsPacket.AsReaderP3xURcpType.AsReaderP3xUFirmwareTypeDeviceReboot: //0x5B, Device Reboot
                                    {
                                        whenReceivedRebootDevice?.Invoke(readByte, strPacket);
                                    }
                                    break;
                                case (byte)AsPacket.AsReaderP3xURcpType.AsReaderP3xURFIDFirmwareTypeAddress: //0xB6
                                    {
                                        ResultData resultData = FindResultDataList(AsPacket.AsReaderP3xURcpType.AsReaderP3xURFIDFirmwareTypeAddress);
                                        if (resultData == null)
                                        {
                                            return;
                                        }

                                        resultData.waitBytes = readByte;
                                        resultData.waitString = strPacket;
                                        resultData.EndWait();

                                    }
                                    break;
                                case (byte)AsPacket.AsReaderP3xURcpType.AsReaderP3xURFIDFirmwareTypeTransferFile: //0xB1
                                    {
                                        ResultData resultData = FindResultDataList(AsPacket.AsReaderP3xURcpType.AsReaderP3xURFIDFirmwareTypeTransferFile);
                                        if (resultData == null)
                                        {
                                            return;
                                        }

                                        resultData.waitBytes = readByte;
                                        resultData.waitString = strPacket;
                                        resultData.EndWait();

                                    }
                                    break;

                            }

                        }
                        break;

                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error: ParseRCP(" + Encoding.ASCII.GetString(readByte) + ") - " + ex.ToString());
            }
        }

        public bool FirmwareUpdate(string filename)
        {
            try
            {
                resultDataList.Clear();
                FileStream myStream = new FileStream(filename, FileMode.Open, FileAccess.Read);
                BinaryReader myReader = new BinaryReader(myStream);
                int bytes = (int)myStream.Length;
                if (bytes == 0 || bytes % 2 != 0)
                {
                    return false;
                }
                FileData = myReader.ReadBytes(bytes);
                myReader.Close();
                myStream.Close();

                //1：请求固件更新地址
                byte[] sendData = new byte[8];
                sendData[0] = 0xBB;
                sendData[1] = 0x00;
                sendData[2] = 0x58;
                sendData[3] = 0x00;
                sendData[4] = 0x00;
                sendData[5] = 0x7E;
                sendData[6] = 0x7E;
                sendData[7] = 0xAD;
                SendCommand(sendData);
                ResultData resultData = new ResultData(AsPacket.AsReaderP3xURcpType.AsReaderP3xUFirmwareTypeAddress);
                resultDataList.Add(resultData);
                if (!resultData.StartWait())
                {
                    whenShowReceiveMsg?.Invoke("Get firmware update address failed.");
                    return false;
                }

                string readStr = "";
                byte[] des = new byte[8];
                byte[] packetRx = resultData.waitBytes;
                Array.Copy(packetRx, 5, des, 0, 8);
                for (int i = 0; i < des.Length; i++)
                {
                    readStr += des[i].ToString("x2").ToUpper();
                }
                // 1：a数组从第1位开始截取；0：b数组从0位开始插入；3：a、b数组截取长度
                int d_len = FileData.Length / 2;
                byte[] tmpData = new byte[d_len];
                if (readStr == "3038303430303030")
                {
                    //3038303430303030 文件后半部分数据传输
                    Array.ConstrainedCopy(FileData, d_len, tmpData, 0, d_len);
                }
                else if (readStr == "3038303630303030")
                {
                    //3038303630303030 文件前半部分数据传输
                    Array.ConstrainedCopy(FileData, 0, tmpData, 0, d_len);
                }
                else
                {
                    whenShowReceiveMsg?.Invoke("Get firmware update address failed( return address:" + resultData.waitString + " ).");
                    return false;
                }

                whenShowReceiveMsg?.Invoke("Get firmware update address succeeded.");

                FileData = new byte[d_len];
                Array.Copy(tmpData, FileData, d_len);
                resultDataList.Remove(resultData);

                whenReceivedFirmwareUpdateProgress?.Invoke();

                //2：开始固件更新, 发送bin文件数据
                //SEND： BB 00 59  + 长度（两个字节）+包的编号+ 50个字节数据 + 校验（两个字节）+尾(两个字节) 
                byte[] header = { 0xBB, 0x00, 0x59 };
                byte[] end = { 0x0D, 0x0A };
                int packet = 50;
                int sendFileBytes = FileData.Length;
                int countPicket = (int)Math.Ceiling((decimal)sendFileBytes / packet);
                int picketNumber = -1;
                int reSendNumber = 0;
                for (int i = 0; i < countPicket; i++)
                {
                    byte[] sendFileData;
                    int everyFileBytes = 0;
                    if (sendFileBytes > i * packet + packet)
                    {
                        everyFileBytes = packet;
                    }
                    else
                    {
                        everyFileBytes = sendFileBytes - (i * packet);
                    }
                    //TODO 判断一下连接状态
                    sendFileData = new byte[everyFileBytes];
                    Array.ConstrainedCopy(FileData, i * packet, sendFileData, 0, everyFileBytes);
                    picketNumber++;
                    if (picketNumber > 255)
                    {
                        picketNumber = 0;
                    }

                    //if (!bluetoothIsConnected) { return false; }

                    byte[] picket = new byte[1];
                    picket[0] = (byte)picketNumber;
                    byte[] sendPicketData = new byte[picket.Length + everyFileBytes];
                    Array.ConstrainedCopy(picket, 0, sendPicketData, 0, picket.Length);
                    // 1：a数组从第1位开始截取；0：b数组从0位开始插入；3：a、b数组截取长度
                    Array.ConstrainedCopy(sendFileData, 0, sendPicketData, picket.Length, everyFileBytes);

                    int newLenght = sendPicketData.Length + 2;
                    byte[] newData = new byte[newLenght];
                    byte[] lenghtData = new byte[2];
                    lenghtData[0] = Convert.ToByte(newLenght + 2 >> 8);
                    lenghtData[1] = Convert.ToByte(newLenght + 2 & 0xFF);
                    Array.ConstrainedCopy(lenghtData, 0, newData, 0, lenghtData.Length);
                    Array.ConstrainedCopy(sendPicketData, 0, newData, lenghtData.Length, sendPicketData.Length);
                    //包的编号：0~255  然后又从0开始
                    //校验：长度+包的编号+ 50个字节数据 CRC16校验
                    int CRC16Value = CRC16(newData);
                    byte[] myCommandArray = new byte[newLenght + 2];
                    Array.Copy(newData, myCommandArray, newLenght);
                    myCommandArray[newLenght] = Convert.ToByte(CRC16Value >> 8);
                    myCommandArray[newLenght + 1] = (byte)CRC16Value;
                    //header->3 ,end->2 newData
                    sendData = new byte[myCommandArray.Length + header.Length + end.Length];
                    Array.Copy(header, sendData, header.Length);
                    Array.ConstrainedCopy(myCommandArray, 0, sendData, header.Length, myCommandArray.Length);
                    Array.ConstrainedCopy(end, 0, sendData, header.Length + myCommandArray.Length, end.Length);
                    SendCommand(sendData);
                    resultData = new ResultData(AsPacket.AsReaderP3xURcpType.AsReaderP3xUFirmwareTypeTransferFile);
                    resultDataList.Add(resultData);
                    bool wait = resultData.StartWait();

                    readStr = resultData.waitString;
                    if (readStr != null)
                    {
                        readStr = readStr.Trim();
                    }
                    if (readStr != "BB 01 59 00 01 00 7E 5E 97" || !wait)
                    {
                        i--;
                        picketNumber--;
                        reSendNumber++;

                        if (reSendNumber >= 5)
                        {
                            whenShowReceiveMsg?.Invoke("Transfer file failed.");
                            return false;
                        }
                    }
                    else
                    {
                        reSendNumber = 0;
                        whenShowReceiveMsg?.Invoke("Transfer file succeeded.");
                    }

                    resultDataList.Remove(resultData);
                    whenReceivedFirmwareUpdateProgress?.Invoke();
                }

                //3：固件更新完成
                sendData = new byte[9];
                sendData[0] = 0xBB;
                sendData[1] = 0x00;
                sendData[2] = 0x5A;
                sendData[3] = 0x00;
                sendData[4] = 0x01;
                sendData[5] = 0x01;
                sendData[6] = 0x7E;
                sendData[7] = 0xC6;
                sendData[8] = 0xD4;
                SendCommand(sendData);

                resultData = new ResultData(AsPacket.AsReaderP3xURcpType.AsReaderP3xUFirmwareTypeTransferComplete);
                resultDataList.Add(resultData);
                if (!resultData.StartWait())
                {
                    whenShowReceiveMsg?.Invoke("Transfer complete failed.");
                    return false;
                }

                readStr = resultData.waitString;
                if (readStr.Trim() != "BB 01 5A 00 01 00 7E B0 45")
                {
                    whenShowReceiveMsg?.Invoke("Transfer complete failed.");
                    return false;
                }

                resultDataList.Remove(resultData);
                whenShowReceiveMsg?.Invoke("Transfer complete succeeded.");
                whenReceivedFirmwareUpdateProgress?.Invoke();
                return true;
            }
            catch (Exception ex)
            {
                Console.WriteLine("FirmwareUpdate: " + ex.Message);
                return false;
            }

        }

        public bool RFIDFirmwareUpdate(string filename)
        {
            try
            {
                resultDataList.Clear();
                FileStream myStream = new FileStream(filename, FileMode.Open, FileAccess.Read);
                BinaryReader myReader = new BinaryReader(myStream);
                int bytes = (int)myStream.Length;
                if (bytes == 0)
                {
                    return false;
                }
                string fileDataStr = Encoding.ASCII.GetString(myReader.ReadBytes(bytes));
                myReader.Close();
                myStream.Close();

                //1：请求固件更新地址
                //T>BB00B100020A107EF941  R>BB01B10001007E67B6
                byte[] sendData1 = { 0xBB, 0x00, 0xB1, 0x00, 0x02, 0x0A, 0x10, 0x7E, 0xF9, 0x41 };
                SendCommand(sendData1);
                ResultData resultData = new ResultData(AsPacket.AsReaderP3xURcpType.AsReaderP3xURFIDFirmwareTypeTransferFile);
                resultDataList.Add(resultData);
                if (!resultData.StartWait())
                {
                    whenShowReceiveMsg?.Invoke("Get firmware update address failed.");
                    return false;
                }

                string readStr = "";
                byte[] packetRx = resultData.waitBytes;

                for (int i = 0; i < packetRx.Length; i++)
                {
                    readStr += packetRx[i].ToString("x2").ToUpper();
                }

                if (readStr != "BB01B10001007E67B6")
                {
                    whenShowReceiveMsg?.Invoke("Get RFID firmware update address failed( return address:" + resultData.waitString + " ).");
                    return false;
                }

                whenShowReceiveMsg?.Invoke("Get RFID firmware update address succeeded.");
                resultDataList.Remove(resultData);

                whenReceivedFirmwareUpdateProgress?.Invoke();

                //2：开始固件更新, 发送hex文件数据
                //SEND： 固定帧头（BB 58 2字节） + 数据地址（2字节） + 有限数据（1024字节）+ 固定数据尾（7E 1字节） + CRC校验（2字节）
                string[] separator = { "\r\n" };
                string[] rfidRowArr = fileDataStr.Split(separator, StringSplitOptions.RemoveEmptyEntries);
                string isGetAddress = "yes";
                string packetAddress = "";
                //string packetStr = "";
                byte[] backPacketData = new byte[0];
                byte[] packetData = new byte[0];
                for (int i = 0; i < rfidRowArr.Length; i++)
                {
                    string tag = rfidRowArr[i].Substring(0, 3);
                    if (tag == ":10")
                    {
                        if (isGetAddress == "yes")
                        {
                            isGetAddress = "no";
                            packetAddress = rfidRowArr[i].Substring(3, 4);
                        }
                        string packetStr = rfidRowArr[i].Substring(9, (rfidRowArr[i].Length - 11));
                        byte[] tmpData = StringToByte(packetStr);

                        packetData = new byte[backPacketData.Length + tmpData.Length];
                        Array.ConstrainedCopy(backPacketData, 0, packetData, 0, backPacketData.Length);
                        Array.ConstrainedCopy(tmpData, 0, packetData, backPacketData.Length, tmpData.Length);

                        backPacketData = new byte[packetData.Length];
                        Array.Copy(packetData, backPacketData, packetData.Length);
                    }
                    else
                    {
                        Console.WriteLine(tag);
                    }
                    int packetLength = packetData.Length;
                    if (packetLength >= 1024 || (i == rfidRowArr.Length - 1 && packetLength > 0))
                    {
                        //校验：CRC16校验
                        byte[] packetAddressData = StringToByte(packetAddress);
                        byte[] CRCData = new byte[packetAddressData.Length + packetData.Length + 2];
                        CRCData[0] = 0x58;
                        Array.ConstrainedCopy(packetAddressData, 0, CRCData, 1, packetAddressData.Length);
                        Array.ConstrainedCopy(packetData, 0, CRCData, packetAddressData.Length + 1, packetData.Length);
                        CRCData[CRCData.Length - 1] = 0x7E;
                        int CRC16Value4 = CRC16(CRCData);
                        byte[] rfidSendData = new byte[CRCData.Length + 3];
                        rfidSendData[0] = 0xBB;
                        Array.ConstrainedCopy(CRCData, 0, rfidSendData, 1, CRCData.Length);
                        rfidSendData[CRCData.Length + 1] = Convert.ToByte(CRC16Value4 >> 8);
                        rfidSendData[CRCData.Length + 2] = (byte)CRC16Value4;

                        isGetAddress = "yes";
                        packetAddress = "";
                        backPacketData = new byte[0];
                        packetData = new byte[0];

                        SendCommand(rfidSendData);
                        resultData = new ResultData(AsPacket.AsReaderP3xURcpType.AsReaderP3xURFIDFirmwareTypeTransferFile);
                        resultDataList.Add(resultData);
                        bool wait = resultData.StartWait();

                        readStr = resultData.waitString;
                        if (readStr != null)
                        {
                            readStr = readStr.Trim();
                        }
                        if (readStr != "BB 01 B1 00 01 00 7E 67 B6" || !wait)
                        {
                            whenShowReceiveMsg?.Invoke("Transfer file failed.");
                        }
                        else
                        {
                            whenShowReceiveMsg?.Invoke("Transfer file succeeded.");
                        }

                        resultDataList.Remove(resultData);
                        whenReceivedFirmwareUpdateProgress?.Invoke();

                    }
                }

                whenShowReceiveMsg?.Invoke("Transfer complete succeeded.");
                whenReceivedFirmwareUpdateProgress?.Invoke();
                return true;
            }
            catch (Exception ex)
            {
                Console.WriteLine("RFIDFirmwareUpdate: " + ex.Message);
                return false;
            }

        }

        public bool RebootDevice()
        {
            byte[] sendData = new byte[9];
            sendData[0] = 0xBB;
            sendData[1] = 0x00;
            sendData[2] = 0x5B;
            sendData[3] = 0x00;
            sendData[4] = 0x01;
            sendData[5] = 0x00;
            sendData[6] = 0x7E;
            sendData[7] = 0x5F;
            sendData[8] = 0xB4;
            bool status = SendCommand(sendData);
            return status;
        }

        public bool DownloadFirmwareFile(string fileType, string path)
        {
            string firmwareFolder = System.AppDomain.CurrentDomain.BaseDirectory + firmwareFolderNmae;
            // ログフォルダ名作成
            Directory.CreateDirectory(firmwareFolder);
            string binFilePath = firmwareFolder + @"\" + path;

            bool isDebug = ConfigurationManager.AppSettings["isDebug"].ToLower() == "true";
            if (isDebug)
            {
                if (File.Exists(binFilePath))
                {
                    return true;
                }
            }

            string fwBinFileURL = fwURL + path;
            if (fileType == "RFIDFW")
            {
                fwBinFileURL = rfidFwURL + path;
            }
            string tempPath = Path.GetDirectoryName(path) + @"\temp";
            Directory.CreateDirectory(tempPath);  //创建临时文件目录
            string tempFile = tempPath + @"\" + Path.GetFileName(path) + ".temp"; //临时文件
            if (File.Exists(tempFile))
            {
                File.Delete(tempFile);    //存在则删除
            }
            whenReceivedDownloadFirmwareProgress?.Invoke();
            try
            {
                FileStream fs = new FileStream(tempFile, FileMode.Append, FileAccess.Write, FileShare.ReadWrite);
                // 设置参数
                HttpWebRequest request = WebRequest.Create(fwBinFileURL) as HttpWebRequest;
                //发送请求并获取相应回应数据
                HttpWebResponse response = request.GetResponse() as HttpWebResponse;
                //直到request.GetResponse()程序才开始向目标网页发送Post请求
                Stream responseStream = response.GetResponseStream();
                //创建本地文件写入流
                //Stream stream = new FileStream(tempFile, FileMode.Create);
                byte[] bArr = new byte[1024];
                int size = responseStream.Read(bArr, 0, (int)bArr.Length);
                whenReceivedDownloadFirmwareProgress?.Invoke();
                while (size > 0)
                {
                    fs.Write(bArr, 0, size);
                    size = responseStream.Read(bArr, 0, (int)bArr.Length);
                }
                fs.Close();
                responseStream.Close();

                if (File.Exists(binFilePath))
                {
                    File.Delete(binFilePath);    //存在则删除
                }
                File.Move(tempFile, binFilePath);
                string msg = "Demo App: Download firmware file succeeded";
                whenShowReceiveMsg?.Invoke(msg);
                whenReceivedDownloadFirmwareProgress?.Invoke();
                return true;
            }
            catch (Exception ex)
            {
                string msg = "Demo App: Download firmware file failed" + ex.ToString();
                whenShowReceiveMsg?.Invoke(msg);
                return false;
            }
        }

        public ushort CRC16(byte[] packetData)
        {
            int[] crc16tab = {
                0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50a5, 0x60c6, 0x70e7,
                0x8108, 0x9129, 0xa14a, 0xb16b, 0xc18c, 0xd1ad, 0xe1ce, 0xf1ef,
                0x1231, 0x0210, 0x3273, 0x2252, 0x52b5, 0x4294, 0x72f7, 0x62d6,
                0x9339, 0x8318, 0xb37b, 0xa35a, 0xd3bd, 0xc39c, 0xf3ff, 0xe3de,
                0x2462, 0x3443, 0x0420, 0x1401, 0x64e6, 0x74c7, 0x44a4, 0x5485,
                0xa56a, 0xb54b, 0x8528, 0x9509, 0xe5ee, 0xf5cf, 0xc5ac, 0xd58d,
                0x3653, 0x2672, 0x1611, 0x0630, 0x76d7, 0x66f6, 0x5695, 0x46b4,
                0xb75b, 0xa77a, 0x9719, 0x8738, 0xf7df, 0xe7fe, 0xd79d, 0xc7bc,
                0x48c4, 0x58e5, 0x6886, 0x78a7, 0x0840, 0x1861, 0x2802, 0x3823,
                0xc9cc, 0xd9ed, 0xe98e, 0xf9af, 0x8948, 0x9969, 0xa90a, 0xb92b,
                0x5af5, 0x4ad4, 0x7ab7, 0x6a96, 0x1a71, 0x0a50, 0x3a33, 0x2a12,
                0xdbfd, 0xcbdc, 0xfbbf, 0xeb9e, 0x9b79, 0x8b58, 0xbb3b, 0xab1a,
                0x6ca6, 0x7c87, 0x4ce4, 0x5cc5, 0x2c22, 0x3c03, 0x0c60, 0x1c41,
                0xedae, 0xfd8f, 0xcdec, 0xddcd, 0xad2a, 0xbd0b, 0x8d68, 0x9d49,
                0x7e97, 0x6eb6, 0x5ed5, 0x4ef4, 0x3e13, 0x2e32, 0x1e51, 0x0e70,
                0xff9f, 0xefbe, 0xdfdd, 0xcffc, 0xbf1b, 0xaf3a, 0x9f59, 0x8f78,
                0x9188, 0x81a9, 0xb1ca, 0xa1eb, 0xd10c, 0xc12d, 0xf14e, 0xe16f,
                0x1080, 0x00a1, 0x30c2, 0x20e3, 0x5004, 0x4025, 0x7046, 0x6067,
                0x83b9, 0x9398, 0xa3fb, 0xb3da, 0xc33d, 0xd31c, 0xe37f, 0xf35e,
                0x02b1, 0x1290, 0x22f3, 0x32d2, 0x4235, 0x5214, 0x6277, 0x7256,
                0xb5ea, 0xa5cb, 0x95a8, 0x8589, 0xf56e, 0xe54f, 0xd52c, 0xc50d,
                0x34e2, 0x24c3, 0x14a0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405,
                0xa7db, 0xb7fa, 0x8799, 0x97b8, 0xe75f, 0xf77e, 0xc71d, 0xd73c,
                0x26d3, 0x36f2, 0x0691, 0x16b0, 0x6657, 0x7676, 0x4615, 0x5634,
                0xd94c, 0xc96d, 0xf90e, 0xe92f, 0x99c8, 0x89e9, 0xb98a, 0xa9ab,
                0x5844, 0x4865, 0x7806, 0x6827, 0x18c0, 0x08e1, 0x3882, 0x28a3,
                0xcb7d, 0xdb5c, 0xeb3f, 0xfb1e, 0x8bf9, 0x9bd8, 0xabbb, 0xbb9a,
                0x4a75, 0x5a54, 0x6a37, 0x7a16, 0x0af1, 0x1ad0, 0x2ab3, 0x3a92,
                0xfd2e, 0xed0f, 0xdd6c, 0xcd4d, 0xbdaa, 0xad8b, 0x9de8, 0x8dc9,
                0x7c26, 0x6c07, 0x5c64, 0x4c45, 0x3ca2, 0x2c83, 0x1ce0, 0x0cc1,
                0xef1f, 0xff3e, 0xcf5d, 0xdf7c, 0xaf9b, 0xbfba, 0x8fd9, 0x9ff8,
                0x6e17, 0x7e36, 0x4e55, 0x5e74, 0x2e93, 0x3eb2, 0x0ed1, 0x1ef0 };

            int i;
            int crc = 0xFFFF;
            byte[] packet = packetData;
            for (i = 0; i < packetData.Length; i++)
            {
                crc = ((crc << 8) ^ crc16tab[((crc >> 8) ^ packet[i]) & 0x00FF]) & 0xFFFF;
            }
            return (ushort)crc;
        }

        public byte[] StringToByte(string hexString)
        {
            try
            {
                hexString = hexString.Replace(" ", "");
                if ((hexString.Length % 2) != 0)
                {
                    hexString += " ";
                }
                byte[] returnBytes = new byte[hexString.Length / 2];
                for (int i = 0; i < returnBytes.Length; i++)
                {
                    returnBytes[i] = Convert.ToByte(hexString.Substring(i * 2, 2), 16);
                }
                return returnBytes;
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error: StringToByte(" + hexString + ") - " + ex.ToString());
                return null;
            }
        }

        public Types.TagStatus CheckTagStatus(byte[] epcData)
        {
            return asreader.CheckTagStatus(epcData);
        }

    }
}
